(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    472155,       7064]*)
(*NotebookOutlinePosition[    532034,       8473]*)
(*  CellTagsIndexPosition[    531154,       8444]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "What Is ",
  StyleBox["MathReader",
    FontSlant->"Italic"],
  "?"
}], "Subsection",
  ShowCellBracket->False,
  CellTags->"What is MathReader"],

Cell[TextData[{
  StyleBox["MathReader",
    FontSlant->"Italic",
    FontColor->GrayLevel[1]],
  StyleBox[" allows you to read ",
    FontColor->GrayLevel[1]],
  StyleBox["Mathematica",
    FontSlant->"Italic",
    FontColor->GrayLevel[1]],
  StyleBox["-compatible notebook documents but not to edit them.",
    FontColor->GrayLevel[1]]
}], "Subtitle",
  ShowCellBracket->False,
  CellMargins->{{0, 0}, {8, 0}},
  CellHorizontalScrolling->True,
  CellFrameMargins->{{18, 16}, {8, 8}},
  FontSize->15,
  Background->RGBColor[0.2, 0, 0.500008],
  CellTags->"What is MathReader"],

Cell[TextData[{
  StyleBox["MathReader",
    FontSlant->"Italic"],
  " lets you:\n    \[Bullet] display any notebook, animate graphics, and play \
sounds\n    \[Bullet] print the notebook, and copy and paste from it "
}], "Text",
  ShowCellBracket->False,
  CellTags->"What is MathReader"],

Cell[TextData[{
  "To create or modify a notebook, you need a complete ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end. To do computations, a complete ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " system, including the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel is required. "
}], "Text",
  ShowCellBracket->False,
  CellTags->"What is MathReader"],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
"Licensing Information", "Subsubsection"]], "Subsubsection",
  ShowCellBracket->False,
  CellHorizontalScrolling->True,
  CellTags->"Licensing Information"],

Cell[TextData[{
  StyleBox["MathReader",
    FontSlant->"Italic"],
  " is licensed free of charge, subject to certain terms and conditions. For \
more information, contact Wolfram Research (",
  ButtonBox["info@wolfram.com",
    ButtonData:>{
      URL[ "mailto: info@wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  ")."
}], "Text",
  ShowCellBracket->False,
  CellTags->"Licensing Information"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Using ", "Subsubsection"],
  StyleBox["MathReader", "Subsubsection",
    FontSlant->"Italic"]
}], "Subsubsection",
  ShowCellBracket->False,
  CellHorizontalScrolling->True,
  CellTags->"Using MathReader"],

Cell[TextData[{
  "Every ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebook consists of a sequence of cells, normally indicated by brackets \
at the right. Groups of cells can be closed, so that only the head cell is \
visible. To open the group, either double-click the bracket of the head cell, \
or click the ",
  StyleBox["\[RightTriangle]",
    FontFamily->"Times",
    FontSize->14,
    FontWeight->"Plain",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  " icon if this is displayed. Repeat the action to close the group."
}], "Text",
  ShowCellBracket->False,
  CellTags->"Using MathReader"],

Cell[CellGroupData[{

Cell[TextData[{
  "Getting a Notebook into ",
  StyleBox["MathReader",
    FontSlant->"Italic"]
}], "Subsubsection",
  ShowCellBracket->False,
  CellTags->{"Get Notebook", "Using MathReader"}],

Cell[TextData[{
  "Choose ",
  StyleBox[ButtonBox["Open",
    ButtonData:>"Open...",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Helvetica"],
  " in the File menu."
}], "Text",
  ShowCellBracket->False,
  CellTags->{"Get Notebook", "Using MathReader"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Configuring Your Web Browser to Use ",
  StyleBox["MathReader",
    FontSlant->"Italic"],
  " "
}], "Subsubsection",
  ShowCellBracket->False,
  CellTags->{"Web Browser", "Using MathReader"}],

Cell[TextData[{
  "You can set up your web browser to launch ",
  StyleBox["MathReader",
    FontSlant->"Italic"],
  " whenever it needs to view a notebook on the web.\nTo do this, associate ",
  
  StyleBox["MathReader",
    FontSlant->"Italic"],
  " with the notebook mime type for notebooks. This mime type is \
application/mathematica.\n\nHere is how to set this up in a Netscape browser.\
\n1. Choose ",
  StyleBox["General", "SR"],
  " from the Preferences menu.\n2. Go to the Helpers section.\n3. Click ",
  "New",
  " to create a new Helper entry.\n\nUse the following definitions in the new \
Helper entry.\n",
  StyleBox["Mime type:  ",
    FontWeight->"Bold"],
  " application (or application/mathematica)\n",
  StyleBox["Subtype:",
    FontWeight->"Bold"],
  "       mathematica\n",
  StyleBox["Extension:",
    FontWeight->"Bold"],
  "    ma, nb\n",
  StyleBox["Application:",
    FontWeight->"Bold"],
  " MathReader\n",
  StyleBox["FileType:",
    FontWeight->"Bold"],
  "      text\n",
  StyleBox["Action:          ",
    FontWeight->"Bold"],
  "launch application"
}], "Text",
  ShowCellBracket->False,
  CellTags->{"Web Browser", "Using MathReader"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Animating Graphics", "Subsubsection",
  ShowCellBracket->False,
  CellTags->{"Animation", "Using MathReader"}],

Cell[TextData[{
  "Animate graphics in a group of cells by double-clicking any of them. \
Animate any sequence of graphics by selecting them and choosing ",
  StyleBox[ButtonBox["Animate Selected Graphics",
    ButtonData:>"Animate Selected Graphics",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Helvetica"],
  StyleBox[" ", "SR"],
  "in the Cell menu. Click again anywhere to cancel.\n"
}], "Text",
  ShowCellBracket->False,
  CellTags->{"Animation", "Using MathReader"}],

Cell[CellGroupData[{

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m0000050003
d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000^0003
d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f00006`02d2T00]0>00;@
:@02d0h00m0X00;@3P03d2P00]0>00?@:002d0h00m0Y00;@>@0001d00]0U00;@4P02d2H000?@0000
4@000m00000T0003d000014000?@000090000m00000A0003d00002@000?@00004@000m00000T00;@
>`0001l000?@00008@000m00000D0003d000028000?@00004`000m00000R0003d00001<000?@0000
8P000m00000C0003d000028000?@00004`000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@
5`02d2000]0G00;@8002d1L00m0O00;@5`03d1l00]0n00008P03d1X00]0L00?@6P03d1/00m0J00?@
6`03d1X00m0L00;@6P03d1`00]0J00?@@00002D00]0E00?@8@02d1H00]0Q00;@5P02d2400m0E00;@
8@03d1D00]0Q00?@5@02d4<0000?00<O5@05d0/01M0V00G@2`06d2D01M0;00K@9P04d0/01]0V00C@
2`06d2H01M0:00K@A@0000l00alJo`_@7OlC00_@<00;d3002m0`00_@<@0:d4/0000?00<O00?oP800
?8000on0o`3o05H0000@0014ol20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`?o0P?oo05H0000@0005oh20P?l0>X001On0P83o0?l0EP000100
04Co`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`?o0P<20ool0EP00010000?oP8000h000on0P00dP003oh2000>000?o0000o`1D00004000A?o0
P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0
P<20`83oo`1F000040000on0P005P003oh20032000?oP8001H000ol0003o05@0000@0014ol20`830
P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P?oo05H0000@0003oh2000N000?oP800;8000on0P007P003o`000?l0E000010004Co`830P<20`830
P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20ool0
EP00010000?oP8002H000on0P00XP003oh2000V000?o0000o`1D00004000A?o0P<20`830P<20`83o
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`83oo`1F0000
40000on0P00;P003oh2002B000?oP8002h000ol0003o05@0000@0014ol20`830P<20`830P<20oh30
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P?oo05H0000@0003
oh2000f000?oP80088000on0P00=P003o`000?l0E0000100037o`830P<20`830P<20`830P?n0`830
P<20`830P<20`830P<20`830P<20`830P<2000;o0170P<20`830P<20`830P<20o`3o05H0000@0003
oh2000n000?oP8006h000on0P00@P003o`000?l0E000010004Co`830P<20`830P<20`830P<20oh30
P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20ool0EP00010000?oP800
4H000on0P00GP003oh2001:000?o0000o`1D00004000A?o0P<20`830P<20`830P<20`830P?n0`830
P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`83oo`1F000040000on0P00CP003
oh2001>000?oP80058000ol0003o05@0000@0014ol20`830P<20`830P<20`830P<20`83oP<20`830
P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P?oo05H0000@0003oh2001F000?oP800
3h000on0P00FP003o`000?l0E000010004Co`830P<20`830P<20`830P<20`830P<20oh30P<20`830
P<20`830P?n0`830P<20`830P<20`830P<20`830P<20ool0EP00010000?oP8005h000on0P00;P003
oh2001R000?o0000o`1D00004000A?o0P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830
P?n0`830P<20`830P<20`830P<20`830P<20`83oo`1F000040000on0P00IP003oh2000N000?oP800
6X000ol0003o05@0000@0014ol20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P?n0`830
P<20`830P<20`830P<20`830P<20`830P?oo05H0000@0003oh2001^000?oP8000h000on0P00LP003
o`000?l0E000010004Co`830P<20`830P<20`830P<20`830P<20`830P<20oh30P?n0`830P<20`830
P<20`830P<20`830P<20`830P<20ool0EP00010000?oP8007H000on0o`0PP003o`000?l0E0000080
oon5ob<0000@0003oh2001f01?lOP003o`000?l0E000010001oo`830P<20`830P<20`830P<20`830
P<20`830P<2000Co0270ol20`830P<20`830P<20`830P<20`830P<20`830P?l0o`1F000040000on0
P00KP003oh2000B000?oP8006h000ol0003o05@0000@0014ol20`830P<20`830P<20`830P<20`830
P<20`83oP<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P?oo05H0000@0003oh2001V0
00?oP80028000on0P00IP003o`000?l0E000010004Co`830P<20`830P<20`830P<20`830P<20`83o
P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20ool0EP00010000?oP8005h000on0
P00<P003oh2001N000?o0000o`1D00004000A?o0P<20`830P<20`830P<20`830P<20`83oP<20`830
P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`83oo`1F000040000on0P00EP003oh200120
00?oP8005H000ol0003o05@0000@0014ol20`830P<20`830P<20`830P<20`83oP<20`830P<20`830
P<20`830P<3o`830P<20`830P<20`830P<20`830P?oo05H0000@0003oh2001>000?oP80058000on0
P00CP003o`000?l0E000010004Co`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830
P<20`830ol20`830P<20`830P<20`830P<20ool0EP00010000?oP8004H000on0P00HP003oh200160
00?o0000o`1D00004000A?o0P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830
P<20`?o0P<20`830P<20`830P<20`83oo`1F000040000on0P00?P003oh2001b000?oP8003h000ol0
003o05@0000@0014ol20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830
P<3o`830P<20`830P<20`830P?oo05H0000@0003oh2000f000?oP80088000on0P00=P003o`000?l0
E000010004Co`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
ol20`830P<20`830P<20ool0EP00010000?oP8002h000on0P00TP003oh2000^000?o0000o`1D0000
4000A?o0P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0
P<20`830P<20`83oo`1F000040000on0P009P003oh2002R000?oP8002H000ol0003o05@0000@0014
ol20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830
P<20`830P?oo05H0000@0003oh2000N000?oP800;8000on0P007P003o`000?l0E000010004Co`830
P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830
P<20ool0EP00010000?oP8001H000on0P00`P003oh2000F000?o0000o`1D00004000A?o0P<20`83o
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`83o
o`1F000040000on0P003P003oh2003B000?oP8000h000ol0003o05@0000@0014ol20`83oP<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P?oo05H0
000@0005oh20P?l0>X001On0P83o0?l0EP00010004Co`83oP<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20ool0EP00010000?oP?l0?X000on0
o`3o05H0000@00;o0420`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`8300_oo05H0000@04Coo`1F0000o`2Z0000o`2Z0000o`2Z0000o`2Z0000
o`2Z0000o`2Z0000o`2Z0000o`2Z0000o`2Z0000o`2Z0000o`2Z0000o`2Z0000o`2Z0000o`2Z0000
o`2Z0000o`2Z0000\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 3}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m0000050003
d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000^0003
d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f00006`02d2T00]0>00;@
:@02d0h00m0X00;@3P03d2P00]0>00?@:002d0h00m0Y00;@>@0001d00]0U00;@2P03o`D00]0V0003
d000014000?@000090000m00000A0003d00002@000?@00004@000m00000T0003d000014000?@0000
9002d3/0000O0003d000024000?@00001@05o`:000?o00001@000m00000R0003d00001<000?@0000
8P000m00000C0003d000028000?@00004`000m00000R0003d00001<000?@00008P000m00000k0000
8002d1l00]0300Go00K0P<20`802o`P00]0P00;@5`02d2000]0G00;@8002d1L00m0O00;@5`03d1l0
0]0n00008P03d1X00]000`3oo`02o`Z000CoP83o2@03d1X00m0K00?@6P03d1/00m0J00?@7002d1X0
0m0L00;@6P03d400000U00;@5@03d0?o01:0`830P<20`830P<20`?o0P?l<00;@5P02d2400]0F00;@
8@03d1D00]0Q00?@5@02d2400m0E00;@@`0000l00alE00G@2`05d003oh20012000GoP820o`0>00G@
2`06d2D01M0;00K@9P04d0/01]0V00C@2`06d2H01M0:00K@A@0000l00alJ00_@01goP<20`830P<20
`830P<20`830P<20`?o0P<20o`0C00_@<00;d3002m0`00_@<@0:d4/0000?00<O7@05oaZ000?oP800
0X000ol0003o05@0000[00Co02K0P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830ool0
E@0002H01OlQP003oh2000F000?o0000o`1C00008@05o`0_P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<3o`830P<20`?l0o`1E00007@04obZ000?oP8001X000ol0003o05<0000H00Go
03W0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P?l0
o`1D00003`037`030?oo00?o<X000on0P008P003o`000?l0DP0000l00al0A?o0P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`83oo`1D0000
3`037`03P?oo03>000?oP8002X000ol0003o0580000A0015oh30P?n0`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`83o0?l0E000018000CoP820
0_l_P003oh2000b000?o0000o`1A00004P001_o0P<20`0;o03f0`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<3o0?l0D`00018000?oP8001H000on0
P00YP003oh2000f000?o0000o`1A00004P002Oo0P<20`830P002o`0j`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830ool0D`00018000?oP8002802obJ0
00?oP8003h000ol0003o0500000C0015oh30P<20`830P<20oh30P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`?o0P<20`830P<20`830P<20`83o0?l0DP0001<000?oP8002X02ob6000?oP800
4H000ol0003o0500000C000?oh30P<20`830P<20`83000;o03B0`830P<20`830P<20`830P<20`830
P<20`830P<20oh30P<20`830P<20`830P<20`83oo`1B00004`000on0P00>P003oh2001^000?oP800
4X000ol0003o0500000D000Aol20`830P<20`830P<20`8000_l0</20`830P<20`830P<20`830P<20
`830P<20oh30P<20`830P<20`830P<20`830P<3oo`1A000050000on0P00@P0;o68000on0P00DP003
o`000?l0C`0001@004Go`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`?o0
P<20`830P<20`830P<20`830P<20`?l0o`1A000050000on0P00CP0;o4h000on0P00FP003o`000?l0
C`0001@001So`830P<20`830P<20`830P<20`830P<02o`0/P<20`830P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P?oo0500000E0003oh2001J000?oP8003H000on0P00HP003o`000?l0
CP0001D001[oP<20`830P<20`830P<20`830P<20`830P0;o02W0P<20`830P<20`83oP<20`830P<20
`830P<20`830P<20`830P<20o`3o0500000E0003oh2001V00_l:P003oh2001V000?o0000o`1>0000
5@00AOn0`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`?o0P<20`830P<20`830P<20
`830P<20`830P<20o`3o0500000F0003oh2001^00_l5P003oh2001b000?o0000o`1=00005P008?o0
P<20`830P<20`830P<20`830P<20`830P<20`8300_l08h30P?n0`830P<20`830P<20`830P<20`830
P<20`830P<3o0?l0C`0001H000?oP8007h000on0o`0OP003o`000?l0C@000080oon5ob<0000F0003
oh2001j00ol00h3oP00NP003o`000?l0C00001L0023oP<20`830P<20`830P<20`830P<20`830P<20
`830P0?o02:0`?ooP<20`830P<20`830P<20`830P<20`830P<20`83oo`1>00005`000on0P00MP003
oh2000B000?oP8006X000ol0003o04`0000G000Xoh30P<20`830P<20`830P<20`830P<20`830P<20
`83oP<20`830P0;o01_0P<20`830P<20`830P<20`830P<20`830P?l0o`1>00005`000on0P00LP003
oh2000R00_lHP003o`000?l0C00001P004Go`830P<20`830P<20`830P<20`830P<20`830P?n0`830
P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`?l0o`1=000060000on0P00JP003oh2000b0
0_lFP003o`000?l0B`0001P004Go`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830
P<20`830ol20`830P<20`830P<20`830P<20`?l0o`1=000060000on0P00HP003oh2001600_lCP003
o`000?l0B`0001P004Ko`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830
P<20oh30P<20`830P<20`830P<20`83oo`1<00006@000on0P00FP003oh2001F00_lAP003o`000?l0
BP0001T003?oP<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<00
0_l04830P<20`830P<20`830P?oo04`0000I0003oh2001F000?oP8006X000on0P00<P003o`000?l0
BP0001T003KoP<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20
`802o`0=`830P<20`830P<20o`3o04`0000J0003oh2001:000?oP8007h000on0P00:P003o`000?l0
B@0001X003So`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830
P<20`0;o00^0`830P<20`830o`3o04/0000J0003oh20016000?oP8008h000on0P007P003o`000?l0
B@0001X003_o`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P002o`08`830P<20`?oo04/0000J0003oh20012000?oP8009h000on0P005P003o`000?l0
B00001/003goP<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`83000;o00J0`830P?oo04X0000K0003oh2000f000?oP800;802o`>000?o0000o`180000
6`00AOn0`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830ol20o`3o04X0000K0003oh2000b000?oP800<803ool0BP0001`004?o`830P<20`830
P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<2000;o
o`19000070000on0P00:P003oh2003:00ooo04T0000L000mol20`830P<20`830ol20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P005ool0C00001`000?oP80028000on0
P00ZP0Goo`1A00007000=?o0P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<04ool0EP0001d000?oP8001X000on0P00RP0Goo`1J00007@00:On0`830P<20oh30P<20
`830P<20`830P<20`830P<20`830P<20`83000Goo`1O00007@000on0P005P003oh2001Z01?oo06@0
000M000Poh30P<20`?o0P<20`830P<20`830P<20`830P<20`805ool0J00001h000?oP8000X000on0
P00CP0Coo`1]00007P005_o0P<20oh30P<20`830P<20`830P<05ool0L@0001h000GoP820o`0<P0Go
o`1f00007P003Oo0P?n0`830P<20`8001?oo07/0000N0004oh20o`B01Ooo07l0000O00Ooo`240000
7`02ool0R@000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000001\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0005
d0000?l00]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00000_l0183o0=0b0003d00000D000?@0000<0000m0000050003
d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
0ol2P005oh3o0=00;`02d0T000?@0000;@02d0T000?@0000;@02d0T000?@0000;@02d0T000?@0000
;P000m00000e00006P000m00000[000;d?oo`830P<3o`?l00P000m00000[0003d00000X000?@0000
:`000m00000:0003d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f0000
6`02d2T00]000on0P005P004oh20o`800]0Y00;@3P03d2P00]0>00?@:002d0h00m0X00;@3P03d2T0
0]0i00007@02d2D00]003_o0P<20`830P?n0`83o1002d2H000?@00004@000m00000T0003d0000140
00?@000090000m00000A0003d00002@000?@00004@000m00000T00;@>`0001l000?@000080000oo@
o`0:P003oh2000:000?o00000`000m00000R0003d00001<000?@00008P000m00000C0003d0000280
00?@00004`000m00000R0003d00001<000?@00008P000m00000k00008002d1h001God=30P<20`830
P<20`?o0P<20`?l01P02d2000]0G00;@8002d1L00]0P00;@5`03d1l00]0G00?@7`02d3h0000R00?@
6@000oo@d00=P003oh2000>000?o00001P03d1X00m0K00?@6P03d1/00m0J00?@7002d1X00m0L00;@
6P03d400000U00;@5@03d00G`830P<20`830P<20`830ol20`830P?l02P02d1H00]0Q00;@5P02d240
0m0E00;@8@03d1D00]0Q00?@5@02d4<0000?00<O5@05d0/01M0AP003oh2000F000?o00002P05d0/0
1]0U00G@2`06d2H01=0;00K@9P04d0/01]0V00G@2P06d4D0000?00<O6P0;d0;o01k0P<20`830P<20
`830P<20`830P?n0`830P<20`?l@00_@<00;d3002m0`00_@<@0:d4/0000?00<O8`02oaF000?oP800
1h000ol0003o0540000b00?o02?0P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20o`3o0580
000`00;o6X000on0P008P003o`000?l0D00002h00_l0:H30P<20`830P<20`830P<20`830P<20`830
P?n0`830P<20`830P<3o0?l0D@0002`00_lMP003oh2000Z000?o0000o`1?0000:@03o`0^P<20`830
P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20ool0D00000l00alE00;o8H000on0
P00<P003o`000?l0CP0000l00alC00;o03?0P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`?o0P<20`830P<20`830P?l0o`1@00003`037a400_lTP003oh2000j000?o0000o`1=00008003o`0h
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`?oo04l0
000N00;o:8000on0P00@P003o`000?l0C00001`00_l0?X30P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`83oo`1>00006P02obb000?oP8004H000ol0
003o04/0000G00?o04>0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83o
P<20`830P<20`830P<20`830P<3o0?l0C@0001800al2oc2000?oP8004h000ol0003o04X0000B00<O
04WoP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20
`830P<20`830P<20`83o0?l0C00001800al0183oool]P003oh2001F000?o0000o`1900005@001?n0
`803o`13P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830
P<20`830P<20`830o`3o04/0000E0003oh2000B00olVP003oh2001N000?o0000o`1800005P002Oo0
P<20`830P002o`0o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20
`830P<20`830P<20`83o0?l0BP0001H000?oP8002803ob6000?oP8005h000ol0003o04P0000G000=
oh30P<20`830P<20`003o`0j`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`830P<20`830ool0B@0001L000?oP8003H03oaZ000?oP8006H000ol0003o04L0000G000C
oh30P<20`830P<20`830P<20`002o`0fP<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830
P<20`830P<20`830P<20`83oo`18000060000on0P00AP0?o58000on0P00KP003o`000?l0AP0001P0
01Oo`830P<20`830P<20`830P<20`830P003o`0aP<20`830P<20`830P<20`83oP<20`830P<20`830
P<20`830P<20`830P<20`830o`3o04L0000I0003oh2001J00ol=P003oh2001f000?o0000o`150000
6@007?n0`830P<20`830P<20`830P<20`830P<20`802o`0]`830P<20`830P<3o`830P<20`830P<20
`830P<20`830P<20`830P<20`83o0?l0AP0001X000?oP8006X03o`N000?oP8007h000ol0003o04@0
000J000Pol20`830P<20`830P<20`830P<20`830P<20`830P<03o`0X`830P?n0`830P<20`830P<20
`830P<20`830P<20`830P<20`830ool0A@0001/000?oP8007h03o`03P?n0026000?o0000o`130000
0P3oohGo8`0001`000?oP8008806ob2000?o0000o`12000070008oo0P<20`830P<20`830P<20`830
P<20`830P<20`830P<2000?o00>0`8000ol07X30P<20`830P<20`830P<20`830P<20`830P<20ool0
A00001`000?oP80088000on0P006P0?o6h000ol0003o0440000M000^oh30P<20`830P<20`830P<20
`830P<20`830P<20`830P?n0`830P<20`830P0;o01[0P<20`830P<20`830P<20`830P<20`830ool0
@`0001d000?oP8007X000on0P00<P0?o5h000ol0003o0400000N000bol20`830P<20`830P<20`830
P<20`830P<20`830P<3o`830P<20`830P<20`830P<03o`0E`830P<20`830P<20`830P<20`83o0?l0
@P0001h000?oP80078000on0P00CP0?o4X000ol0003o03l0000O000goh30P<20`830P<20`830P<20
`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`002o`0AP<20`830P<20`830P<20`?l0
o`1100007`000on0P00KP003oh2001R00ol>P003o`000?l0?P00020003_o`830P<20`830P<20`830
P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P003o`0<P<20`830P<20`83o
o`10000080000on0P00IP003oh2001n00ol8P003o`000?l0?P000240043oP<20`830P<20`830P<20
`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<200_l02<20`830P<3o
o`0o00008@000on0P00GP003oh2002F00ol4P003o`000?l0?@00028004Co`830P<20`830P<20`830
P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`0?o00?0P?l0
o`0n00008P000on0P00EP003oh2002b00ooo03h0000R0019ol20`830P<20`830P<20`830P<20`830
ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P002ool0?@0002<0
00?oP8004h000on0P00]P0;oo`0o00008`00@on0`830P<20`830P<20`830P<20`83oP<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<000ooo0440000T0003oh2001:000?oP800
:802ool0A00002@003ko`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`0;oo`1600009@000on0P00@P003oh2002F00_oo04P0000U000hoh30P<20
`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`803ool0BP0002H0
00?oP8003X000on0P00QP0;oo`1=00009P00<oo0P<20`830P<20`830P<20oh30P<20`830P<20`830
P<20`830P<20`830P<20`830P002ool0C`0002L000?oP80038000on0P00NP0;oo`1A00009`00;On0
`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`003ool0D`0002L000?oP800
38000on0P00IP0;oo`1F0000:000:?o0P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830
P<02ool0F00002P000?oP8002X000on0P00EP0?oo`1J0000:@008_n0`830P<20`830ol20`830P<20
`830P<20`830P<20`802ool0G@0002T000?oP80028000on0P00BP0;oo`1O0000:P007Oo0P<20`830
P<3o`830P<20`830P<20`830P<2000;oo`1Q0000:P000on0P006P003oh2000j00ooo06<0000[000G
oh30P<20`83oP<20`830P<20`830P<000_oo06H0000[0003oh2000B000?oP8002h02ool0J00002`0
01;o`830P<3o`830P<20`830P<02ool0JP0002`000?oP8000h000on0P006P0?oo`1/0000;0003Oo0
P<20oh30P<20`8000_oo06l0000]0005oh20P?l01H02ool0L@0002d000SoP<3o`830P0;oo`1c0000
;P001?n0oh03ool0M@0002h000Co`?ooo`1h0000;`000ol0003o07P0003o0:X0003o0:X0003o0:X0
003o0:X0003o0:X0003o0:X00000\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=20om0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0c0004
om20P0;o0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d00002l000[od830P?n0o`3@<P000m0000050003d000030000?@00001@000m00
000`0003d00000D000?@0000<0000m0000050003d000030000?@0000=00001T000?@0000;@02d0>0
00OoP820o`3@02l00]090003d00002d00]090003d00002d00]090003d00002d00]090003d00002h0
00?@0000=@0001X000?@0000:P003?o@`830P<3o`830o`8000?@0000:`000m00000:0003d00002/0
00?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002`000?@0000=P0001/0
0]0Y00;@1X000on0P002P003o`0000;@:@02d0h00m0X00;@3P03d2P00]0>00?@:002d0h00m0Y00;@
>@0001d00]0U00;@00n0`830P<20`?o0P<20`?l00`02d2H000?@00004@000m00000T0003d0000140
00?@000090000m00000A0003d00002@000?@00004@000m00000T00;@>`0001l000?@00008@000m20
P008P003oh2000B000?o00000P000m00000R0003d00001<000?@00008P000m00000C0003d0000280
00?@00004`000m00000R0003d00001<000?@00008P000m00000k00008002d1l00]004l20`830P<20
`83oP<20`830P?l01@02d2000]0G00;@8002d1L00]0P00;@5`03d1l00]0G00?@7`02d3h0000R00?@
6P02d0b000?oP8001X000ol0000400?@6P03d1/00m0J00?@6`03d1X00m0L00;@6P03d1`00]0J00?@
@00002D00]0E00?@01WoP<20`830P<20`830P?n0`830P<20`83o00P00]0F00;@8@02d1H00]0Q00?@
5@02d2400m0E00;@8@03d1D00]1300003`037aD01M0;00G@00<0ool03X000on0P007P003o`0000P0
1M0;00K@9@05d0/01]0V00C@2`06d2H01=0;00K@9P05d0X01]1500003`037aX02m05000Mol20`830
P<20`830P<20`83oP<20`830P<20`?l03P0;d3002m0`00_@<00;d3402]1;00003`037bP00_lAP003
oh2000V000?o0000o`1>0000>@008_n0`830P<20`830P<20`830P<3o`830P<20`830P<20`?oo04l0
000h0003oh20016000?oP8002h000ol0003o04d0000f00;o02B0`830P<20`830P<20`830P<20`?o0
P<20`830P<20`830P?oo04h0000e0003oh2001B000?oP8003H000ol0003o04/0000c00;o02W0P<20
`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20o`3o04`0000?00<O80000on0P00GP003
oh2000j000?o0000o`1:00003`037ah00_l0;H30P<20`830P<20`830P<20`830P<20`83oP<20`830
P<20`830P<20`830o`3o04/0000?00<O7@000on0P00IP003oh20016000?o0000o`180000;P00<oo0
P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830o`3o04T0000/00;o
7H000on0P00BP003o`000?l0A`0002/003OoP<20`830P<20`830P<20`830P<20`830P<20`830P?n0
`830P<20`830P<20`830P<20`83o0?l0B00002T00_lOP003oh2001F000?o0000o`150000:000??o0
P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20ool0
AP0001800alA00;o8X000on0P00FP003o`000?l0A00001800al@0010oh30P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830ool0A@0001800al?0003
oh2002>000?oP80068000ol0003o0480000R00;o04:0`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P?oo04@0000Q0003oh2002F000?oP800
6X000ol0003o0440000O00;o04O0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
oh30P<20`830P<20`830P<20`830P<20`830P<20o`3o0480000N0003oh2002R000?oP80078000ol0
003o03l0000M001<oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20
`830P<20`830P<20`830P<20`830P<20`830ool0@@0001/00_l/P003oh2001f000?o0000o`0n0000
5`037`1Aol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P<20`830P<3o0?l0?`0001L00al3ob^000?oP80088000ol0003o03`0
000G00<O00>0`8001ol0B830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`830P<20`830P<20`830P<20ool0?P0001X000?oP8001h06oaj000?oP8008H000ol0
003o03/0000K000?oh30P<20`830P<20`83000Oo03g0P<20`830P<20`830P<20`830P<20`?o0P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`83o0?l0?00001`000?oP8004X07oa2000?oP800
8h000ol0003o03T0000L000Lol20`830P<20`830P<20`830P<20`830P<20`0Ko0360`830P<20`83o
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o0?l0>`0001d000?oP8007X07o`:0
00?oP8009H000ol0003o03P000020?ooQOlS00007P000on0P00UP0?o0X06oan000?o0000o`0g0000
7`009on0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`003o`08`830P<20`806o`0K
`830P<20`830P<20`830P<20`830P<20`83o0?l0>000020000?oP80098000on0P00=P0Ko5H000ol0
003o03D0000Q000loh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20
`830P<20`830P<201Ol04X30P<20`830P<20`830P<20ool0=P00024000?oP8008X000on0P00IP0Ko
2h000ol0003o03@0000R0016ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830
P<20`830P<20`830P<20`830P<20`830P<20`0Ko00N0`830P<3o0?l0=@0002<000?oP80088000on0
P00UP0Ko00>0o`00o`0c00008`00DOn0`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`003ool0<`0002@000?oP800
7h000on0P00[P003o`000?l0<`0002D004goP<20`830P<20`830P<20`830P<20`830P<20`830P?n0
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`002ool0=P0002H000?oP800
78000on0P00YP003o`000?l0=P0002H004Wo`830P<20`830P<20`830P<20`830P<20`830P<20oh30
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<2000;oo`0i00009`000on0P00KP003
oh2002J000?o0000o`0i0000:000A_o0P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P?oo03`0000X0003oh2001V000?oP8009802ool0
?@0002T004;oP<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`?oo03l0000Z0003oh2001N000?oP8008H02ool0@00002/003goP<20`830P<20
`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`83o0?l0@P0002/0
00?oP8005X000on0P00NP0;oo`130000;000>Oo0P<20`830P<20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`830P<20`830P<20`830o`3o04D0000]0003oh2001>000?oP8007802ool0AP0002d0
03GoP<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20o`3o04P0
000^0003oh2001:000?oP8006X000ol0003o04L0000_000_oh30P<20`830P<20`830P<20`83oP<20
`830P<20`830P<20`830P<20`830P<000_oo04X0000`0003oh20012000?oP8005h000ol0003o04X0
000`000[ol20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P002ool0C@000340
00?oP8003X000on0P00EP003o`000?l0C@00038002Ko`830P<20`830P<20`830ol20`830P<20`830
P<20`830P<20`0;oo`1@0000<P000on0P00=P003oh2001:000?o0000o`1@0000<`008_n0`830P<20
`830P<20`?o0P<20`830P<20`830P<20`802ool0D`0003@000?oP8002h000on0P00?P003o`000?l0
D`0003D001ooP<20`830P<20`830ol20`830P<20`830P<20`83o0?l0EP0003D000?oP8002H000on0
P00=P0;oo`1G0000=P006oo0P<20`830P<20oh30P<20`830P<20`830o`3o05T0000g0003oh2000N0
00?oP8002X02ool0FP0003L001OoP<20`830P<20oh30P<20`830P<20o`3o05`0000h0003oh2000J0
00?oP8001h02ool0G@0003T001;oP<20`830ol20`830P<20`?oo05l0000j0003oh2000>000?oP800
1H02ool0H00003X000ko`830P<3o`830P<20ool0HP0003/000?oP8000X000on0P003P003o`000?l0
H@0003`000So`830ol20`0;oo`1T0000?0001On0P83o00:000?o0000o`1T0000?@001?n0oh02ool0
I`0003h00ooo06T0000o0003o`000?l0J0000?l0ZP000?l0ZP000?l0ZP000001\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d003o`0003H00]0i00;@>@02d3T00]0i00;@<P0001D0
00?@0000=@001M20om3o03H000C@003@=`001=000=0g0004d000d3L000C@003@=`000m00000b0000
5P02d3@000G@P83oP002d3@000?@00000P02d3@000?@00000P02d3@000?@00000P02d3@000?@0000
0P02d3@000?@0000<`0001P000?@0000<0002M20`83oP<20d00b0003d00000D000?@0000<0000m00
00050003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00
000]00;@18000on0P002P003d00002d00]090003d00002d00]090003d00002d00]090003d00002d0
0]090003d00002h000?@0000=@0001X000?@0000:`003]3oP<20`83oP<20`83@;@000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002`000?@0000
=P0001/00]0Y00;@00?oP80018000on0P004P0;@:@02d0h00m0X00;@3P03d2P00]0>00?@:002d0h0
0m0Y00;@>@0001d00]0U00;@0180oh30P<20`83oP<20`830P?l2d2H000?@00004@000m00000T0003
d000014000?@000090000m00000A0003d00002@000?@00004@000m00000T00;@>`0001l000?@0000
8@001=000?l8P003oh2000J000?o0=0090000m00000C0003d000028000?@00004`000m00000R0003
d00001<000?@00008P000m00000C0003d000028000?@0000>`0002000]0O00;@0P005_n0`830P<20
`83oP<20`830P<20o`02d2000]0G00;@8002d1L00]0P00;@5`03d1l00]0G00?@7`02d3h0000R00?@
6P02d0<000?oP80028000on0P008P003o`0000?@6P03d1/00m0J00?@6`03d1X00m0L00;@6P03d1`0
0]0J00?@@00002D00]0E00?@10006On0`830P<20`830P?n0`830P<20`830P?l01002d1H00]0Q00;@
5P02d2400m0E00;@8@03d1D00]0Q00?@5@02d4<0000?00<O5@05d0/01M060003oh2000Z000?oP800
2X000ol0000300G@2`06d2D01M0;00K@9P04d0/01]0V00C@2`06d2H01M0:00K@A@0000l00alJ00_@
2P007On0`830P<20`830P<20oh30P<20`830P<20`83o00T02m0`00_@<00;d3002m0a00[@B`0000l0
0al^0003oh2000b000?oP80038000ol0003o04T0000n00;o0220`830P<20`830P<20`83oP<20`830
P<20`830P<20ool0BP0003d000?oP8003h000on0P00>P003o`000?l0A`0003`002Ko`830P<20`830
P<20`830P<20oh30P<20`830P<20`830P<20ool0B00003/000?oP8004H000on0P00@P003o`000?l0
A@0003X002[o`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P?oo04H0000?00<O
9`000on0P00CP003oh2001:000?o0000o`1300003`037bH002ko`830P<20`830P<20`830P<20`830
P?n0`830P<20`830P<20`830P<20`83oo`1400003`037bD000?oP8005H000on0P00DP0;oo`120000
=P00<oo0P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830o`3o0440
000e0003oh2001N000?oP8005h000ol0003o03h0000d000gol20`830P<20`830P<20`830P<20`830
P<20oh30P<20`830P<20`830P<20`830P<20`830o`3o03l0000c0003oh2001V000?oP8006H000ol0
003o03`0000b000kol20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830
P<20`830P<20`?l0o`0m00004P037a`000?oP8006h000on0P00KP003o`000?l0>P0001800alK000o
ol20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830
P<3o0?l0>`0001800alI00;o7h000on0P00MP003o`000?l0>00002d004CoP<20`830P<20`830P<20
`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830ool0>@0002`0
00?oP80088000on0P00OP003o`000?l0=P0002/004SoP<20`830P<20`830P<20`830P<20`830P<20
`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`?oo03L0000Z0003oh2002:0
00?oP8008H000ol0003o03@0000Y001<oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ool0=@0002P000?oP80098000on0
P00SP003o`000?l0<P0001L00al=001@oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?oo03<0000G00<O30000on0
P00VP003oh2002F000?o0000o`0`00005`037`/005CoP<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?oo0340
000T0003oh2002R000?oP8009h000ol0003o02h0000S001Hoh30P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830ool0;`00028000?oP800:X000on0P00YP003o`000?l0;000024005coP<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830ool0;@00020000?oP800;8000on0P00[P003o`000?l0:P0000807?l37ooo
I_lS00007P037`03oh2002Z00ol[P003o`000?l0:`0001h00al0;@3o`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`003o`0[`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20o`3o02h0000S0003oh2002V000?oP800:8000ol0003o02d0000T001Fol20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P?oo0300000U0003oh2002N000?oP8009X000ol0003o02l0000V001B
ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20ool0<P0002L000?oP8009H000on0P00TP003o`000?l0<@0002P0
04ko`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P?oo03@0000Y0003oh2002>000?oP8008X000ol0003o03<0000Z001:
ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830
P<20`830P<20`830P?oo03H0000[0003oh20026000?oP80088000ol0003o03D0000/0016ol20`830
P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830
P<20ool0>00002d000?oP8007h000on0P00NP003o`000?l0=`0002h004;o`830P<20`830P<20`830
P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P?oo03X0000_0003
oh2001f000?oP80078000ol0003o03T0000`000nol20`830P<20`830P<20`830P<20`830P<20`830
P?n0`830P<20`830P<20`830P<20`830P<20`830P?oo03`0000a0003oh2001^000?oP8006X000ol0
003o03/0000b000jol20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830
P<20`830P<20ool0?P0003<000?oP8006H000on0P00HP003o`000?l0?@0003@003Ko`830P<20`830
P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P?oo0400000e0003oh2001N0
00?oP8005X000ol0003o03l0000f000bol20`830P<20`830P<20`830P<20`830P?n0`830P<20`830
P<20`830P<20`830P?oo0480000g00;o5X000on0P00DP003o`000?l0@@0003T002goP<20`830P<20
`830P<20`830P<20oh30P<20`830P<20`830P<20`830P?l0o`140000>P000on0P00BP003oh2001:0
00?o0000o`130000>`00:On0`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`83o0?l0
AP0003`000?oP80048000on0P00@P003o`000?l0A@0003d002GoP<20`830P<20`830P<20`83oP<20
`830P<20`830P<20`83o0?l0B00003h000?oP8003X000on0P00>P003o`000?l0A`0003l0027oP<20
`830P<20`830P<20oh30P<20`830P<20`830P?l0o`1:0000@0000on0P00<P003oh2000b000?o0000
o`190000@@007On0`830P<20`830P<20oh30P<20`830P<20`83o0?l0C000048000?oP8002X000on0
P00:P003o`000?l0B`0004<001WoP<20`830P<20`83oP<20`830P<20`83o0?l0CP0004@000?oP800
28000on0P008P003o`000?l0C@0004D001GoP<20`830P<20oh30P<20`830P?l0o`1@0000AP000on0
P006P003oh2000J000?o0000o`1?0000A`004On0`830P<20oh30P<20`83o0?l0DP0004P000?oP800
18000on0P004P003o`000?l0D@0004T000goP<20`83oP<20`83o0?l0E00004X000?oP8000X000on0
P002P003o`000?l0D`0004/000WoP<20oh30P?l0o`1F0000C0001?n0P?l2P003o`000?l0E@0004d0
00GoP?n0o`3o05P0001>00?oo`1I0000C`000ol0003o05P0003o0:X0003o0:X0003o0:X00000\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=3o`=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d?oo00:00]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000W@ol3o`830P=00<P000m0000050003d000030000?@00001@000m00
000`0003d00000D000?@0000<0000m0000050003d000030000?@0000=00001T000?@0000;@02d005
oh20P?l018000m3o000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00
000^0003d00003D0000J0003d00002/000o@003oP<20oh30P<20d?l0;0000m00000:0003d00002/0
00?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002`000?@0000=P0001/0
0]0Y00;@0P000on0P002P003oh2000B00]0Y00;@3P03d2P00]0>00?@:002d0h00m0X00;@3P03d2T0
0]0i00007@02d2D00]03000?oh30P<20oh30P<20`83000;@9P000m00000A0003d00002@000?@0000
4@000m00000T0003d000014000?@000090000m00000A0003d00002@00]0k00007`000m00000Q0003
d000008000?oP80018000on0P008P003d000028000?@00004`000m00000R0003d00001<000?@0000
8P000m00000C0003d000028000?@00004`000m00000R0003d00003/0000P00;@7`02d0D001?o`830
P<20`?o0P<20`830P<2000;@8002d1L00]0P00;@5`02d2000]0G00?@7`02d1L00m0O00;@?P000280
0m0J00;@1P000on0P006P003oh2000Z00m0J00?@6`03d1X00m0K00?@6P03d1`00]0J00?@7002d1X0
0m1000009@02d1D00m07000Hol20`830P<20`?o0P<20`830P<20`8300_l2d1H00]0Q00;@5P02d240
0m0E00;@8@03d1D00]0Q00?@5@02d4<0000?00<O5@05d0/01M0:0003oh2000N000?oP8003H000ol0
d004d0/01]0U00G@2`06d2H01=0;00K@9P04d0/01]0V00G@2P06d4D0000?00<O6P0;d0h001coP<20
`830P<20`?o0P<20`830P<20`830P<200_l400_@<00;d3002m0`00_@<@0:d4/0000?00<O<P000on0
P009P003oh20012000?o0000o`140000@`008_n0`830P<20`830P<20oh30P<20`830P<20`830P<20
`?oo04D000130003oh2000^000?oP8004H02ool0@`00048002Ko`830P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20ool0@P00044000?oP8003H000on0P00DP0;oo`100000@000:oo0P<20`830
P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`?l0o`0o00003`037bh000?oP8003X000on0
P00GP0;oo`0m00003`037bd002ooP<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20
`830P<20o`3o03`0000?00<O;0000on0P00AP003oh2001V00_oo03X0000m000doh30P<20`830P<20
`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830ool0>@0003d000?oP8004X000on0
P00LP003o`000?l0=P0003`003Ko`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830
P<20`830P<20`830P<02ool0=P0003/000?oP8005H000on0P00NP003o`000?l0<`0003X003_o`830
P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P002ool0
<`0001800alU0003oh2001J000?oP8008H000ol0003o0300000B00<O9000?on0`830P<20`830P<20
`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`002ool0<0000180
0alS0003oh2001R000?oP80098000ol0003o02d0000h0013ol20`830P<20`830P<20`830P<20`830
P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P002ool0;@0003L000?oP800
6X000on0P00VP003o`000?l0:P0003H004Wo`830P<20`830P<20`830P<20`830P<20`830P<3o`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o0?l0:`0003D000?oP80078000on0
P00XP0;oo`0Y0000=@00COn0`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`83o0?l0:00003@000?oP8007H000on0P00[P0;o
o`0V00005`037aT005;oP<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3oo`0U00005`037aP000?oP80088000on0
P00ZP0Coo`0T00005`037aP004Wo`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<2000Oo00B0`83oo`0T0000<@000on0P00QP003
oh2001b01ol9P003o`000?l08`00030003go`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20oh30P<20`830P<20`830P<20`830P<2000Oo0120`830P<20`830P<20`83oo`0V0000;`000on0
P00SP003oh2000n01_lEP003o`000?l09@0002l0037oP<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<3o`830P<20`83000Oo01c0P<20`830P<20`830P<20`830P<20`830P<3oo`0W0000
;P000on0P00UP003oh2000Oo8H000ol0003o02H0000201co0aooofKo8`0001h00al<0003oh2001f0
1_l2P0?o9h000ol0003o02P0000N00<O2`006oo0P<20`830P<20`830P<20`830P<20`830P006o`08
`830P<20`803o`0XP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20ool0:P0002/0
00?oP8004h06o`n000?oP8009H000ol0003o02T0000Z000Bol20`830P<20`830P<20`8301Ol0?L20
`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?l0
o`0/0000:P000on0P009P0Ko6h000on0P00SP003o`000?l0:P0002T000OoP<20`83000Ko04N0`830
P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830o`3o02d0000V00<O00>0ool01?lWP003oh20026000?o0000o`0/00009P037`1Boh30P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20
`830P<20`830P<20`830ool0;`0002H00al00on0P00[P003oh20022000?o0000o`0]0000:P02o`1>
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830
P<20`830P<20`830P<20`83oo`0`0000;0000on0P00YP003oh2001f000?o0000o`0_0000;@02o`19
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20
`830P<20`830P<20o`3o0380000_0003oh2002J000?oP80078000ol0003o0300000`0017ol20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830
P<20`?l0o`0c0000<@02obJ000?oP8006H000ol0003o0380000c0012oh30P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<3oo`0e0000=002ob>0
00?oP80068000ol0003o03<0000f000nol20`830P<20`830P<20`830P<20`830P<20`830P<20`83o
P<20`830P<20`830P<20`830P<20`830P?oo03H0000g00;o88000on0P00FP003o`000?l0=@0003T0
03WoP<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P?l0
o`0h0000>P02oaj000?oP80058000ol0003o03H0000l000eol20`830P<20`830P<20`830P<20`830
P<20`830ol20`830P<20`830P<20`830P<20`?l0o`0i0000?@000on0P00JP003oh2001:000?o0000
o`0h0000?P02o`0`P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`83o
o`0j0000@0000on0P00GP003oh20016000?o0000o`0i0000@@02o`0[`830P<20`830P<20`830P<20
`830P<3o`830P<20`830P<20`830P<20o`3o03`000130003oh2001F000?oP8003X000ol0003o03/0
001400;o02N0`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`?l0o`0m0000AP000on0
P00BP003oh2000f000?o0000o`0l0000A`02o`0R`830P<20`830P<20`830P<20oh30P<20`830P<20
`830ool0?`0004T000?oP8003h000on0P00;P003o`000?l0?P0004X0023o`830P<20`830P<20`830
P?n0`830P<20`830P<20ool0@00004/00_l?P003oh2000V000?o0000o`0o0000C@006on0`830P<20
`830P<20`?o0P<20`830P<20o`3o0480001>00;o38000on0P007P003o`000?l0@@00050001Oo`830
P<20`830P<3o`830P<20`830o`3o04<0001A00;o2H000on0P006P003o`000?l0@P0005<001;oP<20
`830P<20oh30P<20`?oo04D0001D00;o1h000on0P004P003o`000?l0@`0005H000ko`830P<20oh30
P<20ool0AP0005L000?oP8000h000on0P002P003o`000?l0A@0005P00_l02830P?n0`83oo`180000
FP001?n0P?l3P003o`000?l0AP0005/00_l01<3o`?oo04T0001M00?oo`1:0000GP000ol0003o04T0
003o0:X0003o0:X0003o0:X00000\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d?oo00800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000C@0?n00_l20003d000030000?@00001@000m00000`0003d00000D0
00?@0000<0000m0000050003d000030000?@00001@000m00000`0003d00003@0000I0003d00002d0
0]00103oP?l2P0?o00?@0000;@02d0T000?@0000;@02d0T000?@0000;@02d0T000?@0000;@02d0T0
00?@0000;P000m00000e00006P000m00000[000>d0000?o0ol20`830om0]0003d00000X000?@0000
:`000m00000:0003d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f0000
6`02d2T00]030004oh20o`N00]0Y00;@3P03d2P00]0>00?@:002d0h00m0X00;@3P03d2T00]0i0000
7@02d2D00]05000=oh30P?n0`830P<20`002d2H000?@00004@000m00000T0003d000014000?@0000
90000m00000A0003d00002@000?@00004@000m00000T00;@>`0001l000?@00008@000m0000040003
oh2000:000?oP80028000m3oo`0R0003d00001<000?@00008P000m00000C0003d000028000?@0000
4`000m00000R0003d00001<000?@00008P000m00000k00008002d1l00]07000Aol20`83oP<20`830
P<20`8000]02oah00]0G00;@8002d1L00]0P00;@5`03d1l00]0G00?@7`02d3h0000R00?@6P02d0P0
00?oP80018000on0P00:P0?@00?o00005`03d1/00m0J00?@6`03d1X00m0L00;@6P03d1`00]0J00?@
@00002D00]0E00?@2P005on0`830P<3o`830P<20`830P<20`83000;@00?o00004`02d2400]0F00;@
8@03d1D00]0Q00?@5@02d2400m0E00;@@`0000l00alE00G@2`05d0`000?oP8001X000on0P00>P0G@
2`06d2D01M0;00K@9P04d0/01]0V00C@2`06d2H01M0:00K@A@0000l00alJ00_@4@007oo0P<20`830
P?n0`830P<20`830P<20`830P<20`?l02m0`00_@<00;d3002m0a00[@B`0000l00alf0003oh2000J0
00?oP8005802ool0@00004L002?oP<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`003ool0
?@0004L000?oP80028000on0P00HP0;oo`0k0000AP00:Oo0P<20`830P<20`?o0P<20`830P<20`830
P<20`830P<20`830P<2000;oo`0i0000AP000on0P00:P003oh2001^00_oo03L00015000^oh30P<20
`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P0?oo`0d00003`037c<000?oP800
38000on0P00OP0;oo`0b00003`037c8003Co`830P<20`830P<20`830ol20`830P<20`830P<20`830
P<20`830P<20`830P<20`8300_oo0300000?00<O<P000on0P00=P003oh2002>00_oo02h00013000i
oh30P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83000?o
o`0[0000@`000on0P00?P003oh2002N00_oo02T00012000ool20`830P<20`830P<20`830P?n0`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<2000;oo`0W0000@P000on0P00AP003
oh2002Z00_oo02D000110014oh30P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`803ool08P0001800al/0003oh2001:000?oP800;h02ool0
800001800al[0019ol20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P002ool07`0001800al[0003oh2001B000?oP800;803o`03
P?l00?l07P0003l004CoP<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P0?o00B0`83oo`0P0000?`000on0P00FP003oh2002F00ol6P003
o`000?l07P0003l003koP<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P0?o00V0`830P<20`?l0o`0Q0000?P000on0P00HP003oh2001n00_l;P003
o`000?l07`0003h003[o`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830
P<20`830P<20`8300ol03L20`830P<20`830P?l0o`0R0000?@000on0P00IP003oh2001V00ol?P003
o`000?l0800001L00alS000eoh30P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`830P<000ol04/20`830P<20`830P<20`830ool08`0001L00alR0003oh2001^000?oP800
4X03oaB000?o0000o`0Q00005`037b80033o`830P<20`830P<20`830P<20`830P<20`830P<20oh30
P<20`830P<20`830P<03o`0G`830P<20`830P<20`830P<20`830P?l0o`0T0000>`000on0P00MP003
oh2000b00_lIP003o`000?l08P0003/002coP<20`830P<20`830P<20`830P<20`830P<20`830P?n0
`830P<20`830P0?o01b0`830P<20`830P<20`830P<20`830P<20`83oo`0T0000>P000on0P00OP003
oh2000F00olMP003o`000?l08`0003X002Oo`830P<20`830P<20`830P<20`830P<20`830P<20`830
ol20`8000ol08H30P<20`830P<20`830P<20`830P<20`830P<20`830o`3o02D0000i0003oh200220
00?oP?l00_lRP003o`000?l0900000807?l37oooI_lS00007P037aL000?oP8007X06ob>000?o0000
o`0U00007P037aL001ko`830P<20`830P<20`830P<20`830P<20`830P<03o`03`83000?o02C0P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`?oo02L0000g0003oh2001V00ol8P003oh200220
00?o0000o`0V0000=`006_n0`830P<20`830P<20`830P<20`830P<200_l0;l20`830P<20`830ol20
`830P<20`830P<20`830P<20`830P<20`830P<20`83o0?l0:00003H000?oP8005H03o`j000?oP800
7X000ol0003o02L0000f000Eol20`830P<20`830P<20`830P<2000?o03>0`830P<20`830P<20`830
P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`?l0o`0Y00009P037`d000?oP8003h03oaF0
00?oP80078000ol0003o02P0000V00<O30004On0`830P<20`830P<20`83000;o03R0`830P<20`830
P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20ool0:P0002H00al<0003
oh2000^00olJP003oh2001^000?o0000o`0Y0000=0003?o0P<20`830P<20`0?o03c0P<20`830P<20
`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`?oo02/0000d0003
oh2000J00olQP003oh2001V000?o0000o`0Z0000<`002?n0`830P<200_l0@L20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`83o0?l0;00003<0
00?oP8000X03obN000?oP8005h000ol0003o02/0000b0003ol2000?o04F0`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`?l0o`0]0000
<P03obj000?oP8005X000ol0003o02/0000`00<O04W0P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`83o0?l0;P0003000al2obn0
00?oP80058000ol0003o02`0000`00<O0P03o`13P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830o`3o02l0000h00;o:X000on0P00CP003
o`000?l0;@0003X00_l0?X30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30
P<20`830P<20`830P<20`83oo`0`0000?002obN000?oP8004H000ol0003o02h0000n00?o03S0P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830ool0<@000440
0_lSP003oh2000n000?o0000o`0_0000@`02o`0c`830P<20`830P<20`830P<20`830P<20`830P<20
`830ol20`830P<20`830P<20`83o0?l0<P0004D00_lPP003oh2000f000?o0000o`0`0000A`03o`0]
P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<3o0?l0<`0004X00_lKP003
oh2000b000?o0000o`0a0000C002o`0XP<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830
P<20ool0=00004h00olGP003oh2000Z000?o0000o`0b0000D@02o`0R`830P<20`830P<20`830P<20
`830P?n0`830P<20`830ool0=@0005<00_lDP003oh2000R000?o0000o`0c0000E@02o`0M`830P<20
`830P<20`830P<20oh30P<20`830P?l0o`0f0000E`03oa2000?oP8001X000ol0003o03@0001J00;o
01R0`830P<20`830P<20`?o0P<20`830P?oo03H0001L00;o3H000on0P004P003o`000?l0=@0005h0
0_l04h30P<20`830P<20oh30P<20`?l0o`0g0000H003o`R000?oP8000h000ol0003o03H0001S00;o
00g0P<20`830ol20`83o0?l0>00006D00_l5P005oh20P?l0o`0i0000I`02o`08`830P?n0`?oo03T0
001Y00?o00B0oh3oo`0j0000K002o`03P?l00?l0>@0006h000?o0000o`0i0000o`2Z0000o`2Z0000
o`2Z0000o`2Z0000o`2Z0000o`2Z0000


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m0000050003
d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000^0003
d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f00006`02d2T00]0>00;@
:@02d0h00m0X00;@3P03d2P00]0>00?@:002d0h00m0Y00;@>@0001d00]0U00;@1@03o`X00]0V0003
d000014000?@000090000m00000A0003d00002@000?@00004@000m00000T0003d000014000?@0000
9002d3/0000O0003d000024000?@00001@000on0P005o`L000?@00008P000m00000C0003d0000280
00?@00004`000m00000R0003d00001<000?@00008P000m00000C0003d000028000?@0000>`000200
0]0O00;@2002o`06`830P<201Ol300;@8002d1L00]0P00;@5`02d2000]0G00?@7`02d1L00m0O00;@
?P0002800m0J00;@2@001?n0P?l:P0Go0m0J00?@6`03d1X00m0K00?@6P03d1`00]0J00?@7002d1X0
0m1000009@02d1D00m0;000Col20oh30P<20`830P<20`830P003o`;@5P02d2400]0F00;@8@03d1D0
0]0Q00?@5@02d2400m0E00;@@`0000l00alE00G@2`05d0h000GoP820o`0BP003om3@00?@2`06d2D0
1M0;00K@9P04d0/01]0V00C@2`06d2H01M0:00K@A@0000l00alJ00_@4`007Oo0P<20oh30P<20`830
P<20`830P<20`830P<3o00_@<00;d3002m0`00_@<@0:d4/0000?00<O>0000on0P002P003oh2001V0
1?oo03/00019000Voh30P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`805ool0=P0004T0
00?oP8001H000on0P00PP0Goo`0a0000B@00<?n0`830P<20`?o0P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P0Goo`0/0000B@000on0P006P003oh2002V01?oo02P00018000jol20`830
P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`0Goo`0S0000
3`037cH000?oP8002H000on0P00`P0Goo`0N00003`037cH004Co`830P<20`830P<3o`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`0;oo`0L00003`037cH0
00?oP8002X000on0P00bP0;o00>0o`00o`0K0000B000A_o0P<20`830P<20`830ol20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P?oo01`000170003oh2000b0
00?oP800;X02o`>000?o0000o`0K0000A`00?_n0`830P<20`830P<20`83oP<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<200_l01/20`830ool07@0004L000?oP8003X000on0
P00YP003oh2000F000?o0000o`0K0000A`00>on0`830P<20`830P<20`830ol20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`83000;o00V0`830P<20`?l0o`0M00004P037c4000?oP800
48000on0P00TP0;o2H000ol0003o01`0000B00<O<@00A_o0P<20`830P<20`830P<20`830ol20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P?oo01h0000B00<O<@000on0
P00AP003oh2002200_l<P003o`000?l0700004H003Go`830P<20`830P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P<20`830P002o`0?`830P<20`830P<20`83o0?l07P0004H000?oP800
4h000on0P00KP003oh2000f000?o0000o`0M0000A@00<on0`830P<20`830P<20`830P<20`830ol20
`830P<20`830P<20`830P<20`830P<20`002o`0AP<20`830P<20`830P<20`?l0o`0O0000A@000on0
P00EP003oh2001J00_lBP003o`000?l07@0004D004KoP<20`830P<20`830P<20`830P<20`830ol20
`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<3oo`0O0000A@000on0P00GP003
oh2001600_lEP003o`000?l07@0001L00alZ000]ol20`830P<20`830P<20`830P<20`830P<20oh30
P<20`830P<20`830P<2000;o01O0P<20`830P<20`830P<20`830P<20o`3o0200000G00<O:P000on0
P00IP003oh2000f000?oP8005X000ol0003o01h0000G00<O:P00:_o0P<20`830P<20`830P<20`830
P<20`830P<20oh30P<20`830P<20`0;o01Z0`830P<20`830P<20`830P<20`830P<20ool0800004@0
00?oP8006X000on0P008P0;o6h000ol0003o01h000140015ol20`830P<20`830P<20`830P<20`830
P<20`830ol20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<3o0?l08@0004<000?oP800
7H000on0P003P0;o7H000ol0003o01l00013000Toh30P<20`830P<20`830P<20`830P<20`830P<20
`83oP<200_l08<20`830P<20`830P<20`830P<20`830P<20`830P<3oo`0Q0000@`000on0P00NP003
oh3o026000?o0000o`0O00000P0Lo`<OoomVob<0000N00<O8@000on0P00NP0Co88000ol0003o0200
000N00<O8@007oo0P<20`830P<20`830P<20`830P<20`830P<20`8000_l09L3oooo0P<20`830P<20
`830P<20`830P<20`830P<20`830P?l0o`0R0000@P000on0P00JP0;o1X000on0P00MP003o`000?l0
8000048004Go`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20oh30P<20`830P<20`830
P<20`830P<20`830P<20`?l0o`0S0000@P000on0P00GP0;o2X000on0P00KP003o`000?l08@000440
04KoP<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20oh30P<20`830P<20`830P<20
`830P<20`830P<3oo`0S00009P037aP000?oP8005H02o`j000?oP8006X000ol0003o0240000V00<O
60005_n0`830P<20`830P<20`830P<20`802o`0]`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`830P<20`83o0?l0900002H00alH0003oh2001:000?oP8004H000on0P00HP003o`000?l0
8P00040001Co`830P<20`830P<20`830P<20`0;o0320`830P<20`830P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P?oo02@000100003oh20012000?oP8005X000on0P00FP003o`000?l0
8P000400017o`830P<20`830P<20`830P002o`0c`830P<20`830P<20`830P<20`830P<20`?o0P<20
`830P<20`830P<20`830P<20`83o0?l09000040000?oP8003802oab000?oP80058000ol0003o02<0
00100015ol20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`830P<3o0?l09@0003l000?oP8002X02ob2000?oP8004h000ol0003o02<0000`00<O
3000A_n0`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20
`830P<20`830P<20`?oo02D0000`00<O30000on0P007P0;o9H000on0P00@P003o`000?l090000300
0al<0008oh30P<20`802o`0k`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20
`830P<20`830P<20`830P?l0o`0V0000?P000on0P005P003oh2002R000?oP8003h000ol0003o02@0
000n0006ol20`8300_l0?X30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
ol20`830P<20`830P<20`83oo`0V0000?P000on0P002P003oh2002b000?oP8003H000ol0003o02D0
000n0003ol2000;o0430P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`83oP<20`830P<20`830P<3oo`0W0000?P03oc:000?oP80038000ol0003o02D0000l00<O04C0P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20
`830ool09`0003`00al00on0P00cP003oh2000V000?o0000o`0V0000?0037`030?oo00?o03g0P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`83o0?l0
:00004D01Ol/P003oh2000R000?o0000o`0V0000BP04o`0dP<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`83oP<20`830P<20ool0:00004h01OlTP003oh2000J000?o0000o`0W0000
D`05o`0YP<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`?l0o`0Y0000F004oaf0
00?oP80018000ol0003o02L0001L00Go0230P<20`830P<20`830P<20`830P<20`83oP<20`830ool0
:@0006401?lEP003oh2000>000?o0000o`0W0000I@05o`0FP<20`830P<20`830P<20`?o0P<20ool0
:P0006X01Ol<P005oh20P?l0o`0Z0000K`04o`0=`830P<20`830ol20o`3o02X0001c00Go18001?n0
P?oo02X0001h00Ooo`0[0000O@02ool0:`000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m0000050003
d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000^0003
d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f00006`02d2T00]0>00;@
:@02d0h00m0X00;@3P03d2P00]0>00?@:002d0h00m0Y00;@>@0001d00]0U00;@4P02d2H000?@0000
4@000m00000T0003d000014000?@000090000m00000A0003d00002@000?@00004@000m00000T00;@
>`0001l000?@00008@000m00000D0003d000028000?@00004`000m00000R0003d00001<000?@0000
8P000m00000C0003d000028000?@00004`000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@
5`02d2000]0G00;@8002d1L00m0O00;@5`03d1l00]0n00008P03d1X00]0L00?@6P03d1/00m0J00?@
6`03d1X00m0L00;@6P03d1`00]0J00?@@00002D00]0E00?@8@02d1H00]0Q00;@5P02d2400m0E00;@
8@03d1D00]0Q00?@5@02d4<0000?00<O5@05d0/01M0V00G@2`06d2D01M0;00K@9P04d0/01]0V00C@
2`06d2H01M0:00K@A@0000l00alJ00_@500Lo`_@7OlC00_@<00;d3002m0a00[@B`0000l00ali0003
oh3o03j000?oP?l0o`0K0000B`00A?n0`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`83oP<3oo`0K0000B`001On0P83o03Z000GoP820o`3o01/0
001;0014oh30P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`83oP<20`?oo01/0001;0003oh2000>000?oP800=8000on0P003P003o`000?l06@0004/0
04CoP<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`83oP<20`830ool06`0000l00ali0003oh2000F000?oP800<8000on0P005P003o`000?l06@0000l0
0ali0014oh30P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P?n0`830P<20`?oo01/0000?00<O>@000on0P007P003oh2002b000?oP8001h000ol0003o01T0
001;0014oh30P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`83oP<20`830P<20`?oo01/0001;0003oh2000V000?oP800:8000on0P009P003o`000?l06@0004/0
04CoP<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20
`830P<20`830ool06`0004/000?oP8002h000on0P00TP003oh2000^000?o0000o`0I0000B`00A?n0
`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20
`830P<3oo`0K00004P037cH000?oP8003H000on0P00PP003oh2000f000?o0000o`0I00004P037cH0
037oP<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`83000;o0160`830
P<20`830P<20`830o`3o01/0000B00<O=P000on0P00?P003oh2001^000?oP80048000ol0003o01T0
001;0014oh30P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<3o`830P<20
`830P<20`830P<20`?oo01/0001;0003oh20016000?oP8005h000on0P00BP003o`000?l06@0004/0
04CoP<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`830ool06`0004/000?oP8004h000on0P00CP003oh2001B000?o0000o`0I0000B`00A?n0
`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20
`830P<3oo`0K0000B`000on0P00EP003oh2000n000?oP8005X000ol0003o01T0000G00<O<@00A?n0
`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20
`830P<3oo`0K00005`037c4000?oP8005h000on0P00;P003oh2001R000?o0000o`0I00005`037c40
04CoP<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<3o`830P<20`830P<20`830P<20
`830P<20`830ool06`0004/000?oP8006H000on0P007P003oh2001Z000?o0000o`0I0000B`00A?n0
`830P<20`830P<20`830P<20`830P<20`830ol20`830P<3o`830P<20`830P<20`830P<20`830P<20
`830P<3oo`0K0000B`000on0P00KP003oh2000>000?oP80078000ol0003o01T0001;0014oh30P<20
`830P<20`830P<20`830P<20`830P<20`?o0P<3o`830P<20`830P<20`830P<20`830P<20`830P<20
`?oo01/0001;0003oh2001f000?oP?l088000ol0003o01T0000201co0aooofKo8`0001h00alZ0003
oh2001f01?lOP003o`000?l06@0001h00alZ000Ooh30P<20`830P<20`830P<20`830P<20`830P<20
`004o`0QP?n0`830P<20`830P<20`830P<20`830P<20`830P<3o0?l06`0004/000?oP8006h000on0
P004P003oh2001^000?o0000o`0I0000B`00A?n0`830P<20`830P<20`830P<20`830P<20`830ol20
`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<3oo`0K0000B`000on0P00IP003oh2000R0
00?oP8006H000ol0003o01T0001;0014oh30P<20`830P<20`830P<20`830P<20`830ol20`830P<20
`830P?n0`830P<20`830P<20`830P<20`830P<20`?oo01/0000V00<O8P000on0P00GP003oh2000b0
00?oP8005h000ol0003o01T0000V00<O8P00A?n0`830P<20`830P<20`830P<20`830P<3o`830P<20
`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<3oo`0K00009P037b8000?oP8005H000on0
P00@P003oh2001F000?o0000o`0I0000B`00A?n0`830P<20`830P<20`830P<20`830ol20`830P<20
`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<3oo`0K0000B`000on0P00CP003oh2001B0
00?oP8004h000ol0003o01T0001;0014oh30P<20`830P<20`830P<20`830ol20`830P<20`830P<20
`830P<20`830P?n0`830P<20`830P<20`830P<20`?oo01/0001;0003oh20016000?oP80068000on0
P00AP003o`000?l06@0004/004CoP<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20
`830P<20`83oP<20`830P<20`830P<20`830ool06`0004/000?oP8003h000on0P00LP003oh2000n0
00?o0000o`0I0000<0037aP004CoP<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20
`830P<20`830P?n0`830P<20`830P<20`830ool06`0003000alH0003oh2000f000?oP80088000on0
P00=P003o`000?l06@0003000alH0014oh30P<20`830P<20`830ol20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P?n0`830P<20`830P<20`?oo01/0001;0003oh2000^000?oP80098000on0
P00;P003o`000?l06@0004/004CoP<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`83oP<20`830P<20`830ool06`0004/000?oP8002H000on0P00XP003oh2000V0
00?o0000o`0I0000B`00A?n0`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20oh30P<20`830P<3oo`0K0000B`000on0P007P003oh2002b000?oP8001h000ol0
003o01T0000l00<O3000A?n0`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`83oP<20`830P<3oo`0K0000?0037``000?oP8001H000on0P00`P003oh2000F0
00?o0000o`0I0000?0037``004CoP<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`83oP<20`830ool06`0004/000?oP8000h000on0P00dP003oh2000>0
00?o0000o`0I0000B`00A?n0`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20oh30P<3oo`0K0000B`001On0P83o03Z000GoP820o`3o01/0001;0014
oh30ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P?n0`?oo01/0001;0003oh3o03j000?oP?l0o`0K0000BP037`10`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P0;oo`0K0000BP037d;o
o`0K0000BP037ol0G@000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m0000050003
d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000^0003
d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f00006`02d2T00]0>00;@
:@02d0h00m0X00;@3P03d2P00]0>00?@:002d0h00m0Y00;@>@0001d00]0U00;@4P02d2H000?@0000
2003o`H000?@000090000m00000A0003d00002@000?@00004@000m00000T0003d000014000?@0000
9002d3/0000O0003d000024000?@000050000m00000R0003d00000@01Ol2P003o`0000D000?@0000
8P000m00000C0003d000028000?@00004`000m00000R0003d00001<000?@00008P000m00000k0000
8002d1l00]0H00;@8002d0801Ol01X30P<20`0;o2002d2000]0G00;@8002d1L00m0O00;@5`03d1l0
0]0n00008P03d1X00]0L00?@6P03d0Co2X001?n0P?l900?@6P03d1/00m0J00?@7002d1X00m0L00;@
6P03d400000U00;@5@03d2400]0F00;@0ol04/20`830P<20`830P<20oh30o``00]0F00;@8@03d1D0
0]0Q00?@5@02d2400m0E00;@@`0000l00alE00G@2`05d2H01M0;00K@4X001On0P83o00h01M0;00K@
9P04d0/01]0V00C@2`06d2H01M0:00K@A@0000l00alJ00_@<00;d00Mol20`830P<20`830P<20`830
P<20`83oP<20`?l04`0;d3002m0`00_@<@0:d4/0000?00<OF005oaZ000?oP8000h000ol0003o01P0
001V00Co02J0`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20ool06P0006401OlQP003
oh2000F000?o0000o`0H0000G005o`0_`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`83oP<20`830P?l0o`0J0000F004obZ000?oP8001h000ol0003o01L0001C00Go03V0`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`?l0o`0I00003`037c`0
1OlbP003oh2000R000?o0000o`0G00003`037cX00_l0@h30P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`?l0o`0I00003`037cX000CoP?oo
<h000on0P00:P003o`000?l05`0004`004Ko`830ol20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`83oo`0H0000C@001?n0P802obn000?oP800
38000ol0003o01H0001=0006oh30P<200_l0?L20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20oh30P<20`830P<20`830P?l0o`0H0000C@000on0P005P003oh2002V000?oP800
3H000ol0003o01H0001=0009oh30P<20`83000;o03^0`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830ol20`830P<20`830P<20`830o`3o01L0000B00<O>0000on0P008P0;o9X000on0
P00?P003o`000?l05@0001800ali0015ol20`830P<20`830ol20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P?n0`830P<20`830P<20`830P<3o0?l05`0001800ali0003oh2000Z00_lQP003
oh20016000?o0000o`0E0000CP003oo0P<20`830P<20`830P002o`0e`830P<20`830P<20`830P<20
`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P?l0o`0F0000CP000on0P00>P003oh2001^0
00?oP8004h000ol0003o01@0001?000Aoh30P<20`830P<20`830P<000_l0<X30P<20`830P<20`830
P<20`830P<20`830ol20`830P<20`830P<20`830P<20`83oo`0F0000C`000on0P00@P0;o68000on0
P00DP003o`000?l0500004l004KoP<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20
`830P?n0`830P<20`830P<20`830P<20`830P<3oo`0E0000C`000on0P00CP0;o4h000on0P00GP003
o`000?l04`0001L00ale000Hoh30P<20`830P<20`830P<20`830P<200_l0;<20`830P<20`830P<20
`830ol20`830P<20`830P<20`830P<20`830P<3oo`0E00005`037cH000?oP8005X000on0P00=P003
oh2001R000?o0000o`0C00005`037cH001[o`830P<20`830P<20`830P<20`830P<20`0;o02Z0`830
P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P?oo01@0001@0003oh2001V00_l:P003
oh2001Z000?o0000o`0B0000D000A_o0P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P?n0`830P<20`830P<20`830P<20`830P<20`830P?oo01@0001A0003oh2001^00_l5P003oh2001b0
00?o0000o`0B0000D@008?n0`830P<20`830P<20`830P<20`830P<20`830P<200_l08l20`?o0P<20
`830P<20`830P<20`830P<20`830P<20`83o0?l05000054000?oP8007h000on0o`0PP003o`000?l0
4@0000807?l37oooI_lS00007P037c0000?oP8007X03o`03P?n001j000?o0000o`0A00007P037c40
023o`830P<20`830P<20`830P<20`830P<20`830P<20`0?o02;0P?oo`830P<20`830P<20`830P<20
`830P<20`830P<3oo`0C0000DP000on0P00MP003oh2000B00_lLP003o`000?l04000058004Ko`830
P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P?n0`830P<20`830P<20`830P<20`830
P<20`83oo`0B0000DP000on0P00LP003oh2000R00_lIP003o`000?l0400005<004GoP<20`830P<20
`830P<20`830P<20`830P<20`?o0P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P?l0
o`0B00009P037bX000?oP8006X000on0P00<P0;o5h000ol0003o00l0000V00<O:P00;_n0`830P<20
`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`802o`0F`830P<20`830P<20`830P<20
`830ool04@0002H00alZ0003oh2001R000?oP8004X000on0P00BP003o`000?l03`0005<0037oP<20
`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`83000;o01>0`830P<20`830
P<20`830P<3o0?l04@0005@000?oP8005X000on0P00FP003oh20012000?o0000o`0>0000E000<oo0
P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P002o`0A`830P<20
`830P<20`830P?l0o`0@0000E0000on0P00EP003oh2001Z00_l>P003o`000?l03P0005@004Ko`830
P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830
P<20`83oo`0@0000E@000on0P00BP003oh2001n00_l<P003o`000?l03@0003000alR0016oh30P<20
`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20
`830ool03`0003000alR0003oh20016000?oP8008h02o`V000?o0000o`0=0000<0037b8003coP<20
`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`802o`08
`830P<20`?oo00l0001E0003oh20012000?oP800:8000on0P004P003o`000?l03@0005H003ko`830
P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`0;o
00J0`830P?oo00h0001F0003oh2000f000?oP800;H000on0P002P003o`000?l0300005H0047o`830
P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P002o`03`83o0?l03P0005H000?oP80038000on0P00aP0?oo`0>0000?0037aP004CoP<20`830P<20
`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P0;o
o`0=0000?0037aP000?oP8002X000on0P00cP0?oo`0=0000?0037aP003koP<20`830P<20`83oP<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P0Goo`0@0000E`000on0
P008P003oh2002^01Ooo01D0001G000doh30P<20`830P<3o`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P0Goo`0J0000F0000on0P006P003oh2002>01?oo01l0001H000Zol20`830
P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`8301Ooo02<0001H0003oh2000F000?oP800
6X05ool0:00004X00al;000Qol20`830P?n0`830P<20`830P<20`830P<20`830P<2000Coo`0]0000
BP037``000?oP8000X000on0P00CP0Goo`0a0000BP037``001KoP<20`?o0P<20`830P<20`830P<20
1Ooo03H0001I0005oh20P?l03805ool0>`0005T000goP<3o`830P<20`83000Coo`100000F@001?n0
P?l4P0Goo`140000F@037`Goo`190000F@037ol0CP0005T00aoo04h0003o0:X0003o0:X0003o0:X0
003o0:X0003o0:X0003o0:X0003o0:X0003o0:X0003o0:X00000


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0005d0000?l00]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000;o00C0o`3@<P000m0000050003
d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
2@000m00000]00;@0ol2P005oh3o0=00;`02d0T000?@0000;@02d0T000?@0000;@02d0T000?@0000
;P000m00000e00006P000m00000[0003d00000X000?@0000:`002m3ooh30P<20oh3o008000?@0000
:`000m00000:0003d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f0000
6`02d2T00]0>00;@:@02d003oh2000F000CoP83o0P03d2P00]0>00?@:002d0h00m0X00;@3P03d2T0
0]0i00007@02d2D00]0B00;@9P003m3oP<20`830P<3o`830o`050003d00002@000?@00004@000m00
000T0003d000014000?@000090000m00000A0003d00002@00]0k00007`000m00000Q0003d00001@0
00?@00008002o`03d82000R000?oP8000X000ol000030003d000028000?@00004`000m00000R0003
d00001<000?@00008P000m00000C0003d000028000?@0000>`0002000]0O00;@6002d1h00_l2d00A
`830P<20`830P?n0`830P?l01P02d2000]0G00;@8002d1L00m0O00;@5`03d1l00]0n00008P03d1X0
0]0L00?@6@001?o@d=0<P003oh2000>000?o00001P03d1X00m0K00?@6P03d1`00]0J00?@7002d1X0
0m1000009@02d1D00m0Q00;@5@006_o@d830P<20`830P<20`830P?n0`830P<3o2P02d1H00]0Q00?@
5@02d2400m0E00;@8@03d1D00]1300003`037aD01M0;00G@9P05d0/01]0@P003oh2000F000?o0000
2P05d0/01]0V00C@2`06d2H01=0;00K@9P05d0X01]1500003`037aX02m0`00_@0_l07X30P<20`830
P<20`830P<20`830ol20`830P<20oa002m0`00_@<00;d3402]1;00003`037eh00_lEP003oh2000N0
00?o0000o`0F0000K@03o`0SP<20`830P<20`830P<20`830P<20`83oP<20`830P<20`?l0o`0G0000
J`02oaZ000?oP80028000ol0003o01D0001Y00;o02W0P<20`830P<20`830P<20`830P<20`830P<3o
`830P<20`830P<20o`3o01H0001W00;o7H000on0P00:P003o`000?l0500006@00ol0;/20`830P<20
`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`?oo01D0000?00<OD002ob6000?oP800
38000ol0003o01<0000?00<OCP02o`0cP<20`830P<20`830P<20`830P<20`830P<20`830P<20`83o
P<20`830P<20`830P<3o0?l05@0000l00am<00;o98000on0P00>P003o`000?l04P0005/00ol0>830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`83oo`0D0000
F@02obR000?oP80048000ol0003o0140001G00;o03k0P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`83oP<20`830P<20`830P<20`830ool04`0005D00_l/P003oh20016000?o0000
o`0@0000DP03o`13`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20
`830P<20`830P<20`830P<20o`3o0180000B00<O>`02oc2000?oP8004h000ol0003o00l0000B00<O
>P02o`18`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20
`830P<20`830P<20`830P<3oo`0A00004P037cX000?oP?l00_l]P003oh2001F000?o0000o`0>0000
D0001?o0P<03o`13`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20
`830P<20`830P<20`830P<20o`3o0100001@0003oh2000B00olVP003oh2001N000?o0000o`0=0000
D@002On0`830P<20`002o`0oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830
P<20`830P<20`830P<20`830P<3o0?l03`00054000?oP8002803ob6000?oP8005h000ol0003o00d0
001B000=ol20`830P<20`830P003o`0jP<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P<20ool03P00058000?oP8003H03oaZ000?oP8006H000ol0003o00`0
000G00<O>0004oo0P<20`830P<20`830P<20`8000_l0=/20`830P<20`830P<20`830P<20`830ol20
`830P<20`830P<20`830P<20`830P<20`830ool03@0001L00ali0003oh2001600olDP003oh2001^0
00?o0000o`0;00005`037cT001OoP<20`830P<20`830P<20`830P<20`003o`0a`830P<20`830P<20
`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20o`3o00`0001D0003oh2001J00ol=P003
oh2001f000?o0000o`0:0000E0007?o0P<20`830P<20`830P<20`830P<20`830P<02o`0]P<20`830
P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<3o0?l02`0005D000?oP8006X03o`N0
00?oP8007h000ol0003o00T0001E000Poh30P<20`830P<20`830P<20`830P<20`830P<20`803o`0X
P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20ool02P0005H000?oP8007h03o`03
P?n0026000?o0000o`0800000P0Lo`<OoomVob<0000N00<O=P000on0P00PP0Ko88000ol0003o00L0
000N00<O=P008on0`830P<20`830P<20`830P<20`830P<20`830P<20`83000?o00?0P<000ol07/20
`830P<20`830P<20`830P<20`830P<20`830ool02@0005L000?oP80088000on0P006P0?o6h000ol0
003o00H0001H000^ol20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`0;o
01Z0`830P<20`830P<20`830P<20`830P<20ool0200005P000?oP8007X000on0P00<P0?o5h000ol0
003o00D0001I000boh30P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20
`803o`0EP<20`830P<20`830P<20`830P<3o0?l01`0002H00al`0003oh2001b000?oP8004h03oa:0
00?o0000o`0400009P037c4003Oo`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830
P<20`830P<20`830P<2000;o0170P<20`830P<20`830P<20o`3o00H0000V00<O<@000on0P00KP003
oh2001R00ol>P003o`000?l00`0005/003_oP<20`830P<20`830P<20`830P<20`830P<20oh30P<20
`830P<20`830P<20`830P<20`830P<20`003o`0<`830P<20`830P<3oo`050000F`000on0P00IP003
oh2001n00ol8P003o`000?l00`0005`0043o`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`8300_l02830P<20`83oo`040000G0000on0P00GP003
oh2002F00ol4P003o`000?l00P0005d004CoP<20`830P<20`830P<20`830P<20`830ol20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P0?o00>0`?l0o`030000G@000on0P00EP003
oh2002b00ooo00<0000`00<O:P00BOn0`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<000_oo0080000`00<O:`000on0P00CP003
oh2002f00_oo00@0000`00<O:`00@oo0P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`8000ooo00H0001O0003oh2001:000?oP800:802ool0
2@0005l003koP<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P0;oo`0;0000H0000on0P00@P003oh2002F00_oo00d0001P000hol20`830P<20`830
P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<03ool03`00064000?oP800
3X000on0P00QP0;oo`0B0000?0037b8003?oP<20`830P<20`830P<20`?o0P<20`830P<20`830P<20
`830P<20`830P<20`830P<000_oo01@0000l00<O8`000on0P00<P003oh2001j00_oo01H0000l00<O
8`00;Oo0P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P003ool060000680
00?oP80038000on0P00IP0;oo`0K0000H`00:?n0`830P<20`830P<3o`830P<20`830P<20`830P<20
`830P<20`802ool07@0006<000?oP8002X000on0P00EP0?oo`0O0000I0008_o0P<20`830P<20oh30
P<20`830P<20`830P<20`830P<02ool08P0006@000?oP80028000on0P00BP0;oo`0T0000BP037aP0
01goP<20`830P<20oh30P<20`830P<20`830P<20`002ool09P0004X00alH0003oh2000J000?oP800
3X03ool0:00004X00alI000Gol20`830P<3o`830P<20`830P<20`8000_oo02/0001V0003oh2000B0
00?oP8002h02ool0;@0006L001;oP<20`83oP<20`830P<20`802ool0;`0006L000?oP8000h000on0
P006P0?oo`0a0000F@037`/000goP<20`?o0P<20`83000;oo`0d0000F@037``000GoP820o`05P0;o
o`0f0000F@037``000So`83oP<20`0;oo`0h0000J@001?n0oh03ool0>P0006T00al00ol0003o03/0
001Y00<Oo`0n0000J@037ol0?P000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d<3od3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0c0004om20P0;o0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000_000:om30P<3o`?l0d38000?@00001@000m00
000`0003d00000D000?@0000<0000m0000050003d000030000?@0000=00001T000?@0000;@02d0T0
00?@0000;@02d0>000OoP820o`3@02l00]090003d00002d00]090003d00002d00]090003d00002h0
00?@0000=@0001X000?@0000:`000m00000:0003d00002X000cod830P<20oh30P?l20003d00002/0
00?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002`000?@0000=P0001/0
0]0Y00;@3P02d2T00]06P003oh2000:000?o00000m0X00;@3P03d2P00]0>00?@:002d0h00m0Y00;@
>@0001d00]0U00;@4P02d2D0017od<20`830P<20oh30P<20o`040003d00002@000?@00004@000m00
000T0003d000014000?@000090000m00000A0003d00002@00]0k00007`000m00000Q0003d00001@0
00?@00008@000oo@P008P003oh2000B000?o00000P000m00000R0003d00001<000?@00008P000m00
000C0003d000028000?@00004`000m00000R0003d00003/0000P00;@7`02d1P00]0O000Eom3@`830
P<20`830ol20`830P<3o00D00]0P00;@5`02d2000]0G00?@7`02d1L00m0O00;@?P0002800m0J00;@
7003d1X00m0;P003oh2000J000?o00001003d1X00m0K00?@6P03d1`00]0J00?@7002d1X00m100000
9@02d1D00m0Q00;@5P02d00Iol20`830P<20`830P<3o`830P<20`830o`0800;@5P02d2400m0E00;@
8@03d1D00]0Q00?@5@02d4<0000?00<O5@05d0/01M0V00G@2`06d0;o3X000on0P007P003o`0000P0
1M0;00K@9P04d0/01]0V00C@2`06d2H01M0:00K@A@0000l00alJ00_@<00;d0D001goP<20`830P<20
`830P<20`?o0P<20`830P<20o`0>00_@<00;d3002m0a00[@B`0000l00amS00;o4H000on0P009P003
o`000?l04`0007@002;o`830P<20`830P<20`830P<20oh30P<20`830P<20`83oo`0D0000L`000on0
P00AP003oh2000^000?o0000o`0B0000L@02o`0T`830P<20`830P<20`830P<20`83oP<20`830P<20
`830P<3oo`0C0000L0000on0P00DP003oh2000f000?o0000o`0@0000KP02o`0YP<20`830P<20`830
P<20`830P<20`83oP<20`830P<20`830P<20`?l0o`0A00003`037e/000?oP8005h000on0P00>P003
o`000?l03`0000l00amI00;o02g0P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20
`830P?l0o`0@00003`037eP000?oP8006H000on0P00AP003o`000?l03@0006T003?oP<20`830P<20
`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P?l0o`0>0000I`02oaf000?oP800
4X000ol0003o00`0001V000gol20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830
P<20`830P<20`830o`3o00d0001T00;o7h000on0P00EP003o`000?l02P0006<003coP<20`830P<20
`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`?oo00/0000B00<O
C002ob:000?oP8005X000ol0003o00T0000B00<OB`00@?o0P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P?oo00X0000B00<OBP000on0P00SP003
oh2001R000?o0000o`070000G@02o`12`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`83oP<20`830P<20`830P<20`830P<20`830P<3oo`090000G0000on0P00UP003oh2001Z000?o0000
o`060000FP02o`17P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`830P<20`830P<20`?l0o`070000F@000on0P00XP003oh2001b000?o0000o`040000
F000C?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830
P<20`830P<20`830P<20`830P?oo00H0001F00;o;8000on0P00MP003o`000?l00`0001L00alk001A
oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`830P<20`830P<20`83o0?l0100001L00alj00Co:h000on0P00PP003o`000?l00@0001L0
0alj0004ol20`0Oo04S0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20
`830P<20`830P<20`830P<20`830P<20`?oo00<0001E0003oh2000N01_lNP003oh20026000?o0000
o`0005H000oo`830P<20`830P<20`8001ol0?H30P<20`830P<20`830P<20`830P<20oh30P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`?l0o`010000E`000on0P00BP0Oo48000on0P00SP003
o`000?d0001G000Loh30P<20`830P<20`830P<20`830P<20`830P0Ko0370P<20`830P<3o`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`83o0?l0001H0003oh2001j01ol2P003oh2002F0
00?o0000o00000807?l37oooI_lS00007P037cP000?oP8009H03o`:01_lOP003o`000?/0000N00<O
>@009oo0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P003o`08P<20`830P<06o`0K
P<20`830P<20`830P<20`830P<20`830P<3o0?`0001K0003oh2002B000?oP8003H06oaF000?o0000
n@0005`003co`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830
P<20`830P<05o`0B`830P<20`830P<20`830P<3onP0005`000?oP8008X000on0P00IP0Ko2h000ol0
003h0000G@00A_n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20
`830P<20`830P<20`830P<20`806o`07`830P<20o`3i00009P037cD000?oP80088000on0P00UP0Ko
00>0o`00m`0002H00ale001Aol20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<2000?om`0002H00alf0003oh2001n0
00?oP800:h000ol0003g0000H000COo0P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<2000;onP00064000?oP80078000on0
P00YP003o`000?X0001Q0019oh30P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`002ood0001R0003oh2001^000?oP8009X000ol0
003m0000H`00A_n0`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`?oo0040001S0003oh2001V000?oP8009802ool00P0003000ala0012
ol20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`83oo`040000<0037c8000?oP8005h000on0P00QP0;oo`050000<0037c<003go`830P<20`830
P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<3o0?l01`0006H0
00?oP8005X000on0P00NP0;oo`080000I`00>On0`830P<20`830P<20`830P<20`830P?n0`830P<20
`830P<20`830P<20`830P<20`830P<20o`3o00X0001X0003oh2001>000?oP8007802ool02`0006P0
03Go`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830o`3o00d0
001Y0003oh2001:000?oP8006X000ol0003o00`0000l00<O:`00;oo0P<20`830P<20`830P<20`830
ol20`830P<20`830P<20`830P<20`830P<2000;oo`0?0000?0037b`000?oP80048000on0P00GP003
o`000?l03`0003`00al/000[oh30P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20
`002ool04P0006`000?oP8003X000on0P00EP003o`000?l04P0006d002KoP<20`830P<20`830P<20
oh30P<20`830P<20`830P<20`830P0;oo`0E0000K@000on0P00=P003oh2001:000?o0000o`0E0000
KP008_o0P<20`830P<20`830P?n0`830P<20`830P<20`830P<02ool0600006l000?oP8002h000on0
P00?P003o`000?l0600004X00alS000Ool20`830P<20`830P?n0`830P<20`830P<20`830o`3o01/0
001:00<O8`000on0P009P003oh2000f00_oo01`0001:00<O90006on0`830P<20`830ol20`830P<20
`830P<20o`3o01h0001b0003oh2000N000?oP8002X02ool07`00078001Oo`830P<20`830ol20`830
P<20`830o`3o0240001c0003oh2000J000?oP8001h02ool08P0005T00alH000Bol20`830P?n0`830
P<20`83oo`0T0000F@037aT000?oP8000h000on0P005P0;oo`0U0000F@037aT000koP<20`83oP<20
`830ool09`0007H000?oP8000X000on0P003P003o`000?l09P0006T00al;0008oh30P?n0`802ool0
:@0006T00al;0005oh20P?l00X000ol0003o02T0001Y00<O30001?o0ol02ool0;00007T00aoo02h0
001i00<Oo`0^0000N@037ol0;P000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]000ol0000f00;@>@02d3T00]0i00;@<P0001D0
00?@0000=@001=000=0g0005d<3od?l0=P001=000=0g0004d000d3L000C@003@=`000m00000b0000
5P02d3@000?@00000P02d3@000G@P83oP002d3@000?@00000P02d3@000?@00000P02d3@000?@0000
0P02d3@000?@0000<`0001P000?@0000<0000m0000050003d000030000W@`830ol20`=00<P000m00
00050003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00
000]00;@2@000m00000]00;@18000on0P002P003d00002d00]090003d00002d00]090003d00002d0
0]090003d00002h000?@0000=@0001X000?@0000:`000m00000:0003d00002/000k@ol20`830ol20
`830d2d000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002`000?@0000
=P0001/00]0Y00;@3P02d2T00]000on0P004P003oh2000B00m0X00;@3P03d2P00]0>00?@:002d0h0
0m0Y00;@>@0001d00]0U00;@4P02d2H001G@0?o0P<20`830ol20`830P<3o0=009P000m00000A0003
d00002@000?@00004@000m00000T0003d000014000?@00009002d3/0000O0003d000024000?@0000
50000m00000R0003d03o00R000?oP8001X000ol0d00T0003d00001<000?@00008P000m00000C0003
d000028000?@00004`000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@01L0ol20`830P<20
`?o0P<20`830P<3o0002d2000]0G00;@8002d1L00m0O00;@5`03d1l00]0n00008P03d1X00]0L00?@
6P03d08000?oP80028000on0P008P003o`0000?@6P03d1/00m0J00?@7002d1X00m0L00;@6P03d400
000U00;@5@03d2400]0F00;@10006Oo0P<20`830P<20`?o0P<20`830P<20`?l01002d1H00]0Q00?@
5@02d2400m0E00;@8@03d1D00]1300003`037aD01M0;00G@9P05d0/01]050003oh2000Z000?oP800
2X000ol0000300G@2`06d2H01=0;00K@9P04d0/01]0V00G@2P06d4D0000?00<O6P0;d3002m0:000M
ol20`830P<20`830P<3o`830P<20`830P<20`?l02@0;d3002m0`00_@<@0:d4/0000?00<OJ@000on0
P00<P003oh2000b000?o0000o`0>0000N@02o`0P`830P<20`830P<20`830ol20`830P<20`830P<20
`?oo00l0001h0003oh2000n000?oP8003X000ol0003o00`0001g000Voh30P<20`830P<20`830P<20
`?o0P<20`830P<20`830P<20`?oo00d0001f0003oh20016000?oP80048000ol0003o00X0001e000Z
oh30P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<3oo`0;00003`037f8000?oP800
4h000on0P00BP003o`000?l0200000l00amQ000^oh30P<20`830P<20`830P<20`830P<3o`830P<20
`830P<20`830P<20`830ool02@0000l00amP0003oh2001F000?oP8005802ool01`00074003?oP<20
`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P?l0o`060000L0000on0
P00GP003oh2001N000?o0000o`030000K`00=on0`830P<20`830P<20`830P<20`830P<20`?o0P<20
`830P<20`830P<20`830P<20`830P?l0o`040000KP000on0P00IP003oh2001V000?o0000o`010000
K@00>on0`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20
`83o0?l00P0001800amG0003oh2001^000?oP8006h000ol0003n00004P037eH003ooP<20`830P<20
`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P?l0o`000180
0amD00;o7h000on0P00MP003o`000?`0001X0014ol20`830P<20`830P<20`830P<20`830P<20`830
P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P?om0000I`000on0P00PP003oh2001n0
00?o0000nP0006H004So`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830
P<20`830P<20`830P<20`830P<20`830P?ok0000I@000on0P00RP003oh20026000?o0000n00006@0
04co`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`83on@0006<000?oP80098000on0P00SP003o`000?H0000G00<OB000D?o0
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`83om`0001L00am70003oh2002J000?oP8009H000ol0003d00005`037dH0
05Co`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P?oe0000G`000on0P00XP003oh2002N000?o0000lP0005h0
05So`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`83ol`0005d000?oP800:X000on0P00YP003o`000?00
001L001Lol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?oa0000F`000on0P00/P003oh2002^0
00?o0000kP0000807?l37oooI_lS00007P037c/000?oP800:X03ob^000?o0000k`0001h00all000/
oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`803o`0[P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830o`3b0000GP000on0P00YP003oh2002R000?o0000
l@0005l005KoP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830oo@0001P0003oh2002N000?oP8009X000ol0
003c0000H@00D_n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`?of00009P037cT000?oP8009H000on0P00TP003
o`000?D0000V00<O>P00C_n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830ooP0000V00<O>`000on0P00SP003oh2002:0
00?o0000m`0006D004[oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20
`830P<20`830P<20`830P<20`830P<20`830ooX0001V0003oh20026000?oP80088000ol0003i0000
I`00A_n0`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20
`830P<20`830P<20`?ol0000J0000on0P00OP003oh2001j000?o0000n`0006T004;oP<20`830P<20
`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`?on0000
JP000on0P00MP003oh2001b000?o0000o@0003000alh000noh30P<20`830P<20`830P<20`830P<20
`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`?oo0040000`00<O>@000on0P00KP003
oh2001Z000?o0000o`0003000alj000joh30P<20`830P<20`830P<20`830P<20`830P<3o`830P<20
`830P<20`830P<20`830P<20`830ool00`0006h000?oP8006H000on0P00HP003o`000?l00P0006l0
03KoP<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`?oo00D0
001`0003oh2001N000?oP8005X000ol0003o00@0001a000boh30P<20`830P<20`830P<20`830P<20
`?o0P<20`830P<20`830P<20`830P<20`?oo00L0001b00;o5X000on0P00DP003o`000?l01P0003`0
0ale000]ol20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<3o0?l02@0003`0
0alf0003oh2001:000?oP8004X000ol0003o00P0000l00<O=`00:Oo0P<20`830P<20`830P<20`830
ol20`830P<20`830P<20`830P<3o0?l02`0007L000?oP80048000on0P00@P003o`000?l02P0007P0
02Go`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<3o0?l03@0007T000?oP8003X000on0
P00>P003o`000?l0300007X0027o`830P<20`830P<20`830ol20`830P<20`830P<20`?l0o`0?0000
N`000on0P00<P003oh2000b000?o0000o`0>0000BP037bl001go`830P<20`830P<20`?o0P<20`830
P<20`830o`3o0140001:00<O<0000on0P00:P003oh2000Z000?o0000o`0@0000BP037c4001Wo`830
P<20`830P<3o`830P<20`830P<3o0?l04`0007l000?oP80028000on0P008P003o`000?l04P000800
01Go`830P<20`830ol20`830P<20`?l0o`0E0000P@000on0P006P003oh2000J000?o0000o`0D0000
F@037bH0017o`830P<20`?o0P<20`830o`3o01L0001I00<O9`000on0P004P003oh2000B000?o0000
o`0F0000F@037bP000go`830P<3o`830P<3o0?l06@0008D000?oP8000X000on0P002P003o`000?l0
600006T00alJ0009ol20`?o0P<3o0?l06`0006T00alK0004oh20o`:000?o0000o`0J0000J@037a`0
00Go`?o0o`3o01d0001i00<O3@037ol07P0007T00al=00<Oo`0N0000N@037`d00aoo01h0003o0:X0
003o0:X00000


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d?n0d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d?oo00:00]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0009d?n0oh30P<3@038000?@00001@000m00
000`0003d00000D000?@0000<0000m0000050003d000030000?@0000=00001T000?@0000;@02d0T0
00?@0000;@02d005oh20P?l018000m3o000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00
000^0003d00003D0000J0003d00002/000?@00002P000m00000[000?d000ol20`?o0P<20`=3o02`0
00?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002`000?@0000=P0001/0
0]0Y00;@3P02d2T00]020003oh2000:000?oP8001803d2P00]0>00?@:002d0h00m0X00;@3P03d2T0
0]0i00007@02d2D00]0B00;@9P005M00003o`830P<3o`830P<20`83od00V0003d000014000?@0000
90000m00000A0003d00002@000?@00004@000m00000T00;@>`0001l000?@00008@000m00000D0003
d000028000G@0000o`06P003oh2000R000?@00008P000m00000C0003d000028000?@00004`000m00
000R0003d00001<000?@00008P000m00000k00008002d1l00]0H00;@8002d0@001?oP<20`830P?n0
`830P<20`83000;@8002d1L00]0P00;@5`03d1l00]0G00?@7`02d3h0000R00?@6P02d1`00m0J00?@
1@000on0P006P003oh2000Z00m0J00?@6`03d1X00m0L00;@6P03d1`00]0J00?@@00002D00]0E00?@
8@02d1H00]07000Hoh30P<20`830P?n0`830P<20`830P<200_l2d1H00]0Q00?@5@02d2400m0E00;@
8@03d1D00]1300003`037aD01M0;00G@9P05d0/01]090003oh2000N000?oP8003H000ol0d004d0/0
1]0V00C@2`06d2H01=0;00K@9P05d0X01]1500003`037aX02m0`00_@3P007?o0P<20`830P<20oh30
P<20`830P<20`830P<02o`@02m0`00_@<00;d3402]1;00003`037fd000?oP8002H000on0P00@P003
o`000?l02@0007h002;o`830P<20`830P<20`?o0P<20`830P<20`830P<20`83oo`0:0000OP000on0
P00;P003oh2001600_oo00P0001m000Voh30P<20`830P<20`830ol20`830P<20`830P<20`830P<20
`?oo00L0001l0003oh2000f000?oP8005802ool01@0007/002_oP<20`830P<20`830P<20`?o0P<20
`830P<20`830P<20`830P<20`83o0?l0100000l00amY0003oh2000j000?oP8005h02ool00P0000l0
0amX000_ol20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`?l0o`010000
3`037fL000?oP8004H000on0P00IP0;ooP0007P003Co`830P<20`830P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P<20`83oo@0007P000?oP8004X000on0P00LP003o`000?X0001g000f
oh30P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<200_oj0000
MP000on0P00EP003oh2001j000?o0000m`0007D003_oP<20`830P<20`830P<20`830P<20`830ol20
`830P<20`830P<20`830P<20`830P<20`830P<20`002ooL0000B00<OH0000on0P00FP003oh200260
00?o0000m00001800amO000ool20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<2000;om00001800amN0003oh2001R000?oP80098000ol0003a0000
L`00@on0`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<000_oa0000LP000on0P00JP003oh2002J000?o0000kP00074004WoP<20`830P<20
`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`83o0>l0001`0003oh2001b000?oP800:802ond0001`001=ol20`830P<20`830P<20`830P<20`830
P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?l0k00006l0
00?oP8007H000on0P00[P0;ojP0001L00amD001Bol20`830P<20`830P<20`830P<20`830P<20`830
P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20onT0000G00<O
D`000on0P00PP003oh2002Z01?oX00005`037e<004WoP<20`830P<20`830P<20`830P<20`830P<20
`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83000Oo00C0P<3oj00006`0
00?oP8008H000on0P00LP0Oo2H000ol0003W0000J`00?On0`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<001ol04<20`830P<20`830P<20`?oZ0000
JP000on0P00SP003oh2000n01_lEP003o`000>T0001Z000aol20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20oh30P<20`830P007o`0LP<20`830P<20`830P<20`830P<20`830P<20on/0
001Y0003oh2002F000?oP8001olQP003o`000>X0000201co0aooofKo8`0001h00am70003oh2001f0
1_l2P0?o9h000ol0003/00007P037dH001_oP<20`830P<20`830P<20`830P<20`830P<001_l02830
P<20`8300ol0:<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o^0000IP000on0
P00CP0Ko3h000on0P00UP003o`000>d0001U000Boh30P<20`830P<20`830P<201Ol0?H30P<20`830
P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?l0l00006D0
00?oP8002H06oa^000?oP8008h000ol0003^0000I0001oo0P<20`8001_l0Al20`830P<20`830P<20
`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83o0?40
000V00<O>P000on0o`05obN000?oP8008H000ol0003`00009P037cT00ol0DL20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20
`830P<20o`3c00009P037c/000?oP800:h000on0P00PP003o`000?40001U00;o04k0P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20
`830P<20`?od0000I`000on0P00YP003oh2001f000?o0000l`0006P00_l0BH30P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`?l0
mP0006X000?oP8009X000on0P00LP003o`000?@0001[0017oh30P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P?l0m`0006`00_lVP003
oh2001V000?o0000mP0003000alk0012ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<3o`830P<20`830P<20`830P<20`830P<20`83on@0003000all00;o8h000on0P00HP003o`000?L0
000`00<O?P00?_n0`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20
`830P<20`830P<3onP0007800_lPP003oh2001J000?o0000n@0007@003Wo`830P<20`830P<20`830
P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`?l0o00007D00_lNP003oh2001B0
00?o0000nP0007L003GoP<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20
`830P<20o`3m0000N0000on0P00JP003oh2001:000?o0000o00003`00alj00;o0330P<20`830P<20
`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`?on0000?0037c`000?oP8005h000on0
P00AP003o`000?d0000l00<O?@02o`0[P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830
P<20`830o`3o0040001n0003oh2001F000?oP8003X000ol0003o0000O`02o`0W`830P<20`830P<20
`830P<20`830ol20`830P<20`830P<20`83o0?l00P00084000?oP8004X000on0P00=P003o`000?l0
0@0008800_l08X30P<20`830P<20`830P<20`?o0P<20`830P<20`830P?oo00@000240003oh2000n0
00?oP8002h000ol0003o00<0001:00<O>0008?n0`830P<20`830P<20`830ol20`830P<20`830P<3o
o`050000BP037cT00_l?P003oh2000V000?o0000o`040000BP037c/001_o`830P<20`830P<20`83o
P<20`830P<20`?l0o`070000R@02o`b000?oP8001h000ol0003o00H0002;000Goh30P<20`830P<20
oh30P<20`830P?l0o`080000S002o`V000?oP8001X000ol0003o00L0001I00<O<P004_o0P<20`830
P<3o`830P<20ool02P0005T00alc00;o1h000on0P004P003o`000?l0200005T00ale000>oh30P<20
`?o0P<20`?oo00/0002B0003oh2000>000?oP8000X000ol0003o00X0001Y00<O9`02o`08`830ol20
`?oo00d0001Y00<O:@001?n0P?l3P003o`000?l02`0006T00alZ00;o00B0oh3oo`0>0000N@037`d0
0al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000o`2Z0000o`2Z0000



\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d?oo00800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0004d03o`0;o0P000m00000`0003d00000D0
00?@0000<0000m0000050003d000030000?@00001@000m00000`0003d00003@0000I0003d00002d0
0]090003d00002d00]00103oP?l2P0?o00?@0000;@02d0T000?@0000;@02d0T000?@0000;@02d0T0
00?@0000;P000m00000e00006P000m00000[0003d00000X000?@0000:`003]00003oP?n0`830P?o@
;@000m00000:0003d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f0000
6`02d2T00]0>00;@:@02d0<000CoP83o1h03d2P00]0>00?@:002d0h00m0X00;@3P03d2T00]0i0000
7@02d2D00]0B00;@9P000m000003000?ol20`?o0P<20`830P?o@02H000?@00004@000m00000T0003
d000014000?@000090000m00000A0003d00002@00]0k00007`000m00000Q0003d00001@000?@0000
8P000m0000030003oh2000:000?oP80028000m3oo`0R0003d00001<000?@00008P000m00000C0003
d000028000?@00004`000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@1P004On0`830ol20
`830P<20`83000;@0_lN00;@5`02d2000]0G00?@7`02d1L00m0O00;@?P0002800m0J00;@7003d1X0
0m070003oh2000B000?oP8002X03d003o`0001L00m0K00?@6P03d1`00]0J00?@7002d1X00m100000
9@02d1D00m0Q00;@5P02d0X001Oo`830P<20oh30P<20`830P<20`830P002d003o`0001<00]0Q00?@
5@02d2400m0E00;@8@03d1D00]1300003`037aD01M0;00G@9P05d0/01]0;0003oh2000J000?oP800
3X05d0/01]0V00C@2`06d2H01=0;00K@9P05d0X01]1500003`037aX02m0`00_@4@007on0`830P<20
`?o0P<20`830P<20`830P<20`830P?l02m0`00_@<00;d3402]1;00003`037g4000?oP8001X000on0
P00DP0;oo`050000PP008oo0P<20`830P<20oh30P<20`830P<20`830P<20`830P<2000?oo`020000
PP000on0P008P003oh2001R00_oo0000P@00:On0`830P<20`830P?n0`830P<20`830P<20`830P<20
`830P<20`83000;oo@00084000?oP8002X000on0P00KP0;on`00080002ko`830P<20`830P<20`?o0
P<20`830P<20`830P<20`830P<20`830P<20`8300ooh00003`037fh000?oP80038000on0P00OP0;o
mP0000l00am]000doh30P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20
`830P0;om00000l00am]0003oh2000f000?oP8008h02oo80001n000iol20`830P<20`830P<20`830
ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<2000?ok`0007h000?oP8003h000on0
P00WP0;ok@0007d003ooP<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<000_o[0000O@000on0P00AP003oh2002Z00_oY0000O000A?o0P<20`830
P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
0ooV00004P037fL000?oP8004X000on0P00_P0;oi00001800amV0019oh30P<20`830P<20`830P<20
`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`002on<0
000B00<OIP000on0P00DP003oh2002b00ol00h3o003R0000NP00A?o0P<20`830P<20`830P<20`830
P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8300ol01<20`?oT0000
NP000on0P00FP003oh2002F00ol6P003o`000>80001j000nol20`830P<20`830P<20`830P<20`830
P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<03o`09`830P<20`83o0>D0001i0003
oh2001R000?oP8007h02o`^000?o0000h`0007T003[oP<20`830P<20`830P<20`830P<20`830P<3o
`830P<20`830P<20`830P<20`830P<20`830P<200ol03H30P<20`830P<20`?l0iP0007P000?oP800
6H000on0P00IP0?o3h000ol0003T00005`037eh003Go`830P<20`830P<20`830P<20`830P<20`830
P?n0`830P<20`830P<20`830P<20`830P003o`0BP<20`830P<20`830P<20`83oi`0001L00amM0003
oh2001^000?oP8004X03oaB000?o0000i@0001L00amM000`oh30P<20`830P<20`830P<20`830P<20
`830P<20`?o0P<20`830P<20`830P<200ol05h30P<20`830P<20`830P<20`830P<3o0>P0001f0003
oh2001f000?oP8003802oaV000?o0000iP0007H002co`830P<20`830P<20`830P<20`830P<20`830
P<20`?o0P<20`830P<20`0?o01c0P<20`830P<20`830P<20`830P<20`830P<3oj00007D000?oP800
7h000on0P005P0?o7H000ol0003W0000M@009on0`830P<20`830P<20`830P<20`830P<20`830P<20
`83oP<20`003o`0Q`830P<20`830P<20`830P<20`830P<20`830P<20`83o0>T0001d0003oh200220
00?oP?l00_lRP003o`000>P0000201co0aooofKo8`0001h00amB0003oh2001j01_lSP003o`000>T0
000N00<ODP007_n0`830P<20`830P<20`830P<20`830P<20`830P0?o00>0`8000ol09830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20on/0001b0003oh2001V00ol8P003oh20022000?o0000
jP00078001[o`830P<20`830P<20`830P<20`830P<20`0;o02n0`830P<20`830P?n0`830P<20`830
P<20`830P<20`830P<20`830P<20`830o`3/0000L@000on0P00EP0?o3X000on0P00NP003o`000>/0
001a000Eoh30P<20`830P<20`830P<20`83000?o03?0P<20`830P<20`830P<20`?o0P<20`830P<20
`830P<20`830P<20`830P<20`830P?l0k@0002H00am80003oh2000n00olEP003oh2001b000?o0000
k00002H00am7000Aol20`830P<20`830P<20`8000_l0><20`830P<20`830P<20`830P<20`830P?n0
`830P<20`830P<20`830P<20`830P<20`830P<3okP0002H00am70003oh2000^00olJP003oh2001^0
00?o0000k@0006l000coP<20`830P<20`803o`0lP<20`830P<20`830P<20`830P<20`830P<20`830
ol20`830P<20`830P<20`830P<20`830P<20`83ok`0006l000?oP8001X03ob6000?oP8006H000ol0
003^0000KP002?o0P<20`8300_l0@H30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83o
P<20`830P<20`830P<20`830P<20`830P<3o0?00001^0003oh2000:00olWP003oh2001N000?o0000
k`0006d000?oP<000ol0AL20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0
`830P<20`830P<20`830P<20`830P<20o`3a0000K@03obj000?oP8005X000ol0003_0000<0037cT0
0_l0BH30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`830P<20`?l0lP0003000alk00;o;h000on0P00DP003o`000?00000`00<O?@03o`13
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20
`830P<20o`3c0000L`02obZ000?oP8004h000ol0003a0000M@02o`0n`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`?od0000M`02obN000?oP800
4H000ol0003b0000N@03o`0hP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830
P<20`830P<20`830P?oe0000O002ob>000?oP8003h000ol0003c0000?0037cl00_l0<h30P<20`830
P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830o`3f0000?0037d400_lPP003
oh2000f000?o0000m00003`00am300?o02g0P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20
`830P<20`830P?l0m`0008D00_lKP003oh2000b000?o0000m@0008L00_l0:<20`830P<20`830P<20
`830P<20`830P<20oh30P<20`830P<20`?oh0000R@03oaN000?oP8002X000ol0003f0000S002o`0R
P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20ooT0002>00;o58000on0P008P003o`000?L0
001:00<O@`02o`0MP<20`830P<20`830P<20`830ol20`830P<20`?l0nP0004X00am500?o48000on0
P006P003o`000?P0001:00<OB002o`0H`830P<20`830P<20`83oP<20`830P<3onP0009L00_l=P003
oh2000B000?o0000n@0009T00_l04l20`830P<20`830ol20`830P?l0n`0009/00ol8P003oh2000>0
00?o0000nP0005T00am200;o00f0`830P<20oh30P<3o0?`0001I00<OA002o`F000GoP820o`3m0000
F@037dH00_l02830P<3o`83oo@000:@00ol0183oP?on0000J@037c/000Co7alOoP0006T00all00<O
oP0006T00all00<OoP0007T00al=00<O30037ol03`0007T00al=00<O30037ol03`0007T00al=00<O
30037ol03`000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m0000050003
d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000^0003
d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f00006`02d2T00]0>00;@
:@02d0h00m0X00;@3P03d2P00]0>00?@:002d0h00m0Y00;@>@0001d00]0U00;@4P02d2H000?@0000
0`03o`/000?@000090000m00000A0003d00002@000?@00004@000m00000T0003d000014000?@0000
9002d3/0000O0003d000024000?@000050000m00000R0003d00000@000?oP8001Ol70003d0000280
00?@00004`000m00000R0003d00001<000?@00008P000m00000C0003d000028000?@0000>`000200
0]0O00;@6002d2000]0700;o00J0`830P<05o`<00]0P00;@5`02d2000]0G00?@7`02d1L00m0O00;@
?P0002800m0J00;@7003d1X00m080004oh20o`Z01Ol3d1X00m0K00?@6P03d1`00]0J00?@7002d1X0
0m1000009@02d1D00m0Q00;@5P02d0/001?oP<3o`830P<20`830P<20`83000?o0]0F00;@8@03d1D0
0]0Q00?@5@02d2400m0E00;@@`0000l00alE00G@2`05d2H01M0;00K@3@001On0P83o01:000?od=00
0m0;00K@9P04d0/01]0V00C@2`06d2H01M0:00K@A@0000l00alJ00_@<00;d1<001goP<20`?o0P<20
`830P<20`830P<20`830P<20o`0;d3002m0`00_@<@0:d4/0000?00<OL`000on0P002P003oh2001V0
1?oo0000Q0009_o0P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`8301Ooj0000Q0000on0
P005P003oh2002201Ooe0000Q000<?o0P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`0Gol00008@000?oP8001X000on0P00YP0Cok00008<003[oP<20`830P<20`?o0P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<201OoW00003`037g4000?oP800
2H000on0P00`P0GohP0000l00ama0014oh30P<20`830P<20oh30P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`802on00000?00<OL@000on0P00:P003oh2003:0
0_l00h3o003O0000P`00A_n0`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830ol20`?oP0000PP000on0P00<P003oh2002j00_l3P003o`000=l0
0022000nol20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<02o`06P<20`83oh@00088000?oP8003X000on0P00YP003oh2000F000?o0000g`000880
03_o`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P002o`09`830P<20`83o0>40000B00<OK0000on0P00@P003oh2002B00_l9P003o`000>00000B00<O
K000A_n0`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`?o0P<20`830P<20`?oR00004P037f`000?oP8004H000on0P00PP0;o38000ol0003P0000P@00=On0
`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`83000;o00n0`830
P<20`830P<20`?l0hP00084000?oP8004h000on0P00KP003oh2000f000?o0000h@00080003?o`830
P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`8000_l04L20`830P<20
`830P<20`83o0><000200003oh2001F000?oP8005X02oa:000?o0000h@00080004Ko`830P<20`830
P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`83o
h`00080000?oP8005h000on0P00AP0;o5H000ol0003Q00005`037fD002goP<20`830P<20`830P<20
`830P<20`830P<3o`830P<20`830P<20`830P<000_l05h30P<20`830P<20`830P<20`830P<3o0>@0
000G00<OI@000on0P00IP003oh2000f000?oP8005X000ol0003R00005`037fD002[oP<20`830P<20
`830P<20`830P<20`830P<20`?o0P<20`830P<20`802o`0J`830P<20`830P<20`830P<20`830P<20
`?oT0000O`000on0P00JP003oh2000R00_lKP003o`000>80001o0015oh30P<20`830P<20`830P<20
`830P<20`830P<20oh30P<20`830ol20`830P<20`830P<20`830P<20`830P<20`83o0>D0001n0003
oh2001f000?oP8000h02oaf000?o0000h`0007h002Co`830P<20`830P<20`830P<20`830P<20`830
P<20`?o0P<02o`0PP<20`830P<20`830P<20`830P<20`830P<20`830P?oU0000OP000on0P00NP003
oh3o026000?o0000h`0000807?l37oooI_lS00007P037e`000?oP8007X04ob2000?o0000i00001h0
0amL000Ooh30P<20`830P<20`830P<20`830P<20`830P<20`002o`0UP?oooh30P<20`830P<20`830
P<20`830P<20`830P<20`830o`3V0000O@000on0P00JP0;o1X000on0P00MP003o`000>@0001m0015
oh30P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`?o0P<20`830P<20`830P<20`830P<20
`830P<20`83o0>L0001m0003oh2001N00_l:P003oh2001^000?o0000i@0007`004Ko`830P<20`830
P<20`830P<20`830P<20`?o0P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`83o
i`0002H00amC0003oh2001F00_l>P003oh2001Z000?o0000i@0002H00amC000Fol20`830P<20`830
P<20`830P<20`0;o02f0`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`?l0
j00002H00amC0003oh2001:000?oP8004H000on0P00HP003o`000>H0001k000Doh30P<20`830P<20
`830P<20`802o`0``830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<3o
j00007/000?oP80048000on0P00FP003oh2001J000?o0000iP0007/0017oP<20`830P<20`830P<20
`002o`0cP<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<3o0>P0
001k0003oh2000b00_lLP003oh2001B000?o0000i`0007/004GoP<20`830P<20`830P?n0`830P<20
`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P?l0j@0007X000?oP800
2X02ob2000?oP8004h000ol0003W0000<0037dL004Ko`830P<20`830P<3o`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`83oj@0003000am70003oh2000N0
0_lUP003oh20012000?o0000j00003000am70008ol20`830P<02o`0kP<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`?l0jP0007T000?oP8001H000on0
P00XP003oh2000n000?o0000j00007T000KoP<20`802o`0n`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`?oZ0000N@000on0P002P003oh2002b0
00?oP8003H000ol0003Y0000N@000on0`002o`10P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830ol20`830P<20`830P<20on/0001i00?o<X000on0P00<P003o`000>T0
000l00<O>@02o`14P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`83oP<20`830P<20`830P?o[0000?0037cT00oleP003oh2000V000?o0000jP0003`00all00Go
03f0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830
P<3o0>`0002000Go;8000on0P008P003o`000>X0002500Co03C0P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`?o0P<20`830P<3ok00008T01OlTP003oh2000J000?o0000j`0008h0
1Ol0:L20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`83o0>d0002C00Co7H000on0
P004P003o`000>/0001:00<OBP05o`0PP<20`830P<20`830P<20`830P<20`830ol20`830P?o]0000
BP037dl01?lEP003oh2000>000?o0000j`0004X00amC00Go01K0P<20`830P<20`830P<20oh30P<3o
kP000:D01Ol<P005oh20P?l0kP000:X01?l03H30P<20`830P?n0`?l0kP000:h01Ol4P004oh20onh0
001I00<OE`05o`<OkP0005T00amL00<OkP0005T00amL00<OkP000?l0ZP0006T00all00<OoP0006T0
0all00<OoP0006T00all00<OoP0007T00al=00<O30037ol03`0007T00al=00<O30037ol03`0007T0
0al=00<O30037ol03`000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m0000050003
d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000^0003
d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f00006`02d2T00]0>00;@
:@02d0h00m0X00;@3P03d2P00]0>00?@:002d0h00m0Y00;@>@0001d00]0U00;@4P02d2H000?@0000
4@000m00000T0003d000014000?@000090000m00000A0003d00002@000?@00004@000m00000T00;@
>`0001l000?@00008@000m00000D0003d000028000?@00004`000m00000R0003d00001<000?@0000
8P000m00000C0003d000028000?@00004`000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@
5`02d2000]0G00;@8002d1L00m0O00;@5`03d1l00]0n00008P03d1X00]0L00?@6P03d1/00m0J00?@
6`03d1X00m0L00;@6P03d1`00]0J00?@@00002D00]0E00?@8@02d1H00]0Q00;@5P02d2400m0E00;@
8@03d1D00]0Q00?@5@02d4<0000?00<O5@05d0/01M0V00G@2`06d2D01M0;00K@9P04d0/01]0V00C@
2`06d2H01M0:00K@A@0000l00alJ00_@<00;d1@07?l;d1go4`0;d3002m0a00[@B`0000l00amd0003
oh3o03j000?oP?l0g`0008H004Co`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830ol20oml000260005oh20P?l0>X001On0P83o0=l000260014
ol20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<3o`830P?oO0000QP000on0P003P003oh2003B000?oP8000h000ol0003M0000QP00A?o0P<20`83o
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`83o
g`0000l00amd0003oh2000F000?oP800<8000on0P005P003o`000=d0000?00<OM000A?o0P<20`830
P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`83o
g`0000l00amd0003oh2000N000?oP800;8000on0P007P003o`000=d000260014ol20`830P<20`83o
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P?oO0000
QP000on0P009P003oh2002R000?oP8002H000ol0003M0000QP00A?o0P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`83og`0008H000?oP800
2h000on0P00TP003oh2000^000?o0000g@0008H004Co`830P<20`830P<20`83oP<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20oml0000B00<OL@000on0P00=P003
oh20022000?oP8003H000ol0003M00004P037g40037o`830P<20`830P<20`830P?n0`830P<20`830
P<20`830P<20`830P<20`830P<2000;o0170P<20`830P<20`830P<20o`3O00004P037g4000?oP800
3h000on0P00KP003oh20012000?o0000g@0008H004Co`830P<20`830P<20`830P<20oh30P<20`830
P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20oml000260003oh20016000?oP800
5h000on0P00BP003o`000=d000260014ol20`830P<20`830P<20`830P<20oh30P<20`830P<20`830
P<20`830P<20oh30P<20`830P<20`830P<20`830P?oO0000QP000on0P00CP003oh2001>000?oP800
58000ol0003M0000QP00A?o0P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`83o
P<20`830P<20`830P<20`830P<20`83og`0008H000?oP8005H000on0P00?P003oh2001J000?o0000
g@0001L00am/0014ol20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P?oO00005`037f`000?oP8005h000on0P00;P003oh2001R000?o0000
g@0001L00am/0014ol20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20oh30P<20`830
P<20`830P<20`830P<20`830P?oO0000QP000on0P00IP003oh2000N000?oP8006X000ol0003M0000
QP00A?o0P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`83oP<20`830P<20`830P<20`830
P<20`830P<20`83og`0008H000?oP8006h000on0P003P003oh2001b000?o0000g@0008H004Co`830
P<20`830P<20`830P<20`830P<20`830P<20oh30P?n0`830P<20`830P<20`830P<20`830P<20`830
P<20oml000260003oh2001f000?oP?l088000ol0003M00000P0Lo`<OoomVob<0000N00<OI@000on0
P00MP0Co7h000ol0003M00007P037fD001oo`830P<20`830P<20`830P<20`830P<20`830P<2000Co
0270ol20`830P<20`830P<20`830P<20`830P<20`830P?l0g`0008H000?oP8006h000on0P004P003
oh2001^000?o0000g@0008H004Co`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`?o0
P<20`830P<20`830P<20`830P<20`830P<20oml000260003oh2001V000?oP80028000on0P00IP003
o`000=d000260014ol20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`?o0P<20`830
P<20`830P<20`830P<20`830P?oO00009P037ed000?oP8005h000on0P00<P003oh2001N000?o0000
g@0002H00amM0014ol20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830ol20`830
P<20`830P<20`830P<20`830P?oO00009P037ed000?oP8005H000on0P00@P003oh2001F000?o0000
g@0008H004Co`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`830P<20oml000260003oh2001>000?oP80058000on0P00CP003o`000=d000260014
ol20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830
P<20`830P?oO0000QP000on0P00AP003oh2001R000?oP8004H000ol0003M0000QP00A?o0P<20`830
P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`83o
g`0008H000?oP8003h000on0P00LP003oh2000n000?o0000g@0003000amC0014ol20`830P<20`830
P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P?oO0000
<0037e<000?oP8003H000on0P00PP003oh2000f000?o0000g@0003000amC0014ol20`830P<20`830
P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P?oO0000
QP000on0P00;P003oh2002B000?oP8002h000ol0003M0000QP00A?o0P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`83og`0008H000?oP800
2H000on0P00XP003oh2000V000?o0000g@0008H004Co`830P<20`830P?n0`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20oml000260003oh2000N000?oP800
;8000on0P007P003o`000=d0000l00<OA`00A?o0P<20`830P?n0`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`83og`0003`00am70003oh2000F000?oP800
<8000on0P005P003o`000=d0000l00<OA`00A?o0P<20`83oP<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`83og`0008H000?oP8000h000on0P00dP003
oh2000>000?o0000g@0008H004Co`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`?o0P<20oml000260005oh20P?l0>X001On0P83o0=l000260014
ol20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`?o0P?oO0000QP000on0o`0nP003oh3o0=l0001:00<O>@02o`10P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`0<OgP0004X00ali04;o
0aoN0000BP037g/00aoN0000o`2Z0000o`2Z0000o`2Z0000F@037e`00ao^0000F@037e`00ao^0000
F@037e`00ao^0000o`2Z0000J@037c`00aon0000J@037c`00aon0000J@037c`00aon0000N@037`d0
0al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000o`2Z0000o`2Z0000



\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m0000050003
d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000^0003
d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f00006`02d2T00]0>00;@
:@02d0h00m0X00;@3P03d2P00]0>00?@:002d0h00m0Y00;@>@0001d00]0U00;@4P02d2H000?@0000
4@000m00000T0003d00000P00ol60003d00002@000?@00004@000m00000T0003d000014000?@0000
9002d3/0000O0003d000024000?@000050000m00000R0003d00001<000?@00008P000m00000400Go
0X000ol000050003d000028000?@00004`000m00000R0003d00001<000?@00008P000m00000k0000
8002d1l00]0H00;@8002d1L00]0P00;@0P05o`06`830P<200_l800;@8002d1L00m0O00;@5`03d1l0
0]0n00008P03d1X00]0L00?@6P03d1/00m0J00?@1?l:P004oh20o`T00m0J00?@7002d1X00m0L00;@
6P03d400000U00;@5@03d2400]0F00;@8@02d1H00]03o`0BP<20`830P<20`830P<3o`83o3003d1D0
0]0Q00?@5@02d2400m0E00;@@`0000l00alE00G@2`05d2H01M0;00K@9@05d0/01]0BP005oh20P?l0
3`04d0/01]0V00C@2`06d2H01M0:00K@A@0000l00alJ00_@<00;d3002m007On0`830P<20`830P<20
`830P<20`830ol20`83o01<02m0`00_@<@0:d4/0000?00<OT`05oaZ000?oP8000h000ol0003L0000
X@04o`0V`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`?oN0000W005ob6000?oP800
1H000ol0003L0000U`05o`0_P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830
P<20`?l0gP0009<01?lZP003oh2000N000?o0000f`0008h01Ol0>L20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20o`3M00003`037gL01OlbP003oh2000R0
00?o0000f`0000l00ame00;o04?0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`83oP<20`830P<20`83o0=d0000?00<OM@001?n0oolcP003oh2000Z000?o0000
f`0008L004KoP<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830ol20`830P<20`830P<3og00008P000CoP8200_l_P003oh2000b000?o0000fP0008P000Ko`830
P<02o`0mP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830
P<20`830o`3L0000R0000on0P005P003oh2002V000?oP8003H000ol0003J0000R0002Oo0P<20`830
P002o`0k`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20
`830P?l0f`0001800amc0003oh2000R00_lVP003oh2000n000?o0000f@0001800amd0015oh30P<20
`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20
`83o0=/0000B00<OM0000on0P00:P0;o8H000on0P00AP003o`000=T00029000?oh30P<20`830P<20
`83000;o03F0`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830
o`3J0000R@000on0P00>P003oh2001^000?oP8004h000ol0003H0000RP004Oo0P<20`830P<20`830
P<2000;o03;0P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830omX0
002:0003oh2001200_lHP003oh2001B000?o0000f00008X004Ko`830P<20`830P<20`830P<20`83o
P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`83of@0008X000?oP800
4h02oa>000?oP8005h000ol0003G00005`037g0001So`830P<20`830P<20`830P<20`830P<02o`0/
P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P?oI00005`037g4000?oP800
5X000on0P00=P003oh2001R000?o0000e`0001L00ama000Joh30P<20`830P<20`830P<20`830P<20
`802o`0Z`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<3of00008/000?oP800
6H02o`Z000?oP8006X000ol0003F0000R`00A_n0`830P<20`830P<20`830P<20`830P<20`830P?n0
`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`?oH0000S0000on0P00KP0;o1H000on0
P00LP003o`000=H0002<000Pol20`830P<20`830P<20`830P<20`830P<20`830P<02o`0SP<20oh30
P<20`830P<20`830P<20`830P<20`830P<20`?l0f00008`000?oP8007h000on0o`0PP003o`000=D0
000201co0aooofKo8`0001h00am[0003oh2001j00ol00h3oP00NP003o`000=D0000N00<OK0008?n0
`830P<20`830P<20`830P<20`830P<20`830P<200ol08X30oon0`830P<20`830P<20`830P<20`830
P<20`830P?oG0000S@000on0P00MP003oh2000B00_lLP003o`000=@0002=0016oh30P<20`830P<20
`830P<20`830P<20`830P<20`83oP<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830omH0
002=0003oh2001b000?oP8002802oaV000?o0000e00008h004Go`830P<20`830P<20`830P<20`830
P<20`830P?n0`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`?l0eP0002H00amU0003
oh2001Z000?oP8003802oaN000?o0000d`0002H00amU000^ol20`830P<20`830P<20`830P<20`830
P<20`?o0P<20`830P<20`830P<20`0;o01J0`830P<20`830P<20`830P<20`83oe@0002H00amU0003
oh2001R000?oP8004X000on0P00BP003o`000=<0002>000aol20`830P<20`830P<20`830P<20`830
P<20oh30P<20`830P<20`830P<20`830P002o`0C`830P<20`830P<20`830P<20o`3E0000S`000on0
P00FP003oh2001J000?oP80048000ol0003B0000S`00<on0`830P<20`830P<20`830P<20`830P?n0
`830P<20`830P<20`830P<20`830P<20`002o`0AP<20`830P<20`830P<20`?l0e00008l000?oP800
5H000on0P00JP0;o3X000ol0003B0000S`00A_n0`830P<20`830P<20`830P<20`830ol20`830P<20
`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`?oD0000T0000on0P00BP003oh2001n0
0_l<P003o`000=40000`00<OG@00A_o0P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830
P<20`830P<20`830P<20`830P?n0`830P<20`830P?oC0000<0037ed000?oP8004H000on0P00SP0;o
2H000ol0003A0000<0037ed003co`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<02o`08P<20`830P?oC0000T0000on0P00@P003oh2002R000?oP800
18000ol0003A0000T@00?_n0`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<200_l01/20`830om80002A0003oh2000f000?oP800;H000on0P002P003
o`000=00002A0011oh30P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<000_l00h30o`3B0000T@000on0P00<P003oh2003600ooB0000?0037e<0
04?o`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<2000<Od@0003`00amC0003oh2000Z000?oP800<h037m40000l00<OD`00?_o0P<20`830
P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8301Ol37m40
002B0003oh2000R000?oP800:h05omT0002B000dol20`830P<20`83oP<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`0GogP0009<000?oP8001X000on0P00SP0Coh`0009<002[oP<20
`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`805onL0002C0003oh2000F000?oP800
6X05on`0001:00<OAP008On0`830P<3o`830P<20`830P<20`830P<20`830P<20`004oa000aoN0000
BP037dL000?oP8000X000on0P00CP0Go50037mh0001:00<OA`005_o0P<20oh30P<20`830P<20`830
P<05oaT00aoN0000U0001On0P83o00b01Ooo0000U0003Oo0P?n0`830P<20`8001?oo00D0002D0004
oh20o`B01Ooo00T0001I00<O>@07oa`00ao^0000F@037cT00_lQ00<OkP0005T00amL00<OkP000?l0
ZP0006T00all00<OoP0006T00all00<OoP0006T00all00<OoP0007T00al=00<O30037ol03`0007T0
0al=00<O30037ol03`0007T00al=00<O30037ol03`000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0005d0000?l00]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m000002o`04
P?l0d38000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
2@000m00000]00;@2@000m00000]00;@0ol2P005oh3o0=00;`02d0T000?@0000;@02d0T000?@0000
;P000m00000e00006P000m00000[0003d00000X000?@0000:`000m00000:0003d00002/000_@ooo0
P<20`?o0o`020003d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f0000
6`02d2T00]0>00;@:@02d0h00m0X00;@00?oP8001H001?n0P?l200?@:002d0h00m0X00;@3P03d2T0
0]0i00007@02d2D00]0B00;@9P000m00000A0003d00002@000o@ol20`830P<20oh30P?l01@000m00
000T0003d000014000?@000090000m00000A0003d00002@00]0k00007`000m00000Q0003d00001@0
00?@00008P000m00000C0003d00002000_l00m20P008P003oh2000:000?o00000`000m00000R0003
d00001<000?@00008P000m00000C0003d000028000?@0000>`0002000]0O00;@6002d2000]0G00;@
7P02o`;@0160`830P<20`830ol20`830o`0600;@8002d1L00m0O00;@5`03d1l00]0n00008P03d1X0
0]0L00?@6P03d1/00m0I0004om3@d0b000?oP8000h000ol0000600?@6P03d1`00]0J00?@7002d1X0
0m1000009@02d1D00m0Q00;@5P02d2400]0E000Jom3@`830P<20`830P<20`830ol20`830P?l:00?@
5@02d2400m0E00;@8@03d1D00]1300003`037aD01M0;00G@9P05d0/01]0U00G@2`06d12000?oP800
1H000ol0000;00C@2`06d2H01=0;00K@9P05d0X01]1500003`037aX02m0`00_@<00;d0;o01k0P<20
`830P<20`830P<20`830P?n0`830P<20`?l@00_@<00;d3402]1;00003`037iT00_lEP003oh2000N0
00?o0000fP000:P00ol08l20`830P<20`830P<20`830P<20`830ol20`830P<20`83o0=/0002V00;o
6X000on0P008P003o`000=T0002T00;o02V0`830P<20`830P<20`830P<20`830P<20`83oP<20`830
P<20`830o`3J0000XP02oaf000?oP8002X000ol0003H0000W`03o`0^P<20`830P<20`830P<20`830
P<20`830P<20`830ol20`830P<20`830P<20omT0000?00<OR`02ob6000?oP80038000ol0003G0000
3`037hT00_l0<l20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20
o`3I00003`037hL00_lTP003oh2000j000?o0000eP0009H00ol0><20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<3of00009@00_lXP003oh20012000?o0000
e@0009800_l0?X30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`83oe`0009000_l/P003oh20016000?o0000e00008d00ol0@h30P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`?l0eP000180
0amf00;o<8000on0P00CP003o`000=<0000B00<OM@02o`18P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`83oe@0001800ame0003
oh3o00;o;H000on0P00EP003o`000=80002;0004oh30P0?o04>0`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<3o0=@0002;0003oh2000B0
0olVP003oh2001N000?o0000d@0008`000Wo`830P<20`8000_l0?l20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20o`3C0000S0000on0P008P0?o
8H000on0P00GP003o`000=40002=000=oh30P<20`830P<20`003o`0j`830P<20`830P<20`830P<20
`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830om80002=0003oh2000f00olJP003
oh2001V000?o0000d00001L00amc000Coh30P<20`830P<20`830P<20`002o`0fP<20`830P<20`830
P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`83od@0001L00amd0003oh200160
0olDP003oh2001^000?o0000c`0001L00amd000Gol20`830P<20`830P<20`830P<20`8000ol0<H30
P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`?l0d00008l000?oP800
5X03o`f000?oP8007H000ol0003>0000S`007?n0`830P<20`830P<20`830P<20`830P<20`802o`0]
`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`83o0<l0002@0003oh2001Z0
0ol7P003oh2001n000?o0000c@000900023o`830P<20`830P<20`830P<20`830P<20`830P<20`0?o
02S0P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<3ocP00094000?oP8007h03o`03
P?n0026000?o0000c00000807?l37oooI_lS00007P037g4000?oP8008806ob2000?o0000b`0001h0
0ama000Sol20`830P<20`830P<20`830P<20`830P<20`830P<20`8000ol00h30P003o`0NP<20`830
P<20`830P<20`830P<20`830P<20`83oc@00098000?oP80088000on0P006P0?o6h000ol0003:0000
T`00;_n0`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`802o`0J`830P<20
`830P<20`830P<20`830P<20`?o<0000T`000on0P00NP003oh2000b00olGP003o`000<T0002D000b
ol20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<03o`0E`830P<20
`830P<20`830P<20`83o0</0000V00<OJ`000on0P00LP003oh2001>00olBP003o`000<P0000V00<O
K000=on0`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<00
0_l04H30P<20`830P<20`830P<3o0<X0000V00<OK0000on0P00KP003oh2001R00ol>P003o`000<L0
002F000kol20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830
P<20`8000ol03830P<20`830P<20olT0002F0003oh2001V000?oP8007h03o`R000?o0000a`0009L0
043oP<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<200_l02<20`830P<3ob00009L000?oP8005h000on0P00UP0?o18000ol000360000V000A?o0
P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`8300ol00l20o`370000V0000on0P00EP003oh2002b00oo70000<0037fD004Wo`830P<20`830
P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<2000<Oa@0003000amV0003oh2001>000?oP800;H02o`<Oa@0003000amV0013oh30P<20`830P<20
`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`003o`80
0ao50000VP000on0P00BP003oh2002R00_o=0000VP00?_o0P<20`830P<20`830P<20`830ol20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8300_o?0000V`000on0P00@P003oh2002F0
0_oA0000V`00>?n0`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<200ooC0000W0000on0P00>P003oh2002600_oF0000?0037ed003?o`830P<20`830P<20`830
P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`8000_l400<Od@0003`00amN0003oh2000b0
00?oP8007X02o`H00aoA0000?0037eh002goP<20`830P<20`830P<3o`830P<20`830P<20`830P<20
`830P<20`830P<000ol800<Od@0009d000?oP80038000on0P00IP0;og`0009h002So`830P<20`830
P<20oh30P<20`830P<20`830P<20`830P<20`8300_oQ0000WP000on0P00:P003oh2001F00ooS0000
W`008_n0`830P<20`830ol20`830P<20`830P<20`830P<20`802onH0002O0003oh2000R000?oP800
4X02onP0001:00<OD`007Oo0P<20`830P<3o`830P<20`830P<20`830P<2000;o2@037mh0001:00<O
D`000on0P006P003oh2000j00ol;00<OgP0004X00amD000Goh30P<20`83oP<20`830P<20`830P<00
0_l>00<OgP000:4000?oP80018000on0P00;P0;ol@000:8001;o`830P<3o`830P<20`830P<02oo<0
002R0003oh2000>000?oP8001X03ooD0001I00<OAP003Oo0P<20oh30P<20`8000_l700<OkP0005T0
0am70005oh20P?l01H02o`T00ao^0000F@037dL000SoP<3o`830P0;o2`037nh0002T0004oh3oP0?o
oP0006T00alh0004ol3oo`<OoP0006T00ali0003o`0000<OoP0006T00all00<OoP0007T00al=00<O
30037ol03`0007T00al=00<O30037ol03`0007T00al=00<O30037ol03`000?l0ZP000?l0ZP000001



\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@P?o@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0c0004om20P0;o0]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000;`002_o@P<20oh3o
0=0b0003d00000D000?@0000<0000m0000050003d000030000?@0000=00001T000?@0000;@02d0T0
00?@0000;@02d0T000?@0000;@02d0>000OoP820o`3@02l00]090003d00002d00]090003d00002h0
00?@0000=@0001X000?@0000:`000m00000:0003d00002/000?@00002P000m00000Z000<om30P<20
`?o0P<3o0P000m00000[0003d00000X000?@0000:`000m00000:0003d00002`000?@0000=P0001/0
0]0Y00;@3P02d2T00]0>00?@:002d0J000?oP8000X000ol00003d2P00]0>00?@:002d0h00m0Y00;@
>@0001d00]0U00;@4P02d2H000?@00004@000m00000S000Aom20`830P<20`?o0P<20`?l010000m00
000T0003d000014000?@000090000m00000A0003d00002@00]0k00007`000m00000Q0003d00001@0
00?@00008P000m00000C0003d000024000?od80028000on0P004P003o`00008000?@00008P000m00
000C0003d000028000?@00004`000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@5`02d1l0
01God=20`830P<20`83oP<20`830P?l01@02d2000]0G00?@7`02d1L00m0O00;@?P0002800m0J00;@
7003d1X00m0K00?@6P03d0^000?oP8001X000ol0000400?@6P03d1`00]0J00?@7002d1X00m100000
9@02d1D00m0Q00;@5P02d2400]0F00;@01WoP<20`830P<20`830P?n0`830P<20`83o00P00m0E00;@
8@03d1D00]0Q00?@5@02d4<0000?00<O5@05d0/01M0V00G@2`06d2D01M0;00K@0_l>P003oh2000N0
00?o00002@04d0/01]0V00C@2`06d2H01M0:00K@A@0000l00alJ00_@<00;d3002m05000Mol20`830
P<20`830P<20`83oP<20`830P<20`?l03P0;d3002m0a00[@B`0000l00anN00;o4H000on0P009P003
o`000=L0002_000Roh30P<20`830P<20`830P<20`?o0P<20`830P<20`830omP0002^0003oh200160
00?oP8002h000ol0003F0000[002o`0TP<20`830P<20`830P<20`830P<3o`830P<20`830P<20`83o
e`000:/000?oP80058000on0P00=P003o`000=@0002Y00;o02W0P<20`830P<20`830P<20`830P<20
`?o0P<20`830P<20`830P<20o`3E00003`037iH000?oP8005h000on0P00>P003o`000=<0000?00<O
U002o`0]P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<3o0=@0000?00<O
T`000on0P00IP003oh20016000?o0000d@000:@003?o`830P<20`830P<20`830P<20`830P<20`830
P?n0`830P<20`830P<20`830P<20`?l0dP000:800_lMP003oh2001:000?o0000d0000:4003OoP<20
`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`83o0=40002O00;o
7h000on0P00EP003o`000<h0002N000lol20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0
P<20`830P<20`830P<20`830P<20`83oc`0001800an700;o8X000on0P00FP003o`000<d0000B00<O
QP00@?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20
`830P<20`?o>00004P037hD000?oP8008h000on0P00HP003o`000</0002H00;o04:0`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P?o=0000
U`000on0P00UP003oh2001Z000?o0000bP0009D00_l0Al20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`83o0</0002D0003oh2002R0
00?oP80078000ol000380000T`00C?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`?o:0000T@02obb000?oP8007H000ol0
003700005`037gH0057o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`?l0b00001L00ame00Co:h000on0P00PP003
o`000<D0000G00<OM@001?n0`807o`18P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
ol20`830P<20`830P<20`830P<20`830P<20`830P<20`83oa`00090000?oP8001h06oaj000?oP800
8H000ol000340000T@003on0`830P<20`830P<20`007o`0m`830P<20`830P<20`830P<20`830P<3o
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20o`350000TP000on0P00BP0Oo48000on0
P00SP003o`000<80002B000Lol20`830P<20`830P<20`830P<20`830P<20`0Ko0360`830P<20`83o
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o0<@0002C0003oh2001j01ol2P003
oh2002F000?o0000`@0000807?l37oooI_lS00007P037g<000?oP8009H03o`:01_lOP003o`000<00
000N00<OM0009on0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`003o`08`830P<20
`806o`0K`830P<20`830P<20`830P<20`830P<20`83o0<40002F0003oh2002B000?oP8003H06oaF0
00?o0000_P0009L003coP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20
`830P<20`830P<20`805o`0BP<20`830P<20`830P<20`83o_`0009L000?oP8008X000on0P00IP0Ko
2h000ol0002m0000V000A_o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`830P<20`830P<20`830P<06o`07P<20`830o`2n00009P037g0000?oP80088000on0
P00UP0Ko00B07alO^`0002H00am`001Boh30P<20`830P<20`830P<20`830P<20`830P<20`830P<3o
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830o`<O^`0002H00ama0003
oh2001n000?oP800:h001?lO7ank0000V`00COn0`830P<20`830P<20`830P<20`830P<20`830P<20
oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83000;o_`0009`000?oP800
78000on0P00YP003o`000;l0002L0019ol20`830P<20`830P<20`830P<20`830P<20`830P?n0`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P002ol80002M0003oh2001^000?oP800
9X000ol000320000WP00A_o0P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P?o50000WP000on0P00IP003oh2002B00_o60000<0037f`0
04;oP<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`?l37lD0000`00<OK@000on0P00GP003oh2002600_l0100O7ao50000<0037fh003goP<20
`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`83o00<0
0ao50000X@000on0P00FP003oh2001j00_o<0000XP00>Oo0P<20`830P<20`830P<20`830P<20`?o0
P<20`830P<20`830P<20`830P<20`830P<20`830o`3>0000X`000on0P00CP003oh2001b00_o?0000
X`00=On0`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`83o0=40
002T0003oh2001:000?oP8006X000ol0003@0000?0037fH0033oP<20`830P<20`830P<20`830P?n0
`830P<20`830P<20`830P<20`830P<20`?l37m40000l00<OI`000on0P00@P003oh2001N000?o01l0
0QoA0000?0037fL002_o`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<2000;o
0P037m40002W0003oh2000j000?oP8005H000ol0003F0000Z0009_o0P<20`830P<20`830P<3o`830
P<20`830P<20`830P<20`8300_oI0000Z0000on0P00=P003oh2001:000?o0000f@000:T002;oP<20
`830P<20`830P<3o`830P<20`830P<20`830P<200_oL0000ZP000on0P00;P003oh2000n000?o0000
g00004X00amN000Moh30P<20`830P<20`?o0P<20`830P<20`830P<000aoN0000BP037eh000?oP800
2H000on0P00=P004oalO7mh0001:00<OG`007?o0P<20`830P<20oh30P<20`830P<20`830o`037mh0
002]0003oh2000N000?oP8002X02on<0002]000Goh30P<20`830P?n0`830P<20`830P?l0i@000:h0
00?oP8001X000on0P007P0;oiP0005T00amC0009oh30P<20`?o000<O00K0P<20`?oX0000F@037e@0
00?oP8000h000on07`027`>00_oY0000F@037e@000So`830P<3o`0<O00?0P?l0j`000;4000?oP800
0X000on0P003P003o`000>X0001Y00<O?0037`L000So`830ol20`0;ok@0006T00all00<O1`001On0
P83o00:000?o0000k@0006T00all00<O20001?n0oh02oo00001i00<O3@037``00alI00?olP0007T0
0al=00<O30037aX000?o0000l@0007T00al=00<O30037ol03`000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@00?o0000=P02d3T00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000G@P?o@o`0f0004d000d3L000C@003@=`000m00000b0000
5P02d3@000?@00000P02d3@000?@00000P02d3@000G@P83oP002d3@000?@00000P02d3@000?@0000
0P02d3@000?@0000<`0001P000?@0000<0000m0000050003d000030000?@00001@000m00000`0009
d830P?n0`83@038000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00
000]00;@2@000m00000]00;@2@000m00000]00;@18000on0P002P003d00002d00]090003d00002d0
0]090003d00002h000?@0000=@0001X000?@0000:`000m00000:0003d00002/000?@00002P000m00
000[000>d?n0`830P?n0`830P=0]0003d00000X000?@0000:`000m00000:0003d00002`000?@0000
=P0001/00]0Y00;@3P02d2T00]0>00?@:002d003oh2000B000?oP8001803d2P00]0>00?@:002d0h0
0m0Y00;@>@0001d00]0U00;@4P02d2H000?@00004@000m00000T000Ed03oP<20`830P?n0`830P<20
o`3@02H000?@00004@000m00000T0003d000014000?@00009002d3/0000O0003d000024000?@0000
50000m00000R0003d00001<000?@00008P000m00o`08P003oh2000J000?o0=0090000m00000C0003
d000028000?@00004`000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@5`02d2000]005`3o
P<20`830P<20oh30P<20`830P?l000;@8002d1L00m0O00;@5`03d1l00]0n00008P03d1X00]0L00?@
6P03d1/00m0J00?@0P000on0P008P003oh2000R000?o00000m0J00?@7002d1X00m0L00;@6P03d400
000U00;@5@03d2400]0F00;@8@02d1H00]04000Ioh30P<20`830P<20oh30P<20`830P<20o`0400?@
5@02d2400m0E00;@8@03d1D00]1300003`037aD01M0;00G@9P05d0/01]0U00G@2`06d0D000?oP800
2X000on0P00:P003o`0000@01=0;00K@9P04d0/01]0V00G@2P06d4D0000?00<O6P0;d3002m0`00_@
2P007On0`830P<20`830P<20oh30P<20`830P<20`83o00T02m0`00_@<@0:d4/0000?00<OY0000on0
P00<P003oh2000b000?o0000dP000;@00_l08830P<20`830P<20`830P?n0`830P<20`830P<20`83o
d`000;<000?oP8003h000on0P00>P003o`000=00002b000Vol20`830P<20`830P<20`830P?n0`830
P<20`830P<20`830P?oA0000/@000on0P00AP003oh20012000?o0000cP000;0002[o`830P<20`830
P<20`830P<20`83oP<20`830P<20`830P<20`830P?o?00003`037id000?oP8004h000on0P00BP003
o`000<`0000?00<OW000;_o0P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830
P?o=00003`037i/000?oP8005H000on0P00DP0;ob`000:`003?o`830P<20`830P<20`830P<20`830
P<20oh30P<20`830P<20`830P<20`830P<20`?l0bP000:/000?oP8005h000on0P00GP003o`000<L0
002Z000gol20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830
o`380000Z@000on0P00IP003oh2001V000?o0000a@000:P003_o`830P<20`830P<20`830P<20`830
P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830o`3600004P037i8000?oP8006h000on0
P00KP003o`000<<0000B00<OT@00?oo0P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P<20`830o`3400004P037hl00_lOP003oh2001f000?o0000`@000:<0
04CoP<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20
`830P<20`830ol80002R0003oh20022000?oP8007h000ol0002o0000X@00B?n0`830P<20`830P<20
`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830ol00
002P0003oh2002:000?oP8008H000ol0002m0000W`00C?n0`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?nn0000WP000on0
P00TP003oh2002>000?o0000^`0001L00an3001@oh30P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?nl00005`037h80
00?oP8009X000on0P00UP003o`000;T0000G00<OP@00E?n0`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830okX0
002J0003oh2002R000?oP8009h000ol0002g0000V@00F?n0`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`?nh0000V0000on0P00ZP003oh2002V000?o0000]@0009L005coP<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830okH0002F0003oh2002b000?oP800:h000ol0002c00000P0Lo`<Od_l37i3o8`0001h0
0amf0003oh2002Z00ol[P004oalO7k<0000N00<OM`00;?o0P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`8300ol0;<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P?l00anc0000V@000on0P00YP003oh2002R000?o0000]P0009X005Ko`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20okT0002K0003oh2002N000?oP8009X000ol0002h0000W000D_o0P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P?nk00009P037g@000?oP8009H000on0P00SP0<O^`0002H00ame001=ol20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`8000ank00009P037gH000?oP8008h000on0P00RP004oalO7k/0002P001:ol20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830
P?no0000X@000on0P00QP003oh20022000?o0000_P000:8004Ko`830P<20`830P<20`830P<20`830
P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`83o`@000:<000?oP800
7h000on0P00NP003o`000<00002T0012ol20`830P<20`830P<20`830P<20`830P<20`830P<20oh30
P<20`830P<20`830P<20`830P<20`830P<20`83o``000:D000?oP8007H000on0P00LP003o`000<80
000`00<OL`00>oo0P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830
P<20`830P<2000<Oa@0003000amd0003oh2001^000?oP8006H037lD0000`00<OM@00>Oo0P<20`830
P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P0037lD0002Y0003
oh2001V000?oP80068000ol000360000ZP00=_o0P<20`830P<20`830P<20`830P<20`830P?n0`830
P<20`830P<20`830P<20`830P<20olT0002[0003oh2001N000?oP8005X000ol000380000[000<_o0
P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`83ob`000:d00_lFP003
oh2001B000?o0000bP0003`00am`000Voh30P<20`830P<20`830P<20`830P?n0`830P<20`830P<20
`8037`04P<20old0000l00<OL@000on0P00BP003oh2000f00al2P003o`000<`0000l00<OLP009?n0
`830P<20`830P<20`830P<20oh30P<20`830P<20`830P0<O00>0o`00cP000;8000?oP80048000on0
P00@P003o`000<h0002c000Uoh30P<20`830P<20`830P<20oh30P<20`830P<20`830P<20o`3A0000
]0000on0P00>P003oh2000j000?o0000d0000;D0027oP<20`830P<20`830P<20oh30P<20`830P<20
`830P?l0d`000;H000?oP80038000on0P00<P003o`000=80001:00<OJP004On0`830P<20`830P<20
oh3000<O00W0P<20`830P?l0e@0004X00am[0003oh2000Z000?oP8000al7P003o`000=@0001:00<O
K0003on0`830P<20`830P?n0`0037`07`830P<20o`3G0000^P000on0P008P003oh2000R000?o0000
eP000;/001GoP<20`830P<20oh30P<20`830P?l0f@000;`000?oP8001X000on0P006P003o`000=P0
001I00<OG0037`80017oP<20`830P?n0`830P<20o`3K0000F@037e`00al30003oh2000B000?oP800
18000ol0003J0000F@037e`00al4000=oh30P<20oh30P<20o`3M0000`0000on0P002P003oh2000:0
00?o0000g00006T00all00<O5P002On0`83oP<20o`3O0000J@037c`00alG0004oh20o`:000?o0000
gP0006T00all00<O60001On0oh3o0>40001i00<O3@037``00alY00?ohP0007T00al=00<O30037bX0
00?o0000h@0007T00al=00<O30037ol03`000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@ol3@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d?oo00:00]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0002M3o`?o0P<20
d00b0003d00000D000?@0000<0000m0000050003d000030000?@0000=00001T000?@0000;@02d0T0
00?@0000;@02d0T000?@0000;@02d005oh20P?l018000m3o000]00;@2@000m00000]00;@2@000m00
000^0003d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`003m00
0?n0`83oP<20`83@o`0/0003d00000X000?@0000:`000m00000:0003d00002`000?@0000=P0001/0
0]0Y00;@3P02d2T00]0>00?@:002d08000?oP8000X000on0P004P0?@:002d0h00m0X00;@3P03d2T0
0]0i00007@02d2D00]0B00;@9P000m00000A0003d00002@001G@0000oh30P<20oh30P<20`830om00
9P000m00000A0003d00002@000?@00004@000m00000T00;@>`0001l000?@00008@000m00000D0003
d000028000?@00004`000m00000R0005d0000?l01X000on0P008P003d000028000?@00004`000m00
000R0003d00001<000?@00008P000m00000k00008002d1l00]0H00;@8002d1L00]0P00;@10004oo0
P<20`830ol20`830P<20`8000]0P00;@5`03d1l00]0G00?@7`02d3h0000R00?@6P02d1`00m0J00?@
6`03d1X00m050003oh2000J000?oP8002X03d1X00m0L00;@6P03d1`00]0J00?@@00002D00]0E00?@
8@02d1H00]0Q00;@5P02d0L001So`830P<20`830ol20`830P<20`830P<02o`?@5@02d2400m0E00;@
8@03d1D00]1300003`037aD01M0;00G@9P05d0/01]0U00G@2`06d0T000?oP8001h000on0P00=P003
o`0000C@2`06d2H01=0;00K@9P05d0X01]1500003`037aX02m0`00_@<00;d0h001coP<20`830P<20
`?o0P<20`830P<20`830P<200_l400_@<00;d3402]1;00003`037jP000?oP8002H000on0P00@P003
o`000<d0002i000Roh30P<20`830P<20`83oP<20`830P<20`830P<20`830olh0002i0003oh2000^0
00?oP8004H02ol`0002h000Vol20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P?o;0000
]`000on0P00=P003oh2001B00_o90000]P00:oo0P<20`830P<20`830P<20oh30P<20`830P<20`830
P<20`830P<20`?l0b00000l00anT0003oh2000j000?oP8005h02olH0000?00<OX`00;on0`830P<20
`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`83o0<D0000?00<OXP000on0P00AP003
oh2001V00_o30000/`00=?n0`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20
`830P<20`?o20000/`000on0P00BP003oh2001b000?o0000_`000;8003Ko`830P<20`830P<20`830
P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<02okl0002a0003oh2001F000?oP800
7X000ol0002l0000/000>oo0P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830
P<20`830P<20`830P<2000;o_00001800anK0003oh2001J000?oP8008H000ol0002i00004P037iX0
03ooP<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<000_ni00004P037iT000?oP80068000on0P00TP003o`000;H0002^0013ol20`830P<20`830
P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P002okH0
002]0003oh2001Z000?oP8009X000ol0002c0000[000BOo0P<20`830P<20`830P<20`830P<20`830
P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?l0]0000:/000?oP800
78000on0P00XP0;o/P000:/004goP<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20o`2a0000ZP000on0P00MP003oh2002^0
0_n_00005`037hl0057oP<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<000an/00005`037hh000?oP80088000on0
P00ZP0;o0an/00005`037hh004Wo`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<2000Oo00>0`1l00Qn/0000Y`000on0P00QP003
oh2001b01ol9P003o`000:`0002V000mol20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P?n0`830P<20`830P<20`830P<20`830P007o`0@P<20`830P<20`830P<20ojl0002U0003oh2002>0
00?oP8003h06oaF000?o0000[P000:D0037oP<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<3o`830P<20`83000Oo01c0P<20`830P<20`830P<20`830P<20`830P<3o/0000:@000?oP800
9H000on0P007ob6000?o0000[`0000807?l37m;o0an@ob<0000N00<OPP000on0P00MP0Ko0X03obF0
0anc00007P037h4001_o`830P<20`830P<20`830P<20`830P<20`8001_l02<20`830P<200ol09H30
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8000anc0000X@000on0P00CP0Ko3h000on0
P00UP003o`000;80002P000Bol20`830P<20`830P<20`8301Ol0?L20`830P<20`830P<20`830P<20
`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?l0]@000:0000?oP8002H06oa^0
00?oP8008h000ol0002c0000W`001on0`830P<001_l0Ah30P<20`830P<20`830P<20`830P<20`830
P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o0;H0000V00<OM@000on0
o`05obN000?oP8006h037`>000?o0000]@0002H00amd00?o04^0`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`8000al00h30
o`2h00009P037gH000?oP800:h000on0P00KP0<O0X000ol0002f0000X002o`1>P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830
P<20`83o^@000:8000?oP800:H000on0P00MP003o`000;P0002S00;o04W0P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`83o0;/0
002U0003oh2002J000?oP80078000ol0002i0000YP00Aoo0P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<3o0;`0002W00;o9X000on0
P00IP003o`000;/0000`00<OMP00>?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
oh30P<20`830P<20`830P<200al01h30P<20`?l0_P0003000amg00;o8h000on0P00?P0<O1X000ol0
002l0000<0037gT003Go`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830
P<20`830P0037`06P<20`83o_`000:d00_lPP003oh2001J000?o0000_P000:l003WoP<20`830P<20
`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P?l0`@000;000_lNP003
oh2001B000?o0000_`000;8003Go`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830
P<20`830P<20`830o`320000/`000on0P00JP003oh2001:000?o0000`@0003`00ame00;o01n0`830
P<20`830P<20`830P<20`830P<20`?o0P<2000<O00j0`830P<20`830P<20ol<0000l00<OM`000on0
P00GP003oh2000:00al<P003o`000<80000l00<ON002o`0L`830P<20`830P<20`830P<20`830P<3o
`830P0<O00b0`830P<20`830P?o50000^@000on0P00EP003oh2000j000?o0000a0000;X00_l09h30
P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830o`360000_0000on0P00BP003oh2000f0
00?o0000a@000;d00_l08/20`830P<20`830P<20`830P?n0`830P<20`830P<20`?o80000_`000on0
P00?P003oh2000^000?o0000a`0004X00amc0008ol20`830P<037`0E`830P<20oh30P<20`830P<20
`83o0<T0001:00<OM002o`F00al7P003oh2000V000?o0000b00004X00amf0005oh30P<000al04l20
`830P<3o`830P<20`830P?l0b`000<@00_l<P003oh2000N000?o0000bP000<H001Oo`830P<20`830
P<3o`830P<20`830o`3<0000a`02o`V000?oP8001X000ol0003;0000F@037e`00al>000Boh30P<20
`830P?n0`830P<3ocP0005T00amL00<O3`02o`N000?oP80018000ol0003<0000F@037e`00alA000>
ol20`830P?n0`830P?o?0000c@000on0P003P003oh2000:000?o0000cP0006T00all00<O8`02o`08
P<20oh30P?oA0000J@037c`00alU0004oh20o`>000?o0000c`0006T00all00<O9P02o`04`?o0om80
001i00<O3@037``00alh00?od`0007T00al=00<O30037cT000?o0000dP0007T00al=00<O30037ol0
3`000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d?oo00800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0001=00oh02o`80
00?@0000<0000m0000050003d000030000?@00001@000m00000`0003d00003@0000I0003d00002d0
0]090003d00002d00]090003d00002d00]00103oP?l2P0?o00?@0000;@02d0T000?@0000;@02d0T0
00?@0000;P000m00000e00006P000m00000[0003d00000X000?@0000:`000m00000:0003d00002/0
00k@0000ol3o`830P<3od2d000?@00002P000m00000[0003d00000X000?@0000;0000m00000f0000
6`02d2T00]0>00;@:@02d0h00m0X00;@0`001?n0P?l7P0?@:002d0h00m0X00;@3P03d2T00]0i0000
7@02d2D00]0B00;@9P000m00000A0003d00002@000?@00000`003on0`83oP<20`830P<3od00V0003
d000014000?@000090000m00000A0003d00002@00]0k00007`000m00000Q0003d00001@000?@0000
8P000m00000C0003d000028000?@00000`000on0P002P003oh2000R000?@ool08P000m00000C0003
d000028000?@00004`000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@5`02d2000]06000A
ol20`830ol20`830P<20`8000]02oah00]0G00?@7`02d1L00m0O00;@?P0002800m0J00;@7003d1X0
0m0K00?@6P03d0L000?oP80018000on0P00:P0?@00?o00005`03d1`00]0J00?@7002d1X00m100000
9@02d1D00m0Q00;@5P02d2400]0F00;@2P005on0`830P<3o`830P<20`830P<20`83000?@5@02d240
0m0E00;@8@03d1D00]1300003`037aD01M0;00G@9P05d0/01]0U00G@2`06d0/000?oP8001X000on0
P00?P0C@2`06d2H01=0;00K@9P05d0X01]1500003`037aX02m0`00_@<00;d14001oo`830P<20`83o
P<20`830P<20`830P<20`830P<3o00_@<00;d3402]1;00003`037j`000?oP8001h000on0P00CP0;o
b@000;d002?oP<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`003olH0002m0003oh2000R0
00?oP8006802ol@0002l000Yol20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`800
0_o20000_0000on0P00:P003oh2001^00_o00000^`00;_n0`830P<20`830P<20`?o0P<20`830P<20
`830P<20`830P<20`830P<20`803okd0000?00<OZ@000on0P00<P003oh2001n00_nk00003`037jP0
03Co`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`8300_ni0000
3`037jP000?oP8003X000on0P00RP0;o]`000;T003WoP<20`830P<20`830P<20`83oP<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<000ond0000^@000on0P00@P003oh2002J00_nb0000
^000?oo0P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P002ok00002h0003oh20016000?oP800:X02ojh0002g0014oh30P<20`830P<20`830P<20
`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`803oj/0000B00<O
XP000on0P00CP003oh2002j000Co7alOY`0001800anQ0019ol20`830P<20`830P<20`830P<20`83o
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P0037jL0000B00<O
X@000on0P00EP003oh2002^00ol37jL0002e0014oh30P<20`830P<20`830P<20`830P<20`?o0P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`803o`04P<20ojT0002e0003oh2001N0
00?oP8009803o`J000?o0000Y`000;D003ooP<20`830P<20`830P<20`830P<20`830P?n0`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<000_l02H30P<20`830o`2Z0000]0000on0P00HP003
oh2001n00ol:P003o`000:P0002d000jol20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`830P<20`830P<20`0?o00g0P<20`830P<20`83o0:/0002c0003oh2001Z000?oP800
6803o`n000?o0000Z@0001L00anI000foh30P<20`830P<20`830P<20`830P<20`830P<20oh30P<20
`830P<20`830P<20`830P<200_l03l20`830P<20`830P<20`0037j`0000G00<OV0000on0P00LP003
oh2001:00olAP0<O[00001L00anH000aol20`830P<20`830P<20`830P<20`830P<20`830P?n0`830
P<20`830P<20`830P003o`0DP<20`830P<20`830P<20`830P<037j`0002a0003oh2001j000?oP800
2h03oaR000?o0000Z`000;4002goP<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20
`830P<000_l07830P<20`830P<20`830P<20`830P<20`830P?n]0000/0000on0P00PP003oh2000F0
0olLP003o`000:`0002`000Xol20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`0?o
0230P<20`830P<20`830P<20`830P<20`830P<20`830ojh0002_0003oh20026000?oP?l00_lQP003
o`000:d0000201co0aoBo`<OT?lS00007P037hd000?oP8007h05oaj00al2P003o`000:h0000N00<O
S@007oo0P<20`830P<20`830P<20`830P<20`830P<20`8000ol00h30o`03o`0MP<20`830P<20`830
P<20`830P<20`830P<20`8000al00h30o`2`0000[@000on0P00JP0?o28000on0P00OP003o`000:l0
002]000Joh30P<20`830P<20`830P<20`830P<20`803o`0^P<20`830P<20`83oP<20`830P<20`830
P<20`830P<20`830P<20`830P<20ok40002/0003oh2001J00_l?P003oh2001f000?o0000/0000:`0
01Ko`830P<20`830P<20`830P<20`8300ol0</20`830P<20`830P<20`830ol20`830P<20`830P<20
`830P<20`830P<20`830P<3o/P0002H00an30003oh2001200olDP003oh2001:00al7P003o`000;40
000V00<OPP004On0`830P<20`830P<20`83000?o02c0P<20`830P<20`830P<20`830P<20`83oP<20
`830P<20`830P<20`830P0<O00R0`830P<20ok<0000V00<OPP000on0P00;P0?o6h000on0P00AP0<O
1X000ol0002b0000ZP003?o0P<20`830P<20`0?o03c0P<20`830P<20`830P<20`830P<20`830P<20
`830ol20`830P<20`830P<20`830P<20`830P<20`?nd0000ZP000on0P007P0;o8X000on0P00HP003
o`000;<0002Y0008oh30P<20`803o`10P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
ol20`830P<20`830P<20`830P<20`830P<20okD0002Y0003oh2000:00olXP003oh2001J000?o0000
]0000:P000?o`8000ol0AH30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83o
P<20`830P<20`830P<20`830P<20`830o`2f0000Z003obj000?oP8005X000ol0002d0000<0037g@0
0_l0><20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20
0al03X30P<20`830P<20`83o]`0003000amf00;o;h000on0P004P0<O3H000ol0002e0000<0037gP0
0ol0<h30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P0037`0=
P<20`830P<20`830o`2h0000[P02ob^000?oP8004X000ol0002f0000/002o`0nP<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P?ni0000/P02obR0
00?oP80048000ol0002g0000]003o`0h`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`?o0P<20`830P<20`830P<20`?nj0000]`02ob>000?oP8003h000ol0002h0000?0037gX00_l06/20
`830P<20`830P<20`830P<20`830P<200al05X30P<20oh30P<20`830P<20`830P?nk0000?0037g`0
0_lHP0<O1H000on0P00=P003o`000;T0000l00<OOP03o`0EP<20`830P<20`830P<20`830P<2000<O
01F0`830P?n0`830P<20`830P<20`?l0_0000<000_lLP003oh2000^000?o0000^P000<800_l0:830
P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P?nm0000a003oaR000?oP8002H000ol0
002k0000a`02o`0R`830P<20`830P<20`830P<20`830P?n0`830P<20`830okh0003900;o58000on0
P008P003o`000;`0001:00<ON`037`;o01g0P<20`830P<20`830P<20`830ol20`830P<20o`2o0000
BP037g/00al200?o48000on0P006P003o`000;d0001:00<ON`037`D00_l06830P<20`830P<20`830
ol20`830P<20okl0003B00;o3H000on0P004P003o`000;h0003D00;o01>0`830P<20`830P?n0`830
P<3o0<00003F00?o2H000on0P002P003o`000;l0001I00<OG0037ah00_l03L20`830P<3o`830P?l0
`@0005T00amL00<O8002o`F000GoP820o`320000F@037e`00alR00;o00S0P<20oh30ol80003O00?o
00B0oh3o``0006T00all00<O=`02o`03P?l00<80001Y00<O?0037cT000?o0000`P0006T00all00<O
oP0007T00al=00<O30037ol03`0007T00al=00<O30037ol03`0007T00al=00<O30037ol03`000?l0
ZP000?l0ZP000001


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m0000050003
d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000^0003
d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f00006`02d2T00]0>00;@
:@02d0h00m0X00;@3P03d2P00]0>00?@:002d0h00m0Y00;@>@0001d00]0U00;@4P02d2H000?@0000
4@000m00000T0003d00000<00ol;0003d00002@000?@00004@000m00000T0003d000014000?@0000
9002d3/0000O0003d000024000?@000050000m00000R0003d00001<000?@00008P000m0000040003
oh2000Go1`000m00000R0003d00001<000?@00008P000m00000C0003d000028000?@0000>`000200
0]0O00;@6002d2000]0G00;@8002d0L00_l01/20`830P0Go0`02d2000]0G00?@7`02d1L00m0O00;@
?P0002800m0J00;@7003d1X00m0K00?@6P03d0P000CoP83o2X05o`?@6P03d1`00]0J00?@7002d1X0
0m1000009@02d1D00m0Q00;@5P02d2400]0F00;@2`004oo0P?n0`830P<20`830P<20`8000ol3d1D0
0]0Q00?@5@02d2400m0E00;@@`0000l00alE00G@2`05d2H01M0;00K@9@05d0/01]0=0005oh20P?l0
4X02o`C@2`06d2H01=0;00K@9P05d0X01]1500003`037aX02m0`00_@<00;d1<001go`830P?n0`830
P<20`830P<20`830P<20`830o`0;d3002m0a00[@B`0000l00an^0003oh2000:000?oP8006H04ol@0
002o000Voh30P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`805okl0002o0003oh2000F0
00?oP8008805okX0002o000`oh30P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<201One0000_`000on0P006P003oh2002V01?na0000_P00>_o0P<20`830P<20oh30P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<05oj`0000?00<O[0000on0P009P003
oh2003201Ol37j@0000?00<O[000A?o0P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`8300anT00003`037j`000?oP8002X000on0P00bP0;o
0anT0000_P00A_o0P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20oh30P?nU0000_@000on0P00<P003oh2002j00_l3P003o`000:@0002m000n
oh30P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`802o`06`830P<3oYP000;d000?oP8003X000on0P00YP003oh2000F000?o0000Y0000;d003_oP<20
`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`002o`09
P<20`830P<3o0:H0000B00<OY`000on0P00@P003oh2002B00_l7P0<OY`0001800anW0013ol20`830
P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830
P0037jL0000B00<OY`000on0P00AP003oh2002200_l:P0<OY`000;`003Go`830P<20`830P<20`830
P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P002o`0?`830P<20`830P<20`83o0:L0
002l0003oh2001>000?oP8006h000on0P00=P003o`000:H0002k000coh30P<20`830P<20`830P<20
`830P<3o`830P<20`830P<20`830P<20`830P<20`83000;o0160`830P<20`830P<20`830o`2X0000
^`000on0P00EP003oh2001J00_lBP003o`000:H0002k0016oh30P<20`830P<20`830P<20`830P<20
`?o0P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830ojP0002k0003oh2001N0
00?oP8004H02oaF000?o0000YP0001L00anP000]ol20`830P<20`830P<20`830P<20`830P<20oh30
P<20`830P<20`830P<2000;o0170P<20`830P<20`830P<20`0037`03`83o0:T0000G00<OX0000on0
P00IP003oh2000f000?oP8004H037`:000?o0000Y`0001L00anP000Zol20`830P<20`830P<20`830
P<20`830P<20`83oP<20`830P<20`8300_l05830P<20`830P<20`830P<20`8300al00l20o`2Y0000
^P000on0P00JP003oh2000R00_lKP003o`000:L0002j0015ol20`830P<20`830P<20`830P<20`830
P<20`830ol20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<3o0:X0002i0003oh2001f0
00?oP8000h02oaf000?o0000Z0000;T002CoP<20`830P<20`830P<20`830P<20`830P<20`830P?n0
`802o`0P`830P<20`830P<20`830P<20`830P<20`830P<20`?nZ0000^@000on0P00NP003oh3o0260
00?o0000Z00000807?l37m;o0an@ob<0000N00<OU`000on0P00NP0Co5X037`N000?o0000Z@0001h0
0anG000Ool20`830P<20`830P<20`830P<20`830P<20`830P002o`0J`?oool20`830P<20`830P<20
`830P<20`8037`08P<20`830P?n[0000^0000on0P00JP0;o1X000on0P00MP003o`000:T0002h0015
ol20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P?n0`830P<20`830P<20`830P<20`830
P<20`830P<3o0:`0002h0003oh2001N00_l:P003oh2001^000?o0000ZP000;L004KoP<20`830P<20
`830P<20`830P<20`830P?n0`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<3o
[00002H00an>0003oh2001F00_l>P003oh2000V00al>P003o`000:X0000V00<OSP005_n0`830P<20
`830P<20`830P<20`802o`0L`830P<20`830P<20`830P<3o`830P<20`830P0<O00j0`830P<20`830
P<20ojd0000V00<OSP000on0P00BP003oh20016000?oP80028037`f000?o0000Z`000;H001Co`830
P<20`830P<20`830P<20`0;o0320`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830
P<20`830P?n]0000]P000on0P00@P003oh2001J000?oP8005X000ol0002[0000]P004Oo0P<20`830
P<20`830P<2000;o03?0P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20
`830P?l0[@000;H000?oP8003802oab000?oP80058000ol0002/0000]P00AOo0P<20`830P<20`830
ol20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830o`2^0000
]@000on0P00:P0;o88000on0P00CP003o`000:`0000`00<OPP00;?n0`830P<20`830P?n0`830P<20
`830P<20`830P<20`830P<20`830P<200al05h3oP<20`830P<20`830P<20`830P<3o0:h0000`00<O
PP000on0P007P0;o88037`:000?oP80048000ol0002]0000<0037h8000SoP<20`830P0;o02;0P<20
`830P<20`830P<20`830P<20`830P<20`830P<200al05X30ol20`830P<20`830P<20`830P?n_0000
]0000on0P005P003oh2002R000?oP8003h000ol0002]0000]0001_o0P<20`0;o03j0`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20ojl0002d0003
oh2000:000?oP800;8000on0P00=P003o`000:h0002d0003ol2000;o0430P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<3o/0000;@00olbP003
oh2000b000?o0000[P0003`00amd00;o0230P<20`830P<20`830P<20`830P<20`830P<20`830P0<O
0260`830P<20`830P<20`830P<3o`830P<20`830P<20`?l0/00003`00amd00?o7h037a>000?oP800
2H000ol0002_0000?0037gL01Ol06/20`830P<20`830P<20`830P<20`830P<200al08830P<20`830
P<20`830P<20`83oP<20`830P<20`83o/@000;/01Ol/P003oh2000R000?o0000[`000<001?l0=830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P?na0000a005obB0
00?oP8001X000ol0002`0000b@05o`0YP<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830
P<20`?l0/P000<h01?lMP003oh2000B000?o0000/00004X00amk00<O1`05o`0P`830P<20`830P<20
`830P<20`830P<20oh30P<20`?nb0000BP037g/00al<00Co5H000on0P003P003o`000;00001:00<O
N`037a001Ol05X30P<20`830P<20`830P<3o`830P?nc0000h005o`b000GoP820o`2c0000i@04o`0=
`830P<20`830ol20o`2c0000j@05o`B000CoP83o/`0005T00amL00<O<`07ok@0001I00<OG0037cP0
0_nd0000F@037e`00ao^0000o`2Z0000J@037c`00aon0000J@037c`00aon0000J@037c`00aon0000
N@037`d00al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000o`2Z0000
o`2Z0000


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m0000050003
d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000^0003
d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f00006`02d2T00]0>00;@
:@02d0h00m0X00;@3P03d2P00]0>00?@:002d0h00m0Y00;@>@0001d00]0U00;@4P02d2H000?@0000
4@000m00000T0003d000014000?@000090000m00000A0003d00002@000?@00004@000m00000T00;@
>`0001l000?@00008@000m00000D0003d000028000?@00004`000m00000R0003d00001<000?@0000
8P000m00000C0003d000028000?@00004`000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@
5`02d2000]0G00;@8002d1L00m0O00;@5`03d1l00]0n00008P03d1X00]0L00?@6P03d1/00m0J00?@
6`03d1X00m0L00;@6P03d1`00]0J00?@@00002D00]0E00?@8@02d1H00]0Q00;@5P02d2400m0E00;@
8@03d1D00]0Q00?@5@02d4<0000?00<O5@05d0/01M0V00G@2`06d2D01M0;00K@9P04d0/01]0E00<O
3P04d0/01]0V00G@2P06d4D0000?00<O6P0;d3002m0`00_@500Lo`_@6ol37a802m0a00[@B`0000l0
0an_0003oh3o03j000Co7alOX`000<4004CoP<3o`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20oh30oj@000310005oh20P?l0>X001On0P83o0:@0
00310014oh30P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`83oP<20`?nT0000`@000on0P003P003oh2003B000?oP8000h000ol0002R0000`@00A?n0
`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0
`830P<3oY00000l00an_0003oh2000F000?oP800<8000on0P003P0<OY00000l00an_0011oh30P<20
`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<00
0anT00003`037jl000?oP8001h000on0P00/P003oh2000F00anT0000`@00A?n0`830P<20`830ol20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<3oY0000<40
00?oP8002H000on0P00XP003oh2000V000?o0000XP000<4004CoP<20`830P<20`830ol20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830oj@000310003oh2000^0
00?oP80098000on0P00;P003o`000:8000310014oh30P<20`830P<20`830ol20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`?nT00004P037j`000?oP8003H000on0
P00PP003oh2000R00al2P003o`000:80000B00<O[000<On0`830P<20`830P<20`830ol20`830P<20
`830P<20`830P<20`830P<20`830P<000_l02h30P<20`830P<2000<O00>0`?l0Y00001800an/0003
oh2000n000?oP8006h000on0P00;P0<O0X000ol0002R0000`@00A?n0`830P<20`830P<20`830P<3o
`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<3oY0000<4000?oP800
4H000on0P00GP003oh2001:000?o0000XP000<4004CoP<20`830P<20`830P<20`830P<3o`830P<20
`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830oj@000310003oh2001>000?oP800
4h000on0P00DP003o`000:8000310014oh30P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`?o0P<20`830P<20`830P<20`830P<20`?nT0000`@000on0P00EP003oh2000n000?oP800
5X000ol0002R00005`037jL003WoP<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20
`?o0P<20`830P<20`830P<000al02<20`830P<3oY00001L00anW0003oh2001N000?oP8002h000on0
P00>P0<O1h000ol0002R00005`037jL003WoP<20`830P<20`830P<20`830P<20`830P<3o`830P<20
`830P<3o`830P<20`830P<20`830P<000al02<20`830P<3oY0000<4000?oP8006H000on0P007P003
oh2001Z000?o0000XP000<4004CoP<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830ol20
`830P<20`830P<20`830P<20`830P<20`830oj@000310003oh2001^000?oP8000h000on0P00LP003
o`000:8000310014oh30P<20`830P<20`830P<20`830P<20`830P<20`?o0P<3o`830P<20`830P<20
`830P<20`830P<20`830P<20`?nT0000`@000on0P00MP003oh3o022000?o0000XP0000807?l37m;o
0an@ob<0000N00<OX0000on0P00MP0Co3X037`j000?o0000XP0001h00anP000Ooh30P<20`830P<20
`830P<20`830P<20`830P<20`004o`0?P?n0`830P<20`830P<2000<O00n0`830P<20`830P<20`?l0
Y0000<4000?oP8006h000on0P004P003oh2001^000?o0000XP000<4004CoP<20`830P<20`830P<20
`830P<20`830P<20`?o0P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830oj@000310003
oh2001V000?oP80028000on0P00IP003o`000:8000310014oh30P<20`830P<20`830P<20`830P<20
`830ol20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`?nT00009P037iP000?oP800
5h000on0P00<P004oalO7aJ000?o0000XP0002H00anH000Zoh30P<20`830P<20`830P<20`830P<20
`?o0P<20`830P<20`830P<200al05h30P<20`830P<20`830P<20`830P<3o0:@0000V00<OV0000on0
P00EP003oh2000n00alFP003o`000:8000310014oh30P<20`830P<20`830P<20`830P<3o`830P<20
`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`?nT0000`@000on0P00CP003oh2001B0
00?oP8004h000ol0002R0000`@00A?n0`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20
`830P<20`83oP<20`830P<20`830P<20`830P<3oY0000<4000?oP8004H000on0P00HP003oh200160
00?o0000XP000<4004CoP<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20
`83oP<20`830P<20`830P<20`830oj@000310003oh2000n000?oP80078000on0P00?P003o`000:80
000`00<OSP008?n0`830P<20`830P<20`830ol20`830P<20`830P<200al08H30P<20`830P<20`830
P?n0`830P<20`830P<20`830o`2T0000<0037hh000?oP8003H000on0P00=P0<O48000on0P00=P003
o`000:80000`00<OSP008?n0`830P<20`830P<20`?o0P<20`830P<20`830P<200al08H30P<20`830
P<20`830P<20oh30P<20`830P<20`830o`2T0000`@000on0P00;P003oh2002B000?oP8002h000ol0
002R0000`@00A?n0`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P?n0`830P<20`830P<3oY0000<4000?oP8002H000on0P00XP003oh2000V000?o0000XP000<40
04CoP<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0
`830P<20`830oj@000310003oh2000N000?oP800;8000on0P007P003o`000:80000l00<OPP005?n0
`830P<20`?o0P<20`830P<200al0;H30P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30
P<20`830o`2T0000?0037h8000?oP8001H000on0P009P0<O98000on0P005P003o`000:80000l00<O
PP005?n0`830P<3o`830P<20`830P<200al0;H30P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`83oP<20`830o`2T0000`@000on0P003P003oh2003B000?oP8000h000ol0002R0000`@00A?n0
`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
oh30P<3oY0000<4000GoP820o`0jP005oh20P?l0Y0000<4004CoP<3o`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30oj@000310003oh3o03j0
00?oP?l0Y00004X00amd00;o00G0P<20`0037`0h`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`802oj@0001:00<OM007o`<O>_nT0000BP037g/00aoN0000
o`2Z0000o`2Z0000o`2Z0000F@037e`00ao^0000F@037e`00ao^0000F@037e`00ao^0000o`2Z0000
J@037c`00aon0000J@037c`00aon0000J@037c`00aon0000N@037`d00al<00<Oo`0?0000N@037`d0
0al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000o`2Z0000o`2Z0000


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m0000050003
d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000^0003
d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f00006`02d2T00]0>00;@
:@02d0h00m0X00;@3P03d2P00]0900<O0P03d2P00]0>00?@:@02d3T0000M00;@9@02d1800]0V0003
d000014000?@000090000m00000A0003d00002@000?@000020001?lO7al50003d00002@000?@0000
4@000m00000T00;@>`0001l000?@00008@000m00000D0003d000028000?@00004`000m00000R0003
d00001<000?@00008P000m00000400Go00B07alO1P000m00000R0003d00001<000?@00008P000m00
000k00008002d1l00]0H00;@8002d1L00]0P00;@5`02d2000]0200Go00J0`830P<02o`P00m0O00;@
5`03d1l00]0n00008P03d1X00]0L00?@6P03d1/00m0J00?@6`03d1X00m04o`Z000CoP83o2P02d1X0
0m0L00;@6P03d400000U00;@5@03d2400]0F00;@8@02d1H00]0Q00?@5@02d0?o01;0P<20`830P<20
`830P?n0`?l<00?@5@02d2400m0E00;@@`0000l00alE00G@2`05d2H01M0;00K@9@05d0/01]0V00C@
2`06d1:000?oP8000al>00C@2`06d2H01M0:00K@A@0000l00alJ00_@<00;d3002m0`00_@01_o`830
P<20`830P<20`830P<20`830P?n0`8000alB00_@<@0:d4/0000?00<OcP05oaZ000CoP8200anS0000
g004o`0VP<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P?nS0000e`05ob6000?oP800
1H000ol0002Q0000dP05o`0_`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20
`830P?l0X`000<h01?lZP003oh2000N000?o0000X0000<T01Ol0>H30P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830o`2R00003`037k801OlbP003oh2000B0
0al00h3o002Q00003`037k000_l0?X30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`?o0P<20`8300al00l3o002Q00003`037k0000CoP?oo<h000on0P006P0<O
00>0o`00X@000<8004Ko`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20oh30P<20`830P<20`83oX@000<<000CoP8200_l_P003oh2000b000?o0000W`000<<0
00KoP<20`802o`0m`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20
`830P<20`830P<20o`2Q0000``000on0P005P003oh2002V000?oP8003H000ol0002O0000``002On0
`830P<20`002o`0kP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`?l0X00001800an^0003oh2000R00_lVP003oh2000J00al6P003o`0009h0000B00<O
[`00>oo0P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830
P<2000<O00N0`830P<3o0:00000B00<O[`000on0P00:P0;o8H000on0P008P0<O1X000ol0002N0000
a0003oo0P<20`830P<20`830P002o`0e`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20
`830P<20`830P<20`830P?l0W`000<@000?oP8003X000on0P00KP003oh2001>000?o0000W@000<D0
017oP<20`830P<20`830P<20`002o`0bP<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830
P<20`830P<20`830P?nO0000a@000on0P00@P0;o68000on0P00DP003o`0009d000350016oh30P<20
`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20
`830oih000350003oh2001>00_lCP003oh2001N000?o0000W00001L00an[000Hoh30P<20`830P<20
`830P<20`830P<200_l06l20`830P<20`830P<20`830ol20`830P<20`0037`0>`830P<20`830P<20
`?nN00005`037j`000?oP8005X000on0P00=P003oh2000R00al=P003o`0009`0000G00<O[0006_o0
P<20`830P<20`830P<20`830P<20`8300_l06830P<20`830P<20`?o0P<20`830P<20`0<O00o0P<20
`830P<20`830P?l0W@000<H000?oP8006H02o`Z000?oP8006X000ol0002K0000aP00A_o0P<20`830
P<20`830P<20`830P<20`830P<20`?o0P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830
P?nM0000a`000on0P00KP0;o1H000on0P00LP003o`0009/00037000Poh30P<20`830P<20`830P<20
`830P<20`830P<20`802o`0S`830ol20`830P<20`830P<20`830P<20`830P<20`830P?l0W@000<L0
00?oP8007h000on0o`0PP003o`0009X0000201co0aoBo`<OT?lS00007P037jH000?oP8007h04o`J0
0alFP003o`0009X0000N00<OY`008Oo0P<20`830P<20`830P<20`830P<20`830P<20`830P003o`07
P?oo`830P0037`0GP<20`830P<20`830P<20`830P<20`?l0W0000<P000?oP8007H000on0P004P0;o
78000ol0002I0000b000A_o0P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20oh30
P<20`830P<20`830P<20`830P<20`830P?nK0000b0000on0P00LP003oh2000R00_lIP003o`0009T0
00390015oh30P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`?o0P<20`830P<20
`830P<20`830P<20`83o09/0000V00<OX0000on0P00JP003oh2000:00al7P0;o5h000ol0002H0000
9P037j0002;oP<20`830P<20`830P<20`830P<20`830P<20oh30P<200al02H30P<20`830P002o`0F
`830P<20`830P<20`830P<20`830oiX0000V00<OX0000on0P00HP003oh2000B00al;P003oh2001:0
00?o0000V0000<T0037oP<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20
`83000;o01>0`830P<20`830P<20`830P<3o09X0003:0003oh2001J000?oP8005X000on0P00@P003
o`0009L0003:000col20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830
P<2000;o0170P<20`830P<20`830P<20o`2I0000bP000on0P00EP003oh2001Z00_l>P003o`0009L0
003:0016ol20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830
P?n0`830P<20`830P<20oiT0003;0003oh2001:000?oP8007h02o`b000?o0000UP0003000anH000F
oh30P<20`830P<20`830P<20`830o`<O02f0`830P<20`830P<20`830P<20`830P<20`830P<20`?o0
P<20`830P<20`?l0V00003000anH0003oh20016000?oP1l00QlQP0;o2H000ol0002F0000<0037iP0
01KoP<20`830P<20`830P<20`830ol200al08h30P<20`830P<20`830P<20`830P<20`830P<20`830
P<2000;o00S0P<20`830oiP0003;0003oh20012000?oP800:8000on0P004P003o`0009H0003<000n
ol20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<02o`06P<20`83oU`000<`000?oP8003H000on0P00]P003oh2000:000?o0000U@000<`0047o`830
P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P002o`03`83o09L0003<0003oh2000b000?oP800<H03oiL0000l00<OSP002?n0`830P<200al0>H30
ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P002oiH0
000l00<OSP000on0P005P0<O0X000on0P00cP0?oUP0003`00an>0008oh30P<20`8037`0cP?n0`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<2000GoV@000<d000?oP800
28000on0P00[P0GoWP000<d003CoP<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<201OnS0000cP000on0P006P003oh2002>01?nX0000cP00:_o0P<20`830ol20`830
P<20`830P<20`830P<20`830P<20`830P<20`0Go[0000<h000?oP8001H000on0P00JP0Go/@0004X0
0amk00<O0`008Oo0P<20`83oP<20`830P<20`830P<20`830P<20`830P004okH0001:00<ON`037`@0
00?oP8000X000on0P00CP0Go^P0004X00amk00<O10005_n0`830ol20`830P<20`830P<20`805okl0
003?0005oh20P?l03805ol@0003?000=oh30ol20`830P<20`004olT0003?0004oh20o`B01Oo=0000
F@037e`00alE00OodP0005T00amL00<O5@02omL0001I00<OG0037nh0003o0:X0001Y00<O?0037oh0
001Y00<O?0037oh0001Y00<O?0037oh0001i00<O3@037``00aoo00l0001i00<O3@037``00aoo00l0
001i00<O3@037``00aoo00l0003o0:X0003o0:X00000


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d00000800]0d0005d00001l00]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m0000050003
d000030000?@00000_l37`03d000030000?@00001@000m00000`0003d00003@0000I0003d00002d0
0]090003d00002d00]090003d00002d00]090003d00002d00]03o`:00al00`3@000^00;@2@000m00
000^0003d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00
000:0003d00002/000_@oon0`830P?n0o`020003d00002/000?@00002P000m00000/0003d00003H0
000K00;@:@02d0h00]0Y00;@3P03d2P00]0>00?@:002d003oh2000F000Co7alO0P03d2P00]0>00?@
:@02d3T0000M00;@9@02d1800]0V0003d000014000?@000090000m00000A0003d00002@000c@oh30
P<20`830ol037`D000?@000090000m00000A0003d00002@00]0k00007`000m00000Q0003d00001@0
00?@00008P000m00000C0003d000028000?@00004`000m00000P00;o00?@P80028000on07`027`03
o`0000<000?@00008P000m00000C0003d000028000?@0000>`0002000]0O00;@6002d2000]0G00;@
8002d1L00]0N00;o0]004L20`830P<20`83oP<20`83o00H00m0O00;@5`03d1l00]0n00008P03d1X0
0]0L00?@6P03d1/00m0J00?@6`03d1T000Cod=3@38000on0P003P003o`0000L00]0J00?@7002d1X0
0m1000009@02d1D00m0Q00;@5P02d2400]0F00;@8@03d1@001[od=20`830P<20`830P<20`83oP<20
`830o`X00m0E00;@8@03d1D00]1300003`037aD01M0;00G@9P05d0/01]0U00G@2`06d2H01=0;00K@
48000on0P002P0<O00?o00002`04d0/01]0V00G@2P06d4D0000?00<O6P0;d3002m0`00_@<00;d0;o
01V0`830P<20`830P<20`830P<20`?o0P<2000<O00>0o`003`0;d3402]1;00003`037m@00_lEP003
oh2000>00al00h3o002P0000h`03o`0SP<20`830P<20`830P<20`830P<20`83oP<20`830P<20`?l0
X0000>400_lJP003oh2000R000?o0000WP000=l00_l0:L20`830P<20`830P<20`830P<20`830P<20
`?o0P<20`830P<20`83o09l0003M00;o7H000on0P00:P003o`0009d0003J00?o02k0P<20`830P<20
`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<3oWP0000l00ao600;o8H000on0P004P0<O
1H000ol0002L00003`037l@00_l0:X30P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30
P<20`0<O00K0P<20`?nN00003`037l800_lTP003oh2000F00al6P003o`0009/0003A00?o03R0`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20oid0003?00;o
:8000on0P00@P003o`0009X0003=00;o03k0P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`83oP<20`830P<20`830P<20`830oi`0003;00;o;8000on0P00AP003o`0009T0003800?o
04?0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`83o09/0000B00<O/@02oc2000?oP80018037`b000?o0000V00001800an`00;o03S0P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P0<O00f0`830
P<20`830P<3o09X0000B00<O/0000on0o`02obf000?oP8001H037`f000?o0000U`000<H000Co`830
0ol0@l20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20
`830P<20`830P?l0V@000<H000?oP8001803obJ000?oP8005h000ol0002F0000a`002On0`830P<20
`002o`0oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830
P<20`830P<3o09P000370003oh2000R00olQP003oh2001N000?o0000UP000<P000go`830P<20`830
P<2000?o03Z0`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830
P<20`83oU`000<P000?oP8003H03oaZ000?oP8006H000ol0002E00005`037jh001?o`830P<20`830
P<20`830P<2000;o01g0P<20`830P<20`830P<20`830P<20`?o0P<20`0037`0F`830P<20`830P<20
`830P<20`830oiH0000G00<O[`000on0P00AP0?o58000on0P003P0<O5H000ol0002D00005`037jl0
01OoP<20`830P<20`830P<20`830P<20`003o`0G`830P<20`830P<20`830P<3o`830P<000al05l20
`830P<20`830P<20`830P<20`83o09D0003:0003oh2001J00ol=P003oh2001f000?o0000T`000<X0
01co`830P<20`830P<20`830P<20`830P<20`8300_l0;H30P<20`830P<20oh30P<20`830P<20`830
P<20`830P<20`830P<20`830o`2D0000b`000on0P00JP0?o1h000on0P00OP003o`000980003;000P
oh30P<20`830P<20`830P<20`830P<20`830P<20`803o`0XP<20`?o0P<20`830P<20`830P<20`830
P<20`830P<20`830P<20oi<0003<0003oh2001n00ol00h3oP00QP003o`000940000201co0aoBo`<O
T?lS00007P037j`000?oP8008803o`<O88000ol0002@00007P037j`002?oP<20`830P<20`830P<20
`830P<20`830P<20`830P<20`003o`<O0ol07/20`830P<20`830P<20`830P<20`830P<20`830oi80
003=0003oh20022000?oP8001X03oa^000?o0000S`000<h002ko`830P<20`830P<20`830P<20`830
P<20`830P<20`830ol20`830P<20`8300_l06X30P<20`830P<20`830P<20`830P<20`83oT@000<h0
00?oP8007X000on0P00<P0?o5h000ol0002>0000c`00<_n0`830P<20`830P<20`830P<20`830P<20
`830P<20oh30P<20`830P<20`830P<200ol05H30P<20`830P<20`830P<20`830o`2@00009P037jH0
00?oP8006H037`03oh2001>00olBP003o`0008d0000V00<OY`006oo0P<20`830P<20`830P<20`830
P<20`830P0037`0Iol20`830P<20`830P<20`830P<20`830P002o`0A`830P<20`830P<20`830P?l0
S`0002H00anW0003oh2001R00al00on0P00HP0?o3X000ol0002<0000d@00>on0`830P<20`830P<20
`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`83000?o00c0P<20`830P<20
`?n>0000d@000on0P00IP003oh2001n00ol8P003o`0008`0003B0010ol20`830P<20`830P<20`830
P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`0;o00R0`830P<20ohd0
003B0003oh2001N000?oP8009H03o`B000?o0000R`000=<004CoP<20`830P<20`830P<20`830P<20
`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P0?o00>0`?l0S0000=<0
00?oP8005H000on0P00/P0?oS00003000anP000>oh30P<20`830P<20`8037`0hP<20`830P?n0`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<02oh/0000`00<OX@000on0
P00:P0<O1X000on0P00]P0;oS@0003000anQ000=ol20`830P<20`830P0037`0cP<20`830ol20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<2000?oS`000=D000?oP8004X000on0
P00XP0;oTP000=D003koP<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P0;oU0000=H000?oP80048000on0P00UP0;oUP000=H003So`830P<20`830
P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`0?oV0000=L000?oP800
3X000on0P00QP0;oV`0003`00anF00<O03:0`830P<20`830P<20`830ol20`830P<20`830P<20`830
P<20`830P<20`830P<20`0;oW@0003`00anF00<O00?oP80038000on0P00NP0;oW`0003`00anF00<O
02go`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`8000onQ0000f0000on0
P00<P003oh2001V00_nT0000f@00:?n0`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20
`802ojH0003I0003oh2000Z000?oP8005H03ojP0003J000Rol20`830P<20`83oP<20`830P<20`830
P<20`830P<20`0;oZ`000=X000?oP80028000on0P00BP0;o[@0004X00amk00<O40007On0`830P<20
`83oP<20`830P<20`830P<20`83000;o[`0004X00amk00<O40000on0P006P003oh2000j00ona0000
BP037g/00alA000Gol20`830P<3o`830P<20`830P<20`8000_nd0000g0000on0P004P003oh2000^0
0_nf0000g@004_n0`830P?n0`830P<20`830P0;o^0000=d000?oP8000h000on0P006P0?o^P0005T0
0amL00<O8P003On0`830ol20`830P<000_nm0000F@037e`00alS0005oh20P?l01H02okl0001I00<O
G0037b<000So`83oP<20`0;o`@000=l000CoP?n00oo30000J@037c`00ald0004oh3oolH0001Y00<O
?0037cD000?o0000aP0006T00all00<OoP0007T00al=00<O30037ol03`0007T00al=00<O30037ol0
3`0007T00al=00<O30037ol03`000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l00anW000050000m00000g00;@>@02d3T00]0i00;@00<O0000=P02d3T00]0b0000
5@000m00000e0004d000d3L000C@003@=`001=000=0g0004d1lOd3L000C@003@=`000m00000b0000
5P02d3@000?@00000P02d3@000?@00000P02d3@000?@00000P02d3<000Kod820oal2d3@000?@0000
0P02d3@000?@0000<`0001P000?@0000<0000m0000050003d000030000?@00001@000m00000`0003
d00000D000?@0000;`001_o@`830o`<O00?@0000<0000m0000050003d000030000?@0000=00001T0
00?@0000;@02d0T000?@0000;@02d0T000?@0000;@02d0T000?@0000;@02d0>000?oP1l00Ql00`3@
000^00;@2@000m00000^0003d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X0
00?@0000:`000m00000:0003d00002X000cod830P<20oh30P?l20003d00002/000?@00002P000m00
000/0003d00003H0000K00;@:@02d0h00]0Y00;@3P03d2P00]0>00?@:002d0J000?oP8000al200?@
:002d0h00m0Y00;@>@0001d00]0U00;@4P02d2H000?@00004@000m00000T0003d000014000?@0000
8`003Oo@`830P<20`83oP<000al00ol000020003d00002@000?@00004@000m00000T00;@>`0001l0
00?@00008@000m00000D0003d000028000?@00004`000m00000R0003d00001<000?@00008@000oo@
P008P003oh2000<O00>0o`000`000m00000R0003d00001<000?@00008P000m00000k00008002d1l0
0]0H00;@8002d1L00]0P00;@5`02d1l001God=30P<20`830P<3o`830P<20`?l01@03d1l00]0G00?@
7`02d3h0000R00?@6P02d1`00m0J00?@6`03d1X00m0K00?@6P03d0^000?oP8001X000ol0000500;@
6P03d1`00]0J00?@@00002D00]0E00?@8@02d1H00]0Q00;@5P02d2400m0E00;@01Wo`830P<20`830
P<20`?o0P<20`830P<3o00P00m0E00;@8@03d1D00]1300003`037aD01M0;00G@9P05d0/01]0U00G@
2`06d2H01=0;00K@0_l>P003oh2000:00al2P003o`0000T01=0;00K@9P05d0X01]1500003`037aX0
2m0`00_@<00;d3002m05000Foh30P<20`830P<20`830P<3o`830P0<O00B0`83o3P0;d3402]1;0000
3`037mT00_lAP003oh2000:00al4P003o`0009`0003Z000Rol20`830P<20`830P<20`830P?n0`830
P<20`830P<20oid0003Y0003oh20016000?oP8002h000ol0002K0000i`02o`0T`830P<20`830P<20
`830P<20`83oP<20`830P<20`830P<3oW0000>H000?oP80058000on0P00=P003o`0009T0003T00;o
02V0`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830o`2J00003`037m4000?oP800
5h000on0P002P0<O2H000ol0002H00003`037ll00_l07l20`830P<20`830P<20`830P<20`830P<3o
`830P<000al02l20`830P<20`83o09T0000?00<OcP000on0P00IP003oh2000>00al;P003o`0009H0
003O000coh30P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`83o09L0
003M00;o7H000on0P00BP003o`0009D0003L000gol20`830P<20`830P<20`830P<20`830P<20`830
P<3o`830P<20`830P<20`830P<20`830o`2F0000fP02oan000?oP8005H000ol0002C0000f@00??n0
`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830oi@0
000B00<O`P02ob:000CoP8200alBP003o`000980000B00<O`@00:Oo0P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`83oP<2000<O01B0`830P<20`830P<20`830P<20oi<0000B00<O`0000on0
P00SP004oh20P0<O58000ol0002@0000d`02o`12`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<3oTP000=8000?oP8009H000on0P00JP003
o`0008l0003@00;o04N0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830
P<20`830P<20`830P<20`830P<20`830o`2@0000c`000on0P00XP003oh2001b000?o0000S@000<h0
04co`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830
P<20`830P<20`830P<20`83oS`000<`00_l/P003oh2001f000?o0000S00001L00ana000_oh30P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<000al07l20`830P<20`830P<20
`830P<20`830P<20`830P?l0S@0001L00an`00Co:h001?lO7alOP003o`0008X0000G00<O/0001?o0
P<07o`0U`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20o`037`0P`830P<20`830P<20
`830P<20`830P<20`830P<20`?n<0000b`000on0P007P0Ko7X000on0P00QP003o`0008T0003<000?
ol20`830P<20`830P<2000Oo03f0`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<3o08X0003=0003oh2001:01ol@P003oh2002>000?o0000Q`000<d0
01coP<20`830P<20`830P<20`830P<20`830P<201_l0<L20`830P<20`?o0P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P?l0R@000<h000?oP8007X07o`:000?oP8009H000ol000260000
0P0Lo`<Od_l37i3o8`0001h00an^0003oh2002600al0183oool2P0Ko7h000ol0002500007P037jl0
02?o`830P<20`830P<20`830P<20`830P<20`830P<20`830P0037`0<P?oooh30P<20`8301_l06h30
P<20`830P<20`830P<20`830P<20`830o`260000d@000on0P00TP003oh2000f01_lEP003o`0008<0
003B000lol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830
P<20`8301Ol04/20`830P<20`830P<20`830oh@0003B0003oh2002:000?oP8006H06o`^000?o0000
PP000=<004KoP<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20
`830P<20`830P<20`830P<201_l01l20`830P?l0P`0002H00an[0003oh2001B00al9P003oh2002F0
1_l00h3o002100009P037j/001Oo`830P<20`830P<20`830P<20`830P0037`0gP<20`830P<20oh30
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P003oh40000V00<O[0000on0
P00CP0<O2H000on0P00[P003o`000840003F001=ol20`830P<20`830P<20`830P<20`830P<20`830
P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8000_n40000e`000on0
P00LP003oh2002V000?o0000Q0000=L004WoP<20`830P<20`830P<20`830P<20`830P<20`830ol20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83000;oQ`000=P000?oP8006h000on0
P00VP003o`0008L0003I0016oh30P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830ohX0003I0003oh2001V000?oP8009802oh/0000`00<O
Y`001oo0P<20`8000al0>830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`83oS@0003000anX0003oh2000>00alAP003oh2002600_n>0000<0037jT000Go`830
P0037`0eP<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`?l0
T0000=`000?oP8005X000on0P00NP0;oT@000=d003WoP<20`830P<20`830P<20`830P<20`83oP<20
`830P<20`830P<20`830P<20`830P<20`830P?l0T`000=h000?oP8004h000on0P00LP0;oU0000=h0
03Go`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830o`2F0000
g`000on0P00BP003oh2001Z000?o0000U@0003`00anF00<O2000;oo0P<20`830P<20`830P<20`830
ol20`830P<20`830P<20`830P<20`830P<2000;oV00003`00anF00<O2@000on0P00@P003oh2001N0
00?o0000V00003`00anF00<O2@00:on0`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20
`830P<000_nK0000hP000on0P00>P003oh2001F000?o0000V`000><002KoP<20`830P<20`830P<20
oh30P<20`830P<20`830P<20`830P0;oWP000><000?oP8003H000on0P00BP003o`0009h0003T000R
ol20`830P<20`830P<20oh30P<20`830P<20`830P<20`0;oX@000>D000?oP8002h000on0P00?P003
o`000:40001:00<ON`037a/001oo`830P<20`830P<20oh30P<20`830P<20`830P<3o0:@0001:00<O
N`037a/000?oP8002H000on0P00=P0;oY@0004X00amk00<O70006on0`830P<20`830ol20`830P<20
`830P<20o`2W0000j0000on0P007P003oh2000Z00_nX0000j0005oo0P<20`830P<3o`830P<20`830
P<3o0:X0003Y0003oh2000J000?oP8001h02oj/0001I00<OG0037bl001;o`830P<20oh30P<20`830
P?n]0000F@037e`00al`0003oh2000>000?oP8001H02ojh0001I00<OG0037c0000koP<20`83oP<20
`830ok00003/0003oh2000:000?oP8000h000ol0002_0000J@037c`00am20008oh30P?n0`802ok80
001Y00<O?0037d8000GoP820o`02P003o`000;80001Y00<O?0037d<000Co`?o00_ne0000N@037`d0
0al<00<OE003okL0001i00<O3@037``00amE0003o`000;H0001i00<O3@037``00aoo00l0003o0:X0
003o0:X00000


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l00anW000050000m00000g00;@>@02d3T00]0i00;@00<O0000=P02d3T00]0b0000
5@000m00000e0004d000d3L000C@003@=`001=000=0g0005d1lOd?l0=P001=000=0g0003d0000380
000F00;@=0000m00000200;@=0000m00000200;@=0000m00000200;@=0001M20P?lO00;@=0000m00
000200;@=0000m00000c000060000m00000`0003d00000D000?@0000<0000m0000050003d0000300
00?@00001@000m00000`0005d<20`?l00al00m00000`0003d00000D000?@0000<0000m00000d0000
6@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@18001_lO7an0d2l0
0]090003d00002h000?@0000=@0001X000?@0000:`000m00000:0003d00002/000?@00002P000m00
000[0003d00000X000?@0000:`003]3o`830P<3o`830P<3@;@000m00000:0003d00002`000?@0000
=P0001/00]0Y00;@3P02d2T00]0>00?@:002d0h00m0X00;@00?oP80018000on07`027`:00m0X00;@
3P03d2T00]0i00007@02d2D00]0B00;@9P000m00000A0003d00002@000?@00004@000m00000T000<
d03o`830P<20`?o00al01/20`?l0d2H000?@00004@000m00000T00;@>`0001l000?@00008@000m00
000D0003d000028000?@00004`000m00000R0003d00001<000?@00008P000m00o`08P003oh0O008O
18000ol0d00T0003d00001<000?@00008P000m00000k00008002d1l00]0H00;@8002d1L00]0P00;@
5`02d2000]005`3o`830P<20`830ol20`830P<20`?l000?@7`02d1L00m0O00;@?P0002800m0J00;@
7003d1X00m0K00?@6P03d1/00m0J00?@0P000on0P008P003oh2000R000Co00000]0J00?@7002d1X0
0m1000009@02d1D00m0Q00;@5P02d2400]0F00;@8@03d1D00]04000Iol20`830P<20`830ol20`830
P<20`830o`0400?@5@02d2400m0E00;@@`0000l00alE00G@2`05d2H01M0;00K@9@05d0/01]0V00C@
2`06d0D000?oP8002X000on0P0037`N000?o00001004d0/01]0V00G@2P06d4D0000?00<O6P0;d300
2m0`00_@<00;d0X0017o`830P<20`830P<20`?o0P0037`09P<20`830P<3o00T02m0a00[@B`0000l0
0aoO0003oh2000b000?oP8000al9P003o`0009L0003_00;o0230P<20`830P<20`830P<3o`830P<20
`830P<20`830oiP0003^0003oh2000n000?oP8003X000ol0002E0000k@009_n0`830P<20`830P<20
`830P<3o`830P<20`830P<20`830P<3oUP000>`000?oP8004H000on0P00@P003o`0009<0003[000Z
oh30P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<3oU00000l00aoH0003oh2001>0
00?oP1l00Ql@P003o`000940000?00<Oe`006On0`830P<20`830P<20`830P<20`830ol000al04/20
`830P<20`830P<20`830oi80000?00<OeP000on0P00EP003oh0O008O4X02oi00003W000coh30P<20
`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`83o08l0003V0003oh2001N0
00?oP8005h000ol0002<0000i@00=on0`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20
`830P<20`830P<20`830P?l0S@000>@000?oP8006H000on0P00IP003o`0008X0003S000koh30P<20
`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P?l0R`000180
0ao=0003oh2001Z00alLP003o`0008P0000B00<Oc0007_n0`830P<20`830P<20`830P<20`830P<20
`830P0<O01j0`830P<20`830P<20`830P<20`830P<20`830P?n900004P037lX00_lNP0<O7X000ol0
00260000gP00A?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830
P<20`830P<20`830P<20`83oQ`000=d000?oP80088000on0P00OP003o`0008@0003L0018ol20`830
P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830
P<20`83oQ@000=/000?oP8008X000on0P00QP003o`000880003J001<ol20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh<0
003I0003oh2002B000?oP8008h000ol0002000005`037kh002;o`830P<20`830P<20`830P<20`830
P<20`830P<20`8300al0:l20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?l0
P@0001L00anm0003oh2002200al3P003oh2002F000?o0000OP0001L00anl000Tol20`830P<20`830
P<20`830P<20`830P<20`830P<20`8300al0;L20`?o0P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20o`1o0000e@000on0P00XP003oh2002N000?o0000O0000=@005So`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`83oO@000=<000?oP800:X000on0P00YP003o`0007X0003B001Lol20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P?mk0000d@000on0P00/P003oh2002^000?o0000N0000080
7?l37m;o0an@ob<0000N00<O/@000on0P00NP0<O2H03ob^000?o0000N@0001h00anb000Poh30P<20
`830P<20`830P<20`830P<20`830P<20`8037`09P<20`830P<2000?o02^0`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<3o07`0003D0003oh2002V000?oP800:8000ol0001k0000
e@00E_n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<3oOP000=H000?oP8009h000on0P00VP003o`0007d0
003G001Boh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830oh00000V00<O[`000on0P00@P0<O4X000on0P00TP003
o`0007l0000V00<O/0004_n0`830P<20`830P<20`830P0<O03V0`830P<20`830P<20`830P<3o`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?l0PP0002H00ana0003oh2000j00alBP003
oh2002:000?o0000P@000=/004[oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20
`830P<20`830P<20`830P<20`830P<20`830P<20`830oh@0003L0003oh20026000?oP80088000ol0
00230000g@00A_n0`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20
`830P<20`830P<20`830P<20`?n60000gP000on0P00OP003oh2001j000?o0000Q@000=l004;oP<20
`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20
`?n80000h0000on0P00MP003oh2001b000?o0000Q`0003000an^00<O03^0`830P<20`830P<20`830
P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830o`2:0000<0037jh00alLP003
oh2001Z000?o0000R@0003000an^00<O03V0`830P<20`830P<20`830P<20`830P<20`830ol20`830
P<20`830P<20`830P<20`830P<20`?l0S0000>@000?oP8006H000on0P00HP003o`0008/0003U000f
oh30P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<3oSP000>H0
00?oP8005h000on0P00FP003o`0008d0003W000boh30P<20`830P<20`830P<20`830P<20`?o0P<20
`830P<20`830P<20`830P<20`?n@0000j002oaJ000?oP80058000ol0002?0000?0037iH00alB000]
ol20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<3o0980000l00<OUP037a<0
00?oP8004X000on0P00BP003o`000940000l00<OUP037a@002Wo`830P<20`830P<20`830P<20`?o0
P<20`830P<20`830P<20`830o`2D0000k@000on0P00@P003oh20012000?o0000T`000>h002Go`830
P<20`830P<20`830P<3o`830P<20`830P<20`830P<3o09H0003_0003oh2000j000?oP8003X000ol0
002E0000l0008Oo0P<20`830P<20`830P<3o`830P<20`830P<20`830o`2H0000l@000on0P00<P003
oh2000b000?o0000U`0004X00amk00<O9`007Oo0P<20`830P<20`830ol20`830P<20`830P<3o09X0
001:00<ON`037bP000?oP8002X000on0P00:P003o`0009T0001:00<ON`037bT001Wo`830P<20`830
P<3o`830P<20`830P<3o09`0003e0003oh2000R000?oP80028000ol0002K0000mP005Oo0P<20`830
P<3o`830P<20`830o`2N0000m`000on0P006P003oh2000J000?o0000W@0005T00amL00<O?@004Oo0
P<20`830ol20`830P<3o0:00001I00<OG0037ch000?oP80018000on0P004P003o`0009l0001I00<O
G0037cl000go`830P<3o`830P<3o0:80003k0003oh2000:000?oP8000X000ol0002Q0000J@037c`0
0amA0009ol20`?o0P<3o0:@0001Y00<O?0037e8000CoP83o0X000ol0002S0000J@037c`00amC0005
ol3o`?l0YP0007T00al=00<O30037f@00onW0000N@037`d00al<00<OI@000ol0002V0000N@037`d0
0al<00<Oo`0?0000o`2Z0000o`2Z0000


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d000d3L000?@0000<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d?ooP1l00]0d0003d0000080
0]0d0003d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00
00050003d000030000G@oh3oP0037`03d000030000?@00001@000m00000`0003d00003@0000I0003
d00002d00]090003d00002d00]090003d00002d00]090003d00002d00]001On0P83o00<O00>0d?l0
;P02d0T000?@0000;P000m00000e00006P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[000?d000ol20`?o0P<20`=3o02`000?@00002P000m00000/0003
d00003H0000K00;@:@02d0h00]0Y00;@3P03d2P00]0>00?@:002d08000?oP8000X000on07`027`:0
0m0X00;@3P03d2T00]0i00007@02d2D00]0B00;@9P000m00000A0003d00002@000?@00004@000m00
000T000<d0000?o0P<20`?o00al01/20`83od2H000?@00004@000m00000T00;@>`0001l000?@0000
8@000m00000D0003d000028000?@00004`000m00000R0003d00001<000?@00008P001M00003o00J0
00?oP1l00Ql6P003d000028000?@00004`000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@
5`02d2000]0G00;@8002d0@001?oP<20`830P?n0`830P<20`83000?@7`02d1L00m0O00;@?P000280
0m0J00;@7003d1X00m0K00?@6P03d1/00m0J00?@1@000on0P006P003oh2000Z000?od=006P03d1`0
0]0J00?@@00002D00]0E00?@8@02d1H00]0Q00;@5P02d2400m0E00;@1`006?n0`830P<20`83oP<20
`830P<20`830P0;o0m0E00;@8@03d1D00]1300003`037aD01M0;00G@9P05d0/01]0U00G@2`06d2H0
1=0;00K@2@000on0P007P003oh0O008O2h000ol00004d0/01]0V00G@2P06d4D0000?00<O6P0;d300
2m0`00_@<00;d0h000go`830P<20`830P?n000<O00b0`830P<20`830P<02o`@02m0a00[@B`0000l0
0aoS0003oh2000V000?oP1l00Ql>P003o`000980003d000Rol20`830P<20`830P<3o`830P<20`830
P<20`830P<20oi<0003d0003oh2000^000?oP8004H02oi40003c000Voh30P<20`830P<20`830ol20
`830P<20`830P<20`830P<20`?n@0000lP000on0P00=P003oh2001B00_n>0000l@00:on0`830P<20
`830P<20`830ol20`830P<20`830P<20`830P<20`830P?l0S@0000l00aoO0003oh2000j00alGP0;o
R`0000l00aoN000Bol20`830P<20`830P<20`8300al06/20`830P<20`830P<20`830P<20`830P<3o
RP0000l00aoM0003oh2001200alJP0;oR0000>h003Co`830P<20`830P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P<20`83oQ`000>h000?oP8004X000on0P00LP003o`0008@0003]000f
oh30P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<200_n40000
k0000on0P00EP003oh2001j000?o0000P@000>/003_oP<20`830P<20`830P<20`830P<20`830ol20
`830P<20`830P<20`830P<20`830P<20`830P<20`002oh40000B00<OeP000on0P00AP0<O0X000on0
P00QP003o`0007h0000B00<Oe@005Oo0P<20`830P<20`830P<20`830P0037`0WP<3o`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<2000;oOP0001800aoD0003oh2001>00al2P003oh2002B0
00?o0000N`000>T004?oP<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`83000;oN`000>P000?oP8006X000on0P00VP003o`0007P0003W0019
oh30P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20o`1i0000iP000on0P00LP003oh2002R00_mg0000iP00COo0P<20`830P<20`830
P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<3o07H0003U0003oh2001f000?oP800:h02og@0000G00<ObP005_o0P<20`830P<20`830P<20`830
P<037`0i`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`83o07<0000G00<Ob@000on0P00DP0<O2H000on0P00ZP0CoLP0001L00ao9000Goh30P<20`830P<20
`830P<20`830P<000al0;l20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`83000Oo00C0P<3oLP000>8000?oP8008H000on0P00LP0Oo2H000ol0001a0000h@00?On0`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<001ol04<20
`830P<20`830P<20`?md0000h0000on0P00SP003oh2000n01_lEP003o`0007<0003P000aol20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P007o`0LP<20`830P<20`830
P<20`830P<20`830P<20ogD0003O0003oh2002F000?oP8001olQP003o`0007@0000201co0aoBo`<O
T?lS00007P037kd000?oP8004X037`R01_l2P0?o9h000ol0001f00007P037k`001KoP<20`830P<20
`830P<20`830P<200al00h30o`05o`08P<20`830P<03o`0X`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830ogP0003L0003oh2001>01_l?P003oh2002F000?o0000M`000=/001;oP<20
`830P<20`830P<20`805o`0mP<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830o`1j0000f`000on0P009P0Ko6h000on0P00SP003o`0007P0003J0007
ol20`830P006o`17`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P?l0N`0002H00an`0003oh3o00Go2X037aZ000?oP8008H000ol0
001j00009P037jl00ol04<20`830P<20`830P<20`8037`0nP<20`830P<20`830P<20`830P<20`830
P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P?mm00009P037k4000?oP8003X037aZ0
00?oP80088000ol0001k0000f`02o`1>`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<3oOP000=d000?oP800:H000on0
P00MP003o`0007d0003N00;o04V0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P?n0`830P<20`830P<20`830P<20`830P<20`830P<3o0800003P0003oh2002J000?oP80078000ol0
001n0000h@00Aon0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20
`830P<20`830P<20`830P<20`83o0840003R00;o9X000on0P00IP003o`000800000`00<O[P037`12
ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830
P<20`83oP`0003000an^00<O00<0ool08h000on0P00HP003o`000840000`00<O[P037`<003koP<20
`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830oh@0
003X00;o88000on0P00FP003o`0008<0003Z000iol20`830P<20`830P<20`830P<20`830P<20`830
P<3o`830P<20`830P<20`830P<20`830P<3o08H0003[00;o7X000on0P00DP003o`0008@0003]000e
oh30P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P?l0Q`000>h0
00?oP8006X000on0P00BP003o`0008H0000l00<OUP037aL00_l0<<20`830P<20`830P<20`830P<20
`830P<20oh30P<20`830P<20`830P<20`830ohP0000l00<OUP037aT000?oP8005h000on0P00AP003
o`0008L0000l00<OUP037aX00_l0:h30P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830
P<20`?l0RP000?@000?oP8005H000on0P00>P003o`0008T0003e00;o02O0P<20`830P<20`830P<20
`830P<3o`830P<20`830P<20`830P?l0R`000?L000?oP8004X000on0P00=P003o`0008X0003h00;o
02:0`830P<20`830P<20`830P<3o`830P<20`830P<20`83oS@000?X000?oP8003h000on0P00;P003
o`0008`0001:00<ON`037c00023oP<20`830P<20`830P<20`?o0P<20`830P<20`830ohh0001:00<O
N`037c400_l?P003oh2000V000?o0000S@0004X00amk00<O<`006oo0P<20`830P<20`830P?n0`830
P<20`830o`2@0000o`02o`b000?oP8001h000ol0002?0000o`02000Goh30P<20`830P<20oh30P<20
`830P?l0T@000?l00`02o`V000?oP8001X000ol0002@0000F@037e`00am9000Bol20`830P<20`?o0
P<20`83oT`0005T00amL00<OBP02o`N000?oP80018000ol0002A0000F@037e`00am<000>oh30P<20
`?o0P<20`?nD0000o`090003oh2000>000?oP8000X000ol0002C0000J@037c`00amN00;o00S0P<3o
`830oiH0001Y00<O?0037f0000CoP83o0h000ol0002D0000J@037c`00amQ00;o00B0oh3oU`0007T0
0al=00<O30037g<00onH0000N@037`d00al<00<OM0000ol0002G0000N@037`d00al<00<Oo`0?0000
o`2Z0000o`2Z0000


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d000d3L000?@0000<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d1lO01l00]0d0003d0000080
0]0d0003d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00
00050003d000030000G@7alOo`037`03d000030000?@00001@000m00000`0003d00003@0000I0003
d00002d00]090003d00002d00]090003d00002d00]090003d00002d00]001@0O7an000<O00?od000
;P02d0T000?@0000;P000m00000e00006P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[000>d0000?n0oh30P<20om0]0003d00000X000?@0000;0000m00
000f00006`02d2T00]0>00;@:@02d0h00m0X00;@3P03d2P00]030004oh20o`:00al2P0?@:002d0h0
0m0Y00;@>@0001d00]0U00;@4P02d2H000?@00004@000m00000T0003d000014000?@000090000m00
00030006ol20`?o00al01/20`83od2H000?@00004@000m00000T00;@>`0001l000?@00008@000m00
000D0003d000028000?@00004`000m00000R0003d00001<000?@00008P000m0000030003oh2000:0
00?oP1l00Ql6P003d?oo028000?@00004`000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@
5`02d2000]0G00;@8002d0H0017oP<20`83oP<20`830P<20`003d003o`0001`00]0G00?@7`02d3h0
000R00?@6P02d1`00m0J00?@6`03d1X00m0K00?@6P03d0L000?oP80018000on0P00;P0;@00?o0000
5`03d1`00]0J00?@@00002D00]0E00?@8@02d1H00]0Q00;@5P02d2400m0E00;@2P005oo0P<20`83o
P<20`830P<20`830P<2000?@5@02d2400m0E00;@@`0000l00alE00G@2`05d2H01M0;00K@9@05d0/0
1]0V00C@2`06d0/000?oP8001X001?lO7al>P0C@2`06d2H01M0:00K@A@0000l00alJ00_@<00;d300
2m0`00_@4@002_n0`830P<20`?l37`0BP<20`830P<20`830P<20`83o2m0a00[@B`0000l00aoW0003
oh2000N00alCP0;oSP000?P002?o`830P<20`830P?n0`830P<20`830P<20`830P<20`830P003oh/0
003h0003oh2000R000?oP8006802ohT0003g000Yoh30P<20`830P<20`?o0P<20`830P<20`830P<20
`830P<20`830P<000_n70000m`000on0P00:P003oh2001^00_n50000mP00;_o0P<20`830P<20`830
P?n0`830P<20`830P<20`830P<20`830P<20`830P<03oh80000?00<Oi0000on0P009P0<O00?oP800
7h02oh00000?00<Oh`003On0`830P<20`830P<000al09?n0`830P<20`830P<20`830P<20`830P<20
`830P<20`830P0;oOP0000l00aoS0003oh2000Z00al00h3oP00SP0;oO0000?@003Wo`830P<20`830
P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8000omi0000m0000on0
P00@P003oh2002J00_mg0000l`00?on0`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`002ogD0003c0003oh20016000?oP800:X02og<0003b0014
ol20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<03og00000B00<Og@000on0P00:P0<O1X000on0P00^P0;oKP0001800aoL000>oh30P<20
`830P<20`8037`0hP<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<02ofd0000B00<Og0000on0P00;P0<O1h000on0P00[P0?o00>0o`00K0000?0004Co`830
P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`0?o00C0P<3oKP000?0000?oP8005h000on0P00TP0?o1X000ol0001/0000l000?oo0P<20`830
P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P002o`09
`830P<20`83o06l0003_0003oh2001R000?oP8007h03o`Z000?o0000K@000>l003[oP<20`830P<20
`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<200ol03H30P<20`830
P<20`?l0L0000>h000?oP8006X000on0P00HP0?o3h000ol0001^00005`037m@000co`830P<20`830
P<037`0W`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`83000;o01:0`830P<20`830
P<20`830P?ma00005`037m<000?oP8002X037`n000?oP8004X03oa>000?o0000K`0001L00aoC000=
oh30P<20`830P<20`0037`0Q`830P<20`830P<20`830ol20`830P<20`830P<20`83000?o01K0P<20
`830P<20`830P<20`830P<3oLP000>`000?oP8007X000on0P00;P0?o68000ol0001`0000k000;Oo0
P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P002o`0L`830P<20`830P<20
`830P<20`830P<20`830og80003[0003oh20022000?oP8001H03oab000?o0000L@000>/002SoP<20
`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<200ol08830P<20`830P<20`830P<20`830
P<20`830P<20`83oL`000>X000?oP8008H000on0o`02ob6000?o0000LP0000807?l37m;o0an@ob<0
000N00<Ob0000on0P007P0<O5H05ob>000?o0000L`0001h00ao8000:oh30P<20`830P0<O01:0`830
P<20`830P<20`830P<03o`03`83o00?o02?0P<20`830P<20`830P<20`830P<20`830P<20`830P<20
o`1e0000j0000on0P00JP0?o28000on0P00OP003o`0007@0003X000Jol20`830P<20`830P<20`830
P<20`830P<03o`0^`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830ogH0
003W0003oh2001J00_l?P003oh2001f000?o0000M@000>L001KoP<20`830P<20`830P<20`830P<20
0ol0<X30P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`83oM`0002H0
0ann0004oh20P0<O3803oaB000?oP80078000ol0001f00009P037kd000Go`830P0037`09P<20`830
P<2000?o03N0`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830
P<3o07P0000V00<O_@000on0P002P0<O1X03oa^000?oP8006X000ol0001g0000i@003?n0`830P<20
`830P0?o03b0`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830
P<20`830P?mi0000i@000on0P007P0;o8X000on0P00HP003o`0007P0003T0008ol20`830P<03o`10
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20
`830ogX0003T0003oh2000:00olXP003oh2001J000?o0000N@000><000?oP<000ol0AL20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20
o`1k0000h`03obj000?oP8005X000ol0001i0000<0037jh00al0BH30P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`?l0O0000300
0an^00<O0_l_P003oh2001B000?o0000NP0003000an^00<O0P03o`13`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20o`1m0000j@02ob^0
00?oP8004X000ol0001k0000j`02o`0n`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<3o`830P<20`830P<20`830P<20`?mn0000k@02obR000?oP80048000ol0001l0000k`03o`0h
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P?mo0000
lP02ob>000?oP8003h000ol0001m0000?0037iH00alL00;o03>0`830P<20`830P<20`830P<20`830
P<20`830P<20`830ol20`830P<20`830P<20`?l0P00003`00anF00<O7P02ob2000?oP8003H000ol0
001n0000?0037iH00alP00?o02g0P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20
`830P?l0P@000?/00_lLP003oh2000^000?o0000O`000?d00_l0:<20`830P<20`830P<20`830P<20
`830P<20oh30P<20`830P<20`?n20000o`03oaR000?oP8002H000ol000200000o`0300;o02:0`830
P<20`830P<20`830P<20`830ol20`830P<20`83oP`000?l01@02oaB000?oP80028000ol000210000
BP037g/00alk00;o01f0`830P<20`830P<20`830P<20oh30P<20`830o`240000BP037g/00alm00?o
48000on0P006P003o`000880001:00<ON`037d000_l06<20`830P<20`830P<20oh30P<20`830oh@0
003o00h00_l=P003oh2000B000?o0000P`000?l04002o`0C`830P<20`830P<3o`830P<20o`250000
o`0B00?o2H000on0P002P003o`0008@0001I00<OG0037eT00_l03H30P<20`83oP<20`?l0QP0005T0
0amL00<OF`02o`F000GoP820o`270000F@037e`00amM00;o00R0`830ol20ohL0003o01/00ol0183o
P?n80000J@037c`00amb00;o00?0o`00Q`0006T00all00<OM0000ol000270000J@037c`00aon0000
N@037`d00al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000o`2Z0000
o`2Z0000


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d000d3L000?@0000<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d1lO01l00]0d0003d0000080
0]0d0003d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00
00050003d000030000G@7alO00037`03d000030000?@00001@000m00000`0003d00003@0000I0003
d00002d00]090003d00002d00]090003d00002d00]090003d00002d00]001@0O7al000<O00<0d000
;P02d0T000?@0000;P000m00000e00006P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002`000?@0000
=P0001/00]0Y00;@3P02d2T00]0>00?@:002d0h00m0X00;@0P037`@00al200?@:002d0h00m0Y00;@
>@0001d00]0U00;@4P02d2H000?@00004@000m00000T0003d000014000?@000090000m00000200<O
00Co00000al50003d00002@000?@00004@000m00000T00;@>`0001l000?@00008@000m00000D0003
d000028000?@00004`000m00000R0003d00001<000?@00008P000m00000300<O00B0oooo0al60003
d000028000?@00004`000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@5`02d2000]0G00;@
8002d0L00_l01X30P<20`0Go0`03d1l00]0G00?@7`02d3h0000R00?@6P02d1`00m0J00?@6`03d1X0
0m0K00?@6P03d0P000CoP83o2X05o`030=3@01X00m0L00;@6P03d400000U00;@5@03d2400]0F00;@
8@02d1H00]0Q00?@5@02d0/001?oP<3o`830P<20`830P<20`83000?o0m0E00;@8@03d1D00]130000
3`037aD01M0;00G@9P05d0/01]0U00G@2`06d2H01=0;00K@3@001On0P83o00>00al<P0;o1=0;00K@
9P05d0X01]1500003`037aX02m0`00_@<00;d3002m0C0008oh30P<3o`8037`0BP<20`830P<20`830
P<20`83o2m0a00[@B`0000l00aoY0003oh2000:000?oP8000alFP0CoR@000?X002Ko`830P<20oh30
P<20`830P<20`830P<20`830P<20`830P<20`0GoQ0000?X000?oP8001H000on0P00PP0GoO`000?X0
033o`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<05ogX0003j0003
oh2000J000?oP800:H04ogH0003i000joh30P<20`830P<3o`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P0GoL@0000l00aoW0003oh2000J00al00on0P00`P0GoK00000l0
0aoW0009oh30P<20`83000<O03SoP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P0;oJP0000l00aoW0003oh2000J00al00h3oP00cP0;o00>0o`00J@000?T0
04KoP<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`?o0P<3oJP000?P000?oP80038000on0P00^P0;o0h000ol0001Y0000n000?_o0P<20`830
P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8300_l01X30
P<20of/0003h0003oh2000j000?oP800:H000on0P005P003o`0006T0003h000kol20`830P<20`830
P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8000_l02L20`830P<20
o`1[00004P037n8000?oP8001H037`R000?oP8009802o`V000?o0000JP0001800aoR0008oh30P<20
`8037`0kP<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P<20`?l0K00001800aoR0003oh2000F00al9P003oh2002200_l<P003o`0006X0003g000eoh30P<20
`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<000_l03h30P<20`830
P<20`830o`1/0000m`000on0P00CP003oh2001^000?oP8003H000ol0001[0000mP00<oo0P<20`830
P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P002o`0A`830P<20`830P<20
`830P?l0K@000?H000?oP8005H000on0P00FP0;o4X000ol0001[0000mP00A_o0P<20`830P<20`830
P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P?m]0000
mP000on0P00GP003oh2001600_lEP003o`0006/0000G00<Of`001On0`83000<O02G0P<20`830P<20
`830P<20`830ol20`830P<20`830P<20`83000;o01N0`830P<20`830P<20`830P<20`830o`1^0000
5`037m/000?oP8000X037aB000?oP8003H000on0P00FP003o`0006`0000G00<Of`001On0`83000<O
02;0P<20`830P<20`830P<20`830P<3o`830P<20`830P<200_l06/20`830P<20`830P<20`830P<20
`830P<3oKP000?D000?oP8006X000on0P008P0;o6h000ol0001/0000m@00AOn0`830P<20`830P<20
`830P<20`830P<20`830P?n0`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20o`1_0000
m0000on0P00MP003oh2000>00_lMP003o`0006d0003d000Tol20`830P<20`830P<20`830P<20`830
P<20`830P<3o`8300_l08830P<20`830P<20`830P<20`830P<20`830P<20`83oK`000?@000?oP800
7X000on0o`0QP003o`0006d0000201co0aoBo`<OT?lS00007P037m800alNP0Co88000ol0001^0000
7P037m800al07830P<20`830P<20`830P<20`830P<20`830P<02o`0UP?oooh30P<20`830P<20`830
P<20`830P<20`830P<20`830o`1`0000l`000on0P00JP0;o1X000on0P00MP003o`0006h0003c0015
oh30P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`?o0P<20`830P<20`830P<20`830P<20
`830P<20`83o0740003c0003oh2001N00_l:P003oh2001^000?o0000K`000?8004Ko`830P<20`830
P<20`830P<20`830P<20`?o0P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`83o
L@0002H00ao200<O10000on0P00EP0;o3X000on0P00JP003o`0006l0000V00<O`P037`@001Ko`830
P<20`830P<20`830P<20`8300_l0;H30P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830
P<20`830o`1b00009P037l800al40003oh2001:000?oP8004H000on0P00HP003o`000700003a000D
oh30P<20`830P<20`830P<20`802o`0``830P<20`830P<20`830P<20`830ol20`830P<20`830P<20
`830P<20`830P<3oLP000?4000?oP80048000on0P00FP003oh2001J000?o0000L0000?40017oP<20
`830P<20`830P<20`002o`0cP<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830
P<20`830P<3o0780003a0003oh2000b00_lLP003oh2001B000?o0000L@000?4004GoP<20`830P<20
`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P?l0
L`000?0000?oP8002X02ob2000?oP8004h000ol0001a0000<0037jh00al<0016ol20`830P<20`830
ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20og<0
000`00<O[P037``000?oP8001h02obF000?oP80048000ol0001b0000<0037jh00al<0008ol20`830
P<02o`0kP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830
P<20`?l0M0000>l000?oP8001H000on0P00XP003oh2000n000?o0000LP000>l000KoP<20`802o`0n
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20
`?md0000k`000on0P002P003oh2002b000?oP8003H000ol0001c0000k`000on0`002o`10P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20ogD0
003_00?o<X000on0P00<P003o`0007<0000l00<OUP037aH00_l0A830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`83oM@0003`00anF00<O
5P03ocF000?oP8002H000ol0001d0000?0037iH00alI00Go03f0`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<3o07H0003f00Go;8000on0P008P003
o`0007@0003k00Co03C0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20
`830P<3oMP000?l01OlTP003oh2000J000?o0000M@000?l01@05o`0Y`830P<20`830P<20`830P<20
`830P<20`830P<20`83oP<20`830P?l0M`000?l02P04oaf000?oP80018000ol0001e0000BP037g/0
0am200Go0220`830P<20`830P<20`830P<20`830P<3o`830P<20ogL0001:00<ON`037dL01?lEP003
oh2000>000?o0000M@0004X00amk00<OB`05o`0F`830P<20`830P<20`830P?n0`830ogP0003o01`0
1Ol<P005oh20P?l0N0000?l08@04o`0=P<20`830P<20oh30o`1h0000o`0U00Go18001?n0P?mh0000
F@037e`00am^00OoN@0005T00amL00<OL`02ogT0001I00<OG0037nh0003o0:X0001Y00<O?0037oh0
001Y00<O?0037oh0001Y00<O?0037oh0001i00<O3@037``00aoo00l0001i00<O3@037``00aoo00l0
001i00<O3@037``00aoo00l0003o0:X0003o0:X00000


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d000d3L000?@0000<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d1lO01l00]0d0003d0000080
0]0d0003d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00
00050003d000030000G@7alO00037`03d000030000?@00001@000m00000`0003d00003@0000I0003
d00002d00]090003d00002d00]090003d00002d00]090003d00002d00]001@0O7al000<O00<0d000
;P02d0T000?@0000;P000m00000e00006P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002`000?@0000
=P0001/00]0Y00;@3P02d2T00]0>00?@:002d0h00m0X00;@0P037`@00al200?@:002d0h00m0Y00;@
>@0001d00]0U00;@4P02d2H000?@00004@000m00000T0003d000014000?@000090000m00000200<O
10037`D000?@000090000m00000A0003d00002@00]0k00007`000m00000Q0003d00001@000?@0000
8P000m00000C0003d000028000?@00004`000m00000R0003d00000<00al400<O1P000m00000R0003
d00001<000?@00008P000m00000k00008002d1l00]0H00;@8002d1L00]0P00;@5`02d2000]0G00?@
7`02d1L00m0O00;@?P0002800m0J00;@7003d1X00m0K00?@6P03d1/00m0J00?@7002d1X00m0L00;@
6P03d400000U00;@5@03d2400]0F00;@8@02d1H00]0Q00?@5@02d2400m0E00;@8@03d1D00]130000
3`037aD01M0;00G@9P05d0/01]0U00G@2`06d2H01=0;00K@3@037`D00al>00C@2`06d2H01M0:00K@
A@0000l00alJ00_@<00;d3002m0`00_@4`037`Go0alBo`_@7OlD00[@B`0000l00aoY00<O00?oP800
0X037cN000?oP?l0J@000?`004Co`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830ol20ofT0003l0005oh20P?l0>X001On0P83o06T0003l0014
ol20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<3o`830P?mY0000o0000on0P003P003oh2003B000?oP8000h000ol0001W0000o000A?o0P<20`83o
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`83o
J@0000l00aoZ0003oh2000>00albP003oh2000F000?o0000I`0000l00aoZ0006ol20`8300al0>on0
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`83o06T0
000?00<OjP000on0P003P0<O00>0oh00;H000on0P007P003o`0006L0003l0014ol20`830P<20`83o
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P?mY0000
o0000on0P009P003oh2002R000?oP8002H000ol0001W0000o000A?o0P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`83oJ@000?`000?oP800
2h000on0P00TP003oh2000^000?o0000I`000?`004Co`830P<20`830P<20`83oP<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20ofT0000B00<Oi`000on0P0037`Z0
00?oP80088000on0P00=P003o`0006L0000B00<Oi`000oo0P0037`0[P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P<20`830P002o`0A`830P<20`830P<20`830P?l0J@0001800aoW0003
oh2000<O38000on0P00KP003oh20012000?o0000I`000?`004Co`830P<20`830P<20`830P<20oh30
P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20ofT0003l0003oh200160
00?oP8005h000on0P00BP003o`0006L0003l0014ol20`830P<20`830P<20`830P<20oh30P<20`830
P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P?mY0000o0000on0P00CP003oh2001>0
00?oP80058000ol0001W0000o000A?o0P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830
P<20`83oP<20`830P<20`830P<20`830P<20`83oJ@000?`000?oP8005H000on0P00?P003oh2001J0
00?o0000I`0001L00aoP00<O04?0P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20
oh30P<20`830P<20`830P<20`830P<20`83o06T0000G00<Oh0037aV000?oP8002h000on0P00HP003
o`0006L0000G00<Oh0037`13`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`83oP<20
`830P<20`830P<20`830P<20`830P<20o`1Y0000o0000on0P00IP003oh2000N000?oP8006X000ol0
001W0000o000A?o0P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`83oP<20`830P<20`830
P<20`830P<20`830P<20`83oJ@000?`000?oP8006h000on0P003P003oh2001b000?o0000I`000?`0
04Co`830P<20`830P<20`830P<20`830P<20`830P<20oh30P?n0`830P<20`830P<20`830P<20`830
P<20`830P<20ofT0003l0003oh2001f000?oP?l088000ol0001W00000P0Lo`<Od_l37i3o8`0001h0
0aoB00<O1P000on0P00MP0Co7h000ol0001W00007P037m800al6000Ool20`830P<20`830P<20`830
P<20`830P<20`830P004o`0Q`?o0P<20`830P<20`830P<20`830P<20`830P<20`83o06T0003l0003
oh2001^000?oP80018000on0P00KP003o`0006L0003l0014ol20`830P<20`830P<20`830P<20`830
P<20`83oP<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P?mY0000o0000on0P00IP003
oh2000R000?oP8006H000ol0001W0000o000A?o0P<20`830P<20`830P<20`830P<20`830P?n0`830
P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`83oJ@0002H00ao200<O3P000on0P00GP003
oh2000b000?oP8005h000ol0001W00009P037l800al>0014ol20`830P<20`830P<20`830P<20`830
P?n0`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P?mY00009P037l800al>0003
oh2001F000?oP80048000on0P00EP003o`0006L0003l0014ol20`830P<20`830P<20`830P<20`83o
P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P?mY0000o0000on0P00CP003
oh2001B000?oP8004h000ol0001W0000o000A?o0P<20`830P<20`830P<20`830P?n0`830P<20`830
P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`83oJ@000?`000?oP8004H000on0P00HP003
oh20016000?o0000I`000?`004Co`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830
P<20`830P<3o`830P<20`830P<20`830P<20ofT0003l0003oh2000n000?oP80078000on0P00?P003
o`0006L0000`00<O[P037aP004Co`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830
P<20`830P<20`?o0P<20`830P<20`830P<20ofT0000`00<O[P037aP000?oP8003H000on0P00PP003
oh2000f000?o0000I`0003000an^00<O6000A?o0P<20`830P<20`830P?n0`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`83oJ@000?`000?oP8002h000on0P00TP003
oh2000^000?o0000I`000?`004Co`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<3o`830P<20`830P<20ofT0003l0003oh2000V000?oP800:8000on0P009P003
o`0006L0003l0014ol20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<3o`830P<20`830P?mY0000o0000on0P007P003oh2002b000?oP8001h000ol0001W0000
?0037iH00alT0014ol20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`?o0P<20`830P?mY0000?0037iH00alT0003oh2000F000?oP800<8000on0P005P003
o`0006L0000l00<OUP037b@004Co`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<3o`830P<20ofT0003l0003oh2000>000?oP800=8000on0P003P003
o`0006L0003l0014ol20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<3o`830P?mY0000o0001On0P83o03Z000GoP820o`1Y0000o000A?o0P?n0`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`83o
J@000?`000?oP?l0?X000on0o`1Y0000BP037g/00ala00;o0420`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8300_mY0000BP037g/00ala04Co
J@0004X00amk00<OgP000?l0ZP000?l0ZP000?l0ZP0005T00amL00<OkP0005T00amL00<OkP0005T0
0amL00<OkP000?l0ZP0006T00all00<OoP0006T00all00<OoP0006T00all00<OoP0007T00al=00<O
30037ol03`0007T00al=00<O30037ol03`0007T00al=00<O30037ol03`000?l0ZP000?l0ZP000001



\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d000d3L000?@0000<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d1lO01l00]0d0003d0000080
0]0d0003d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00
00050003d000030000G@7alO00037`03d000030000?@00001@000m00000`0003d00003@0000I0003
d00002d00]090003d00002d00]090003d00002d00]090003d00002d00]001@0O7al000<O00<0d000
;P02d0T000?@0000;P000m00000e00006P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002`000?@0000
=P0001/00]0Y00;@3P02d2T00]0>00?@:002d0h00m0X00;@0P037`@00al200?@:002d0h00m0Y00;@
>@0001d00]0U00;@4P02d2H000?@00004@000m00000T0003d000014000?@000090000m00000200<O
10037`D000?@000090000m00000800?o1P000m00000T00;@>`0001l000?@00008@000m00000D0003
d000028000?@00004`000m00000R0003d00001<000?@00008P000m00000300<O10037`H000?@0000
8P000m00000400Go0X000ol000050003d000028000?@0000>`0002000]0O00;@6002d2000]0G00;@
8002d1L00]0P00;@5`03d1l00]0200Go00K0P<20`802o`P00m0O00;@?P0002800m0J00;@7003d1X0
0m0K00?@6P03d1/00m0J00?@7002d1X00m04o`Z000CoP83o2P02d1X00m1000009@02d1D00m0Q00;@
5P02d2400]0F00;@8@03d1D00]0Q00?@5@02d0?o01:0`830P<20`830P<20`?o0P?l<00?@5@02d4<0
000?00<O5@05d0/01M0V00G@2`06d2D01M0;00K@9P04d0/01]0=00<O1@037`h01=0;00K@4X001On0
P83o00l01M0:00K@A@0000l00alJ00_@<00;d3002m0`00_@4`037`D00alB00_@01goP<20`830P<20
`830P<20`830P<20`?o0P<20o`0D00[@B`0000l00aoY00<O1@037aD01OlJP003oh2000>000?o0000
IP000?l06004o`0V`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`?mX0000o`0C00Go
8H000on0P005P003o`0006H0003o00h01Ol0;h30P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830ol20`830P<3o06P0003o00X01?lZP003oh2000N000?o0000I@000?l01@05o`0i`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`83o06L0000?00<O
jP037`?o0alaP003oh2000R000?o0000I@0000l00aoZ00<O00?0P<000al0?L20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P?l0I`0000l00aoZ00<O
0_l0180O7al_P003oh2000Z000?o0000I@000?d004KoP<20oh30P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<3oIP000?h000CoP8200_l_P003
oh2000b000?o0000I0000?h000Ko`830P<02o`0mP<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<3o`830P<20`830P<20`830o`1V0000oP000on0P005P003oh2002V000?oP800
3H000ol0001T0000oP002Oo0P<20`830P002o`0k`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P?n0`830P<20`830P<20`830P?l0I@0001800aoY0004oalO7`N00_lVP003oh2000n0
00?o0000H`0001800aoZ00<O04:0`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830ol20`830P<20`830P<20`830P?mU00004P037nX00al:P0;o8H000on0P00AP003o`0006<0
003o000?oh30P<20`830P<20`83000;o03F0`830P<20`830P<20`830P<20`830P<20`830P<20oh30
P<20`830P<20`830P<20`830o`1T0000o`000on0P00>P003oh2001^000?oP8004h000ol0001R0000
o`01000Aol20`830P<20`830P<20`8000_l0</20`830P<20`830P<20`830P<20`830P<20oh30P<20
`830P<20`830P<20`830P<3oI0000?l00@000on0P00@P0;o68000on0P00DP003o`000680003o0040
04Ko`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830
P<20`830P<20`83oH`000?l00@000on0P00CP0;o4h000on0P00GP003o`000640000G00<Oh0037`<0
01So`830P<20`830P<20`830P<20`830P<02o`0/P<20`830P<20`830P<20`83oP<20`830P<20`830
P<20`830P<20`830P?mS00005`037n000al40003oh2001J000?oP8003H000on0P00HP003o`000640
000G00<Oh0037`@001[oP<20`830P<20`830P<20`830P<20`830P0;o02[0P<20`830P<20`83oP<20
`830P<20`830P<20`830P<20`830P<20`?mR0000o`020003oh2001V00_l:P003oh2001Z000?o0000
H0000?l00P00A_n0`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`?o0P<20`830P<20
`830P<20`830P<20`830P<20`?mR0000o`030003oh2001^00_l5P003oh2001b000?o0000H0000?l0
0`008?o0P<20`830P<20`830P<20`830P<20`830P<20`8300_l08h30P?n0`830P<20`830P<20`830
P<20`830P<20`830P<3o0680003o00<000?oP8007h000on0o`0PP003o`0005l0000201co0aoBo`<O
T?lS00007P037m800al<0003oh2001n01?lOP003o`0005l0000N00<OdP037`d0027oP<20`830P<20
`830P<20`830P<20`830P<20`830P<000ol08L3ooh30P<20`830P<20`830P<20`830P<20`830P<20
o`1Q0000o`040003oh2001f000?oP8001802oab000?o0000GP000?l01000A_n0`830P<20`830P<20
`830P<20`830P<20`830P<20oh30P<20`830ol20`830P<20`830P<20`830P<20`830P<20`?mP0000
o`040003oh2001b000?oP8002802oaV000?o0000GP000?l01@00AOo0P<20`830P<20`830P<20`830
P<20`830P<20oh30P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830o`1P00009P037l80
0alF0003oh2001Z000?oP8003802oaN000?o0000G@0002H00ao200<O5P00;_o0P<20`830P<20`830
P<20`830P<20`830P<3o`830P<20`830P<20`830P<02o`0FP<20`830P<20`830P<20`830P<20oel0
000V00<O`P037aH000?oP80068000on0P00BP003oh2001:000?o0000G@000?l01@00<Oo0P<20`830
P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`8000_l04l20`830P<20`830P<20
`830P?l0G`000?l01P000on0P00FP003oh2001J000?oP80048000ol0001L0000o`06000coh30P<20
`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`83000;o0160`830P<20`830
P<20`830o`1N0000o`060003oh2001F000?oP8006X02o`j000?o0000G0000?l01P00A_n0`830P<20
`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`?mN0000o`070003oh2001:000?oP8007h02o`b000?o0000F`0003000an^00<O8P00A_o0P<20`830
P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830
P?mM0000<0037jh00alR0003oh20016000?oP8008h02o`V000?o0000F`0003000an^00<O8P00??o0
P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`0;o
00R0`830P<20oed0003o00L000?oP80048000on0P00XP003oh2000B000?o0000F`000?l02000?_n0
`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
0_l01/20`830oe`0003o00P000?oP8003H000on0P00]P003oh2000:000?o0000FP000?l02000@On0
`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`83000;o00>0`?l0G0000?l020000on0P00<P003oh2003600omL0000?0037iH00al`0014ol20`830
P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<02oe/0000l00<OUP037c0000?oP8002X000on0P00cP0?oF`0003`00anF00<O<000?_o0P<20`830
P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8301OmN0000
o`090003oh2000R000?oP800:h05of<0003o00T003Co`830P<20`830P?n0`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`8301OmX0000o`0:0003oh2000J000?oP8008h04ofd0003o00X0
02[oP<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`805og40003o00X000?oP800
1H000on0P00JP0GoMP0004X00amk00<O?P008On0`830P<3o`830P<20`830P<20`830P<20`830P<20
`004og/0001:00<ON`037cl000?oP8000X000on0P00CP0GoO`0004X00amk00<O?`005_o0P<20oh30
P<20`830P<20`830P<05oh@0003o00/000GoP820o`0<P0GoR@000?l02`003Oo0P?n0`830P<20`800
1?n>0000o`0;0004oh20o`B01OnB0000F@037e`00am@00OoU`0005T00amL00<OD002oi`0001I00<O
G0037nh0003o0:X0001Y00<O?0037oh0001Y00<O?0037oh0001Y00<O?0037oh0001i00<O3@037``0
0aoo00l0001i00<O3@037``00aoo00l0001i00<O3@037``00aoo00l0003o0:X0003o0:X00000


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d000d3L000?@0000<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d1lO01l00]0d0005d0000?l0
0]0d0003d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00
00050003d000030000G@7alO00037`03d000030000?@00000_l0183o0=0b0003d00003@0000I0003
d00002d00]090003d00002d00]090003d00002d00]090003d00002d00]001@0O7al000<O00<0d000
;P02d0?o0X001On0o`3@030000?@0000=@0001X000?@0000:`000m00000:0003d00002/000?@0000
2P000m00000[0003d00000X000?@0000:`000m00000:0003d00002/000_@ooo0P<20`?o0o`020003
d00002`000?@0000=P0001/00]0Y00;@3P02d2T00]0>00?@:002d0h00m0X00;@0P037`@00al200?@
:002d003oh2000F000CoP83o0P03d2T00]0i00007@02d2D00]0B00;@9P000m00000A0003d00002@0
00?@00004@000m00000T0003d00000800al400<O1@000m00000T000?d?o0P<20`830P?n0`83o00D0
00?@00009002d3/0000O0003d000024000?@000050000m00000R0003d00001<000?@00008P000m00
000C0003d000028000?@00000`037`@00al60003d00002000_l00m20P008P003oh2000:000?o0000
0`000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@5`02d2000]0G00;@8002d1L00m0M00;o
0]004H30P<20`830P<3o`830P<3o00H00m0O00;@?P0002800m0J00;@7003d1X00m0K00?@6P03d1/0
0m0J00?@7002d1T000Cod=3@38000on0P003P003o`0000L00]0J00?@@00002D00]0E00?@8@02d1H0
0]0Q00;@5P02d2400m0E00;@8@03d1@001[od=30P<20`830P<20`830P<3o`830P<20o`X00m0E00;@
@`0000l00alE00G@2`05d2H01M0;00K@9@05d0/01]0V00C@2`06d0d00al500<O3P04d0/01]0@P003
oh2000F000?o00002`05d0X01]1500003`037aX02m0`00_@<00;d3002m0C00<O1@037a802m02o`0N
`830P<20`830P<20`830P<20`83oP<20`830P<3o4@0:d4/0000?00<Oj@037`D00alK00;o5H000on0
P007P003o`0006@0003o01l00ol08l20`830P<20`830P<20`830P<20`830ol20`830P<20`83o06D0
003o01d00_lJP003oh2000R000?o0000H`000?l06`02o`0YP<20`830P<20`830P<20`830P<20`830
P<20oh30P<20`830P<20`?l0I0000?l06@02oaf000?oP8002X000ol0001R0000o`0F00?o02j0`830
P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`83oH`0000l00aoZ00<O0`037`h0
0_lQP003oh2000b000?o0000H@0000l00aoZ00<O0`037``00_l0<l20`830P<20`830P<20`830P<20
`830P<20`830P<20`830ol20`830P<20`830P<20o`1S00003`037nX00al300<O2P02obB000?oP800
3X000ol0001P0000o`0=00?o03S0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0
`830P<20`830P<20`830of80003o00/00_lXP003oh20012000?o0000G`000?l02@02o`0nP<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P?mQ0000
o`0700;o;8000on0P00AP003o`0005h0003o00@00ol0@h30P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`?l0H00001800aoZ00<O00?oP800
;X000on0P00CP003o`0005d0000B00<OjP037`18P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`83oG`0001800aoZ00<O0ol]P003
oh2001F000?o0000G0000?l00P001?n0`803o`13P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830o`1N0000o`020003oh2000B00olVP003
oh2001N000?o0000F`000?l00`002Oo0P<20`830P002o`0o`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`83o05d0003o00<000?oP8002803ob60
00?oP8005h000ol0001K0000o`04000=oh30P<20`830P<20`003o`0j`830P<20`830P<20`830P<20
`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830oe`0003o00@000?oP8003H03oaZ0
00?oP8006H000ol0001J00005`037n000al6000Coh30P<20`830P<20`830P<20`002o`0fP<20`830
P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`83oF`0001L00aoP00<O
1`000on0P00AP0?o58000on0P00KP003o`0005T0000G00<Oh0037`L001Oo`830P<20`830P<20`830
P<20`830P003o`0aP<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830
o`1J0000o`060003oh2001J00ol=P003oh2001f000?o0000F0000?l01P007?n0`830P<20`830P<20
`830P<20`830P<20`802o`0]`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20
`83o05T0003o00L000?oP8006X03o`N000?oP8007h000ol0001G0000o`07000Pol20`830P<20`830
P<20`830P<20`830P<20`830P<03o`0X`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20
`830oeP0003o00P000?oP8007h03o`03P?n0026000?o0000EP0000807?l37m;o0an@ob<0000N00<O
dP037a8000?oP8008806ob2000?o0000E@0001h00aoB00<O4P008oo0P<20`830P<20`830P<20`830
P<20`830P<20`830P<2000?o00>0`8000ol07X30P<20`830P<20`830P<20`830P<20`830P<20oeL0
003o00T000?oP80088000on0P006P0?o6h000ol0001D0000o`0:000^oh30P<20`830P<20`830P<20
`830P<20`830P<20`830P?n0`830P<20`830P0;o01[0P<20`830P<20`830P<20`830P<20`830oeH0
003o00X000?oP8007X000on0P00<P0?o5h000ol0001C0000o`0;000bol20`830P<20`830P<20`830
P<20`830P<20`830P<3o`830P<20`830P<20`830P<03o`0E`830P<20`830P<20`830P<20`83o05D0
000V00<O`P037a`000?oP80078000on0P00CP0?o4X000ol0001B00009P037l800alM000goh30P<20
`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`002o`0AP<20`830
P<20`830P<20`?l0E00002H00ao200<O7@000on0P00KP003oh2001R00ol>P003o`000540003o00d0
03_o`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830
P003o`0<P<20`830P<20`83oD`000?l03@000on0P00IP003oh2001n00ol8P003o`000540003o00h0
043oP<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<200_l02<20`830P<3oDP000?l03P000on0P00GP003oh2002F00ol4P003o`000500003o00l0
04Co`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`0?o00?0P?l0D@000?l03`000on0P00EP003oh2002b00omA0000<0037jh00alZ0019
ol20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P002oe00000`00<O[P037b/000?oP8004h000on0P00]P0;oDP0003000an^00<O
:`00@on0`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<000omD0000o`0A0003oh2001:000?oP800:802oeL0003o014003ko`830P<20`830
P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`0;oF@000?l0
4P000on0P00@P003oh2002F00_mK0000o`0B000hoh30P<20`830P<20`830P<20oh30P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`803oed0003o01<000?oP8003X000on0P00QP0;oH00003`0
0anF00<O>P00<oo0P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830
P002of80000l00<OUP037c/000?oP80038000on0P00NP0;oI00003`00anF00<O>`00;On0`830P<20
`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`003ofH0003o01@000?oP80038000on0
P00IP0;oJ@000?l05@00:?o0P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<02of/0
003o01D000?oP8002X000on0P00EP0?oK@000?l05P008_n0`830P<20`830ol20`830P<20`830P<20
`830P<20`802og00003o01H000?oP80028000on0P00BP0;oLP0004X00amk00<OB`007Oo0P<20`830
P<3o`830P<20`830P<20`830P<2000;oM00004X00amk00<OB`000on0P006P003oh2000j00omf0000
BP037g/00am<000Goh30P<20`83oP<20`830P<20`830P<000_mi0000o`0H0003oh2000B000?oP800
2h02og/0003o01T001;o`830P<3o`830P<20`830P<02ogd0003o01T000?oP8000h000on0P006P0?o
O`0005T00amL00<OG@003Oo0P<20oh30P<20`8000_n20000F@037e`00amN0005oh20P?l01H02oh@0
001I00<OG0037eh000SoP<3o`830P0;oQP000?l06`001?n0oh03ohP0001Y00<O?0037fl000Co`?oo
R`0006T00all00<OL0000ol0002;0000J@037c`00aon0000N@037`d00al<00<Oo`0?0000N@037`d0
0al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000o`2Z0000o`2Z0000


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d83od3L000?@0000<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d1lO01l00]0c0004om20P0;o
0]0d0003d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00
00050003d000030000G@7alO00037`03d00002l000[od830P?n0o`3@<P000m00000d00006@000m00
000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@00D07alO00037`030=0002h0
0]03P007oh20P?l0d00`0003d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X0
00?@0000:`000m00000:0003d00002/000?@00002P000m00000Z000<om30P<20`?o0P<3o0P000m00
000/0003d00003H0000K00;@:@02d0h00]0Y00;@3P03d2P00]0>00?@:002d0800al400<O0P03d2P0
0]06P003oh2000:000?o00000m0Y00;@>@0001d00]0U00;@4P02d2H000?@00004@000m00000T0003
d000014000?@000090000m00000200<O10037`D000?@00008`004Oo@P<20`830P<3o`830P<3o00@0
00?@00009002d3/0000O0003d000024000?@000050000m00000R0003d00001<000?@00008P000m00
000C0003d000028000?@00000`037`@00al60003d000024000?od80028000on0P004P003o`000080
00?@00008P000m00000k00008002d1l00]0H00;@8002d1L00]0P00;@5`02d2000]0G00?@7P005Oo@
d830P<20`830P?n0`830P<20o`0500?@7`02d3h0000R00?@6P02d1`00m0J00?@6`03d1X00m0K00?@
6P03d1`00]0J00?@2h000on0P006P003o`0000D00]0J00?@@00002D00]0E00?@8@02d1H00]0Q00;@
5P02d2400m0E00;@8@03d1D00]006On0`830P<20`830P<20oh30P<20`830P?l02003d1D00]130000
3`037aD01M0;00G@9P05d0/01]0U00G@2`06d2H01=0;00K@3@037`D00al>00C@2`06d0;o3X000on0
P007P003o`0000T01M0:00K@A@0000l00alJ00_@<00;d3002m0`00_@4`037`D00alB00_@1@007Oo0
P<20`830P<20`830P<20oh30P<20`830P<3o00l02]1;00003`037nT00al500<O8002oa6000?oP800
2H000ol0001Q0000o`0V000Roh30P<20`830P<20`830P<20`?o0P<20`830P<20`830of80003o02D0
00?oP8004H000on0P00;P003o`000600003o02<00_l09830P<20`830P<20`830P<20`830ol20`830
P<20`830P<20of40003o028000?oP80058000on0P00=P003o`0005h0003o02000_l0:L20`830P<20
`830P<20`830P<20`830ol20`830P<20`830P<20`83o05l0000?00<OjP037`<00alI0003oh2001N0
00?oP8003X000ol0001M00003`037nX00al300<O5`02o`0]P<20`830P<20`830P<20`830P<20`830
P?n0`830P<20`830P<20`830P<3o05h0000?00<OjP037`<00alF0003oh2001V000?oP8004H000ol0
001K0000o`0K000col20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830
P<3o05`0003o01T00_lMP003oh2001:000?o0000FP000?l06000=on0`830P<20`830P<20`830P<20
`830P<20`830P<20oh30P<20`830P<20`830P<20`830P?l0F`000?l05P02oan000?oP8005H000ol0
001H0000o`0E000lol20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830
P<20`830P<20`83oF@0001800aoZ00<O4002ob:000?oP8005X000ol0001G00004P037nX00al?0010
oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20
`830oeP0000B00<OjP037`h000?oP8008h000on0P00HP003o`0005D0003o00l00_l0@X30P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20oeL0
003o00h000?oP8009H000on0P00JP003o`0005@0003o00`00_l0Al20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`83o05D0003o00/0
00?oP800:8000on0P00LP003o`000580003o00X004coP<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<3oE0000?l02002obb0
00?oP8007H000ol0001A00005`037n000al700<O0530P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830oe80000G00<O
h0037`L00al2ob^000?oP80088000ol0001?00005`037n000al700<O00?0P?l01_l0B830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830
P<20oe40003o00L000?oP8001h06oaj000?oP8008H000ol0001>0000o`08000?oh30P<20`830P<20
`83000Oo03g0P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`83o04l0003o00T000?oP8004X07oa2000?oP8008h000ol0001<0000o`09000Lol20`830
P<20`830P<20`830P<20`830P<20`0Ko0360`830P<20`83oP<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<3o04h0003o00X000?oP8007X07o`:000?oP8009H000ol0001;00000P0Lo`<O
d_l37i3o8`0001h00aoB00<O5@000on0P00TP0?o0X06oan000?o0000BP0001h00aoB00<O5@009on0
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`003o`08`830P<20`806o`0K`830P<20
`830P<20`830P<20`830P<20`83o04/0003o00d000?oP80098000on0P00=P0Ko5H000ol000180000
o`0>000loh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20
`830P<201Ol04X30P<20`830P<20`830P<20odT0003o00h000?oP8008X000on0P00IP0Ko2h000ol0
00170000o`0?0016ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830
P<20`830P<20`830P<20`830P<20`0Ko00N0`830P<3o04P0000V00<O`P037b4000?oP80088000on0
P00UP0Ko00>0o`00AP0002H00ao200<O8P00D?o0P<20`830P<20`830P<20`830P<20`830P<20`830
P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8300om600009P037l80
0alR0003oh2001n000?oP800:h000ol000160000o`0B001=oh30P<20`830P<20`830P<20`830P<20
`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<000_m90000
o`0C0003oh2001b000?oP800:H000ol000190000o`0D001:oh30P<20`830P<20`830P<20`830P<20
`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?m<0000o`0D0003
oh2001^000?oP8009X02odd0003o01D004Ko`830P<20`830P<20`830P<20`830P<20`830P?n0`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oC`000?l05P000on0P00IP003oh2002>0
0_m@0000<0037jh00alb0011ol20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`?l0DP0003000an^00<O<P000on0P00GP003oh2002600_mC0000
<0037jh00alc000moh30P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20
`830P<20`830P<20o`1E0000o`0I0003oh2001F000?oP8007h000ol0001D0000o`0J000goh30P<20
`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`002oeL0003o01X0
00?oP80058000on0P00LP003o`0005L0003o01/003?o`830P<20`830P<20`830P<20`830ol20`830
P<20`830P<20`830P<20`830P<20`8000_mJ0000o`0L0003oh2001:000?oP8006H000ol0001J0000
?0037iH00am3000aoh30P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20
o`1M0000?0037iH00am40003oh20012000?oP8005h02oeh0000l00<OUP037dD002coP<20`830P<20
`830P<20`83oP<20`830P<20`830P<20`830P<20`830of00003o01l000?oP8003X000on0P00DP0;o
H@000?l07`00:?o0P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P?mS0000o`0P0003
oh2000f000?oP8004H02of@0003o024002?o`830P<20`830P<20`83oP<20`830P<20`830P<20`830
o`1V0000o`0R0003oh2000Z000?oP80048000ol0001U0000BP037g/00amF000Noh30P<20`830P<20
`?o0P<20`830P<20`830P<200_mX0000BP037g/00amG0003oh2000V000?oP8003H000ol0001X0000
BP037g/00amH000Ioh30P<20`830P<3o`830P<20`830P<20`002of/0003o02D000?oP8001h000on0
P00:P003o`0006/0003o02D001Go`830P<20`830ol20`830P<20`8000_m^0000o`0V0003oh2000F0
00?oP80028000ol0001^0000F@037e`00am[000Bol20`830P?n0`830P<20`83oL@0005T00amL00<O
J`000on0P004P003oh2000F00_mb0000F@037e`00am/000>oh30P<20oh30P<20`?md0000o`0Y0003
oh2000:000?oP8000X02ogD0001Y00<O?0037gh000WoP<20oh30P?l0M`0006T00all00<OOP001On0
P83o00:000?o0000MP0006T00all00<OO`001?o0ol02ogT0001i00<O3@037``00an@00?oN`0007T0
0al=00<O30037i4000?o0000NP0007T00al=00<O30037ol03`000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]000ol0000f00;@
<P0001D000?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0005d83od?l0=P000m00
000b00005P02d3@000?@00000P02d3@000?@00000P02d3@000?@00000P02d3@000G@7al07`02d3@0
00G@P83oP002d3@000?@0000<`0001P000?@0000<0000m0000050003d000030000?@00001@000m00
000`0003d00000D000?@0000<0001M0O7al000<O00?@0000<0002M20`83oP<20d00b0003d00003@0
000I0003d00002d00]090003d00002d00]090003d00002d00]090003d00002d00]001@0O7al000<O
00<0d000;P02d0B000?oP8000X000m00000^0003d00003D0000J0003d00002/000?@00002P000m00
000[0003d00000X000?@0000:`000m00000:0003d00002/000?@00002P000m00000[000>d?n0`830
P?n0`830P=0^0003d00003H0000K00;@:@02d0h00]0Y00;@3P03d2P00]0>00?@:002d0800al400<O
0P03d2P00]000on0P004P003oh2000B00m0Y00;@>@0001d00]0U00;@4P02d2H000?@00004@000m00
000T0003d000014000?@000090000m00000200<O10037`D000?@000090005M00oh30P<20`83oP<20
`830P?l0d00V00;@>`0001l000?@00008@000m00000D0003d000028000?@00004`000m00000R0003
d00001<000?@00008P000m00000300<O10037`H000?@00008P000m00o`08P003oh2000J000?o0=00
90000m00000k00008002d1l00]0H00;@8002d1L00]0P00;@5`02d2000]0G00?@7`02d00G0?n0`830
P<20`83oP<20`830P<20o`000m0O00;@?P0002800m0J00;@7003d1X00m0K00?@6P03d1/00m0J00?@
7002d1X00m020003oh2000R000?oP80028001?l00002d1X00m1000009@02d1D00m0Q00;@5P02d240
0]0F00;@8@03d1D00]0Q00?@5@02d0@001WoP<20`830P<20`83oP<20`830P<20`83o00@00m0E00;@
@`0000l00alE00G@2`05d2H01M0;00K@9@05d0/01]0V00C@2`06d0d00al500<O3P04d0/01]050003
oh2000Z000?oP8002X000ol0000400G@2P06d4D0000?00<O6P0;d3002m0`00_@<00;d1<00al500<O
4P0;d0X001goP<20`830P<20`830P?n0`830P<20`830P<20o`0:00[@B`0000l00aoY00<O1@037bH0
00?oP80038000on0P00<P003o`0005`0003o02/00_l08830P<20`830P<20`830P?n0`830P<20`830
P<20`83oG@000?l0:P000on0P00?P003oh2000j000?o0000FP000?l0:@009_o0P<20`830P<20`830
P<20`83oP<20`830P<20`830P<20`83oF`000?l0:0000on0P00AP003oh20012000?o0000F0000?l0
9`00:_o0P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20oeT0000?00<OjP037`<0
0alP0003oh2001>000?oP8004X000ol0001F00003`037nX00al300<O7`00;_o0P<20`830P<20`830
P<20`830P<20oh30P<20`830P<20`830P<20`830P?mG00003`037nX00al300<O7P000on0P00EP003
oh2001B00_mE0000o`0S000col20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830
P<20`830P<3o05@0003o028000?oP8005h000on0P00GP003o`000540003o024003Oo`830P<20`830
P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<3o0580003o020000?oP800
6H000on0P00IP003o`0004l0003o01l003_o`830P<20`830P<20`830P<20`830P<20`830P?n0`830
P<20`830P<20`830P<20`830P<20`830o`1@00004P037nX00alK0003oh2001^000?oP8006h000ol0
001=00004P037nX00alJ000ool20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830
P<20`830P<20`830P<20`830P<3o04h0000B00<OjP037aP00_lOP003oh2001f000?o0000B`000?l0
6P00A?n0`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20
`830P<20`830P<3oC0000?l06@000on0P00PP003oh2001n000?o0000B@000?l06000B?n0`830P<20
`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20
`830odX0003o01L000?oP8008X000on0P00QP003o`0004L0003o01H004coP<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o
B0000?l05@000on0P00TP003oh2002>000?o0000A@0001L00aoP00<O1`037``0053oP<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830odH0000G00<Oh0037`L00al;0003oh2002J000?oP8009H000ol0001300005`037n00
0al700<O2P00E?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830od@0003o014000?oP800:8000on0P00WP003
o`000440003o010005SoP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o@P000?l03`000on0P00ZP003
oh2002V000?o0000?`000?l03P00G?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o@0000?l0
3@000on0P00/P003oh2002^000?o0000?@0000807?l37m;o0alDo`<ONOlS00007P037m800alD00<O
00?oP800:X03ob^000?o0000?P0001h00aoB00<O50037`0]0?o0P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`83000?o02_0P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`83o0440003o010000?oP800:H000on0P00XP003o`000400003o014005Ko`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20od<0003o018000?oP8009h000on0P00VP003o`000480003o01<005;o`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`83oA@0002H00ao200<O9@000on0P00UP003oh2002B000?o0000A00002H0
0ao200<O9P00C_o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20odL0000V00<O`P037bL000?oP8008h000on0P00RP003
o`0004H0003o01L004[o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830
P<20`830P<20`830P<20`830P<20`830P<20odT0003o01P000?oP8008H000on0P00PP003o`0004P0
003o01T004Ko`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830
P<20`830P<20`830P<20`83oB`000?l06P000on0P00OP003oh2001j000?o0000BP000?l06`00@_o0
P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830
P<20odd0003o01`000?oP8007H000on0P00LP003o`0004`0000`00<O[P037cP003ko`830P<20`830
P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20odl0000`00<O
[P037cT000?oP8006h000on0P00JP003o`0004h0000`00<O[P037cX003[o`830P<20`830P<20`830
P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`83oD@000?l080000on0P00IP003
oh2001R000?o0000D0000?l08@00=_o0P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830
P<20`830P<20`830P<20oe<0003o028000?oP8005h000on0P00FP003o`000580003o02<003;o`830
P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20oeD0003o02@00_lFP003
oh2001B000?o0000E00003`00anF00<OC@00;On0`830P<20`830P<20`830P<20`83oP<20`830P<20
`830P<20`830P<20o`1G0000?0037iH00am>0003oh2001:000?oP8004X000ol0001F0000?0037iH0
0am?000Yoh30P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P?l0F@000?l0:@000on0
P00@P003oh20012000?o0000F0000?l0:P009On0`830P<20`830P<20`830P?n0`830P<20`830P<20
`830P?l0F`000?l0:`000on0P00>P003oh2000j000?o0000FP000?l0;0008On0`830P<20`830P<20
`83oP<20`830P<20`830P<20o`1M0000o`0]0003oh2000b000?oP80038000ol0001L0000BP037g/0
0amR000Moh30P<20`830P<20`83oP<20`830P<20`830P?l0G`0004X00amk00<OH`000on0P00:P003
oh2000Z000?o0000GP0004X00amk00<OI0006On0`830P<20`830P?n0`830P<20`830P?l0H@000?l0
<@000on0P008P003oh2000R000?o0000H0000?l0<P005On0`830P<20`83oP<20`830P<20o`1S0000
o`0c0003oh2000J000?oP8001X000ol0001R0000F@037e`00amh000Aoh30P<20`83oP<20`830P?l0
I@0005T00amL00<ON@000on0P004P003oh2000B000?o0000I00005T00amL00<ONP003On0`830P?n0
`830P?l0I`000?l0=`000on0P002P003oh2000:000?o0000IP0006T00all00<OS0002On0`83oP<20
o`1Y0000J@037c`00an=0004oh20o`:000?o0000J00006T00all00<OSP001On0oh3o06/0001i00<O
3@037``00anO00?oK00007T00al=00<O30037j0000?o0000J`0007T00al=00<O30037ol03`000?l0
ZP000?l0ZP000001


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d?o0d3L000?@0000<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d1lO01l00]0d0003d?oo00:0
0]0d0003d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00
00050003d000030000G@7alO00037`03d000030000W@ol3o`830P=00<P000m00000d00006@000m00
000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@00D07alO00037`030=0002h0
0]001On0P83o00B000?@o`00;P000m00000e00006P000m00000[0003d00000X000?@0000:`000m00
000:0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`003m000?n0`83oP<20`83@
o`0]0003d00003H0000K00;@:@02d0h00]0Y00;@3P03d2P00]0>00?@:002d0800al400<O0P03d2P0
0]020003oh2000:000?oP8001803d2T00]0i00007@02d2D00]0B00;@9P000m00000A0003d00002@0
00?@00004@000m00000T0003d00000800al400<O1@000m00000T000Ed0000?n0`830P?n0`830P<20
`?o@02H00]0k00007`000m00000Q0003d00001@000?@00008P000m00000C0003d000028000?@0000
4`000m00000R0003d00000<00al400<O1P000m00000R0003d000008000?oP8000h000on0P008P003
d000028000?@0000>`0002000]0O00;@6002d2000]0G00;@8002d1L00]0P00;@5`03d1l00]04000C
ol20`830P<3o`830P<20`830P003d1l00]0n00008P03d1X00]0L00?@6P03d1/00m0J00?@6`03d1X0
0m0L00;@6P03d0D000?oP8001X000on0P00:P003om3@01X00m1000009@02d1D00m0Q00;@5P02d240
0]0F00;@8@03d1D00]0Q00?@5@02d0L001So`830P<20`830ol20`830P<20`830P<02o`?@5@02d4<0
000?00<O5@05d0/01M0V00G@2`06d2D01M0;00K@9P04d0/01]0=00<O1@037`h01=0;00K@2@000on0
P007P003oh2000f000?o00001M0:00K@A@0000l00alJ00_@<00;d3002m0`00_@4`037`D00alB00_@
3P007?n0`830P<20`830ol20`830P<20`830P<20`802o`D02]1;00003`037nT00al500<O:P000on0
P009P003oh20012000?o0000E`000?l0<@008Oo0P<20`830P<20`83oP<20`830P<20`830P<20`830
o`1H0000o`0`0003oh2000^000?oP8004H02oeH0003o02l002Ko`830P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20oeD0003o02h000?oP8003H000on0P00DP0;oD`000?l0;P00:_n0`830P<20
`830P<20`83oP<20`830P<20`830P<20`830P<20`830oe80000?00<OjP037`<00alW0003oh2000j0
00?oP8005h02oe00000?00<OjP037`<00alV000_oh30P<20`830P<20`830P<20`?o0P<20`830P<20
`830P<20`830P<20`830P?l0C`0000l00aoZ00<O0`037bH000?oP80048000on0P00IP0;oC@000?l0
:`00<oo0P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830o`1<0000
o`0Z0003oh2001:000?oP80078000ol000190000o`0Y000fol20`830P<20`830P<20`830P<20`?o0
P<20`830P<20`830P<20`830P<20`830P<20`8300_m90000o`0Y0003oh2001B000?oP8007X000ol0
00160000o`0X000joh30P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20
`830P<20`830P0;oAP0001800aoZ00<O90000on0P00FP003oh20026000?o0000@`0001800aoZ00<O
9000?_o0P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830
P<20`8300_m300004P037nX00alS0003oh2001N000?oP80098000ol000100000o`0U0013ol20`830
P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P002od00003o02@000?oP8006X000on0P00VP003o`0003d0003o02@004SoP<20`830P<20`830P<20
`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?ln0000
o`0S0003oh2001^000?oP800:802oc`0003o028004goP<20`830P<20`830P<20`830P<20`830P<20
`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20o`0k0000o`0R0003
oh2001b000?oP800:h02ocT0000G00<Oh0037`L00alI001Aol20`830P<20`830P<20`830P<20`830
P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o03P0
000G00<Oh0037`L00alH0003oh2001n000?oP800:X04ocL0000G00<Oh0037`L00alG0019ol20`830
P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P007o`04P<20ocL0003o01l000?oP80088000on0P00LP0Oo2H000ol0000f0000o`0N000l
oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20
1ol04830P<20`830P<20`830P?li0000o`0M0003oh2002:000?oP8003h06oaF000?o0000>0000?l0
7@00<?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`0Oo01c0P<20
`830P<20`830P<20`830P<20`830P<3o>P000?l070000on0P00TP003oh2000Oo8H000ol0000i0000
0P0Lo`<Od_l37aCo0amiob<0000N00<OdP037a@00al<0003oh2001f01_l2P0?o9h000ol0000k0000
7P037m800alD00<O30006on0`830P<20`830P<20`830P<20`830P<20`005o`08`830P<20`803o`0X
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20ocd0003o01T000?oP8004h06o`j0
00?oP8009H000ol0000l0000o`0H000Aoh30P<20`830P<20`830P<001_l0?830P<20`830P<20`830
P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20ocl0003o01P000?oP800
2806oa^000?oP8008h000ol0000m0000o`0G0007ol20`830P005o`17P<20`830P<20`830P<20`830
P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?l0@00002H0
0ao200<O90037`03oh3o00Go9X000on0P00QP003o`0003l0000V00<O`P037b@00al2o`1@`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20
`830P<20`830P<20`?m200009P037l800alT00<O00<0oh00:h000on0P00PP003o`000400003o01P0
0_l0CL20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`830P<20`830P<20`83o04<0003o01X000?oP800:8000on0P00MP003o`000480003o01/0
04[o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830
P<20`830P<20`830P<20odD0003o01`00_lWP003oh2001b000?o0000@`000?l07P00A_n0`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20
`?m60000o`0O00;o9H000on0P00IP003o`0004D0000`00<O[P037c`0047o`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830o`180000<0037jh0
0alm00;o8X000on0P00HP003o`0004H0000`00<O[P037cl003goP<20`830P<20`830P<20`830P<20
`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`83o04T0003o02D000?oP8007X000on0
P00FP003o`0004P0003o02H00_l0=l20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20
`830P<20`830P<20`830P?l0B`000?l0:0000on0P00LP003oh2001B000?o0000B@000?l0:@02o`0c
P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<3o04`0003o02/0
00?oP8006H000on0P00BP003o`0004/0000l00<OUP037e<0037oP<20`830P<20`830P<20`830P<20
`830P<3o`830P<20`830P<20`830P<20`83o04d0000l00<OUP037e@00_lHP003oh20016000?o0000
C00003`00anF00<OEP00;?o0P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`83o
C`000?l0<002oaJ000?oP8003X000ol0001>0000o`0b000Xoh30P<20`830P<20`830P<20`830P?n0
`830P<20`830P<20`830oe00003o03<00_lCP003oh2000f000?o0000C`000?l0=@008oo0P<20`830
P<20`830P<20`83oP<20`830P<20`830P<3o0580003o03H000?oP8003h000on0P00;P003o`000540
001:00<ON`037f/00_l07X30P<20`830P<20`830P?n0`830P<20`830P<20oe<0001:00<ON`037fd0
00?oP8003H000on0P009P003o`000580001:00<ON`037fh00_l06L20`830P<20`830P<3o`830P<20
`830P?l0E@000?l0?0000on0P00:P003oh2000N000?o0000E0000?l0?@02o`0EP<20`830P<20`?o0
P<20`830P<3o05H0003o03l000?oP8001h000on0P006P003o`0005D0001I00<OG0037h@001;oP<20
`830P<20oh30P<20`?mH0000F@037e`00an500;o1h000on0P004P003o`0005H0001I00<OG0037hL0
00ko`830P<20oh30P<20oeT0003o04@00_l4P003oh2000:000?o0000F00006T00all00<OVP002On0
`83oP<20o`1K0000J@037c`00anK0004oh20o`>000?o0000F@0006T00all00<OW002o`04`?o0oe`0
001i00<O3@037``00an^00?oG@0007T00al=00<O30037jl000?o0000G00007T00al=00<O30037ol0
3`000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d000d3L000?@0000<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d1lO01l00]0d0003d?oo0080
0]0d0003d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00
00050003d000030000G@7alO00037`03d000030000C@0?n00_l20003d000030000?@0000=00001T0
00?@0000;@02d0T000?@0000;@02d0T000?@0000;@02d0T000?@0000;@02d00501lO7`000al00`3@
000^00;@00@0oh3o0X03o`03d00002h000?@0000=@0001X000?@0000:`000m00000:0003d00002/0
00?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002/000k@0000ol3o`830
P<3od2h000?@0000=P0001/00]0Y00;@3P02d2T00]0>00?@:002d0h00m0X00;@0P037`@00al200?@
:002d0<000CoP83o1h03d2T00]0i00007@02d2D00]0B00;@9P000m00000A0003d00002@000?@0000
4@000m00000T0003d00000800al400<O1@000m00000T0003d00000<000ooP<20oh30P<20`830om00
9P02d3/0000O0003d000024000?@000050000m00000R0003d00001<000?@00008P000m00000C0003
d000028000?@00000`037`@00al60003d000028000?@00000`000on0P002P003oh2000R000?@ool0
8P000m00000k00008002d1l00]0H00;@8002d1L00]0P00;@5`02d2000]0G00?@7`02d0H0017o`830
P<3o`830P<20`830P003d003o`0001`00]0n00008P03d1X00]0L00?@6P03d1/00m0J00?@6`03d1X0
0m0L00;@6P03d0L000?oP80018000on0P00;P0;@00?o00005`03d400000U00;@5@03d2400]0F00;@
8@02d1H00]0Q00?@5@02d2400m0E00;@2P005on0`830P<3o`830P<20`830P<20`83000?@5@02d4<0
000?00<O5@05d0/01M0V00G@2`06d2D01M0;00K@9P04d0/01]0=00<O1@037`h01=0;00K@2`000on0
P006P003oh2000n01M0:00K@A@0000l00alJ00_@<00;d3002m0`00_@4`037`D00alB00_@4@007_o0
P<20`830P?n0`830P<20`830P<20`830P<20`0;o2]1;00003`037nT00al500<O;P000on0P007P003
oh2001>00_mC0000o`0d000Soh30P<20`830P<3o`830P<20`830P<20`830P<20`830P<000om@0000
o`0d0003oh2000R000?oP8006802odh0003o03<002Wo`830P<20`830P<20oh30P<20`830P<20`830
P<20`830P<20`830P002od`0003o03<000?oP8002X000on0P00KP0;oBP000?l0<P00;_n0`830P<20
`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`803odL0000?00<OjP037`<00al/0003
oh2000b000?oP8007h02odD0000?00<OjP037`<00al[000dol20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`0;o@`0000l00aoZ00<O0`037b/000?oP8003X000on0
P00RP0;o@@000?l0<000>On0`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`003och0003o030000?oP80048000on0P00VP0;o?0000?l0;`00?oo0P<20`830
P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P002ocX0
003o02l000?oP8004H000on0P00ZP0;o>0000?l0;P00A?n0`830P<20`830P<20`830P<20`83oP<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<200ole00004P037nX00al[0003
oh2001>000?oP800;X02oc<0000B00<OjP037bX004Wo`830P<20`830P<20`830P<20`830P?n0`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<2000;o<P0001800aoZ00<O
:P000on0P00EP003oh2002^00ol00h3o000a0000o`0/0014oh30P<20`830P<20`830P<20`830P<20
`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`803o`04P<20oc<0003o02`0
00?oP8005h000on0P00TP0?o1X000ol0000a0000o`0/000ooh30P<20`830P<20`830P<20`830P<20
`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`83000;o00V0`830P<20`?l0=0000?l0
:`000on0P00HP003oh2001n00ol:P003o`000380003o02/003[o`830P<20`830P<20`830P<20`830
P<20`830ol20`830P<20`830P<20`830P<20`830P<20`8300ol03L20`830P<20`830P?l0=@000?l0
:P000on0P00JP003oh2001R00ol?P003o`0003<0000G00<Oh0037`L00alR000foh30P<20`830P<20
`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<200_l04/20`830P<20`830P<20
`830ocH0000G00<Oh0037`L00alQ0003oh2001b000?oP8004X03oa>000?o0000=00001L00aoP00<O
1`037b40037o`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<2000?o
01J0`830P<20`830P<20`830P<20`83o=`000?l0:0000on0P00NP003oh2000^00olHP003o`0003D0
003o02P002goP<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<000_l07830
P<20`830P<20`830P<20`830P<20`830P?lg0000o`0W0003oh20022000?oP8001H03oab000?o0000
=P000?l09`00:?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<03o`0P`830P<20
`830P<20`830P<20`830P<20`830P<20`?lh0000o`0V0003oh20026000?oP?l00_lQP003o`0003L0
000201co0aoBo`<O5?l37gWo8`0001h00aoB00<O50037aL000?oP8007h05ob>000?o0000>00001h0
0aoB00<O50037aL001oo`830P<20`830P<20`830P<20`830P<20`830P<2000?o00>0`?l00ol08h30
P<20`830P<20`830P<20`830P<20`830P<20`830P<3o03X0003o02@000?oP8006X03o`R000?oP800
7h000ol0000i0000o`0T000Joh30P<20`830P<20`830P<20`830P<20`803o`0^P<20`830P<20`83o
P<20`830P<20`830P<20`830P<20`830P<20`830P<20oc/0003o02<000?oP8005X02o`n000?oP800
7H000ol0000j0000o`0S000Fol20`830P<20`830P<20`830P<20`0?o03;0P<20`830P<20`830P<20
`?o0P<20`830P<20`830P<20`830P<20`830P<20`830oc`0000V00<O`P037b@00al=0003oh200120
0olDP003oh2001b000?o0000>`0002H00ao200<O90037``0017oP<20`830P<20`830P<20`003o`0g
`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20o`0m0000
9P037l800alT00<O30000on0P00;P0?o6h000on0P00JP003o`0003`0003o024000co`830P<20`830
P<03o`0l`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20
`830P<3o?P000?l08@000on0P007P0;o8X000on0P00HP003o`0003d0003o020000SoP<20`830P0?o
0420`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830
P<20`83o?`000?l080000on0P002P0?o:8000on0P00FP003o`0003h0003o01l000?o`8000ol0AH30
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830
P<20`830o`100000o`0O00?o;X000on0P00FP003o`0003h0000`00<O[P037cP00al0BL20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20
`830P?l0@@0003000an^00<O>0037`;o;h000on0P00DP003o`0003l0000`00<O[P037cP00al200?o
04>0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830
P<20`830P<3o0480003o02D00_l[P003oh2001:000?o0000@0000?l09`02o`0nP<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P?m30000o`0Y00;o
:8000on0P00@P003o`000440003o02/00ol0><20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<3o`830P<20`830P<20`830P<3oA0000?l0;P02ob>000?oP8003h000ol000120000?0037iH0
0amG00;o03?0P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P?l0
A@0003`00anF00<OF@02ob2000?oP8003H000ol000130000?0037iH00amK00?o02f0`830P<20`830
P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`?l0AP000?l0=`02oab000?oP8002h000ol0
00140000o`0i00;o02R0`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`83oA`000?l0
>`03oaR000?oP8002H000ol000150000o`0n00;o02;0P<20`830P<20`830P<20`830P<20oh30P<20
`830P<3oB0000?l0@002oaB000?oP80028000ol000160000BP037g/00amf00;o01g0P<20`830P<20
`830P<20`830ol20`830P<20o`190000BP037g/00amh00?o48000on0P006P003o`0004L0001:00<O
N`037g/00_l06830P<20`830P<20`830ol20`830P<20odT0003o04T00_l=P003oh2000B000?o0000
B0000?l0B`02o`0CP<20`830P<20`83oP<20`830o`1:0000o`1=00?o2H000on0P002P003o`0004T0
001I00<OG0037i@00_l03L20`830P<3o`830P?l0B`0005T00amL00<OUP02o`F000GoP820o`1<0000
F@037e`00anH00;o00S0P<20oh30od`0003o05H00ol0183oP?m=0000J@037c`00an]00;o00>0o`00
C00006T00all00<O[`000ol0001<0000J@037c`00aon0000N@037`d00al<00<Oo`0?0000N@037`d0
0al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000o`2Z0000o`2Z0000


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d000d3L000?@0000<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d1lO01l00]0d0003d0000080
0]0d0003d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00
00050003d000030000G@7alO00037`03d000030000?@00001@000m00000`0003d00003@0000I0003
d00002d00]090003d00002d00]090003d00002d00]090003d00002d00]001@0O7al000<O00<0d000
;P02d0T000?@0000;P000m00000e00006P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002`000?@0000
=P0001/00]0Y00;@3P02d2T00]0>00?@:002d0h00m0X00;@0P037`@00al200?@:002d0h00m0Y00;@
>@0001d00]0U00;@4P02d2H000?@00004@000m00000T0003d000014000?@000090000m00000200<O
10037`D000?@000090000m00000400?o2P000m00000T00;@>`0001l000?@00008@000m00000D0003
d000028000?@00004`000m00000R0003d00001<000?@00008P000m00000300<O10037`H000?@0000
8P000m0000050003oh2000Go1P000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@5`02d200
0]0G00;@8002d1L00m0O00;@2002o`06P<20`8301Ol200?@7`02d3h0000R00?@6P02d1`00m0J00?@
6`03d1X00m0K00?@6P03d1`00]0J00?@2@001?n0P?l:P0Co00<0d=006P03d400000U00;@5@03d240
0]0F00;@8@02d1H00]0Q00?@5@02d2400m0E00;@30004_n0`?o0P<20`830P<20`830P0?o0m0E00;@
@`0000l00alE00G@2`05d2H01M0;00K@9@05d0/01]0V00C@2`06d0d00al500<O3P04d0/01]0>0005
oh20P?l04X000oo@d003d0X01]1500003`037aX02m0`00_@<00;d3002m0C00<O1@037a802m0D000M
oh30P<3o`830P<20`830P<20`830P<20`830P?l02]1;00003`037nT00al500<O<0000on0P003P003
oh2001R01Om=0000o`0g000Vol20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<04odT0
003o03L000?oP8001H000on0P00OP0GoA0000?l0=`00;oo0P<20`830ol20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<2000Go?`000?l0=P000on0P007P003oh2002R01?lk0000o`0f000i
oh30P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83000Go
=P0000l00aoZ00<O0`037c0000?oP80028000on0P00`P0Go<@0000l00aoZ00<O0`037c0004?oP<20
`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`83000;o;`0000l00aoZ00<O0`037c0000?oP8002X000on0P00aP0;o00>0o`00;P000?l0=@00A_o0
P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20oh30P?l_0000o`0e0003oh2000b000?oP800;H02o`>000?o0000;P000?l0=@00?Oo0P<20`830
P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8000_l01/20
`830oc00003o03D000?oP8003H000on0P00YP003oh2000F000?o0000;P000?l0=000>on0`830P<20
`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83000;o00V0`830
P<20`?l0<00001800aoZ00<O<@000on0P00?P003oh2002B00_l9P003o`0002l0000B00<OjP037c40
04GoP<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0
`830P<20`830P?l0<@0001800aoZ00<O<@000on0P00AP003oh2001n00_l<P003o`0002l0003o03<0
03Go`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P002o`0?
`830P<20`830P<20`83o0340003o03<000?oP8004h000on0P00KP003oh2000f000?o0000<0000?l0
<`00<_o0P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`8300_l04H30
P<20`830P<20`830P<3o0380003o03<000?oP80058000on0P00FP0;o4X000ol0000`0000o`0b0016
oh30P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20oh30P<20`830P<20
`830P<20`830oc80003o038000?oP8005h000on0P00AP0;o5H000ol0000`00005`037n000al700<O
:P00;?n0`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<200_l05l20`830P<20
`830P<20`830P<20`83o03<0000G00<Oh0037`L00alZ0003oh2001R000?oP8003H000on0P00FP003
o`000340000G00<Oh0037`L00alY000Zol20`830P<20`830P<20`830P<20`830P<20`83oP<20`830
P<20`8300_l06X30P<20`830P<20`830P<20`830P<20`83o<`000?l0<@000on0P00JP003oh2000R0
0_lKP003o`000340003o034004Go`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`83o
P<20`830P<20`830P<20`830P<20`830P<20`?l0=0000?l0<@000on0P00LP003oh2000>00_lMP003
o`000380003o034002?o`830P<20`830P<20`830P<20`830P<20`830P<20oh30P002o`0P`830P<20
`830P<20`830P<20`830P<20`830P<20`?ld0000o`0`0003oh2001j000?oP?l08H000ol0000b0000
0P0Lo`<Od_l37aCo0amiob<0000N00<OdP037a@00alR0003oh2001f01?lPP003o`0003<0000N00<O
dP037a@00alR000Noh30P<20`830P<20`830P<20`830P<20`830P<200_l09L3oooo0P<20`830P<20
`830P<20`830P<20`830P<20`830P?l0=@000?l0;`000on0P00JP0;o1X000on0P00MP003o`0003<0
003o02l004Go`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20oh30P<20`830P<20`830
P<20`830P<20`830P<20`?l0=P000?l0;`000on0P00GP0;o2X000on0P00KP003o`0003@0003o02l0
04Go`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`83oP<20`830P<20`830P<20`830
P<20`830P<20`?l0=P0002H00ao200<O90037aP000?oP8005H02o`j000?oP8006X000ol0000d0000
9P037l800alT00<O60005_n0`830P<20`830P<20`830P<20`802o`0]`830P<20`830P<20`830P<3o
`830P<20`830P<20`830P<20`830P<20`83o03L0000V00<O`P037b@00alH0003oh2001:000?oP800
4H000on0P00HP003o`0003D0003o02h001?oP<20`830P<20`830P<20`83000;o0320`830P<20`830
P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P?lg0000o`0]0003oh20012000?oP800
5X000on0P00FP003o`0003D0003o02d0017o`830P<20`830P<20`830P002o`0c`830P<20`830P<20
`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`83o03L0003o02d000?oP8003802oab0
00?oP80058000ol0000f0000o`0]0015ol20`830P<20`830P<3o`830P<20`830P<20`830P<20`830
P<20`830P<20`?o0P<20`830P<20`830P<20`830P<3o03P0003o02`000?oP8002X02ob2000?oP800
4h000ol0000f0000<0037jh00alh00<O3000A_n0`830P<20`830P?n0`830P<20`830P<20`830P<20
`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`?lh0000<0037jh00alh00<O30000on0
P007P0;o9H000on0P00@P003o`0003L0000`00<O[P037cP00al<0008oh30P<20`802o`0k`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P?l0>@000?l0
;0000on0P004P003oh2002R000?oP8003h000ol0000g0000o`0[0006ol20`8300_l0?X30P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`83o>@000?l0
:`000on0P002P003oh2002b000?oP8003H000ol0000h0000o`0[0003ol2000;o0430P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<3o>P000?l0
:`03oc:000?oP80038000ol0000h0000?0037iH00am@00<O04C0P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830ocX0000l00<OUP037e00
0al00on0P00cP003oh2000V000?o0000>@0003`00anF00<OD0037`030?oo00?o03g0P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`83o03/0003o0380
1Ol/P003oh2000R000?o0000>@000?l0=`04o`0dP<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`83oP<20`830P<20oc/0003o03/01OlTP003oh2000J000?o0000>P000?l0@005o`0Y
P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`?l0?0000?l0A@04oaf000?oP800
18000ol0000j0000BP037g/00amm00Go0230P<20`830P<20`830P<20`830P<20`83oP<20`830oc`0
001:00<ON`037h801?lEP003oh2000>000?o0000>P0004X00amk00<OQP05o`0FP<20`830P<20`830
P<20`?o0P<20ocd0003o05L01Ol<P005oh20P?l0?@000?l0G004o`0=`830P<20`830ol20o`0m0000
o`1P00Go18001?n0P?lm0000F@037e`00anY00Oo?P0005T00amL00<O[P02och0001I00<OG0037nh0
003o0:X0001Y00<O?0037oh0001Y00<O?0037oh0001Y00<O?0037oh0001i00<O3@037``00aoo00l0
001i00<O3@037``00aoo00l0001i00<O3@037``00aoo00l0003o0:X0003o0:X00000


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d000d3L000?@0000<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d1lO01l00]0d0003d0000080
0]0d0003d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00
00050003d000030000G@7alO00037`03d000030000?@00001@000m00000`0003d00003@0000I0003
d00002d00]090003d00002d00]090003d00002d00]090003d00002d00]001@0O7al000<O00<0d000
;P02d0T000?@0000;P000m00000e00006P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002`000?@0000
=P0001/00]0Y00;@3P02d2T00]0>00?@:002d0h00m0X00;@0P037`@00al200?@:002d0h00m0Y00;@
>@0001d00]0U00;@4P02d2H000?@00004@000m00000T0003d000014000?@000090000m00000200<O
10037`D000?@000090000m00000A0003d00002@00]0k00007`000m00000Q0003d00001@000?@0000
8P000m00000C0003d000028000?@00004`000m00000R0003d00000<00al400<O1P000m00000R0003
d00001<000?@00008P000m00000k00008002d1l00]0H00;@8002d1L00]0P00;@5`02d2000]0G00?@
7`02d1L00m0O00;@?P0002800m0J00;@7003d1X00m0K00?@6P03d1/00m0J00?@7002d1X00m0L00;@
6P03d400000U00;@5@03d2400]0F00;@8@02d1H00]0Q00?@5@02d2400m0E00;@8@03d1D00]130000
3`037aD01M0;00G@9P05d0/01]0U00G@2`06d2H01=0;00K@3@037`D00al>00C@2`06d2H01M0:00K@
A@0000l00alJ00_@<00;d3002m0`00_@4`037`D00alB00_@500Mo`[@7Ol^00003`037nT00al500<O
<@000on0o`0nP003oh3o02h0003o03P004CoP<3o`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20oh30obh0003o03P000GoP820o`0jP005oh20P?l0
;P000?l0>000A?n0`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20oh30P<3o;P000?l0>0000on0P003P003oh2003B000?oP8000h000ol0000/0000
o`0h0014oh30P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20oh30P<20`?l^00003`037nX00al300<O<P000on0P005P003oh20032000?oP8001H000ol0
000/00003`037nX00al300<O<P00A?n0`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`83oP<20`830P<3o;P0000l00aoZ00<O0`037c8000?oP8001h000on0
P00/P003oh2000N000?o0000;0000?l0>000A?n0`830P<20`830ol20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<3o;P000?l0>0000on0P009P003oh2002R0
00?oP8002H000ol0000/0000o`0h0014oh30P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20oh30P<20`830P<20`?l^0000o`0h0003oh2000^000?oP80098000on0
P00;P003o`0002`0003o03P004CoP<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20oh30P<20`830P<20`830obh0000B00<OjP037cD000?oP8003H000on0P00PP003
oh2000f000?o0000;00001800aoZ00<O=@00<On0`830P<20`830P<20`830ol20`830P<20`830P<20
`830P<20`830P<20`830P<000_l04H30P<20`830P<20`830P<3o02h0000B00<OjP037cD000?oP800
3h000on0P00KP003oh20012000?o0000;0000?l0>000A?n0`830P<20`830P<20`830P<3o`830P<20
`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<3o;P000?l0>0000on0P00AP003
oh2001N000?oP8004X000ol0000/0000o`0h0014oh30P<20`830P<20`830P<20`830ol20`830P<20
`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`?l^0000o`0h0003oh2001>000?oP800
4h000on0P00DP003o`0002`0003o03P004CoP<20`830P<20`830P<20`830P<20`?o0P<20`830P<20
`830P<20`830ol20`830P<20`830P<20`830P<20`830obh0003o03P000?oP8005H000on0P00?P003
oh2001J000?o0000;00001L00aoP00<O1`037c0004CoP<20`830P<20`830P<20`830P<20`830ol20
`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830obh0000G00<Oh0037`L00al`0003
oh2001N000?oP8002h000on0P00HP003o`0002`0000G00<Oh0037`L00al`0014oh30P<20`830P<20
`830P<20`830P<20`830ol20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`?l^0000
o`0h0003oh2001V000?oP8001h000on0P00JP003o`0002`0003o03P004CoP<20`830P<20`830P<20
`830P<20`830P<20`?o0P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830obh0003o03P0
00?oP8006h000on0P003P003oh2001b000?o0000;0000?l0>000A?n0`830P<20`830P<20`830P<20
`830P<20`830P<3o`830ol20`830P<20`830P<20`830P<20`830P<20`830P<3o;P000?l0>0000on0
P00MP003oh3o022000?o0000;00000807?l37m;o0alDo`<ONOlS00007P037m800alD00<O:P000on0
P00MP0Co7h000ol0000/00007P037m800alD00<O:P007on0`830P<20`830P<20`830P<20`830P<20
`830P<001?l08H3oP<20`830P<20`830P<20`830P<20`830P<20`830o`0^0000o`0h0003oh2001^0
00?oP80018000on0P00KP003o`0002`0003o03P004CoP<20`830P<20`830P<20`830P<20`830P<20
`?o0P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830obh0003o03P000?oP8006H000on0
P008P003oh2001V000?o0000;0000?l0>000A?n0`830P<20`830P<20`830P<20`830P<20`?o0P<20
`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<3o;P0002H00ao200<O90037b8000?oP800
5h000on0P00<P003oh2001N000?o0000;00002H00ao200<O90037b8004CoP<20`830P<20`830P<20
`830P<20`830ol20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830obh0000V00<O
`P037b@00alR0003oh2001F000?oP80048000on0P00EP003o`0002`0003o03P004CoP<20`830P<20
`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830obh0
003o03P000?oP8004h000on0P00DP003oh2001>000?o0000;0000?l0>000A?n0`830P<20`830P<20
`830P<20`?o0P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<3o;P000?l0
>0000on0P00AP003oh2001R000?oP8004H000ol0000/0000o`0h0014oh30P<20`830P<20`830P<20
`?o0P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`?l^0000o`0h0003
oh2000n000?oP80078000on0P00?P003o`0002`0000`00<O[P037cP00alH0014oh30P<20`830P<20
`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`?l^0000
<0037jh00alh00<O60000on0P00=P003oh20022000?oP8003H000ol0000/0000<0037jh00alh00<O
6000A?n0`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20
`830P<20`830P<3o;P000?l0>0000on0P00;P003oh2002B000?oP8002h000ol0000/0000o`0h0014
oh30P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20
`830P<20`?l^0000o`0h0003oh2000V000?oP800:8000on0P009P003o`0002`0003o03P004CoP<20
`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20
`830obh0003o03P000?oP8001h000on0P00/P003oh2000N000?o0000;00003`00anF00<OD0037``0
04CoP<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
oh30P<20`830obh0000l00<OUP037e000al<0003oh2000F000?oP800<8000on0P005P003o`0002`0
000l00<OUP037e000al<0014oh30P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20oh30P<20`?l^0000o`0h0003oh2000>000?oP800=8000on0P003P003
o`0002`0003o03P004CoP<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P?n0`830obh0003o03P000GoP820o`0jP005oh20P?l0;P000?l0>000A?n0
`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`83oP<3o;P000?l0>0000on0o`0nP003oh3o02h0001:00<ON`037f/00al0@<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`802obh0001:00<O
N`037f/00am2obh0001:00<ON`037f/00am`0000o`2Z0000o`2Z0000o`2Z0000F@037e`00ao^0000
F@037e`00ao^0000F@037e`00ao^0000o`2Z0000J@037c`00aon0000J@037c`00aon0000J@037c`0
0aon0000N@037`d00al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000
o`2Z0000o`2Z0000


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d000d3L000?@0000<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d1lO01l00]0d0003d0000080
0]0d0003d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00
00050003d000030000G@7alO00037`03d000030000?@00001@000m00000`0003d00003@0000I0003
d00002d00]090003d00002d00]090003d00002d00]090003d00002d00]001@0O7al000<O00<0d000
;P02d0T000?@0000;P000m00000e00006P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002`000?@0000
=P0001/00]0Y00;@3P02d2T00]0>00?@:002d0h00m0X00;@0P037`@00al200?@:002d0h00m0Y00;@
>@0001d00]0U00;@4P02d2H000?@00004@000m00000T0003d000014000?@000090000m00000200<O
10037`D000?@000090000m00000A0003d00002@00]0900?o;`0001l000?@00008@000m00000D0003
d000028000?@00004`000m00000R0003d00001<000?@00008P000m00000300<O10037`H000?@0000
8P000m00000C0003d000028000?@00001005o`:000?o0000;@0002000]0O00;@6002d2000]0G00;@
8002d1L00]0P00;@5`03d1l00]0G00?@7`02d0801Ol01X30P<20`0;o;`0002800m0J00;@7003d1X0
0m0K00?@6P03d1/00m0J00?@7002d1X00m0L00;@6P03d0Co2X001?n0P?l^00009@02d1D00m0Q00;@
5P02d2400]0F00;@8@03d1D00]0Q00?@5@02d2400m0E00;@0ol04/20`830P<20`830P<20oh30obh0
000?00<O5@05d0/01M0V00G@2`06d2D01M0;00K@9P04d0/01]0=00<O1@037`h01=0;00K@9P05d0X0
1]0BP005oh20P?l0;P0000l00alJ00_@<00;d3002m0`00_@4`037`D00alB00_@<@0:d00Mol20`830
P<20`830P<20`830P<20`83oP<20`?l0;P0000l00aoY00<O1@037e001OlJP003oh2000>000?o0000
:`000?l0D`04o`0VP<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P?l]0000o`1>00Go
8H000on0P005P003o`0002/0003o04T01Ol0;l20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20oh30P<20`83o02d0003o04D01?lZP003oh2000N000?o0000:P000?l0@005o`0iP<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<3o02`0000?00<O
jP037`<00ale00Go<X000on0P008P003o`0002X0000?00<OjP037`<00alc00;o04>0`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<3o02`0
000?00<OjP037`<00alc0004oh3ooc>000?oP8002X000ol0000Z0000o`0i0016ol20`?o0P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20ob/0
003o03X000CoP8200_l_P003oh2000b000?o0000:@000?l0>P001_n0`830P0;o03g0P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`83o02/0003o03X0
00?oP8001H000on0P00YP003oh2000f000?o0000:@000?l0>P002On0`830P<20`002o`0kP<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`?l0:P000180
0aoZ00<O=`000on0P008P0;o9X000on0P00?P003o`0002P0000B00<OjP037cP004Go`830P<20`830
P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`?l0
:P0001800aoZ00<O>0000on0P00:P0;o8H000on0P00AP003o`0002P0003o03/000oo`830P<20`830
P<20`8000_l0=L20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20
`83o02T0003o03/000?oP8003X000on0P00KP003oh2001>000?o00009`000?l0?0004On0`830P<20
`830P<20`83000;o03:0`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830
P<20obT0003o03`000?oP8004802oaR000?oP80058000ol0000W0000o`0l0016oh30P<20`830P<20
`830P<20`830ol20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830obP0
003o03`000?oP8004h02oa>000?oP8005h000ol0000V00005`037n000al700<O=0006?n0`830P<20
`830P<20`830P<20`830P0;o02c0P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20
`830obP0000G00<Oh0037`L00ale0003oh2001J000?oP8003H000on0P00HP003o`0002H0000G00<O
h0037`L00ale000Jol20`830P<20`830P<20`830P<20`830P<02o`0ZP<20`830P<20`830ol20`830
P<20`830P<20`830P<20`830P<20`83o9`000?l0?@000on0P00IP0;o2X000on0P00JP003o`0002D0
003o03d004Ko`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`83oP<20`830P<20`830
P<20`830P<20`830P<20`83o9`000?l0?P000on0P00KP0;o1H000on0P00LP003o`0002D0003o03h0
023oP<20`830P<20`830P<20`830P<20`830P<20`830P0;o02?0P<3o`830P<20`830P<20`830P<20
`830P<20`830P<20o`0W0000o`0n0003oh2001n000?oP?l088000ol0000T00000P0Lo`<Od_l37aCo
0amiob<0000N00<OdP037a@00al`0003oh2001n01?lOP003o`0002@0000N00<OdP037a@00ala000Q
ol20`830P<20`830P<20`830P<20`830P<20`830P<2000?o0260ooo0P<20`830P<20`830P<20`830
P<20`830P<20`?l09P000?l0?`000on0P00MP003oh2000B00_lLP003o`0002<0003o03l004Ko`830
P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P?n0`830P<20`830P<20`830P<20`830
P<20`83o9@000?l0?`000on0P00LP003oh2000R00_lIP003o`0002<0003o040004GoP<20`830P<20
`830P<20`830P<20`830P<20`?o0P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P?l0
9@0002H00ao200<O90037bX000?oP8006X000on0P00<P0;o5h000ol0000R00009P037l800alT00<O
:P00;_n0`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`802o`0F`830P<20
`830P<20`830P<20`830ob@0000V00<O`P037b@00alZ0003oh2001R000?oP8004X000on0P00BP003
o`000280003o0400037oP<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20
`83000;o01>0`830P<20`830P<20`830P<3o02@0003o044000?oP8005X000on0P00FP003oh200120
00?o00008@000?l0@@00<oo0P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830
P<20`830P002o`0A`830P<20`830P<20`830P?l08`000?l0@@000on0P00EP003oh2001Z00_l>P003
o`000240003o044004Ko`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830
P<20`830P<20oh30P<20`830P<20`83o8`000?l0@P000on0P00BP003oh2001n00_l<P003o`000200
000`00<O[P037cP00alR0016oh30P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20
`830P<20`830P<20`830ol20`830P<20`830ob80000`00<O[P037cP00alR0003oh20016000?oP800
8h02o`V000?o0000800003000an^00<O>0037b8003coP<20`830P<20`830P<20`830ol20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`802o`08`830P<20`?lR0000o`120003oh200120
00?oP800:8000on0P004P003o`000200003o04<003ko`830P<20`830P<20`830P?n0`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`0;o00J0`830P?lQ0000o`130003oh2000f0
00?oP800;H000on0P002P003o`0001l0003o04<0047o`830P<20`830P<20`830ol20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P002o`03`83o0240003o04<000?oP800
38000on0P00aP0?o8@0003`00anF00<OD0037aP004CoP<20`830P<20`830ol20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P0;o800003`00anF00<OD0037aP0
00?oP8002X000on0P00cP0?o800003`00anF00<OD0037aP003koP<20`830P<20`83oP<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P0Go8`000?l0A0000on0P008P003
oh2002^01OlX0000o`14000doh30P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P0Go;@000?l0A@000on0P006P003oh2002>01?lb0000o`15000Zol20`830P<3o`830
P<20`830P<20`830P<20`830P<20`830P<20`8301Olf0000o`150003oh2000F000?oP8006X05oc/0
001:00<ON`037f/00al;000Qol20`830P?n0`830P<20`830P<20`830P<20`830P<2000Co@00004X0
0amk00<OJ`037``000?oP8000X000on0P00CP0GoA00004X00amk00<OJ`037``001KoP<20`?o0P<20
`830P<20`830P<201Om90000o`160005oh20P?l03805odh0003o04H000goP<3o`830P<20`83000Co
D`000?l0AP001?n0P?l4P0GoE`0005T00amL00<ORP037`GoG00005T00amL00<ORP037f40001I00<O
G0037hX00amQ0000o`2Z0000J@037c`00aon0000J@037c`00aon0000J@037c`00aon0000N@037`d0
0al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000o`2Z0000o`2Z0000



\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d000d3L000?@0000<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d1lO01l00]0d0003d0000080
0]0d0004d00000;o<00001P000?@0000<0000m0000050003d000030000?@00001@000m00000`0003
d00000D000?@0000<0001M0O7al000<O00?@0000<0000m0000050003d000030000?@00000_l00l3o
000_00006@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@00D07alO
00037`030=0002h00]090003d00002h000C@oooo0X000on0o`0_00006P000m00000[0003d00000X0
00?@0000:`000m00000:0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00
000:0003d00002`000[@oh30P<20oh3o;`0001/00]0Y00;@3P02d2T00]0>00?@:002d0h00m0X00;@
0P037`@00al200?@:002d0h00m0Y00;@1h001?n0P?l^00007@02d2D00]0B00;@9P000m00000A0003
d00002@000?@00004@000m00000T0003d00000800al400<O1@000m00000T0003d000014000?@0000
9002d00=P<20`830P<3o`830o`0^00007`000m00000Q0003d00001@000?@00008P000m00000C0003
d000028000?@00004`000m00000R0003d00000<00al400<O1P000m00000R0003d00001<000?@0000
8002o`03d82000R000?oP8000X000ol0000[00008002d1l00]0H00;@8002d1L00]0P00;@5`02d200
0]0G00?@7`02d1L00m0M00;o0]004L20`830P<20`83oP<20`83o02d0000R00?@6P02d1`00m0J00?@
6`03d1X00m0K00?@6P03d1`00]0J00?@7002d1T000Cod=3@38000on0P003P003o`0002/0000U00;@
5@03d2400]0F00;@8@02d1H00]0Q00?@5@02d2400m0E00;@8@03d1@001[od=20`830P<20`830P<20
`83oP<20`830ob`0000?00<O5@05d0/01M0V00G@2`06d2D01M0;00K@9P04d0/01]0=00<O1@037`h0
1=0;00K@9P05d0X01]0@P003oh2000F000?o0000:P0000l00alJ00_@<00;d3002m0`00_@4`037`D0
0alB00_@<@0:d0;o01j0`830P<20`830P<20`830P<20`?o0P<20`830P?l[00003`037nT00al500<O
EP02oaF000?oP8001h000ol0000Y0000o`1J00?o02>0`830P<20`830P<20`830P<20`830P?n0`830
P<20`830o`0Z0000o`1H00;o6X000on0P008P003o`0002P0003o05H00_l0:L20`830P<20`830P<20
`830P<20`830P<20`?o0P<20`830P<20`83o02T0003o05@00_lMP003oh2000Z000?o00009`000?l0
D@03o`0^`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830obP0000?00<O
jP037`<00am900;o8H000on0P00<P003o`0002H0000?00<OjP037`<00am700;o03>0`830P<20`830
P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`?l0:00000l00aoZ00<O0`037dD0
0_lTP003oh2000j000?o00009@000?l0B003o`0hP<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<3o`830P<20`830P<20`830P?lW0000o`1600;o:8000on0P00@P003o`0002@0003o04@0
0_l0?/20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20
`830P<3o9P000?l0@P02obb000?oP8004H000ol0000S0000o`0o00?o04?0P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`83o02D0000B00<O
jP037cX00_l`P003oh2001>000?o00008P0001800aoZ00<O>@02o`18`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<3o90000180
0aoZ00<O>@000on0o`02obf000?oP8005H000ol0000Q0000o`0m0004ol20`0?o04?0P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`83o02<0
003o03d000?oP8001803obJ000?oP8005h000ol0000P0000o`0n0009oh30P<20`83000;o03n0`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`?l0
8P000?l0?P000on0P008P0?o8H000on0P00GP003o`000200003o03l000go`830P<20`830P<2000?o
03Z0`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`83o
8@000?l0?`000on0P00=P0?o6X000on0P00IP003o`0001l0000G00<Oh0037`L00alg000Col20`830
P<20`830P<20`830P002o`0f`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20
`830P<20`830P<3o800001L00aoP00<O1`037cP000?oP8004H03oaB000?oP8006h000ol0000N0000
5`037n000al700<O>0005on0`830P<20`830P<20`830P<20`83000?o0370P<20`830P<20`830P<20
`?o0P<20`830P<20`830P<20`830P<20`830P<20`83o01l0003o044000?oP8005X03o`f000?oP800
7H000ol0000M0000o`11000Lol20`830P<20`830P<20`830P<20`830P<20`0;o02f0`830P<20`830
P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`?l07P000?l0@P000on0P00JP0?o1h000on0
P00OP003o`0001`0003o0480023oP<20`830P<20`830P<20`830P<20`830P<20`830P0?o02R0`830
ol20`830P<20`830P<20`830P<20`830P<20`830P<20`83o7@000?l0@`000on0P00OP0?o00>0oh00
8H000ol0000K00000P0Lo`<Od_l37aCo0amio`06P<20`83o7@0001h00aoB00<O50037cH000?oP800
8806ob2000?o00006P0001h00aoB00<O50037cH002?oP<20`830P<20`830P<20`830P<20`830P<20
`830P<20`003o`03`83000?o01k0P<20`830P<20`830P<20`830P<20`830P<20`?lL0000o`140003
oh20022000?oP8001X03oa^000?o00006@000?l0A@00;_o0P<20`830P<20`830P<20`830P<20`830
P<20`830P<3o`830P<20`830P<02o`0JP<20`830P<20`830P<20`830P<20`830P?lK0000o`150003
oh2001j000?oP8003803oaN000?o000060000?l0AP00<_n0`830P<20`830P<20`830P<20`830P<20
`830P<20oh30P<20`830P<20`830P<200ol05H30P<20`830P<20`830P<20`830o`0J00009P037l80
0alT00<O<0000on0P00LP003oh2001>00olBP003o`0001L0000V00<O`P037b@00ala000gol20`830
P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P002o`0A`830P<20
`830P<20`830P?l06@0002H00ao200<O90037c4000?oP8006h000on0P00HP0?o3X000ol0000F0000
o`18000koh30P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20
`830P<000ol03<20`830P<20`830oaP0003o04P000?oP8006H000on0P00OP0?o28000ol0000F0000
o`190010ol20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`0;o00R0`830P<20oaL0003o04T000?oP8005h000on0P00UP0?o18000ol0000E0000
o`1:0014oh30P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`803o`03P<3o01H0003o04X000?oP8005H000on0P00/P0?o5P0003000an^00<O
>0037bX004WoP<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`83000;o5@0003000an^00<O>0037b/000?oP8004h000on0P00]P0;o
5`0003000an^00<O>0037b/004?o`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<2000?o6@000?l0C0000on0P00BP003oh2002R00_lL0000
o`1<000noh30P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`802oah0003o04d000?oP80048000on0P00UP0;o80000?l0C@00>?o0P<20`830P<20`830
P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8300olR0000o`1>0003oh2000j0
00?oP8008H02obD0000l00<OUP037e000alR000coh30P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`830P<20`830P<20`83000;o9`0003`00anF00<OD0037b<000?oP80038000on0P00NP0;o
:@0003`00anF00<OD0037b<002go`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830
P<20`8000ol[0000o`1?0003oh2000b000?oP8006H02obh0003o050002SoP<20`830P<20`830ol20
`830P<20`830P<20`830P<20`830P<200_l`0000o`1@0003oh2000Z000?oP8005H03oc80003o0540
02;o`830P<20`830P?n0`830P<20`830P<20`830P<20`8300_le0000o`1A0003oh2000R000?oP800
4X02ocL0001:00<ON`037f/00alH000Moh30P<20`830P?n0`830P<20`830P<20`830P<000_li0000
BP037g/00am[00<O60000on0P006P003oh2000j00olk0000BP037g/00am[00<O6@005oo0P<20`830
ol20`830P<20`830P<2000;o?P000?l0D`000on0P004P003oh2000^00_m00000o`1D000Boh30P<20
oh30P<20`830P<200_m20000o`1D0003oh2000>000?oP8001X03od@0001I00<OG0037hX00al;000=
oh30P<3o`830P<20`002odL0001I00<OG0037hX00al<0005oh20P?l01H02odT0001I00<OG0037hX0
0al<0008ol20oh30P<02od/0003o05H000CoP?n00om=0000J@037c`00anZ00<O00?o0000CP0006T0
0all00<OZP037e40001Y00<O?0037jX00amA0000N@037`d00al<00<Oo`0?0000N@037`d00al<00<O
o`0?0000N@037`d00al<00<Oo`0?0000o`2Z0000o`2Z0000


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d000d3L000?@`?l0<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d1lO01l00]0d0003d0000080
0]0c0004om20P0;o<@0001P000?@0000<0000m0000050003d000030000?@00001@000m00000`0003
d00000D000?@0000<0001M0O7al000<O00?@0000<0000m0000050003d00002l000Sod<20`?o0oc00
000I0003d00002d00]090003d00002d00]090003d00002d00]090003d00002d00]001@0O7al000<O
00<0d000;P02d0T000?@0000;@000oo@P002P005oh20P?l0;`0001X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002/000?@0000
2P000m00000Z00;o00[@`830P?n0`83o;`0001/00]0Y00;@3P02d2T00]0>00?@:002d0h00m0X00;@
0P037`@00al200?@:002d0h00m0X0003om3@00F000?oP8000X000ol0000/00007@02d2D00]0B00;@
9P000m00000A0003d00002@000?@00004@000m00000T0003d00000800al400<O1@000m00000T0003
d000014000?@00008`004Oo@d830P<20`83oP<20`83o02d0000O0003d000024000?@000050000m00
000R0003d00001<000?@00008P000m00000C0003d000028000?@00000`037`@00al60003d0000280
00?@00004`000m00000Q0003om2000R000?oP80018000ol0000Z00008002d1l00]0H00;@8002d1L0
0]0P00;@5`02d2000]0G00?@7`02d1L00m0N000Eom3@`830P<20`830ol20`830P<3o02`0000R00?@
6P02d1`00m0J00?@6`03d1X00m0K00?@6P03d1`00]0J00?@7002d1X00m0;P003oh2000J000?o0000
:@0002D00]0E00?@8@02d1H00]0Q00;@5P02d2400m0E00;@8@03d1D00]0Q00?@5@02d00Iol20`830
P<20`830P<3o`830P<20`830o`0Z00003`037aD01M0;00G@9P05d0/01]0U00G@2`06d2H01=0;00K@
3@037`D00al>00C@2`06d2H01M0:00K@0_l>P003oh2000N000?o0000:00000l00alJ00_@<00;d300
2m0`00_@4`037`D00alB00_@<@0:d0D001goP<20`830P<20`830P<20`?o0P<20`830P<20o`0Y0000
3`037nT00al500<OF`02oa6000?oP8002H000ol0000V0000o`1Q000Rol20`830P<20`830P<20`830
P?n0`830P<20`830P<20obL0003o060000?oP8004H000on0P00;P003o`0002D0003o05h00_l09<20
`830P<20`830P<20`830P<20oh30P<20`830P<20`830obH0003o05d000?oP80058000on0P00=P003
o`0002<0003o05/00_l0:H30P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<3o02@0
000?00<OjP037`<00amD0003oh2001N000?oP8003X000ol0000R00003`037nX00al300<ODP02o`0]
`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`83o02<0000?00<OjP037`<0
0amA0003oh2001V000?oP8004H000ol0000P0000o`1F000coh30P<20`830P<20`830P<20`830P<20
`830P<3o`830P<20`830P<20`830P<20`83o0240003o05@00_lMP003oh2001:000?o00007`000?l0
D`00=oo0P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`?l0
80000?l0D@02oan000?oP8005H000ol0000M0000o`1@000loh30P<20`830P<20`830P<20`830P<20
`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<3o7P0001800aoZ00<OB`02ob:000?oP800
5X000ol0000L00004P037nX00am:0010ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P?n0`830P<20`830P<20`830P<20`830P<20oad0000B00<OjP037dT000?oP8008h000on0P00HP003
o`0001X0003o04X00_l0@/20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20
`830P<20`830P<20`830P<20`830oa`0003o04T000?oP8009H000on0P00JP003o`0001T0003o04L0
0_l0Ah30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830
P<20`830P<20`830P<3o01X0003o04H000?oP800:8000on0P00LP003o`0001L0003o04D004co`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830
P<20`830P<20`83o6@000?l0@`02obb000?oP8007H000ol0000F00005`037n000al700<O>P00DOn0
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20
`830P<20`830P<20`830P<20o`0G00005`037n000al700<O>@04ob^000?oP80088000ol0000D0000
5`037n000al700<O>@001?o0P<07o`18`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<3o5P000?l0@P000on0P007P0Ko7X000on0
P00QP003o`0001<0003o04<000oo`830P<20`830P<20`8001ol0?H30P<20`830P<20`830P<20`830
P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?l050000?l0A0000on0P00BP0Oo
48000on0P00SP003o`000140003o04@001coP<20`830P<20`830P<20`830P<20`830P<201_l0<L20
`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?l04`000?l0A@000on0
P00NP0Oo0X000on0P00UP003o`000100000201co0aoBo`<O5?l37gWo01:0`830P<20`830P<20`830
P?lA00007P037m800alD00<O>@000on0P00TP0?o0X06oan000?o00003`0001h00aoB00<O50037cT0
02Oo`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8000ol02830P<20`8301_l06h30
P<20`830P<20`830P<20`830P<20`830o`0@0000o`180003oh2002B000?oP8003H06oaF000?o0000
3@000?l0B@00??o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830
P<20`830P<20`0Go01;0P<20`830P<20`830P<20`?l>0000o`190003oh2002:000?oP8006H06o`^0
00?o000030000?l0BP00A_n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20
`830P<20`830P<20`830P<20`830P<20`806o`07`830P<20o`0=00009P037l800alT00<O=@000on0
P00PP003oh2002F01_l00h3o000;00009P037l800alT00<O=P00D?n0`830P<20`830P<20`830P<20
`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
0ol;00009P037l800alT00<O=P000on0P00OP003oh2002^000?o00002`000?l0C@00COo0P<20`830
P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<2000;o3P000?l0CP000on0P00LP003oh2002V000?o00003P000?l0C`00B_o0P<20`830
P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`83o4@000?l0C`000on0P00KP003oh2002J00_lB0000o`1@0016oh30P<20`830P<20`830P<20
`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830oa@0003o0540
00?oP8006H000on0P00SP0;o5@0003000an^00<O>0037c80047oP<20`830P<20`830P<20`830P<20
`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20o`0G0000<0037jh00alh00<O
<P000on0P00GP003oh2002600_lH0000<0037jh00alh00<O<`00?Oo0P<20`830P<20`830P<20`830
P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`?l06P000?l0E0000on0P00EP003
oh2001n000?o00006@000?l0E@00=oo0P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830
P<20`830P<20`830P<20`8000_lL0000o`1E0003oh2001B000?oP80078000ol0000L0000o`1F000c
oh30P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`83000;o7`000?l0
E`000on0P00BP003oh2001V000?o00007`0003`00anF00<OD0037b/0037o`830P<20`830P<20`830
P<20`?o0P<20`830P<20`830P<20`830P<20`830P<3o0280000l00<OUP037e000al/0003oh200120
00?oP8005h02ob<0000l00<OUP037e000al]000/ol20`830P<20`830P<20`830ol20`830P<20`830
P<20`830P<20`830P?lU0000o`1J0003oh2000j000?oP8005802obH0003o05X002SoP<20`830P<20
`830P<20`?o0P<20`830P<20`830P<20`830P<3o:0000?l0F`000on0P00=P003oh2001600_lY0000
o`1L000Soh30P<20`830P<20`830ol20`830P<20`830P<20`830P?l0:`000?l0G@000on0P00:P003
oh20012000?o0000:P0004X00amk00<OJ`037b<001ko`830P<20`830P<20oh30P<20`830P<20`830
P<02obd0001:00<ON`037f/00alT0003oh2000V000?oP8003H000ol0000]0000BP037g/00am[00<O
9@006Oo0P<20`830P<20oh30P<20`830P<20`8000_l`0000o`1P0003oh2000N000?oP8002X000ol0
000`0000o`1P000Eoh30P<20`830P?n0`830P<20`83000;o<`000?l0H@000on0P005P003oh2000R0
00?o0000<`0005T00amL00<ORP037aT001;oP<20`830ol20`830P<20`?lf0000F@037e`00an:00<O
6@000on0P004P003oh2000F00_lg0000F@037e`00an:00<O6P003_o0P<20`?o0P<20`83o>@000?l0
I0000on0P002P003oh2000:00_lj0000J@037c`00anZ00<O30002Oo0P<3o`830o`0l0000J@037c`0
0anZ00<O30001On0P83o00:000?o0000>`0006T00all00<OZP037`d000CoP?n00_ln0000N@037`d0
0al<00<ObP037`03o`0003h0001i00<O3@037``00ao:00<O@@0007T00al=00<O30037lX00am10000
o`2Z0000o`2Z0000


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@00?o0000
;`0001D000?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d000d3L000G@`?o0
o`0`00005P02d3@000?@00000P02d3@000?@00000P02d3@000?@00000P02d3@000G@7al07`02d3@0
00?@00000P02d3@000C@P83o0X000ol0000]000060000m00000`0003d00000D000?@0000<0000m00
00050003d000030000?@00001@000m00000`0005d1lO7`000al00m00000`0003d00000D000?@0000
<0002M30P<3o`830o`0^00006@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00
000]00;@00D07alO00037`030=0002h00]090003d00002h000?@P8000X000on0P002P003o`0002/0
000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002/0
00?@00002P000m00000[0003d00000X000?@0000;0003M30P<20`?o0P<20`?l0;00001/00]0Y00;@
3P02d2T00]0>00?@:002d0h00m0X00;@0P037`@00al200?@:002d0h00m0Y00;@1X000on0P004P003
o`0002T0000M00;@9@02d1800]0V0003d000014000?@000090000m00000A0003d00002@000?@0000
0P037`@00al50003d00002@000?@00004@000m00000T00;@017o`830P<20`?o0P<20`830o`0Z0000
7`000m00000Q0003d00001@000?@00008P000m00000C0003d000028000?@00004`000m00000R0003
d00000<00al400<O1P000m00000R0003d00001<000?@00008P000m00o`08P003oh2000J000?o0000
9`0002000]0O00;@6002d2000]0G00;@8002d1L00]0P00;@5`03d1l00]0G00?@7`02d00F0?o0P<20
`830P<3o`830P<20`830obP0000R00?@6P02d1`00m0J00?@6`03d1X00m0K00?@6P03d1`00]0J00?@
7002d1X00m020003oh2000R000?oP80028000ol0000U00009@02d1D00m0Q00;@5P02d2400]0F00;@
8@03d1D00]0Q00?@5@02d2400m0E00;@10006Oo0P<20`830P<20`?o0P<20`830P<20`?l09P0000l0
0alE00G@2`05d2H01M0;00K@9@05d0/01]0V00C@2`06d0d00al500<O3P04d0/01]0V00G@2P06d0D0
00?oP8002X000on0P00:P003o`0002<0000?00<O6P0;d3002m0`00_@<00;d1<00al500<O4P0;d340
2]0:000Mol20`830P<20`830P<3o`830P<20`830P<20`?l0900000l00aoY00<O1@037f4000?oP800
38000on0P00<P003o`000240003o06H00_l08<20`830P<20`830P<20`?o0P<20`830P<20`830P<3o
8P000?l0I@000on0P00?P003oh2000j000?o00007`000?l0I0009_n0`830P<20`830P<20`830P<3o
`830P<20`830P<20`830P<3o80000?l0H`000on0P00AP003oh20012000?o00007@000?l0HP00:_n0
`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830oah0000?00<OjP037`<00amK0003
oh2001>000?oP8004X000ol0000K00003`037nX00al300<OFP00;_n0`830P<20`830P<20`830P<20
`830ol20`830P<20`830P<20`830P<20`?lL00003`037nX00al300<OF@000on0P00EP003oh2001B0
0_lJ0000o`1N000coh30P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20
`83o01T0003o05d000?oP8005h000on0P00GP003o`0001H0003o05`003OoP<20`830P<20`830P<20
`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`83o01L0003o05/000?oP8006H000on0
P00IP003o`0001@0003o05X003_oP<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20
`830P<20`830P<20`830P<20o`0E00004P037nX00amF0003oh2001^000?oP8006h000ol0000B0000
4P037nX00amE000ooh30P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20
`830P<20`830P<20`83o01<0000B00<OjP037e<00_lOP003oh2001f000?o000040000?l0E@00A?o0
P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830
P<20`83o4@000?l0E0000on0P00PP003oh2001n000?o00003P000?l0D`00B?o0P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20o`l0
003o058000?oP8008X000on0P00QP003o`0000`0003o054004co`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83o3@000?l0
D0000on0P00TP003oh2002>000?o00002P0001L00aoP00<O1`037dL0053o`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20o`/0000G00<Oh0037`L00am60003oh2002J000?oP8009H000ol0000800005`037n000al700<O
A@00E?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20o`T0003o04`000?oP800:8000on0P00WP003o`0000H0
003o04/005So`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83o1`000?l0BP000on0P00ZP003oh2002V0
00?o000010000?l0B@00G?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83o1@000?l0B0000on0
P00/P003oh2002^000?o00000P0000807?l37m;o0alDo`<OVOl300007P037m800alD00<O>`000on0
P00ZP0?o:h000ol0000300007P037m800alD00<O?000;?n0`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<200ol0:h30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`?l01P000?l0B`000on0P00YP003oh2002R000?o00001@000?l0C000E_n0`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<3o20000?l0C@000on0P00WP003oh2002J000?o00001`000?l0CP00D_n0`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`?l:00009P037l800alT00<O>@000on0P00UP003oh2002B000?o00002@0002H0
0ao200<O90037cX004koP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`?l<00009P037l800alT00<O>`000on0P00SP003
oh2002:000?o00002`000?l0DP00B_n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o3P000?l0D`000on0P00QP003oh200220
00?o00003@000?l0E000A_n0`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20
`830P<20`830P<20`830P<20`830P<20`?l@0000o`1E0003oh2001n000?oP8007X000ol0000?0000
o`1F0012oh30P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20
`830P<20`830P<3o4P000?l0E`000on0P00MP003oh2001b000?o00004@0003000an^00<O>0037cP0
03koP<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20
`830oa@0000`00<O[P037cP00ali0003oh2001^000?oP8006X000ol0000C0000<0037jh00alh00<O
>P00>_n0`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20
`?lF0000o`1K0003oh2001V000?oP80068000ol0000E0000o`1L000foh30P<20`830P<20`830P<20
`830P<20`830ol20`830P<20`830P<20`830P<20`830P<3o60000?l0G@000on0P00GP003oh2001J0
00?o00005`000?l0GP00<_n0`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20
`830P<3o6P000?l0G`02oaJ000?oP80058000ol0000I0000?0037iH00am@00<O=@00;Oo0P<20`830
P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830o`0L0000?0037iH00am@00<O=P000on0
P00BP003oh2001:000?o00006`0003`00anF00<OD0037cL002Wo`830P<20`830P<20`830P<20`?o0
P<20`830P<20`830P<20`830o`0N0000o`1T0003oh20012000?oP80048000ol0000M0000o`1U000U
ol20`830P<20`830P<20`830ol20`830P<20`830P<20`830o`0P0000o`1V0003oh2000j000?oP800
3X000ol0000O0000o`1W000Qol20`830P<20`830P<20`?o0P<20`830P<20`830P<3o0280003o06P0
00?oP80038000on0P00<P003o`000240001:00<ON`037f/00al_000Mol20`830P<20`830P<3o`830
P<20`830P<20`?l0900004X00amk00<OJ`037c0000?oP8002X000on0P00:P003o`0002<0001:00<O
N`037f/00ala000Iol20`830P<20`830ol20`830P<20`830o`0V0000o`1/0003oh2000R000?oP800
28000ol0000U0000o`1]000Eol20`830P<20`?o0P<20`830P<3o02P0003o06h000?oP8001X000on0
P006P003o`0002L0001I00<OG0037hX00alV000Aol20`830P<3o`830P<20`?l0:P0005T00amL00<O
RP037bL000?oP80018000on0P004P003o`0002T0001I00<OG0037hX00alX000=ol20`830ol20`830
o`0/0000o`1b0003oh2000:000?oP8000X000ol0000[0000J@037c`00anZ00<O6P002Oo0P<3o`830
o`0^0000J@037c`00anZ00<O6`001?n0P?l2P003o`0002d0001Y00<O?0037jX00alL0005ol3o`?l0
<00007T00al=00<O30037lX00al=00<O<@0007T00al=00<O30037lX00al=00<O<@0007T00al=00<O
30037lX00al=00<O<@000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  ShowCellBracket->True,
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->-1,
  AnimationCycleRepetitions->Infinity,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}]
}, Closed]],

Cell[TextData[{
  StyleBox["Square rolling on catenaries.",
    FontWeight->"Bold"],
  "\nStan Wagon"
}], "Text",
  ShowCellBracket->False,
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Playing Sounds", "Subsubsection",
  ShowCellBracket->False,
  CellTags->{"Sound", "Using MathReader"}],

Cell[TextData[{
  "Play a sound by either double-clicking the sound graphic or select the \
sound graphic, or its cell bracket, and then choose",
  StyleBox[" ", "SR"],
  StyleBox[ButtonBox["Play Sound",
    ButtonData:>"Play Sound",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Helvetica"],
  StyleBox[" ", "SR"],
  "from the Cell menu. Click again anywhere to cancel."
}], "Text",
  ShowCellBracket->False,
  CellTags->{"Sound", "Using MathReader"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.588604 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sampled sound
1 string
8192 16384 8
{ currentfile 1 index readhexstring pop }
 false 1 sampledsound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pop
% End of sampled sound
% End of Graphics
MathPictureEnd
\
\>"], "Sound",
  ShowCellBracket->True,
  Evaluatable->False,
  CellHorizontalScrolling->True,
  AspectRatioFixed->True,
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J0000[PP10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?oo6ol00003o`000?l05`01o`0000?o0000
:0001_l0o`3o00;o00<0ool01Ol00`3o0002o`030?oo00co00@0o`3o0P000ol00031007o00000ol0
000R0003o`3o00So00<0ool04ol01P3oo`3o00;o00D0o`3o0002o`030?oo00Ko00<0o`001?nd007o
00000ol0000M0003o`3o00Ko00L0oooo0?l000go00L0o`3o0?l001Go00L0oooo0?l000go00<0ool0
Z@01o`0000?o00006P03o`030?oo00?o00<0ool01?l00`3oo`0Bo`040?ooo`803?l00`3oo`0<o`03
0?l000804?nQ007o00000ol0000G01Go00<0ool04?l01@3o0?l000Oo0P001?l0o`0Ho`030?l001;o
V001o`0000?o00004P0;o`030?l000Go00<0ool09?l00`3o000johd00Ol00003o`0000d0<_l00`3o
o`0io`030?oo01Go=00Loc<00Ol00003o`0000@0W?l506Go3001o`0000?o0?l0oolFo`400Ol00003
o`0000/0Q_lN04Co0P000ol0000N007o00000ol0000A02_o0P001Ol0o`3o00@01Ol00`3oo`0eoi80
0Ol00003o`0001D05_l201Ko00<0ool02?l00`3oo`07o`030?l001ooW001o`0000?o00006@0Bo`03
0?l000801?l200Co00<0ool04?l00`3oo`09o`090?l0o`3o0?l000ooY@01o`0000?o0?l07007o`03
0?oo01Oo00<0o`000P03o`<00ol400Co0`04o`030?oo00[o[`01o`0000?o00008@08o`050?l0o`00
0_l00`3o0006o`030?l000;o00D0o`3o0009o`030?l000co^`01o`0000?o0000:002o`030?l0023o
00<0o`00aP01o`0000?o0000o`0G007o003ooa_o00000ol0003o01L00Ol00003o`0005H000?o0000
1P02o`030?l00;800Ol00003o`0005@000Go0000o`0;0003o`0000@00_nY007o00000ol0001B0003
o`0000@000go0000o`3o0?l0o`3o00<00_l0103ooonW007o00000ol0001E0003o`3o01L000?o0000
Y001o`0000?o0000B`000ol000050003o`00008000Co003o0P000ol000040004o`3oo`L000?o0000
0`000ol0o`2M007o00000ol0001900;o00<0ool00`000ol0000=0003o`3o00d000?o00000_l01@3o
003o09/00Ol00003o`00054000?o00001P000ol0o`020003o`0000@000?o00000`02ojP00Ol00003
o`0004L00_l500;o3P000ol000040003o`00008000?o00001@02o`060?l0o`3oW001o`0000?o0000
?P000ol0o`0?0003o`0001D000Ko0000o`02o`<000?o00001002oiX00Ol00003o`00048000Co003o
4@02oaL000?o00002@000ol0002G007o00000ol0000l0003o`0000L000?o000030000ol000020003
o`3o00T000?o00000P000ol0000300;oX`01o`0000?o0000@`000ol0000=0003o`0001<000?o0000
20002?l0o`3o0?l01_nD007o00000ol0000k0003o`0000`000?o00009P000ol000020009o`3oo`3o
0?l000?oTP01o`0000?o0000@@001?l0ool40003o`0000L000?o0?l030000ol0o`020003o`0000`0
00?o00002`000ol0002?007o00000ol0000o0003o`0000X00_l0103oool50003o`3o00H000?o0000
0`000ol0000;0003o`0000T00_l0103ooon@007o00000ol0000e0005o`3o0?l010000ol000030003
o`3o00;o2002o`T00_l00`3o000J0005o`00o`000_l300;oS`01o`0000?o0000=0000ol000060006
o`00o`3o4`000ol000020003o`000;P00Ol00003o`00038000?o00001`000ol000020003o`0000L0
00Co003o1@001ol0o`3o0?l00P001?l0ool:00;o00<0o`000`000ol000060003o`3o00@000?o0000
0on=007o00000ol000120003o`0000@000So003o0?l0o`<000?o00000P001?l00002o`<000?o0000
10000ol0000300?o20001?l00?l40007o`3o0?l0o`2=007o00000ol0000l0003o`0000/000?o0000
1@000ol0o`060003o`0000@00ol80003o`0000T000?o00002@001?l00?n=007o00000ol0000`0004
o`00o`8000Co00001?l0103o0?l30004o`00o`8000?o0?l02P000ol000020003o`0000;o0P04o`d0
00Go0?l0o`050003o`3o00H00on;007o00000ol0000a0004o`0000;o00<0o`000_l30005o`000?l0
0P001?l00?l500?o10001Ol0003o00<000Co003o0`001Ol0o`3o008000?o00000`02o`<000?o0000
1@001?l00?l400;o0P02ohT00Ol00003o`00038000?o00005P000ol0000@0003o`0001T000?o0000
20000ol0o`020003o`0008T00Ol00003o`0002l00_l30007o`000?l0o`020003o`0000@000?o0000
1`000ol0000D0006o`00o`3o2P000ol0000;00;o1@001?l0oon8007o00000ol0000^0003o`000080
00?o00000`000ol000070003o`0000/00_l80005o`3o0?l00`02o`H000?o00003P02o`/000?o0?l0
0on7007o00000ol0000X0007o`3o0?l0o`060003o`0000D000?o00001@000ol0o`0?0003o`0000`0
00?o0?l04P000ol000030003o`00008000?o0?l00P001Ol0o`3o08H00Ol00003o`0002L000?o0000
5@000ol000060003o`0000`000?o00004P000ol000040003o`0001T000?o0000Q001o`0000?o0000
;@000ol000080003o`0000L000?o0?l020000ol0000800;o00<0ool00`000ol000080004o`3oo`l0
00Co0?oo10002?l0003o0?l00_n6007o00000ol0000U0005o`00o`000_l00`3o00020003o`000080
0_l60003o`3o00<01?l40005o`000?l00P001?l00?l;0003o`0000?o0P000ol0o`0200Co1`000ol0
000600;o0`000ol0o`0200;o00<0o`00Q001o`0000?o0000:@000ol0000;00;o10000ol000020003
o`0000<000?o0?l04P000ol000090003o`0000H000?o00006`000ol00023007o00000ol0000W0003
o`00008000?o000010001?l0ool200Co1P001Ol0003o00<000So0?oo0?l0o`H000?o00001`02o`P0
00?o0?l00P02o`@000?o00000`000ol000040003o`0000@000?o00000on4007o00000ol0000S0003
o`00008000Co003o0P02o`030?l000P000?o0?l00`000ol0000;0003o`0000800_l;0004o`00o`/0
00?o0?l00`000ol0o`090003o`00008000_o0?l0o`3o0?l0o`24007o00000ol0000_0005o`000?l0
0`000ol000090003o`0000H000?o00003`02o`L000?o00000`000ol0o`040003o`0000<000?o0000
4`000ol0o`23007o00000ol0000U0003o`0000H00_l50005o`000?l01@001?l0ool30004o`00o`L0
00?o0?l01@000ol000060003o`0000H00_l01@3o003o008000?o0?l01002o`X000?o0?l010000ol0
00020003o`0008000Ol00003o`00024000?o00000P001?l00?l20003o`0000L000?o000020000ol0
00070006o`000?l00_l00`3oo`040007o`3o0?l0o`0800;o0`001Ol00?l000?o2`001Ol0003o0080
00?o00000_l00`3oo`04oh800Ol00003o`00028000Go0?l0o`030003o`0000@000?o00002`02o`P0
0ol30003o`0000<00_l00`3oo`020003o`0000h000So0000o`3o00;o1P000ol0000:0009o`00o`3o
0?l000;oP@01o`0000?o0000:0000ol000090003o`0000`000?o00005@000ol0000:0003o`3o01@0
00?o0?l01P000ol0000800;oP@01o`0000?o000080001?l00?l300?o00D0o`3o0002o`X000?o0000
10000ol000020003o`00008000Co003o0P000ol000020004o`3o00;o1P001?l00?l:0004o`3oo`80
00Co003o10000ol00003o`<000?o00001002o`050?l00?l0P001o`0000?o000090001?l0ool:00?o
1@000ol00002o`D000?o00002P000ol0o`0300;o00@0o`000ol30004o`3oo`@00_lI0005o`000?l0
0P000ol0o`0200?o00<0o`00OP01o`0000?o00007`000ol0000200Go70000ol0000?0003o`0001D0
00?o00001@02o`d000?o00000P000ol000030004o`3o00;oO`01o`0000?o00007P001ol0003o0?l0
10000ol0000200?o1@02o`8000?o0?l01`000ol000030003o`0000?o1@001ol0003o0?l00P001?l0
0?l20003o`0000H000Co003o0P02o`030?l000;o1`000ol000050004o`00o`8000?o0?l010000ol0
001m007o00000ol0000Q00?o1`002?l0ool0o`3o0P000ol0o`02o`030?oo00L00ol90003o`0000?o
00@0o`3o0`000ol0o`0800;o00<0o`001@001Ol0003o008000Go0000o`0:0003o`0000<000?o0?l0
0`000ol0o`0M00_oE`01o`0000?o00007@001?l00002o``000Go0?l0o`0>00?o20000ol0000?0003
o`00028000Co003o2P000ol00002oa`000Ko003o0?l20005o`3o0?l0EP01o`0000?o000070001_l0
0?l0o`P000Co003o0P001?l00002o`<00_l30003o`0000P000?o00001002o`030?l000D000?o0000
0`000ol0000E0003o`3o00Co3@001Ol0003o00801OlI00;o00<0ool01_l00`3oo`03oe@00Ol00003
o`0001d000Co0?oo0`001Ol0o`3o00801Ol400;o00<0o`000P03o`800_l20003o`0000;o00X0oooo
0?l0o`3o4`03o`8000?o00000P02o`<000Oo0?l0o`3o008000?o0?l02002o`@000?o00000_l30003
o`0001D01Ol01P3oool0o`8000Go0?oo0005oe000Ol00003o`00020000?o00000`000ol0000?00;o
10000ol000080005o`000?l020000ol0o`030004o`3o00Co00@0o`3o1@000ol000080005o`000?l0
3P000ol000030006o`00o`3o6002o`0:0?l0o`3o0?l0o`H000Go003o0002odh00Ol00003o`0001/0
00Co0?oo0P02o`<000?o00000P03o`@000Oo0000o`3o008000?o0?l00P03o`801?l600?o10000ol0
00060003o`3o008000?o00003P001?l0o`05o`030?l000;o1@000ol000020003o`0000D01?lE00;o
00T0o`00o`3o0?l00P000ol0o`020005o`00o`000_l00`3oo`02odX00Ol00003o`0001X000Ko0?l0
o`02o`D000?o00000P02oa000_l00`3o0002o`@00_l00`3o00020003o`3o00L000Co0?oo0`001_l0
0?l0o`P000?o00000`001?l00?l30003o`3o00;o0P000ol0o`0:00?o0`03oa<01Ol01`3oo`3o0?l0
0P02o`030?oo00;o00@0o`3o0P000ol0o`03odT00Ol00003o`0001X00_l20004o`3oo`L000?o0000
1P001Ol0003o008000?o00000P001Ol0003o00<000Oo0000o`3o00@000?o00002002o`@000Co003o
0P001Ol0003o008000?o0?l01?l20003o`3o00<000?o00001P001Ol0o`3o008000?o00000P03o`80
0_lB0006o`3o0?l00_l20004o`00o`P000?o0?l00ol0103o0?m:007o00000ol0000I0003o`0000L0
00?o0?l00`000ol0000C0003o`0000H000?o0?l00P02o`L000?o0?l02`000ol0o`0D0005o`000?l0
40000ol0000300;o00<0o`0040001ol0o`3o0?l00P000ol000050003o`3o008000Co003o1P001?l0
oom7007o00000ol0000I0005o`3oo`000_l40003o`0000800_l0103oool70004o`3oo`H000Co003o
0P000ol000020003o`0000X000?o0?l01@000ol0000400?o10001Ol0o`3o00L00_l300;o1`000ol0
00030003o`3o00800ol00`3oo`0B00Go00H0o`00o`03o`D000?o00001`001Ol0003o00801?m3007o
00000ol0000H00?o10001Ol0003o00@000?o000010000ol000020003o`0000D00_l20003o`0000D0
00Co003o0P02o`P000?o00001@001?l0ool60003o`3o00;o1`03o`040?l0o`800ol40004o`00o`L0
00?o00000P000ol00002o`l00_l20004o`3o00;o0`000ol00004o`070?ooo`3o0002o`<000Co0?l0
0_l00`3oo`02od400Ol00003o`0001T00_l600;o1`000ol000030003o`00008000?o0?l03`000ol0
00060004o`3oo`@000?o00002`001_l00?l0oaL000?o000010000ol0o`020003o`0000<000?o0000
4P04o`050?l00?l00P000ol0000;0003o`3o008000?o0?l01@000ol0o`0200;o?`01o`0000?o0000
5`002Ol0003o0?l0o`0400Go00<0ool00_l20006o`000?l00_l00`3oo`050003o`0000@000Go0000
o`060003o`3o00@000?o00000P02o`<000Go0000o`030003o`0000<000Co003o1`03o`030?oo00`0
00Co00000_l200Go3P09o`<01?l00`3o000;0004o`0000;o00<0o`000`03o`030?oo03d00Ol00003
o`0001H01?l200?o00<0ool00_l00`3o0005o`030?oo00Co00D0o`00o`060003o`3o00;o0`001?l0
o`02o`050?oo0?l00`001_l00?l0o`<000Co003o0P000ol0o`0500;o1`000ol000020003o`000080
0_l20003o`00008000Co003o1002o`<00_l00`3oo`03o`d00_l200?o0`02o`@000Oo0000o`3o0080
00?o0?l010001Ol0003o008000?o00000`02o`030?l003/00Ol00003o`0001P000?o00000ol500;o
3P000ol000060003o`0000L000?o00004`000ol0o`0;0003o`3o00X00ol80003o`0000P000?o0000
1@000ol000020003o`0000/01?l400;o00D0o`00o`040006o`3oo`3o30000ol000020003o`0000@0
00?o0000>P01o`0000?o00005@001?l00003o`<00_l60003o`00008000Co0?oo0`001?l0o`02o`80
00?o00001@03o`H00_l00`3o000400;o0P03o`<000Co0?oo1003o`<000Oo0000o`3o00H000[o003o
0?l0o`3o3002o`8000?o0?l00ol00`3oo`0;00Go0P02o`L00_l20003o`3o00<000?o0?l00ol30006
o`000?l01?l300Ko>001o`0000?o00005003o`8000?o0?l01P001?l00?l50005o`000?l01@001?l0
0003o`8000?o00000_l00`3oo`0200;o0P000ol0000200?o00<0o`000_l20003o`0000@000?o0?l0
0P001ol00?l0o`000_l20005o`000?l02P02o`060?l0o`3o1@001?l00?l50003o`0000?o2`02o`<0
0ol0103oo`04o`<000?o00000`001?l00?l300;o00<0o`000P000ol0000300;o0P02o`030?l000?o
=@01o`0000?o00004`06o`040?l000Go0`03o`@000Co00000_l50003o`0000<00_l00`3oo`020003
o`3o00X000?o00000`000ol00004o`8000?o000010001?l0ool300Ko1`001?l00006o`8000Go0000
o`0600;o00@0ool00_l00`3oo`0;00Oo00<0o`000P000ol000060003o`0000D000?o000010001_l0
ool0o`D00_l20005o`3oo`000olc007o00000ol0000C00Ko0P001?l0o`02o`8000Co00000_l:0005
o`000?l01P000ol000040003o`0000L000?o00001@02o`050?l00?l030001?l0ool30003o`0000@0
0_l0103oool40003o`0000@000Oo0?l0o`3o00@000Co00000ol00`3oo`0900?o1@000ol000040005
o`000?l01@000ol0000:00;o00@0oooo3P000ol0000b007o00000ol0000G0003o`3o00?o1@001?l0
0?l40003o`3o00;o00@0o`000_l30005o`00o`000ol50003o`0000L000Co0?l00_l00`3o00040005
o`000?l010000ol000030007o`3oo`3o0002o`030?oo00<00ol20003o`0000800_l80003o`3o00@0
00?o0?l00`000ol0o`0900?o0P001?l0ool30005o`00o`000ol00`3o0002o`<000?o0000100Bo`<0
0_l200;o<@01o`0000?o00004P09o`090?l0o`3o0?l000?o0P03o`060?l0o`3o0P02o`@00_l30004
o`3oo`8000Co0?oo0`001?l00?l60007o`00o`3o0002o`<000Co0?oo0P000ol00002o`800_l30005
o`000?l010002Ol0003o0?l0o`030004o`00o`<000?o000010000ol00004o`P01_l00`3o000200?o
00<0o`000_l40006o`000?l02?l00`3o0002o`030?oo00Go00@0ool01Ol0103o0003obh00Ol00003
o`00014000Co0?l00_l0103o0?l30005o`3o0?l01002o`@000?o00002003o`P000?o00000P001_l0
0?l0o`H000?o0?l03@000ol000020003o`0000<00_l00`3o00040003o`0000@00_l0103o0002o`X0
0_l30003o`0000?o00<0o`001`000ol0o`030005o`000?l010000ol000040004o`00o`8000?o0?l0
1Ol0103oool20006o`000?l00_l400;o00<0ool00_l400?o;001o`0000?o000040000ol0o`04o`04
0?oo00;o00<0ool00ol60003o`00008000?o0?l00_l30003o`0000D000?o00000P000ol0000300;o
0`03o`D00_l01P3oo`3o00?o0`001?l00?l60003o`00008000Co0?oo10000ol00002o`D00ol50003
o`0000800ol0103o0?l300;o2004o`040?l000;o10001?l00?l900Ko00<0ool01?l20006o`000?l0
0_l0103o0?l20003o`3o00Go00@0ool01?lX007o00000ol0000?00Go00<0ool00ol00`3oo`04o`03
0?oo008000Oo0?l0o`3o00<000So0?oo0?l0o`800ol00`3o000500_o00<0ool00P000ol000030004
o`3o00;o00<0o`000`02o`8000Co003o0P02o`040?ooo`8000?o00001P000ol0o`02o`040?ooo`<0
00?o00000`02o`030?oo00800ol700;o00<0ool01Ol300;o0P000ol000020005o`00o`000_l20004
o`3oo`800_l0103o0?l200;o00L0o`00o`3o00<000Go0?oo0002o`030?oo00?o00@0o`3o9`01o`00
00?o00004002o`030?oo008000?o0?l00_l00`3o0003o`<000Go0000o`040003o`0000H000?o0?l0
1P02o`P000?o0?l00`04o`@000?o00000_l00`3o0002o`@000Co003o0P03o`8000Go0?l0o`020003
o`0000D000Co003o0P000ol0000<0003o`3o008000?o0?l00_l60003o`3o00@000Co00000ol00`3o
0002o`060?ooo`3o0`02o`040?ooo`L00_l30003o`3o00800_l0103oool40003o`0000;o00<0o`00
0_l200?o9@01o`0000?o00003P0>o`<000?o0?l00ol20004o`0000?o0P000ol00002o`801Ol30004
o`0000?o20000ol0o`02o`@000?o0?l00ol01@3o0?l000;o00<0ool00_l50003o`3o00Co00<0o`00
0P001Ol0003o00<00_l00`3oo`06o`040?ooo`H01?l200;o1@05o`030?l000800ol50004o`00o`<0
1?l300;o0P02o`050?oo0?l00P04o`<000Co003o0P000ol0o`03o`<00ol200Co00<0ool08`01o`00
00?o00003@06o`030?oo00[o0`04o`030?l0008000?o0?l01ol200?o00<0ool00P02o`8000?o0?l0
0P001?l0o`04o`8000Ko0?oo0?l200?o0P02o`030?oo00Oo00L0oooo0?l000;o00<0ool00`001?l0
ool40003o`3o00Ko1004o`800_l00`3o0004o`D01?l01@3oool000;o1@02o`8000?o00000P0=o`03
0?l0008000?o0?l00P04o`030?oo00?o00D0o`3o0005o`030?l000?o00<0ool01_lO007o00000ol0
000=00Co0`05o`800_l01`3o003o0?l01`001?l0ool800Ko00<0o`000P02o`030?oo008000Oo003o
0?l000Co1003o`@000?o00000P02o`030?l000@000?o00000_l30003o`00008000So0?oo0?l0o`80
00Co003o0P03o`L00_l40003o`00008000?o00000P03o`D000?o00000P03o`<000?o00000`02o`<0
0_l0103oool50003o`3o00;o0P000ol00002o`050?l0o`001_l00`3oo`05o`060?oo0?l00_l00`3o
o`02oad00Ol00003o`0000`05ol00`3o0003o`030?oo00;o0P001?l00?l200Co0P000ol0o`06o`06
0?l00?l00_l01@3oool000?o0`02o`030?l000;o0`000ol0o`02o`030?oo00@00ol01P3oo`3o00;o
0`06o`040?l0o`800ol00`3o000700Go00<0ool00ol300Oo1004o`030?l000;o1@02o`030?oo00<0
0ol200Go10001?l00008o`030?oo00;o00D0oooo000DoaX00Ol00003o`0000X06ol01P3o003o00Wo
0P07o`060?oo0?l01_l40003o`0000Co00<0ool02ol01@3oool000;o00@0ool01Ol200Ko0P03o`05
0?ooo`000_l200co0P001?l0o`06o`<01Ol200Co00<0ool04Ol00`3oo`0200;o00D0o`3o0009o`05
0?oo0?l00P07o`070?ooo`3o0007o`030?oo00[o5P01o`0000?o0000200?o`050?l0o`003Ol0103o
o`04o`030?oo00[o0P03o`801?l00`3oo`0?o`060?oo0?l01ol01@3oool000Go00<0o`000_l00`3o
o`0;o`030?oo00Ko1P04o`030?l000;o00D0oooo0009o`040?l0o`P01_l01@3oool000Ko0`0@o`03
0?oo00?o0P0Roa400Ol00003o`0000L02ol01@3o0?l000;o0P0;o`<00_l00`3o00030003o`3o00Ko
0`000ol000020003o`3o00Go00<0o`001Ol00`3oo`0200go0`000ol0o`03o`040?oo00Oo00@0ool0
1?l00`3oo`0200?o1003o`030?l000So0`04o`030?oo00Co0`001?l0o`04o`<01Ol20004o`3o00Go
100<o`040?l000Oo00<0ool08ol?007o00000ol0000401Co00<0o`009ol01@3oool003Ko00<0ool0
2Ol00`3oo`20o`X00Ol00003o`3o01?o00<0ool00_l00`3o0002013o00<0ool04ol00`3oo`0Co`03
0?oo02co00<0ool0R_l1007o00000ol0000:o`050?ooo`000_l0103o0?l20005o`3o0?l00`0<o`04
0?oo00[o00<0ool01Ol01@3o0?l000_o00<0ool01_l300Oo00<0ool02Ol00`3o000;o`030?oo01Ko
00<0ool07?l00`3oo`07o`030?l000Wo00L0o`3o0?l000Oo00<0ool0=ol2007o00000ol0000308Ko
00<0ool0Q?l6007o00000ol0000602So00<0ool01ol00`3oo`03o`030?oo00Wo00L0oooo0?l000Oo
00D0oooo000@o`030?oo01Co0P0:o`030?oo00Oo00<0o`001Ol01@3oool000go00<0ool04ol00`3o
o`0:o`030?oo00Go00<0o`009ol=007o00000ol0000800Ko00@0ool01Ol00`3oo`03o`060?oo0?l0
0ol300Co00<0o`000_l0103oool200?o00@0o`3o0P02o`<00ol00`3o0005o`040?oo00Ko00<0o`00
0`001Ol0o`3o008000Co0?oo0`02o`800_l00`3oo`0300Co00<0o`000_l200Go00@0oooo0P000ol0
0004o`050?oo0?l00P02o`801Ol300;o20001?l0o`04o`050?l0o`000ol50003o`3o00Co0P03o`<0
00Ko0?l0o`02o`040?l000Ko00@0ool01Ol01@3oool000_o4P01o`0000?o00002@0Bo`030?oo00Ko
00<0ool00_l200Wo0P07o`030?oo00Wo0P001?l0o`0>o`050?ooo`001?l00`3oo`02o`030?l000Co
00<0ool02Ol00`3oo`05o`030?oo00So0`02o`040?l000Oo0P04o`050?ooo`002_l00`3oo`05o`03
0?l000Oo0P000ol0000Ao`030?oo00?o00<0ool01Ol01P3oo`3o013o5001o`0000?o00002`0Ko`80
2_l400;o00D0oooo0003o`030?oo00Co0`000ol00004o`030?oo00;o00<0ool01?l0103o0?l30003
o`0000?o0`001Ol0ool000;o00<0o`000ol00`3oo`04o`050?l0o`000_l00`3oo`02o`040?l000?o
0P001_l0o`3o00Go0P02o`050?ooo`000ol40003o`0000800ol00`3oo`05o`050?oo0?l00P001?l0
0?l200;o0P06o`030?oo00So00<0o`001Ol00`3oo`0?oaT00Ol00003o`0000`04?l01P3oool0o`<0
0_l20003o`3o00Go10001_l0o`3o00Co00<0o`001Ol30003o`0000;o00<0o`000ol20005o`3oo`00
0ol20003o`3o00Oo00<0o`000P0:o`801?l30003o`3o00;o00<0ool00_l700;o00D0oooo0005o`<0
2?l200Ko1@02o`801?l00`3oo`07o`040?l0o`800_l20003o`0000;o00<0ool04ol20003o`3o00Ko
7001o`0000?o00003@07o`060?ooo`3o0P000ol00002o`030?l000D000Co003o1`000ol0000:0004
o`0000Go0`001Ol0003o008000Co0?oo1`001?l0ool200Co00D0o`00o`0200;o00@0ool00_l30005
o`3oo`000_l30003o`0000Co2P002?l0003o0?l00_l400;o0`001_l00?l0o`<00ol40003o`000080
0ol50004o`0000?o0`001Ol0003o00@01?l00`3o000400Co1`001Ol0ool000?o7`01o`0000?o0000
3@0;o`801?l20003o`3o00;o0P000ol0o`030007o`00o`3o0009o`8000Go0000o`0600;o0P04o`L0
1Ol0103oo`07o`@000Ko0?l0o`06o`<00ol20003o`3o00;o00<0o`000_l500Go00<0o`001ol500Go
00@0oooo0`001?l00003o`<000?o00000P02o`040?oo00Co00<0o`001?l0103oool200;o00D0oooo
0007o`040?oo00Wo00D0ool0o`0P007o00000ol0000?0003o`3o00Go00@0ool00_l20004o`3oo`<0
00Go0?l0o`020008o`3oo`3o0?l200;o00@0ool00_l200;o00H0ool0o`02o`040?l000Co0`001Ol0
ool000Go00@0o`001Ol20005o`00o`000ol200;o20000ol000040003o`3o00;o0`03o`@000Co0?l0
0_l0103oool500?o00@0oooo0P05o`@00_l30003o`0000800_l0103oool30003o`3o00?o00<0o`00
0_l0103o0002o`8000Co00002?l00`3oo`05o`030?l002<00Ol00003o`0000l00ol01P3oool0o`80
00Go0000o`0200?o2@001?l0ool20004o`3o00;o00<0o`0030001?l00?l20003o`3o00;o3@001?l0
ool30003o`0000<00_l30005o`000?l010001ol00?l0o`000_l0103o0002o`d000?o00000ol00`3o
000500;o0`000ol0o`050003o`00008000?o0?l00P000ol0000700;o00<0o`001`000ol000060005
o`000?l01P001?l0ool20003o`3o02L00Ol00003o`0001000_l01P3oo`3o00;o0P02o`030?oo00D0
0ol700;o0`04o`L000Oo003o0?l000Co0P02o`030?l000<00_l0103o0002o`8000?o00001`000ol0
000500?o00@0o`3o0`000ol0o`060003o`3o00?o0`02o`@000?o0?l00P001_l0ool0o`L02?l20003
o`0000;o10001_l00?l0o`802?l20004o`3o00;o00D0o`3o0002o`040?l0o`8000?o0?l02?l20003
o`3o00;o9`01o`0000?o00004@09o`050?oo0?l010001_l0o`3o00;o00<0ool00ol00`3o00030003
o`3o00<000?o00000P02o`8000?o0?l00`02o`030?l0008000?o00000P000ol0o`0300?o1002o`<0
00Oo003o0?l000;o00<0o`000`02o`D000?o0?l01?l00`3o00030003o`0000<00_l40003o`0000;o
2002o`<000?o0?l00_l0103o0002o`<000Co00000_l200Ko00<0ool00_l20003o`0000Co0P06o`03
0?oo00Co00<0o`000ol00`3o000Y007o00000ol0000B0003o`0000H000Ko003o0?l40003o`0000<0
0_l900;o00<0o`000`000ol000050003o`00014000Co003o1@001?l00?l30003o`0000<000Co003o
2@001Ol0003o00<000?o00002P02o`8000Co00000_l00`3o000700?o00P0o`3o0?l0o`@000Go0?l0
o`040003o`0000801_l01`3oo`3o0?l010001?l0ool20003o`3o00Go0P001?l0ool^007o00000ol0
000C00Co0P001Ol0003o00801Ol00`3oo`030005o`000?l00`02o`040?l0o`H00_l40004o`00o`80
00?o00000`000ol00002o`@000?o0?l00ol300;o0`001Ol0003o008000?o00001P001?l0ool30009
o`000?l0o`3o00<00_l300;o0P001?l0ool300;o2@06o`030?l000800_l30005o`3o0?l01002o`80
0ol00`3o0005o`040?oo00;o00@0ool01_l20004o`0000;o<001o`0000?o00004`07o`@000Go0000
o`0400?o00<0o`000`000ol000030003o`0000;o00<0o`000`000ol0000200;o1`000ol0o`0400Co
0`001Ol0003o00H000?o00001?l200?o0P001?l00?l20003o`0000@00_l:0003o`0000<000Co0?oo
0P02o`X00_l300?o00H0o`3o0?l500;o1P000ol0o`0600Go00@0ool00_l00`3oo`0900;o<P01o`00
00?o000050001?l00?l200;o00@0o`3o0P001Ol0003o00<000?o000020000ol0000<0004o`3o00;o
2@000ol000030003o`0000T000Co003o0`000ol0o`03o`800_l40004o`3oo`@00_l20006o`00o`3o
0`000ol0000700;o00<0o`002@000ol0o`02o`<000Go0000o`030003o`0001<01?l20005o`000?l0
0P02o`060?ooo`3o=001o`0000?o00005002o`801Ol20003o`3o008000Ko0?oo0?l300;o0P000ol0
0005o`070?l0o`3o0002o`050?oo0?l01003o`030?l0008000Wo0000o`3o0?l01@000ol0o`02o`@0
0_l01`3oo`3o0?l01`02o`<00_l00`3oo`0:0004o`0000Go00<0ool00_l<00Co0`03o`8000Go0?l0
o`030004o`00o`<000Ko0?oo0?l20003o`00008000Wo0000o`3o0?l00`000ol00003oc@00Ol00003
o`0001D01ol30003o`00008000Co00000_l700;o00<0o`000P000ol0000200;o0`001?l0ool30004
o`00o`@01?l00`3oo`02o`030?oo008000Co003o1`000ol000070003o`0000;o1@000ol00002o`X0
0_l300;o00@0o`3o0P02o``00ol0103oool300;o00<0o`000P001?l00002o`P000?o0?l02@000ol0
o`020003o`3o00Co=`01o`0000?o00005`02o`060?oo0?l01?l200;o00@0o`3o0P001_l0o`3o00?o
0`02o`P000?o0?l00P000ol0o`0400;o0`02o`@000Go003o0003o`L00_l00`3o00040003o`0000<0
00Ko003o0?l300;o0`02o`8000?o000010000ol000020003o`3o00?o3@07o`030?oo00800_l20003
o`0000<00ol01@3oo`3o008000Oo0?oo0?l000;o1@001?l0oolk007o00000ol0000F0004o`00o`80
0ol20005o`00o`000_l@0004o`3ooaP000?o00003@000ol0o`0I0003o`3o00X000Co003o0P000ol0
o`040003o`0000`00ol40003o`0000/000?o00004@02o`030?l003l00Ol00003o`0001T00_l40004
o`0000Co00@0o`3o0`001?l00003o`030?l0008000?o0?l01@000ol0o`0400;o0P001Ol00?l000;o
1`000ol0o`040003o`00008000?o0?l00_l20007o`00o`3o0002o`@000Go0?l0o`020003o`0000L0
00Go0000o`0500Ko3P04o`801?l30003o`0000;o1@001Ol0003o00T000?o00001003ocd00Ol00003
o`0001L00_l0203oo`3o0?l00_l60006o`3o0?l00_l20005o`000?l00`001?l0ool30003o`0000/0
00?o00000P000ol000060005o`00o`000_l00`3oo`0300;o00@0o`3o2002o`040?l0o`H00_l200;o
10001?l00002o`801Ol>00;o0P02o`8000?o0?l00`002?l00?l0o`3o1@04o`030?l000;o00<0o`00
0_l0103ooolo007o00000ol0000K00;o0`02o`X000?o000070001?l00?l200;o0`02o`/000?o0000
4@000ol000020004o`3o00;o2P000ol0o`040003o`3o00@000?o00003P03o`040?l0o`H000?o0000
0`001Ol0003o00L000?o0?l00`001?l00?m2007o00000ol0000H0003o`0000<000Oo0000o`3o00H0
0ol30003o`0000@00_l300;o0`02o`H000?o00000P02o`050?l00?l010000ol0000300;o1P000ol0
o`0900;o00<0ool01P03o`H000?o00000`000ol00002o`8000Co00000_l@00?o0P03o`800_l01P3o
0?l0o`800_l0203o0?l0o`3o0P001Ol0ool000Co@P01o`0000?o00006@001?l0ool300;o0P001?l0
0?l400;o1002o`030?oo00<00_l50003o`0000<000?o00000_l<00;o0P03o`@000Oo0000o`3o00T0
00?o00000`001?l0ool70005o`000?l020001?l00004oa800_l00`3o0002o`050?l00?l00P000ol0
0002o`D000?o0?l01P001?l00?m6007o00000ol0000I0003o`0001<000?o00003003o`030?l000<0
00Co0?l01?l00`3o000A00;o00<0o`000_l:0003o`0000L000?o0?l00`001?l00?l30003o`3o00/0
00?o00003`000ol0o`02o`8000Co003o2P000ol000040004o`3o00?oB001o`0000?o00006P02o`80
00?o00000P001?l00?l40003o`0000;o00<0o`004@02o`030?l000@00_l200;o10000ol0000400?o
1P02o`@000?o00000_l20003o`00008000Co0?oo0P000ol0000;0005o`3oo`000ol300;o4P03o`03
0?oo008000Go003o0002o`<00_l00`3o0002o`050?l00?l00P000ol00017007o00000ol0000M00;o
00@0o`3o0P001_l00?l0o`<000?o0?l020000ol0000300;o0`001Ol0003o00800_l20004o`00o`T0
00Co003o0P000ol00002o`8000Go0000o`080003o`0000@000?o0?l00P000ol000060003o`0000D0
00Co00000_lD00Ko00<0ool00P001?l00?l30004o`00o`801?l00`3oo`1:007o00000ol0000J0003
o`0000Co00P0ool0o`3o00;o00<0ool00`02o`@000?o00000P000ol0o`020005o`000?l010001?l0
0?l<0003o`0000D01?l;00;o00L0o`3o0?l000Go00<0o`001002o`8000Ko003o0?l20003o`3o00;o
00<0o`005003o`030?oo008000?o0?l00`02o`040?oo00SoC001o`0000?o00006`000ol0000:00;o
2@02o`050?oo0?l00`000ol000090004o`00o`T000Co003o0P02o`T000?o000050000ol0o`020003
o`0000X000?o00007@03o`030?l000<00_l20003o`0000<000?o0?l0D001o`0000?o000080000ol0
00050004o`3o00;o0P001?l00003o`8000Co0?l00_l00`3o0002o`040?ooo`H00_l50004o`00o`@0
00Go0?l0o`0300;o10000ol0000;0003o`3o00?o2P000ol000020004o`00o`8000Co003o6@05o`03
0?oo00;o00D0o`3o0003oe<00Ol00003o`0001`00_l20005o`000?l00`000ol00002o`D000Co003o
1P001?l00005o`<000?o00002@001?l00?l200;o0`02o`@000?o00000`001Ol0003o008000?o0000
0P001Ol0o`3o00<000?o000010001?l00?l20003o`3o008000?o00001?lI00Co00@0o`3o0P02o`80
0_mE007o00000ol0000`0004o`00o`<000?o00000P000ol0o`0:0003o`3o00`000?o00006@04o`80
00?o000020000ol000040003o`0000@00_lO00Oo0P02oeL00Ol00003o`0001l000?o0?l00`000ol0
00020003o`0000?o1P001Ol0003o00T00_l90003o`3o008000?o00000`001?l00?l20003o`0000`0
00Co003o1@02oa@000Co0?l00ol00`3o000P00;o00<0ool0F@01o`0000?o00007P02o`L000?o0000
1002o`/000?o000020000ol000040003o`0000P00_l40003o`0000<000?o000010001Ol0o`3o00@0
00?o00000_l40006o`00o`3o1002o`050?l00?l010001?l0oon0007o00000ol0000P0005o`00o`00
0_l30003o`0000L000Go0?l0o`050003o`0000@000?o00001P000ol0o`050005o`000?l00P000ol0
00060003o`0001@000?o00001@000ol000030005o`000?l01@000ol0001n007o00000ol0000P00;o
00<0o`000`000ol000030004o`00o`L000Go0000o`0<0003o`3o00D00_l200?o0P000ol0o`0400;o
1@001Ol0003o00<000Co0?l00ol20003o`0000H000?o00001`001_l0o`3o00?oP001o`0000?o0000
8`001Ol0003o00D000?o00000`02o`X000Co003o1`000ol000040003o`0000<000?o00000P000ol0
00090003o`0000<000?o0?l00`03oa0000?o00000`001?l00?l200;oP@01o`0000?o00008P001_l0
0?l0oa4000?o00002P03o`l000Co0?oo1P000ol0000L0003o`0000X000?o00000_n3007o00000ol0
000Y0004o`3oo`<000Oo003o0?l000?o2@000ol000020003o`0000P01?l20004o`00o`@000?o0000
0`001_l00?l0o`H000?o0?l00P001?l00?l80006o`3o0?l00_l20004o`3o00?oP@01o`0000?o0000
8P000ol0o`020003o`0000`000?o00001`000ol000060003o`0000<00_l300?o2`000ol0o`070004
o`0000;o3P02o`@000?o00000`000ol000020003o`3o08800Ol00003o`0002P000?o00000P001?l0
o`02o`D000?o00000P000ol0o`060007o`3o0?l0o`040003o`0000X000?o0?l02`000ol0o`030003
o`3o00L000Co003o2@001?l00003o`8000?o0000P@01o`0000?o00009P001ol0003o0?l00`000ol0
000300;o0`000ol000040003o`0000d000Go0?l0o`080003o`0000H000?o0?l00P001Ol0003o00<0
00?o00001P000ol000030003o`0000D000Go003o0002oh<00Ol00003o`0002@000?o00001`000ol0
000300;o10000ol0000600;o00@0o`000_l20005o`00o`000_lB0003o`0000T000?o000010000ol0
000:00;o0`000ol0000200;oQ001o`0000?o0000:003oa000_l300;o1`000ol0o`020004o`00o``0
0_l60005o`3o0?l010000ol00002o`D000?o00001`000ol000020003o`0000800_l20003o`000880
0Ol00003o`0002/000?o0?l02P001Ol0o`3o00D000?o00001`001_l00?l0o`H000?o00000`000ol0
00030003o`0000H000Co00000_l=0003o`0000L000?o00000P02ohD00Ol00003o`0002H000?o0000
0`02o`030?l000<000?o00000`001Ol0003o00<01?l00`3o000600;o1P000ol000030005o`000?l0
0P001?l0ool60003o`3o00L000?o00000`001Ol0003o00L000?o00000on6007o00000ol0000^00;o
00<0ool02P000ol000090003o`00008000Co003o2@02o`/00_l0103o0?l90003o`00008000?o0000
1P000ol0o`0300;o00<0ool0QP01o`0000?o00009`001Ol0003o00@000?o000030000ol0000;0003
o`0000T000?o00003P02oa@000?o0000T`01o`0000?o0000:@000ol000020003o`00008000Ko0?oo
0?l80003o`3o00`000?o00001`000ol000060003o`0000H000?o00001`000ol000020003o`0000@0
00?o00000`02o`030?oo00;oQ`01o`0000?o0000<0000ol000070003o`0000@000Co0?oo1@02o`d0
00?o00001P000ol00002o`<000?o00004P02o`D000Co003o0`000ol00026007o00000ol0000b0003
o`3o00L000?o00001002o`040?l0o`D000Co003o2@001Ol0003o00D000?o00000_l40003o`3o00<0
00?o00000P02o`P00_l01`3o0?l0o`000_n8007o00000ol0000d0003o`0000H000Go0?l0o`090003
o`0000X000?o00000P001?l00?l50003o`0000X000?o00001`000ol0000;0003o`0008P00Ol00003
o`0002l000?o00001002o`030?l000@000?o00004@000ol000030003o`3o00<000?o00000`000ol0
o`030003o`0000l000Go0000o`0400;o00@0ooooRP01o`0000?o0000=@001?l00?l<00;o3P000ol0
o`0700;o00D0oooo0002o`@000?o00000`000ol0000<0003o`0000<00on<007o00000ol0000g0007
o`000?l0o`0>0003o`0002L000Go0000o`040003o`00008000Go0000o`2=007o00000ol0000a0003
o`0000H000Co0?oo2P000ol000020003o`0000D000?o0?l01@001ol0003o0?l05@000ol000040008
o`00o`3o0?n>007o00000ol0000c0004o`00o`8000Co00000_l40003o`0000@00_l400;o00<0o`00
0P02o`030?oo00800_l;0003o`3o00<000?o00001`02o`060?l0o`3o0P000ol0o`2>007o00000ol0
000e0003o`0000P000?o0?l01`001_l00?l0o``000?o000050001Ol0003o00h000?o0000S@01o`00
00?o0000?`000ol000030003o`3o00H00_l00`3o00020003o`0000;o0`001Ol0003o00D000?o0?l0
3P000ol000030009o`000?l0o`3o08l00Ol00003o`0004L000Ko0?oo0?l50005o`3o0?l030000ol0
000?0003o`0000L00_l200?oT001o`0000?o0000>`000ol000050005o`3o0?l05`000ol0000=0005
o`000?l01@001?l00?l60003o`0009000Ol00003o`00044000?o000030001Ol0003o008000?o0000
2`000ol000090005o`000?l00`001?l0o`03o`030?oo09<00Ol00003o`0003`000?o00000`03o`/0
00?o0?l02@000ol0o`0600;o10000ol000040003o`0000P000Co003oU@01o`0000?o0000B@000ol0
00030003o`0000`000?o000030000ol0000700;o0`000ol0002G007o00000ol0000n0003o`3o01L0
00?o0?l07`000ol0002I007o00000ol0001J0003o`0000l000?o00000`001Ol0o`3o00800onJ007o
00000ol000160005o`000?l00P001_l00?l0o`T000Go0000o`030005o`000?l00`002Ol0003o0?l0
o`040003o`0009X00Ol00003o`0004`000?o0?l05`001Ol0o`3o00<000?o00000P001?l00?l20003
o`0009X00Ol00003o`0004P000?o00003@001?l00?l;0003o`0000H00_l30004o`3ooid00Ol00003
o`0004T000?o0?l01@001?l00?l=0004o`00o`@000Go0000o`2W007o00000ol0001G0003o`0000<0
0_l50003o`0000P000?o0000Y001o`0000?o0000D`001?l0ool20003o`00008000?o0?l010001Ol0
003o00800_nX007o00000ol0001G0003o`0000D000Go0000o`070003o`000:P00Ol00003o`000640
00?o0000/P01o`0000?o0000o`0G007o003ooa_o0000\
\>"],
  ImageRangeCache->{{{0, 281}, {173, 0}} -> {-0.0270276, -0.0250053, 
  0.00375109, 0.00606938}},
  ImageSoundCache->{{{0, 281}, {173, 0}} -> GraphicsData["MacintoshSound", "\<\
00400@050000X001P540000001@0000000100200000000000000000lOgmoOgmo
OgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmo
OgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoP7moOh1oOgn0OgmoOh1oOgn0
OgmoP7moOh20OgmoP7moOh1oOgn0P7moP81oOgn0OgmoP81oOh20Ogn0P7moOh1o
Ogn0P7moP81oOgn0OgmoP81oOh20Ogn0P7moOh20Ogn0P7moP81oOh20OgmoP81o
Oh20Ogn0P7moOh20Ogn0P7moP81oOh20OgmoP81oOh20Ogn0P7mnOh20OWn0P7mo
P81oOX20P7ioP81nOh20Ogj0PGmnOh60OWn0P7mnP85oOWn1P7ioPH1nOX21Ogj0
PGmnOh60OWn1P7inP85oOWn1P7ioPH1nOX21Ogj0PGmnOh60OWj1PGinP85oOGn1
P7ioPH5nOX61Ogf0PGmmOh60OWj1PGimP89oOGn2P7enPH5nOX62Ogf0PX1mOh:1
OGj1PGimP89oOGn2P7enPX5nOH62OWf0PX1mOh:1OGf1PWimP89oO7n2P7enPX9m
OH62OWb0Ph1lOX:1OGf2PWilP8=oO7n3PGamPX9mO863OWb0Ph1lOX>1OGf2Pgil
P8=oO7n3PGamPX9mO863Og]oPh1kOX>2O7b2PgikP8AoNgj4PGamPh=mNh64Og]o
Q81kOH>2O7b2Q7ikP8B0Ngj4PW]lPh=mNh64OgYoQ85kOHB3O7^2Q7ijP8F0NWj4
PW]lPhAmNX65OgYoQH5jOHB3O7^2QGijP8F0NWf5PW]kPhAmNX65OgUoQH9jO8B4
NgZ2QGiiP8J0NGf5PgYkPhEmNH66OgUnQX9jO8B4NgZ2QWiiOhJ1NGf5PgYjQ8Em
NH66OgQnQX9iNhF5NgV2QWihOhN1N7b6Q7YjQ8IlN867OgMnQh=hNXF6NgR2R7ig
OhR2N7^6QGYiPhMmN827P7QmQX=iNhF5NgV3QgigOhR1Mgb7QGUhQHQlMX69PGIl
R8EhN8F8O7J1RH1fOHR3N7Z5QW]iPhMmN827P7MmR8=hNXJ6NWN4RGeeOhZ3MGV9
R7QeQ8]nM7j;PgEiR8MiMh>8OGJ0R81gOHN3N7^6QGUiQHQkMX::OgAmRhEeMhR:
NG>2SH1bNhb6MGJ7Rg]cPH^1M7b9Q7MiQXIjN8>7O7N1R7ifOhV2MG^9QWIfQh]k
LH6>PW5iS8YeLXJ>O71nSXAcN8Z9N7F4RWeeP8V1Mgf7PWQlQhAhNHN8NGF4S7ea
Ohj4LGN<S7I`QI5oKW^@R79dRXiiL86>PG9kRhIfN8J7NWR4QgahPhQmMX6;P7=l
S8IcMHZ=Mfn3TX5]NI6;LG29TG]/Oi65L7J<RgMcQ8amM7n:PGImR89gOHR3MWZ9
QgIeR8ejKh6BPfegT8ebKHRDOFYlU8U^LXf@Mff2TH5`NXb7MWN7QgYhQ8IkN8B7
NgJ3RgeaOhn4KgJ?SW=/QiInJ7ZES6e^SIEiJH2EQFaeSXeeLHF>OG=oRX5fOXN1
Mgj8PGElRhIcMH^>MVf4UH1YN9F>KF^<V7YUOIV9JW2@TgEZPiB1KGV>R7EfQhQj
N8B6NgV5QgUfQXajKh6BPV]gThm_JXZIO6AkVXaXK96HMVF1VHEYM96?M6n6Sgea
Oh^1MWj7P7R0R7mdOXf4L7J?SW9[R9QmI7VJSVQYT9]gHGnMRFE_TiEcJ8BGPF]i
ShUdMHN8NWR4QGYkQXEgMhV<Mfj5U7mXN9N>JVV?W7QPOIn;Hf^EVW=RPif5IG>D
T79]Qi5mL7j;PWMnQWmiPHQmM86>PFihTXe^JhbJNF5lWheSJ9FNLef1XXQQKING
LFF5VH5ZN929LgF7R7YiQ8AjNhN4MWR:RWE_R9EkIWbKS6EYUIicFh6UReeYVYi`
GH>PQV=aUI5bKHJAOG5oRh1fOhMoN868OGB2SWm^NiB:JVfBVW=NPZF:G6RLXFiH
PjR9G6^IVW1SQIZ2JWR@R7AgR8MiNHJ4NG^7Q7IiRXQcLX^CMfF2WhMOJibOK5N6
[8UFIinRKEV4Y8MQL9FBLVf6T7ebP8YoMX28OWN1R7eePXamKgnEQFMaV9U/G8RZ
QUAYY:AXDhJ]REQYW9e`H8BKPfYhSXMeNHR5N7Z7Q7QjQhAgNXZ6LgF>TG9VR:61
FFnTWfACRk:6D6NUYFYEQ:N8H6jEU7=]QHimM8:9OGN2R7efPHQmMX>:Ng23U81U
MIfFIE^?[X1>Jj^UHTj:/hUCIinPKej3VhA[Mhf7MWZ7PgMlR8AgNXN4N7^9Pg=i
T8e]J8jRNeEdZieLDI:gPdUWZZMVDHF[REi/U9EeKH><OGJ2Qg]gQ8UlMX68OWR3
R7UcQi=kHg^QTUiLUk1jB6nbYE];S[N8CfFQXVmLPI^6KGN;QWQlQh5gOXV3MWZ7
QGUlQh5dOI68JF^EXW=BN[6JEE2I^gi4J;2YHdj6[X]MJYBFMfj1RgiiPhEjN8J9
NgF1R7miPXEhMhZ@MF>2YHaHGinbLT=c^JAEBI:kQT]TY:E_Fh2LR6ieR8IkOXEn
Mh2:PWEjQhEkOHAnMH:BPVE`Vj1/D86fUTeAX;ei?fZeZUm;Qk2<G6RCUgU^OhV0
O8>2N7Z7RGYePHR0Nh61N7^>SFmURJN6DV>W/F]0NKnRCdRG_XA7I:JWKeUnW8]`
M8F6OX23O7N2Rh9eNHJ5OGf1NgR7TGaSMZ6LI529^Y17DjNoM3]/^J]MBHNbSEaV
TIQlKWb7PWj2P7QlR8MjMX67PGb0OgQoShQ[JI2VODiZ[jmQ?H35X4Q6Vl:4AF:U
ZG5INiZ<LgB3QGn0PWaiPXR0Mg^5Q7enP7]kRHegIGjSU5aDU;f7?eNa`FdeKKj^
G4J5/Y5NIHfGOg5lQH5nPX1jOHF5NgV1QGmmP7ijPXf2JG2GXW9<MKNYESb9bia1
A9k6QD=NY:]eFWNGSGIePHAoP89mNh65P7YnQ85mOh1kOXZ9LVV7Y8YDFZ2mO3QM
^L9W<6o2/5]3P[:EHV>9UX9cNX>1Oh60O7f3PWelPX9nOX1mO8F;O6UhWI]XCH2m
XT`mT]2H>d>QbHI1Fj6]NU]cThmjMGn3P7n1OgeoPWmmP89oOX1oO86:Pfi^T:=o
Cf>Z^g0cI<;1H2eaaK9K@GjbVFEPQ9F6MWV1PGn0PGmnOh1oP860OWn0OGj7QgEZ
PJ:CGE2=`IQ3@9cCTSI3Y<b7@5NO/7mKKY2BOWEmPX1oPH5oOGj0PH9oOGj0OWf4
RGaZMIVPLd]]];MU<Fg8_UX[LlRcG3ij/YiYGGjERWQgP89oOh:1OG]nPX>0OGf0
Ogf1RH=_K8^UREAEVL>=>dFUe8dbAJK=RD1CW;>5G6R<UH9eNX61OX64P7YjP8F3
OG]oP7eoR8QeJ7fQVfI:NKf`FC1fcKYE:gG9]EdlM[:TKEYiUHmjMGj2Ogj4Q7eg
O8J7OgUmPGmmQH]mJG6FYWe<GJK3PCE<[M>6<4JXcX]0CiVfRe]RRIR6M7N1PGf1
Qh9gMX::Q7UjP85lPH^5KVN7Z9AJBhO3YdhcP=2eDBagbKIO>W6bZW1ELiJDO79l
PginQHMlLg^:RWefOH9nOXV<MfAgX:EaAVNb`7@aEKG@P2m9Z<j=@4^E^Y5KGHJL
RWAePH5lPHV3MGB4SH=gNH60O8>=PFUZT:Z:D4nDaia4=H[E/4/[N<^iH3Q//:ed
EFnDUGicO89nOXF7O7AlRHQlN7n2OWn9R7=VOjBMITIc^k]W:ebodWXYB:cBSd18
TKVEH5f2V8YgMh21OH66PWQhPhV1NGb2P7f4RWeYLYNVOT]HXLRA>CNEg:e49g[?
_64fJ:f_NUU]Si>0MWb1Ogj3QGehOXJ4O7Z0PGj1R8=`K8RUTea9PL>dFRQTbM=c
8dN_eY50AHfhVFIMOIB;NWQoP7j0Q85kNh:5Og]nPGmoQHIhJg^LWg98Hjg7Q34l
X>6Y?BEld[mS=F>Y/H1LJHVBPgQlP7mnPH=oO7n3PGamPH1nPXInKW:@XhMCCho8
ZThVK]7BKAi7/MRD@D67]Yi[GGN@SGiiOX1nOX62Ogj0P7emP85oP8F2Lfj4X9MV
B72h`gHZ@Z[SXcLSO]C1ICANYK>7GfF4THMkNh20OGj1PX1oOWenP89oOhB4N6ij
V:1jC5NMbim2:7WHcfHLBK?JUd8nP[FTLEaaS8n2NWf0OganPX>1OW]lP8>0Oh:5
OG1cSZ>=FTYn`KeX9D^di9dc97oE`fPcFJ2fSV9QOY6;OWYoP7ekP8F5OgYjOhB2
OX25PG=^Pj2KKDMRZl^B>2b4gLYP6dZcfiY4>W^dZWQKJhVBQW]lP7mjO8>8Q7Yf
O8B4Ogn4Q7M/NIRSPDm>SLVdFb=E_N:F<2F0eLE/<e>L^IIUG7RASh1iOX5lN7n9
RWmdMh:7PWj2QWe]L8fVTem4KkS9Pc0bSmo4Fa]</m^MASMe/k5nFFB6UHUkNh5o
N7V5SHIfLWb7QWioQH9aJX2RXWA6EIc>ZDhTH<CNSbhXPMC7L39=UkfNIeIbTI>2
N7j2NgEnSHemL7F4RH9mPhIiJWBFZ8YCAWg2`gDY>I[R_eHJCK?LXDTdKk2ePe]Q
PYB;O7^1OgQiQHf5MW=nR8EnOhEoL6j7Y9YXA66Zcia18f[>h8TX9H;FbW<cBI6j
XFeJL8f@PWYnPGahOXV9OGAiQ8J0OX>3MfelVZ9nCTj;bK]V8SnVjKa>5DbegjE<
<fV[]8UQHWj@RWelPH1jNX>9PgQgP8J2OX23OG5dSZ:?GdM^]Lb>=BAef>638B>3
fLig=4F;]ZAdGVj7SXAlOX5nNWj5QGeiOH>4Ogj2P7IbPibJLT]HV/faF1e7/^fh
Aa5<]n:XCc9SYKB?If=jRhV0OH20O7b1Q85lO863P7j1PGYcO9BNPeM<OKo7P2`W
PN3OO1`RPm[ANcI1Pk>XO69[PX^5OWj1OgemPH5oOX22P7ioPGeeN8^MT6I:IJS?
YDXKDKg`/T4?CKSS[5<aGIjdUViSM8N9PWj0PGmmOGmoP862P7inPGmhMXBHV7I@
E8g7`74T;HgVg7HI8XCJdh0h?Gb_[8AVJ7b9Qh1nPH9oO7anP8>3PGemP81jMGjC
W8AKBg>ecILm75c6l:`l3djgi;1G<5JG]IeeHfn3RXAnOh>2OWUjOhB6PgelOh5l
MWZ<W91YBefLcKIQ7SJIj]M_5b>4f]F5>cUcZk6<JFAfQhV1OX64PGYfNX>9QWmj
OH5nMgJ5VYUhDDn2`LV7<QmYc^fU>A1?]^BdG2m>T;JUNf9YOXZ6Ogn4QGieMGn9
Rh9jNWn0NGAoUIj7G4QY[=2YDQa0Y>c@JQLUQ=SGRchdJjRfUFaPLHJ;Pgf2Qh=h
LGN6SXQlMgf1O7AhSJ2DJdQET/[3MbXUM]CYWCLCD;CS^F8_AhVg[H5PHg^;RGmn
QXQnL71oShn2MWR0P7IcQ9bNOE18Mk[@VdDKBjo/bV@G9h?FfI12<F>S^I]`Gfj4
Rh=mPXR4Mg1hR8n7NgMmPG]dO9:OS657H:3?^FPR:h;MjIPa44ndiKeW<D>2/Zj6
IVEiR8MoOXF7OWAdP8^:P7QkPGmgN8RJUG=?DXK2bX`h6UFkllMM4BB2f=fFAS5N
VkBMMVA^PHR3OX66PgYeNhJ:Q7]jOh5kMh6CVH5KC6j/cjaI6c6?i^VB:`a>]>O2
KCA0Nj^]S6eXMhF5P7j3QGmhN827QGijOH5nNGf<UhaZCefDal9m;A]QaoO3E``R
P]SPVd`bF9>`X7eYKWj5PWj0Ph=mNWf3QH1kO820Ng^6Ti5gEeAm]lbNBQLiVnkX
S2D:CK?XaW<h?G:T[99dJgF1Q81nPH>1OGf0PX1mO7n1OG^2Si>1HE5[Xl^hKB@P
KM7h_U498H7GhZ5B<U::Zj>5KfijPX9oOX62PGmoP7mmOGn1OgaoRY:8K5AMSL37
ScdFA:Sci8DQ2Dbbj<Yj?3YZW:bHNfebOH>1OWj1Ph>1OgekO7n1P7enQi6=MUYF
NK3<ZedM9W[Jn;Q<22:0e^>WF3=;PJNWSGA^MX22OgeoPhF5PGaiNWj2PWimQ8n@
OV5CJIg7_gha652cmMmo7`Y<[nO>PD0gH9B/Wh=_KgZ2PGelP8J8QGegMgb2Pgml
PHbBQVYDG8VlbYe=6Bn7h?BaB0TSO]?T[UldA7NS[9EiKG9mPWmkO8>:RX9hLgR0
QH9mOXVBSGAHE7J/c;E]:1eM_OGHNAl<C:cUdXU5<eN=[JN:LFafPH9lNGn9SXQk
LG=lQHEoO8FATWiOCfFIa/J=?aPkU>C_ZDD<9Gc?iKAV=Ca^X;2MOV]^Nh=oNGZ5
Shn2LfifPhN2O82>UHQYCeN4^/jYGB0TJlKcd7@O3dbXhmFABS5?QZb/Sg=[M822
NgQnRi69NFmbOXJ5OWf7TXifFE5`Y/^mO3<HAZ7[kJ=12RAicNJjKSTjIiV]Wh9_
L7^2OgUjQ8f<PGAaNH>6PGf2SI21I5=RTL38VThK:GOBnLi]6@]9Yn?IV54dC7jT
Z95hKgIoPGaiOXN;QWYdMh25PgioR8n7L5UKOZo9/6dY6U2^lnfN>PDQMl_W_gHo
>f6@Yij6M7=kPGmkNh:8Qh1hMgf3Q81nPh^:NF9IKig3_hY15c65g?c:Ia@8AjCR
g9mI>4UfVjBDOWAgOX5nNgf3QX=lNGb1Q85nPHR:OfYLIXbgaJ9M8AiM^_S[V3D2
7gG9j<AnAS]KQZ2NRgYeNh20OGaoPh=oO7b0Ph9oOhF9Pg9PHGfXa;Ai=ALkT^Gl
aF8A1TFQh=jVHSa6KI:PUhAhN7f0OgelOh60Ogj1Ph9oOh:7QGQVH7:J_KnCCQ`T
J/Glj98a0Aiba^S9QddlE7fIWY20N7YoPGmlO7eoOh62Ph9oOX65QWa[H6^</l>W
JB/IAio[n[mM40I3W]gQ[V]1@VB9WIZ:OGUlP85nNgYkOX64QH>0OGn4QWm`HVF0
Yl6fPT0I;GS?oN:<;`8NKl;VcY1E?DecTijEQG]iOX:1O7QgNX26R8J1OGj2QX9d
IF9eV[^oVEPS7UB[l?JhFA08@YWJh[EdACmJP9ZMT85iNh23P7UeMWb5RXV4OGb0
QHAhJ61/S[?3Zg4d6CR6eo_KQRh47fbliM>IG3e6JHfOVh]mNGf3PgadLGN2Rhf8
Og]nQ8ImK5mUPJS2^HU97BES]_7`/EHB2d6DeN>mOTXkDGRGXIJ4NGZ1QH5gKg5k
RI2=Pg]kPXN2LV5OMIbn`YiP:Aa5TmcgdX4_225X]^;HXf@n?en7Win?OWQmQ8Al
LFiePhn@R7ijOXF5NFMNJhfca:mi>a/^LL7dk:]B4P/oSm7T`hMA?4eaTYnGQW]j
PHF1N75bO8V?Rh5kO8:5OVmSIWnT_[V?DR<PDJ7Vn]1l:P@MI;?PfZY]AT9MP9NJ
SX1jOH>4OWEcN8>;RhAmNgn4PWIYIGJF]KfQJC8K=gk=n^bVC@d7>h_>hlR?FT9=
K8ZHU8MmO824PG]fMgj6RHIoNgf2Pg]_J72:Z[^]OdDO9Uj^k__<MbD16V2^g]b`
Mdi6FWV?UHj2OGj2PgmjN7^2QXJ1O7b0PWidJfj1W[JdTU/Z7T:<f?kYXDP;1CN6
bN;<V6A9CFJ2TI68P7f0PX9nNg]oPhB1OGaoPH1hKfikU:jfX6lj7Ri[^_Ckb78R
01QLZM[M]h5GBEIaQi6=QGmnPH:1OgenP860OWanP81kLfmgS:JdZH9=9B=?VN3o
iIa52@@ePLCQd:5_D4ePNH^?RX9nOh63PX60OgmnOGamP85mMW1eQYja[i5O<Ali
NLGhn<9]8@0GF:?Fg[j<HDeCJGn<SHN1OWn2Q8B3PGilNg]lOh5nN79cPIN//Iea
@24ZG:KWo^2F@PX5<gbng]BZNEM=FW24SH^5Ogj0Q8J6Q7mkN7QkOh5oNW=bO96W
/ZJ1D2TRAHO>n_>kJB425eBLd=k5UfY@Cf5gR8f9PWinPXN9R8=lMgEhOH61O7Ab
NH^R/Jb?HCDQ=6^bjo_HT44=1c5f]m_G]8AMCE=XOX^=Qh1mOhF;S8MoMg9dNX22
OWIaMHFL[k6KLD8T:5>Ee_S/]6HS1AQ@UL[Nc:9cE4aIKhB>S8AmOH::Shf4NG5`
MWj3PGUbLWnF[;BVP54[8cmj_Nged8]24@/`KjoGf[f?I4a=GgR9ShV0Ngj7Si6:
OW9^LGZ2PgadLGV=YK>]Sf8g8S5QXmggiZeS90LGBhg4g=2ZO5Y=EV^0S8b4OGb2
RXn=PgQaLGMoPh1hLgJ5Vjb^VW=6:2Q;R<WcmLb7?Ph8:fVXd]W1UfiEDV1eQH^7
P7anQH^<QgieLWImPX9lMWIoTZB/XH5F<RDkKk3VnnFZGb044dJ7_]SA/8ITEEUZ
O8N8PgimP8J:R89jMGIkPH9oNGMlRYbXY8aU?RP`F9KCn?G9PS/<1BMSXLcGa9mh
GUQQLX27QH1mOX:6QhAnNGQjOh:1O7QkQIFSY9AcC2hZAWflkOgRYE/N0Q51P;KC
dKF?KUeMJGR2QH=oOGn2QHB0O7YkOh:1OW]kPXnMXiUnFCPZ>FJSg?_ca7hh2`@T
GI[5e<NVPfQNHVmkPhB1OWeoPH:1OgemOh62P7alP8^HX9^6ID8]<E>;ao;lgJ1H
7@8??7R^c]6kVGUUH6McOH:2OgemOX20P7moP8:2P7ilP8RDWIb<Kddc;TEd/>?l
kkmj=`/48ENA_]79[XebI6=[MWn2PGilNganOh21PXB3PGimOhJAVYb@N5Pk;S]Q
VM3enMRKEQh43cQaY/S@`:>4KFAVKgV0PX1mNWUjO7n2Q8J5PgmmOXB>V9^DOf53
<CABPk_Yn^ViMSL>1R1ARKK=c;JHO6YTJ79kPH9oNgQgNGf1QXR8QH5nOX><UY^F
QFY;=C55L:KHm_?@UUDP1a0eJIg1clF]SgEWI6YdOH:1OGQeMGUoQHZ;R8=nOH6:
U9^IRW5C>S0mH9;6joOR/W<i4PTOBgn]bLjnXhI_I6E]Mgn2OgUdLWAkPhZ=S8J0
OGn7TYZKT7UK@34fDWnbg_C/b95E90`A<F6C^/g:]YUmJV9VL7^2PWaeL71fOhV?
ShZ3OGf4SiVMUH5TAc@bAfjPc^gbfZ]a>QH<7DEfY<?=`j^>MFMTJgIoPX1iLg1c
NhB<SX^5Ogf0RI>IUXM_DS`c?en=_^CejLB=Db@<3beJR[;7b;RNQ75XJG5kPH5m
Mg=cN827S8^7PGenQHjEUH]gGDDg>e=l[=SblmRXKSPD2AToKY^kal6]U7e_Jfmg
OX60NgMeMgb3R8Z7PWinPXV@ThemIThm>T]]VlW[m^S0RE0R2PdXDh6X_lBhXh]i
KfidNh21Og]hMg^0QHN7PgmnP8F<T8f1KUM4?4IQR[SOmO;EY6/f4`PG>FJA/L6n
[iV5Mg5bN7f1PGikNGYnPXF5Ph1nOh>8SHb3Lei;@4=HO:SBkoKT_8I>8PX<94ah
W[No^:NBPGIcMW]oPH1nO7amP8:3PX1nOX66RXZ4MfEBA4=AKiS3iOK_d:1X=Q@8
5CANQjRi^k6OSGmgMWQmP861OginOh21P7mmOX24QhV4NVYGBDA=IHZdfO7dh;N3
CR<<3255KYB^^KNZVHUmN7QjOX62PX60P7moOWelOGn2QXN4NfeLCTI;GWjUc>We
j/ZKIcLF2Q@`EWfM/[RbYIF7OGUiO822Q8B3PH1nOG]kNgj1Q8J4O71PDTU:F7BH
_moal=VaP4hV3`hO?fF9Y;Bf[Z6AQGaiNWf1Q8J6Q89oO7YiNGb0PhF4OG9TED]:
E6^</]C[lN?4UfHi6PhE;4ibTjZe]:^MSX=lNG]oQ8N8QhB0O7QfMgUnPXF4OgAV
F4e:DFF2Y/SSknWBZge?:Q@@7SUKOY^^]K:WVH^1NgYmPXN:RXR3OWQeM7MkPHB5
P7IYFTm:CemjVkgJjncK_99U?B0C5RU6J8RQ/KF`Y9J8OWYjOhF:SHb7PGUdLW=h
OX>5PWU/GE19C5YbTK?@iN_RbJEkDBlJ51ddDW>AYk:d[9nAQ7ajO8:8S8f:Q7ef
Lg=fO864PgeaHeI>CUM[QjS7gn_Xe[N?I3hR51HU?emnV:V`[ZBGRh5lNgn4RH^:
QX1jMGAfNWn3PgmfJUeDDEMVOiflenS/h<JRN50_6A<K;d]ZQibY[:NMTHIoO7f1
QHR9Qh9mN7IfNGf1Ph1jKfAJEEQTN9Bbc^?/im>cS6<n8a@E8SYGM8fOYjNQUXb3
OWeoPXJ7QhB0NgQhNGb0PX5lM6UPFUYRM8bYaMcZj]g2WgI?;aXC6B]5HGbAWjBR
Vi68PGinP8>5QHB1OW]jNWaoPH5mMfiUGUeSL8JP_=CUjn??[hUR?b@F5B0eCfZ2
U9jPWIF=QH1nOX22Ph>2OgelO7eoPH5nNG5YHf1TKh6I/lcPjNOH_Y]eD34M5ATX
?eUbQYFLW9RARXB0OWn0PH:1P7mmOGioPH5oNWA]IfAVKWjC[<CIi^SObJ^7HT0W
6ALO<DQQMhVDVIVDSXR2OginOh20P7moOh20PH5oNgI`JVMXKWb>YKgBhNORd[RG
Le4d8APJ9SY@Ig^:U9NFTHb6PGimOGenOgn0P862PX:0O7MbK6UZKgZ;X;K;g>GT
f<>VQ693;1dJ82i1EfanRi:EThn:QH1mO7]lOGj0PH:3Q8>1OGUcKV][L7Z9Vk75
e^7Sg<^bTg=C>BHM7BDeB5e`P8^BTi:=R8=oNgYiNWaoPH>5QXF3OgYdL6a/L7V7
V:c0dMgRg]6lXH9SAc4S7R4[>diQLh6<TI:@S8J1O7UhN7YmP8>6QhN5PGafLFe]
L7V5UJRkc=WOg]C3Zi1bESh/8R0U<D1CIGJ3S96BShZ4OWYgMWMjOX>6RHV7Pgih
LVi]L7R4TjFgb=GLgMK8]9^0ID`h:R<S:CE5EfQhQHfATHf8PGagMGEhO865RHZ9
QX1jM71^LGN1T:2b`m3Ig=S>_:J=LUU2<BLS9RllC5e^O8J<Shf9Q7mjMgIgNWj3
QXR8QX9mN7AaLWN0S9^/_L_Efm[Ba;2HOfE=>R`U92Xe@e=SLWj6Rhb:QX5mNGMh
NGf1Q8N7QXB0NgMdM7QoRYNW]lGAf=WEbKRSRg5IA3@Z9BP_>dUIJ7EoQXV9Qh=o
NgUhNGaoPXF6QXB1OGYgMgUoR9BR/L3<eMSFcKn/UGeUCcd`:BL/=D5?GV]gOhB7
QXB1OW]jNW]nP8>4QHB2OgajNG]oQi:O[K_7d=GEd<BdWhQaFdLh;RTZ<3Y7EF9^
N7n3QHB2P7elNgamOh63Ph>2P7elNgb0Qi2LZ;K2c=;Dd<NjYi=lIU91=Bd[;SI0
C5UUL7QnPX>2PGmnOGemOh21PX:1P7imOGj1QhnIYK6malkAd<Vn[Y^6LEe;?C<^
;S<kAE5MJ75hOH21PH1oOWinOWn0PH60P7inOWn2QhjHXZji`l[>c/[1/j>?NfME
ASXc<C8g@4YDGfUbN7eoPH61P7moOgn0P81oOginOX23R8jGX:^e_lK;c<W2]jRG
QG9PD4<j=C<f?4A=Ef5ZLWQlOh61PH60P81oOgmnOWemOX23R8jFWjVb^l?7bLS2
^JfMSG]ZFTa1>SLg>T18D5YSJg9hO7n1PX:2PH60OgimOGamOX23R8jFWZN`^;o4
a/G1^ZnRTh=cHeE:@C`i>Si3Be=KI6acN7f0PX>4Ph:1OgilNg]kOGn3R8jEWJJ^
][c1`l?0^[6UV8YkK5mCBD8n?3e1ATeEGFE]M7UnPXB5QHB2P7ilNgYjNgj2QhfE
WJF]];Zn`L2n^;6WW8n2M6MLDTU3@3m0@dQ?EUiVKWEkP8>5QXJ4PWmmNWUiNWb0
QH^CVZ:Z/KNk_Kjl]k6YWi>7NfmSFE1:AD=2A4Q=E5]SJg9hOX64QHF4Ph1nO7Yi
NW]nPhR>UYfTZk6f^KZi][6ZXIN<PGEZH5M@BTM6AdY>E5YQJ6mfNgn3Q8F4Ph5o
OG]jNW]mPHF;TIROYZ^`];Jf];2ZXiZ@QW]`IUeFD4a:BTa?E5YPIfecNGf1PhB4
Ph:0OWakNg]mOh>8SI>JX:J[[k6b/JjZY9bCRX1fKFALEU9?CTmAEEYOIFaaMg]o
PX>4Ph:1OgelNg]lOX65RXnEVj2UZJb][JbXXifESHAkLVYSG5QDDe=DEe]PIFY`
MGUmP8:3Ph:1P7imO7alOX23QhbAUY^PY:NYZJRVXYfFShMoMg1YHUiJF5MHFUeQ
IFY_M7QlOX62PX:1P7mnOGemOWn2QHV=TYJKWZ6TYJBSX9bGTHZ3O7E^J6=PGEaL
GEmRIVY^LgMjOGn1PX:1PH1oOWemOWn1PhN:SY:FVIbNX:2OWIZFTH^5OgUcKVUU
Hf5PHF9UJ6]_LWIiO7j0PH61PH1oOWinOWn0PXF8RhjAU9NIVi^KVINDT8b7PWag
LVi[J6IUIFIXJVa_LWEhNgenP820P81oOgmnOgn0PX>6R8^=T9:DUIJFUIBBSh^7
PgmkMg=`KFa[JVY[KFmaLgIhNWamOWn0P820OgmoOh20PH>4QXR:S8j?TI6ATI2>
S8Z7Q85mNWMeLg5`Kfm`L79cMGIhNW]lOGioOgmoOgmoP821PH:3QHJ7RHZ;S8b<
S8b;RHR6Ph5oOG]iMgIeM7AdM7EfMgQiNW]lOGenOWmoOh20P821PH:3Q8B5QXJ7
QhR8QhN6QHF3PX60OgelNg]jNGUiNGUiNWYjNg]lO7emOGinOgn0P861PX:3Ph>4
Q8B4Ph>3Ph:2PH61P820OgmoOginOWinOWemOGemO7alO7emOGenOgn0P861PX:2
PX:2PX61P81oOginOWinOWioOh20PH62PX:2PX:1PH1oOginOGemOGenOWmoP861
PX:2PX61P7mnOGakNgYjNWYjNgamOX21PhB5QXJ6QXJ5QHB3PH1oOWimOGemOWio
P821PH:2PH60OgelNgUhMgIfMGIfN7UkOGn1PhF7RHZ:RhZ:RHR6QH>2P7mnOGem
OGioOh21PH:2PH1oOWakNGMeLg9bLG9bM7IhNgf0PhJ9Rhf>Shn>SHb:R8J4PX5o
OWemOGinOh21PH:2PH1oOWaiMgEbL6m^KFe^L79dN7]oPhJ:SHnATY>CTY2>S8Z7
QH>1OgimOGenOh20PH:2PH1oOG]iMW=`KVaZJFUZJfiaM7QmPHJ:SY6DUYNGUYFC
T8j;R8F2P7mnOGenOWn0PH62PH5oOW]hMG9_K6UWIVEVIfU/L7EjOhB9SY:FV9ZK
VYVGUI:>RhR5PX1nOGemOWn0PH62PX60OW]hMG5^JVMUHf9RHfEXK75fO8:8SY>G
VYfNWYjLVIJCSh^7Q89oOWemOGioP862PX60OWaiMG5]JFIRH5iNGf1SIfabNGn6
S9:HW9nQXZ:PWY^GThn;Qh>1OgimOGioP861PX61OgeiMW9]JFEQGUaJFeaOHfQ^
MGb3RY6GWJ6TYJFTXYnKUi>>RXJ3P7imOGenOh21PX:1P7ejMg9^JFAPG5UHEeQJ
GV=YL7R0R8nFWJ:UZ:VXYjBPW9NBSHV5PWmnOGenOh21PX:1P7ikMg=^JFAOFeME
E5AFFEiTJg=lQ8fEW::WZZb/ZjRUX9^FTHb7Q85oOGemOWn0PH:2PGmlNGA_JVAO
FUICDE5BEEUOIVigP8VBVZ6WZjj^[Z^XY9jIThj9QH:0OWemOWn0PH61PH1nNgMc
KVQSGEUDDE1@DEEJHFUbO8J?V:2W[:n`[jfYY9nJU8n:QX>1OginOWmoP861PH1o
O7YfLVeWHUaGDe1>Ce5EFf=/MX6<UYnV[:na/:jZYZ2JUHn;QhB1P7moOgmoP820
P81oOWaiMG5/IV5KEU5>CDiAEUeVL7b7TYbU[;2b/[2/Yj6KUI2;QhB2PH1oOgmo
Oh20P7moOWekN7E`JfEOFEA?C4a=DEMPJWJ2SYVSZk2c/k6^Z::LUY2;QhB2PH20
P820OgmoOgmoOgimNgQeL6YTGUMBCD];CE9JI6mlRIFPZK2c]K>`ZZBMUi2;QhB2
PH60P820P7moOginOWinOG]hM6mYHU]ECd]9BTiDGVUfPi2LYjjc][Fb[:JOV96;
QhB2PH61PH61P81oOWinOWinOWekN7A^J65IDTe9BD]@F69_OHZHXjbc][Jd[jRQ
VI:<Qh>1P821PH61PH1oOWimOGinOgmnO7QdKFINEe1;B4Q<DUaXMXBBWjZa][Ne
/JZSVi><Qh>0P820PH:2PX60OgimOGenOgn0OgahLfaTG5A=BDM9CUIQKgf<VZJ_
]KRg/jfUWIB=Qh:0OWn0PH:2PX:1OgimO7amOX21PGmmN79ZHEUABdM7BU5KJ7J5
U:6/];Rh]JnXWiJ>Qh9oOGenP8:3Ph>2P7imO7alOWn1PX:0OGM`IeiFCTU6B4eE
HFmnSIbX/KNh]k:ZXIR?R89nO7amOh63Ph>3PGmmO7]kOGn1Ph>3PGafKVEKDTa7
ATU@FVQgQYJS[[Fh^;B]Y9^ARH9mNgYkOH22Q8B3PX1nO7]kO7j0PXB5Q85kM6]Q
F519AdM<EF5_OhnMZK:g^;F_YifCRX=mNWUjO7j1PhB4Ph5oOG]kNgeoPXB6QXB0
NW9YGeE=B4I9CeYWMhRGYK2f^KNaZInERh=mNWUiNgf0PX>3Ph:0OWelO7anP8>5
QXJ4P7UaIeeCBdM6BU=OKh2AX:fe^KRcZj6FS8AnNWQhNWanP8:2PX:0OgimO7en
Oh:4QXN6Q7mhKfEJDDY6AdeHIWN9VZRc^;Rd[J>HSXEnNWQhNG]mOh61PX60P7mn
OGenOh63QHN8QhAnMfeREdi8ATUAGVn1Tj>_]kVf[jFJShEnNGMgN7YlOX20PH60
P7moOWinOh22Q8J8RHN4OWEZGeA<AdM<EfIhRib[];Vg/JRLTHInNGIfMgUlOWn0
P820OgmoOgmoOh21PhF7RHZ8Q7ecJ5aABDI8D5i_PYFU/KRh/j^OThQnN7EdMWQk
OGioOgmoOgn0P820P820PXB6RH^;RHAkL6AHCTQ7C5IVNHbN[KFh]JfRUHUoN7Ac
M7MjO7inOginOWmoP861PH20PH:5R8^<S8V3NFePE4]7BE1NL8>FYk:g]k2UV8b0
N7=aLWEhNgenOWimOGioP862PX61PH63QXZ=SXf9PGIZG55:B4aGIgZ>X:jf]k:Y
W8j2N79`L7=gNWenOWemO7enOh62PX:2PH62QHR<Si2>RGmcIEQ>BDUAGW24V:Rb
][B/X9:4NG9^KW5eNGanOWelO7amOX22Ph>3PX61PhJ:Si:BShMlKf5DC4U=F6Qk
Sj6^]KF^XiF7Ng9]K6ibMg]mOWelNg]lOGn2PhB4PX61PXB8SI:DThj5NFYLDD];
DV1bQYVX/[B`YiV;OG9/JV]_M7UlOWilNgYjO7j1PhF5Q8:1PH>6Ri2EUYB=PWAV
F4m;CeUYO92Q[K>bZYf>P7A/J6U/LWMkOWimNgYiNWf0PhF5QH>2PH64R8jCUiNC
RWi_HEA=CE=PLhNJZK6b[J6CQ7M]J6Q[L7IjOGinO7]jNganPH>4Q8>2PH22QHZ?
U9NFT8MiJUaAC4mIJGfBXjnc[jJHR7Y`JVQ[KgEjOGmoOWakNganP8:3Ph>2PH20
PXJ;T9FFU8j2M6AGCTaBH7>8W:^b/JVLSGibJfQZKgAiOGmoOWelO7enOh22PX:2
PH1oP8>7S96EUY>:OViODde>F6UnTjF`/ZfQTX9eK6UZKW=iOGn0OgimOGenOh21
PH:1PH1oOh23QhfBUYJAQgQXFU1=DV1dRYj//ZnUUhIhKVUYKG9hOGn0P7mnOWin
Ogn0P861PH1oOgn0PhR>U9JESX9cHUE>CeUZOiFV/;6YW8]lL6UXK75gO7n1PH1o
OgmoOgmoOh20P81oOWinP8B:T9FGU8]mK5eACU=QMH^O[;6]XI60LfYXJW1fO821
PH20Oh20P820OgmoOgmoOgimOX25S9:GUi:6MfIHCe1IJh6FYjn_YIJ5MVaWJFie
Nh22PX60P821PH60OginOWioOgimO7f1QhjDV9J?PG5PE4mDHWJ<X:b_ZIb;NViW
IfacNX23Ph:1P821PX:1P7imOGenOWimNg]mPXV@UiVERW]ZFe9AFfb2UjN^[:6@
Og5XIVYaNGn3Q8>2PH61PX>2PGmmO7amOWimNgYkOXB<TiVITXEeI5MAEVAhSJ2[
[JFFQGEZIFM^MWj3QHF3PX61Ph>3PX1mO7]lOGimO7YiNWn6SiJJV8ioKUiDE5e^
PiRV[:RKRWU/IFE[M7b3QXJ5Ph61PhB4Ph5nO7]kO7emO7YhN7^1RI:IViF9NFMJ
E5QUNHjPZJVPT7m_IVAXL7Z2QhR6Q8:2PXB5Q8>0O7YjNgamOG]hMgMlPhfFViZB
Pg9REeIOKhBHYJZTUXEdJ6=VKGN0QXR7QH>2PX>4Q8>1OWajNgamOGajN7MiOXN@
V9^GS7aZG5EIIWZ?X:VWW8]jK6EUJgAnQ8N7QH>1PH:3Q8>2OgelNgamOWelNWQg
NX6:TiVJThIdHeQFGg26VZJYXI:0L6MUJG9kPhN7QX>2PH62Ph>2P7imO7amOWim
NgUgN7b3SIFJV8ioKEiFFFMkTJ:YYIR6MFUUJ71iPHJ7QXB2PH61PX:2PGmnOGem
OWinOG]iMgUnQXnGVYF8MfEIEemaQi^WZ9j=NfeVIfegOhF7QhB2PH21PH61P81o
OWinOWioOWejN7MjP8VBV9R@PFmOEeYXO9:RZ::DPW5XIV]dOXB7QhF2PH20P860
P81oOgmnOWmoOgilNGMgNh:<UIVFRgYXFeQPLXRLYZFJRGMZIVUaNh>7R8J3PH20
P820OgmoP81oOgmoOgmnNgUgN7f5SiNITXAbHEUKJGjCXZJOT7e^IVM_NH:7R8J3
PH1oP81oOgmoP820P81oOh1oOGYgMWQoRI>HUhelJUeIHW>9W:FSUXAcJ6I/MX27
RHR4PGmoOgmoOWinOh21PH20P820OgeiMWIjPXfFVIB6M6AKGFYoU:6TVh]iJfIY
Lgf6RXV6PWmoOgmoOWemOX21PX61P820P7mkMgEfO8J@V9R?OfeOFf=eRYbSWi9o
L6MWKgZ4RXZ7Ph1nOWmoOWelOGn1PX:2PH20PH1nNGEdMgn:U9VER7MVGEm/P9BP
XIN6MFUVK7N2RHb9QH5nOWinOWelO7j0PX>3PH20PH60O7McLgV3SYNHT85_HUiV
Mh^KXI^=NfeVJG=nR8b;Qh9nOGinOWekNgaoPXB4Ph61PH:1OgYeLWAlQi:HUXYi
JF1RKX6DWYjCPW9XIfmkQXb=RHAoOGenOWelNganP8>4Ph:1PH62PGehLg9fP8bE
V963LFAOIgR<VinHRGQ[IfagPXZ<RXF0OWenOWimO7amOh63Ph:1PH62PX1kMW=d
NXB@UiJ;NfYPHVn2UInMT7i_J6YcOXR<RhJ1OWemOWinOGamOX22PX:1PH61PX5n
NWEcMWj9TiNBQ7=TH6QiSI^OUXIeJVQ_NhF;RhN3OgemOWinOWemOWn1PX:1PH21
PH:1OGUdM7R2SIFFS7a[HF=`Q9FNVhekKFQ/Mh:9RhR4OgemOWioOWinOWn0PH61
PH20PH:2P7agM7ElQY6FTXEdIV5YNXjKWI>2LVUZLgj7RhV5P7imOGioOginOgmo
P820P820P862PWmkMWAgOh^DUHenKF9TLHFFWIR9N6aYL7^5RXZ6PGimOGioOgmo
OgmoOgn0P820P862PX5nNGEdNXB?UI>7MVMRJW^>Vi^@Og1ZKGN2RH^7PWilOGio
OgmoOh20OgmoOh20P821PX:1OGMdMWf8TYF>OfiTIG>6UYbEQWI[Jg=nR8^9Q7ml
O7enOgmoP820P7mnOgn0P820PX>3P7]fM7R1SIBCQgMYI6alSiZISGa_JW1kQH^:
QH1lO7enOgmoP861P7mnOWioP820PH:3PWiiM7AkQY2DSX1`IVMdQYFJTX=cJfeg
PXZ;Qh5mNganOgmoP861PH1nOGenOh20P8:3Q89lMW=fOhZCTXQhJfI]OXnHUXUi
KVacOXR<RH=mNg]mOWmoP862PX5oOGemOgn0P863Q8B0NWAcNHB>Thn1LVQYMXND
Uhn0LVa_NXF<RhIoNgYlOWmoOh22Ph:0OWalOWmoOh22Q8F3OWMcM7f8TI:9NVeX
Kgn>UY>6Mfe]MX::S8R1NgUjOGmoOh21Ph>1OgelOGioOgn1PhF5PW]eLgN2SI:?
PW=ZJgN7U9F<OG1/LWf8S8Z3OGYjO7ioOh20PX:2P7imOGioOgn0PH>5Q7mhM7Ak
Qi2BRG]]JG20SiJAPgE]KgV4Rh^6Og]jO7ioP820PH:2PGmnOGinOgmoP8:4QH9m
MWAgP8^ASX=dJVahR9BDRW]`KWF0RH^7PGajNgeoP820P861PH1nOWinOgmoOh22
Q8B0NWEdNXF>THYkKVYaPHnESh5dKW9lQX^9PgikNgeoP820P821PH1oOWinOgmo
Ogn1PhB3OWQdMWn9T8j3MF]]NHVCThMiKfmhPXV:QGmkNgeoP820P820P81oOgmn
OgmoOgn0PH>4PGafMGV3SI2:O6m[LX6?U8eoLfmdOhN:Qh5lNganP820P820P820
OgmoOgmoOgmoP8:4Ph1jMGImR8n>PgE/KWZ9Ti65Mg1bNhF:R8=mNganP820P820
P7moOh1oOgmoOgmnOh23Q8=nN7EiPX^?RWe`K7B2Si::OG9`Mh68RHEoNg]mOh20
P820P7moOh20P7moOgmnOWn1Q8B1NgIfO8J>SHAfKVmkRY:?PgI`M7f6RXJ0O7Yl
Oh21P820P7moOgn0P81oOgmoOWj0PXB4OgUeN82:SXUmLFiePhjAR7]bLWZ3RHR2
OGYkOX21PH20P7mnOWn0PH60OgmoOWinP8>5PWegMW^5S8f4MfmaO8V@S85eLGJ0
R8V5OWYjOH21PH20P7mnOWioPH60P7moOWinOh:4QH5jMWMoR8f9OW=_MX>>SXIj
LWAlQHV7P7]jO7n1PH60P81oOWioP861P7moOgimOX23QHAnN7EjPh^<Q7QaLgf9
ShYoMG9iPXV8PgaiNgj1PX60P81oOWenP862PH1oOgimOGj1QHF2NgIgOXN<RGid
LGR4SHf4NG=fOXN9QGmjNWf0PX61P81oOWinOh21PH1oOgmnOGeoPhF4OgUfNX::
RhAiLWAnRHj8OGAdNhB8Qh5lNWaoPH61P820OginOX21PH20OgmoOWenP8B5PWag
Mgf6RhQoMG9iQ8b;PWQcMh27R8=mNW]nPH61P820OgmnOWn0PH60OgmoOWinOh:4
Q81jMgV1RH^4NG9dOhV=QgaeMGf5R8EoNg]mP861P820OgmoOWn0P820P7moOgin
OX23Q89mN7QmQHZ8OgEcNHF<RX5gM7V2QhJ1O7]lOh61P81oOgmoOgmoP820P81o
OgmnOWj1PhB1NgQiPHR:Q7YcMGn9S8EkMGMnQHN3OW]lOX21PH1oOgmoOgmoOh20
P820OgmoOWioPXB3OWUhO8B:R7mfM7Z5RhUoMgEkPhN5P7akOH21PH1oOgmoOgmo
OgmoP820P81oOWinP8>4PGahNH27RHAjM7N0RHZ4NWIhP8J6PWekOGn1PH1oOgmo
Ogn0P7moOh20P820OginOX63PgmjN7b3RHMoMgEkQHZ7OWMgOHB6PgikO7n1PH1o
OgmoOgn0P7moOgn0P820P7mnOWn2Q89mNGYoQXR3NgEhP8R9PWYfNX66QH1lNgj0
PH60OgmoOgn0P81oOgmoP820P7mnOGj0Ph>0NgUlPXR6OgQfO8F9QGegN7j4QX9m
Ngf0PH60OgmoOgn0P81oOgmoP820P81oOWeoPHB2OWYjOhF7Pg]fNH68Qh5jMgb2
QXAoNgaoPH:1OgmoOgmoP820OgioOh20P820OgemP8>4PGaiNh:7QWmiMgf5R8Am
N7Z0QHF1O7]mP8:1P7moOgmoP860OginOh20P820OgimOX63PgmkNWj4Qh=lN7Z1
QhJ0NWUmPhF2OW]lOh:2P7moOgmoP821P7mnOWn0P820P7mmOGn2Ph5mNW^1QXEo
NGQnQ8N3O7UkPHF4P7alOX62PGmoOgmoOh20P7moOWmoP820P7mnOGj0Ph=oNgYn
Q8J3O7QkPHJ5OgYjOX>4PGelOH21PH1oOgmoOh20P81oOgmoP820P81oOWioPH>1
OG]lPHF5OgYiOXB6PWaiO864PgmlOGn1PH1oOgmoOgn0P81oOgmoOh20P820Ogin
P8:2P7akOX>5PWaiNh:6Q7ijNgn3Q81mO7j0PH1oOgmoOgn0P820OgmoOgn0P820
OginOh62PGikO824Q7mjNWn4QH5lNWf2Q89nO7j0PH60OgmoOgmoP820OgmoOgmo
P820P7mnOWn2PX1mNgj2QH9mNWb2QH=nNWb0Ph=oOGeoPH60OgmoOgmoP81oOgmo
OgmoOh20P81oOWj0PX5oO7b0Q8AoNgYoQ8B0O7]nPX>1OWenP860OgmoOgn0P7mo
OgmoOgmoOgn0P81oOWioPH:0OGanPXB2OGYmPXB2OW]mPH>2OgenP860OgmoOgn0
P7moOgmoP7moOgmoP820OginP8:1OgamP8>3Og]kOh>3P7alOh:2P7imOh21P7mo
Ogn0P81oOgmoP81oOgmoOh20P7mnOh62P7ilOX63PGekOH:4PWelOH62PGimOX21
P7moOgn0P81oOgmoP820OgmoOh20P7mnOWn1PGmmOGn2PWmlO823PgmlOH22PWmm
OWn1P7moOgn0P820OgmoP820OgmoOgn0P81oOWn0PH5nOGj1Ph5nO7j1Ph5mO7j1
PX1nOGn0PH1oOgmoP820OgmoOh20P7moOgn0P81oOWioPH60OGeoPX9oOGf0PX9o
OGf0PX5oOWj0PH1oOgmoP820OgmoOh20P7moOgmoP820OgioP861OgenPH:1OWen
PH:0OWeoPH60OWioP820OgmoP820P7moOgn0P81oOgmoOh20OgmnOh61P7imOh61
OgemP8:1OgenP860OgioP820OgmoOh20P7moOgn0P81oOgmoOh20P7moOh21P7mn
OX22P7imOh62P7imOh61OginOh20OgmoOh20P7moOgmoP81oOgmoOgn0P81oOgn0
PH1nOWn1PGmnOX21PGmnOX21P7mnOh20P7moOgn0P7moOgmoOh20OgmoOgmoP81o
Ogn0P81oOWn0PH1nOWn1PH1nOWn1P7mnOh20P7moOgn0OgmoOgmoOgmoOgmoOgmo
P820OgmoP820OgioPH5oOWj0PH1oOWn0P81oOgn0P7moOgn0OgmoOgmoOgmoOgmo
OgmoOh20OgmoOh20OgioP860OgioP85oOWj0P81oOgn0P81oOgmoOgmoOgmoOgmo
OgmoOgmoOgn0P7moOh20P7moOh20OgioP820OgioP81oOgmoP81oOgmoOgmoOgmo
OgmoOgmoOgmoOgn0P7moOgn0P7moOh20P7moOh20OgmoP820OgmoP81oOgmoOgmo
OgmoOgmoOgmoOgmoOgmoP81oOgn0P81oOgn0P7moOh20P7moOh20OgmoP81oOgmo
OgmoOgmoOgmoOgmoOgmoOgmoOh1oOgmoP81oOgn0P81oOgn0P7moOh20OgmoOh20
OgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOh1oOgmoP81oOgmoP7moOgn0Ogmo
OgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmo
OgmoOgmoOgmoO`\>"]},
  ImageCacheContents->"Sound",
  CellTags->{"Sound", "Using MathReader"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Changing Display Characteristics", "Subsubsection",
  ShowCellBracket->False,
  CellTags->{"Display Characteristics", "Using MathReader"}],

Cell[TextData[{
  "Resize a window using the standard mechanisms on your window system. \
Magnify by using the pop-up menu in the window, or the ",
  StyleBox[ButtonBox["Magnification",
    ButtonData:>"Magnification",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Helvetica"],
  StyleBox[" ", "SR"],
  "command in the Format menu. Resize a graphic by clicking and dragging."
}], "Text",
  ShowCellBracket->False,
  CellTags->{"Display Characteristics", "Using MathReader"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Printing", "Subsubsection",
  ShowCellBracket->False,
  CellTags->{"Printing", "Using MathReader"}],

Cell[TextData[{
  "Print a complete notebook by choosing",
  StyleBox[" ", "SR"],
  StyleBox[ButtonBox["Print...",
    ButtonData:>"Print...",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Helvetica"],
  StyleBox[" ", "SR"],
  "in the File menu. Print part of a notebook by choosing",
  StyleBox[" ", "SR"],
  StyleBox[ButtonBox["Print Selection",
    ButtonData:>"Print Selection",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Helvetica"],
  ".\nNote: notebooks are separately optimized for screen and printing, so \
they may look different in the two environments. (See",
  StyleBox[" ", "SR"],
  StyleBox[ButtonBox["Screen Style Environment",
    ButtonData:>"Screen Style Environment",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Helvetica"],
  StyleBox[" ", "SR"],
  "and",
  StyleBox[" ", "SR"],
  StyleBox[ButtonBox["Printing Style Environment",
    ButtonData:>"Printing Style Environment",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Helvetica"],
  StyleBox[" ", "SR"],
  "on the Format menu.)"
}], "Text",
  ShowCellBracket->False,
  CellTags->{"Printing", "Using MathReader"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["International and Special Characters", "Subsubsection",
  ShowCellBracket->False,
  CellTags->{"Special Characters", "Using MathReader"}],

Cell["\<\
Notebooks use platform-independent Unicode for all characters. \
Characters generated on any computer system should, therefore, display \
correctly so long as the necessary fonts have been installed.\
\>", "Text",
  ShowCellBracket->False,
  CellTags->{"Special Characters", "Using MathReader"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["More Information", "Subsection",
  ShowCellBracket->False,
  CellHorizontalScrolling->True,
  CellTags->"More Information"],

Cell[CellGroupData[{

Cell["Using the Help Browser", "Subsubsection",
  ShowCellBracket->False,
  CellTags->{"More Information", "Using Help"}],

Cell[TextData[{
  "Versions of ",
  StyleBox["MathReader",
    FontSlant->"Italic"],
  " on CD-ROM come with a complete ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " help system. The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Help Browser can be accessed by choosing the",
  StyleBox[" ", "SR"],
  StyleBox[ButtonBox["Help...",
    ButtonData:>"Help...",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Helvetica"],
  StyleBox[" ", "SR"],
  "command."
}], "Text",
  ShowCellBracket->False,
  CellTags->{"More Information", "Using Help"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Notebook Format", "Subsubsection",
  ShowCellBracket->False,
  CellTags->{"More Information", "Notebook Format"}],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-compatible notebook documents contain only printable ASCII characters, \
making them easy to exchange between applications and between computer \
systems."
}], "Text",
  ShowCellBracket->False,
  CellTags->{"More Information", "Notebook Format"}],

Cell[TextData[{
  "Notebooks are represented as ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " symbolic expressions, which can be manipulated using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". To see the expression form of a cell, use",
  StyleBox[" ", "SR"],
  StyleBox[ButtonBox["Show Expression",
    ButtonData:>"Show Expression",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Helvetica"],
  " in the Format menu."
}], "Text",
  ShowCellBracket->False,
  CellTags->{"More Information", "Notebook Format"}],

Cell["\<\
Notebooks use resolution-independent PostScript for most graphics, \
but also include platform-independent bitmap caches.\
\>", "Text",
  ShowCellBracket->False,
  CellTags->{"More Information", "Notebook Format"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Licensing Information", "Subsubsection",
  ShowCellBracket->False,
  CellTags->{"More Information", "Licensing Info"}],

Cell[TextData[{
  StyleBox["MathReader",
    FontSlant->"Italic"],
  " is licensed free of charge, subject to certain terms and conditions.  For \
more information contact Wolfram Research (",
  ButtonBox["info@wolfram.com",
    ButtonData:>{
      URL[ "mailto:info@wolfram.com"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  ")."
}], "Text",
  ShowCellBracket->False,
  CellTags->{"More Information", "Licensing Info"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Resources on the Web", "Subsection",
  ShowCellBracket->False,
  CellHorizontalScrolling->True,
  CellTags->"Web Resources"],

Cell[CellGroupData[{

Cell["Main Web Sites", "Subsubsection",
  ShowCellBracket->False,
  CellTags->{"ContactInformation", "web", "Web Resources"}],

Cell[TextData[{
  ButtonBox["http://www.wolfram.com",
    ButtonData:>{
      URL[ "http://www.wolfram.com"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  "\n",
  ButtonBox["http://www.wolfram.co.uk",
    ButtonData:>{
      URL[ "http://www.wolfram.co.uk"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  "\n",
  ButtonBox["http://www.wolfram.co.jp",
    ButtonData:>{
      URL[ "http://www.wolfram.co.jp"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  "\n\nNote: All services listed are available at all of these sites."
}], "Text",
  ShowCellBracket->False,
  CellTags->{"ContactInformation", "web", "Web Resources"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["General and sales information",
  FontWeight->"Bold"]], "Subsubsection",
  ShowCellBracket->False,
  CellTags->{"ContactInformation", "info", "Web Resources"}],

Cell[TextData[{
  ButtonBox["info@wolfram.com",
    ButtonData:>{
      URL[ "mailto:info@wolfram.com"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  "\n",
  ButtonBox["http://www.wolfram.com",
    ButtonData:>{
      URL[ "http://www.wolfram.com"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None]
}], "Text",
  ShowCellBracket->False,
  CellTags->{"info", "Web Resources"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Frequently asked technical and other questions",
  FontWeight->"Bold"]], "Subsubsection",
  ShowCellBracket->False,
  CellTags->{"info", "Web Resources"}],

Cell[TextData[ButtonBox["http://www.wolfram.com/faq",
  ButtonData:>{
    URL[ "http://www.wolfram.com/faq"], None},
  ButtonStyle->"Hyperlink",
  ButtonNote->None]], "Text",
  ShowCellBracket->False,
  CellTags->{"info", "Web Resources"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" training information",
    FontWeight->"Bold"]
}], "Subsubsection",
  ShowCellBracket->False,
  CellTags->{"services", "Web Resources"}],

Cell[TextData[{
  ButtonBox["training@wolfram.com",
    ButtonData:>{
      URL[ "mailto:training@wolfram.com"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  "\n",
  ButtonBox["http://www.wolfram.com/training",
    ButtonData:>{
      URL[ "http://www.wolfram.com/training"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None]
}], "Text",
  ShowCellBracket->False,
  CellTags->{"services", "Web Resources"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Suggestions",
  FontWeight->"Bold"]], "Subsubsection",
  ShowCellBracket->False,
  CellTags->{"ContactInformation", "comments", "Web Resources"}],

Cell[TextData[{
  ButtonBox["suggestions@wolfram.com",
    ButtonData:>{
      URL[ "mailto:suggestions@wolfram.com"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  "\n",
  ButtonBox["http://www.wolfram.com/suggestions",
    ButtonData:>{
      URL[ "http://www.wolfram.com/suggestions"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None]
}], "Text",
  ShowCellBracket->False,
  CellTags->{"comments", "Web Resources"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Comments and feedback",
  FontWeight->"Bold"]], "Subsubsection",
  ShowCellBracket->False,
  CellTags->{"comments", "Web Resources"}],

Cell[TextData[{
  ButtonBox["comments@wolfram.com",
    ButtonData:>{
      URL[ "mailto:comments@wolfram.com"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  "\n",
  ButtonBox["http://www.wolfram.com/comments",
    ButtonData:>{
      URL[ "http://www.wolfram.com/comments"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None]
}], "Text",
  ShowCellBracket->False,
  CellTags->{"comments", "Web Resources"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  StyleBox[" Products Catalog",
    FontWeight->"Bold"]
}], "Subsubsection",
  ShowCellBracket->False,
  CellTags->{"ContactInformation", "products", "Web Resources"}],

Cell[TextData[ButtonBox["http://www.wolfram.com/catalog",
  ButtonData:>{
    URL[ "http://www.wolfram.com/catalog"], None},
  ButtonStyle->"Hyperlink",
  ButtonNote->None]], "Text",
  ShowCellBracket->False,
  CellTags->{"products", "Web Resources"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The ",
    FontWeight->"Bold"],
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" Book",
    FontWeight->"Bold"]
}], "Subsubsection",
  ShowCellBracket->False,
  CellTags->{"products", "Web Resources"}],

Cell[TextData[{
  ButtonBox["book-updates-responder@wolfram.com",
    ButtonData:>{
      URL[ "mailto:book-updates-responder@wolfram.com"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  "\n",
  ButtonBox["http://www.wolfram.com/book-updates",
    ButtonData:>{
      URL[ "http://www.wolfram.com/book-updates"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None]
}], "Text",
  ShowCellBracket->False,
  CellTags->{"products", "Web Resources"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" Bookstore",
    FontWeight->"Bold"]
}], "Subsubsection",
  ShowCellBracket->False,
  CellTags->{"products", "Web Resources"}],

Cell[TextData[ButtonBox["http://www.wolfram.com/bookstore",
  ButtonData:>{
    URL[ "http://www.wolfram.com/bookstore"], None},
  ButtonStyle->"Hyperlink",
  ButtonNote->None]], "Text",
  ShowCellBracket->False,
  CellTags->{"products", "Web Resources"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["MathSource",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" Electronic Library",
    FontWeight->"Bold"]
}], "Subsubsection",
  ShowCellBracket->False,
  CellTags->{"products", "Web Resources"}],

Cell[TextData[{
  ButtonBox["http://www.wolfram.com/mathsource",
    ButtonData:>{
      URL[ "http://www.wolfram.com/mathsource"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  "\n",
  ButtonBox["ftp: mathsource.wolfram.com",
    ButtonData:>{
      URL[ "ftp: mathsource.wolfram.com"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  "\nmail server: ",
  ButtonBox["mathsource@wolfram.com",
    ButtonData:>{
      URL[ "mailto:mathsource@wolfram.com"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  "\nadministrator: ",
  ButtonBox["mathsource-admin@wolfram.com",
    ButtonData:>{
      URL[ "mailto:mathsource-admin@wolfram.com"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None]
}], "Text",
  ShowCellBracket->False,
  CellTags->{"products", "Web Resources"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["MathUser ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["Newsletter",
    FontWeight->"Bold"]
}], "Subsubsection",
  ShowCellBracket->False,
  CellTags->{"products", "Web Resources"}],

Cell[TextData[{
  ButtonBox["http://www.wolfram.com/mathuser",
    ButtonData:>{
      URL[ "http://www.wolfram.com/mathuser"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  "\n",
  ButtonBox["mathuser@wolfram.com",
    ButtonData:>{
      URL[ "mailto:mathuser@wolfram.com"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None]
}], "Text",
  ShowCellBracket->False,
  CellTags->{"products", "Web Resources"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "The Complete ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " System"
}], "Subsection",
  ShowCellBracket->False,
  CellHorizontalScrolling->True,
  CellTags->"Complete Mathematica Contact"],

Cell[CellGroupData[{

Cell[TextData[{
  "To obtain your own copy of the complete ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " system, contact Wolfram Research at any of the following addresses:"
}], "Subsubsection",
  ShowCellBracket->False,
  CellTags->"Complete Mathematica Contact"],

Cell[TextData[{
  StyleBox["Wolfram Research, Inc.",
    FontWeight->"Bold"],
  "\n",
  StyleBox["email:",
    FontSlant->"Italic"],
  ButtonBox[" info@wolfram.com",
    ButtonData:>{
      URL[ "mailto:info@wolfram.com"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  "  \n",
  StyleBox["web:",
    FontSlant->"Italic"],
  " ",
  ButtonBox["http://www.wolfram.com",
    ButtonData:>{
      URL[ "http://www.wolfram.com"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  "\n",
  StyleBox["phone: ",
    FontSlant->"Italic"],
  "217-398-5151\n",
  StyleBox["fax:",
    FontSlant->"Italic"],
  " 217-398-1108\n",
  StyleBox["mail:",
    FontSlant->"Italic"],
  " 100 Trade Center Drive\nChampaign, IL 61820-7237, USA\n\n",
  StyleBox["Wolfram Research Europe Ltd.",
    FontWeight->"Bold"],
  "\n",
  StyleBox["email:",
    FontSlant->"Italic"],
  ButtonBox[" info@wolfram.co.uk",
    ButtonData:>{
      URL[ "mailto:info@wolfram.co.uk"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  "\n",
  StyleBox["web:",
    FontSlant->"Italic"],
  " ",
  ButtonBox["http://www.wolfram.co.uk",
    ButtonData:>{
      URL[ "http://www.wolfram.co.uk"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  "\n",
  StyleBox["phone:",
    FontSlant->"Italic"],
  " +44-(0)1993-883400 \n",
  StyleBox["fax:",
    FontSlant->"Italic"],
  " +44-(0)1993-883800\n",
  StyleBox["mail:",
    FontSlant->"Italic"],
  " 10 Blenheim Office Park, Lower Road \nLong Hanborough, Oxfordshire OX8 \
8LN, UK\n\n",
  StyleBox["Wolfram Research Asia Ltd.",
    FontWeight->"Bold"],
  "\n",
  StyleBox["email:",
    FontSlant->"Italic"],
  ButtonBox[" info@wolfram.co.jp",
    ButtonData:>{
      URL[ "mailto:info@wolfram.co.jp"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  "\n",
  StyleBox["web:",
    FontSlant->"Italic"],
  ButtonBox[" http://www.wolfram.co.jp",
    ButtonData:>{
      URL[ "http://www.wolfram.co.jp"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  "\n",
  StyleBox["phone:",
    FontSlant->"Italic"],
  " +81-(0)3-5276-0506\n",
  StyleBox["fax:",
    FontSlant->"Italic"],
  " +81-(0)3-5276-0509\n",
  StyleBox["mail:",
    FontSlant->"Italic"],
  " Izumi Building 8F\n3-2-15 Misaki-cho\nChiyoda-ku, Tokyo 101, JAPAN"
}], "Text",
  ShowCellBracket->False,
  CellTags->"Complete Mathematica Contact"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1152}, {0, 850}},
Editable->False,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{703, 668},
WindowMargins->{{5, Automatic}, {Automatic, 5}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Inherited, Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"], Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}},
PrintingOptions->{"PrintCellBrackets"->True,
"FirstPageHeader"->False,
"FacingPages"->True},
ShowCellBracket->False,
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb",
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002n88o?moogl<H`Ue0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@DneO000000000006P801T1T00000000000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "What is MathReader"->{
    Cell[1709, 49, 164, 7, 38, "Subsection",
      CellTags->"What is MathReader"],
    Cell[1876, 58, 577, 18, 43, "Subtitle",
      CellTags->"What is MathReader"],
    Cell[2456, 78, 289, 7, 70, "Text",
      CellTags->"What is MathReader"],
    Cell[2748, 87, 405, 13, 40, "Text",
      CellTags->"What is MathReader"]},
  "Licensing Information"->{
    Cell[3178, 104, 180, 4, 34, "Subsubsection",
      CellTags->"Licensing Information"],
    Cell[3361, 110, 402, 12, 39, "Text",
      CellTags->"Licensing Information"]},
  "Using MathReader"->{
    Cell[3800, 127, 233, 7, 34, "Subsubsection",
      CellTags->"Using MathReader"],
    Cell[4036, 136, 681, 18, 56, "Text",
      CellTags->"Using MathReader"],
    Cell[4742, 158, 192, 6, 34, "Subsubsection",
      CellTags->{"Get Notebook", "Using MathReader"}],
    Cell[4937, 166, 267, 9, 23, "Text",
      CellTags->{"Get Notebook", "Using MathReader"}],
    Cell[5241, 180, 210, 7, 34, "Subsubsection",
      CellTags->{"Web Browser", "Using MathReader"}],
    Cell[5454, 189, 1167, 36, 352, "Text",
      CellTags->{"Web Browser", "Using MathReader"}],
    Cell[6658, 230, 116, 2, 34, "Subsubsection",
      CellTags->{"Animation", "Using MathReader"}],
    Cell[6777, 234, 487, 11, 61, "Text",
      CellTags->{"Animation", "Using MathReader"}],
    Cell[7289, 249, 7824, 104, 114, 7443, 93, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[15116, 355, 7898, 105, 122, 7524, 94, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[23017, 462, 7910, 105, 122, 7536, 94, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[30930, 569, 7946, 105, 122, 7572, 94, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[38879, 676, 7958, 105, 122, 7584, 94, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[46840, 783, 7991, 106, 122, 7617, 95, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[54834, 891, 7998, 109, 122, 7624, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[62835, 1002, 8006, 109, 122, 7632, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[70844, 1113, 7949, 108, 122, 7575, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[78796, 1223, 8018, 109, 122, 7644, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[86817, 1334, 8038, 109, 122, 7664, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[94858, 1445, 8014, 109, 70, 7640, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[102875, 1556, 7978, 109, 70, 7604, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[110856, 1667, 7966, 109, 70, 7592, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[118825, 1778, 7917, 108, 70, 7543, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[126745, 1888, 7925, 108, 70, 7551, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[134673, 1998, 7885, 108, 70, 7511, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[142561, 2108, 7949, 108, 70, 7575, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[150513, 2218, 7966, 109, 70, 7592, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[158482, 2329, 7957, 108, 70, 7583, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[166442, 2439, 7941, 108, 70, 7567, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[174386, 2549, 7990, 109, 70, 7616, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[182379, 2660, 7982, 109, 70, 7608, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[190364, 2771, 7974, 109, 70, 7600, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[198341, 2882, 7941, 108, 70, 7567, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[206285, 2992, 8010, 109, 70, 7636, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[214298, 3103, 8014, 109, 70, 7640, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[222315, 3214, 8059, 110, 70, 7685, 99, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[230377, 3326, 7998, 109, 70, 7624, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[238378, 3437, 8063, 110, 70, 7689, 99, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[246444, 3549, 8055, 110, 70, 7681, 99, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[254502, 3661, 8091, 110, 70, 7717, 99, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[262596, 3773, 8047, 110, 70, 7673, 99, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[270646, 3885, 8204, 111, 70, 7830, 100, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[278853, 3998, 8265, 112, 70, 7891, 101, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[287121, 4112, 8281, 112, 70, 7907, 101, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[295405, 4226, 8306, 113, 70, 7932, 102, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[303714, 4341, 8314, 113, 122, 7940, 102, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[312031, 4456, 8346, 113, 122, 7972, 102, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[320380, 4571, 8358, 113, 122, 7984, 102, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[328741, 4686, 8306, 113, 122, 7932, 102, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[337050, 4801, 8371, 114, 122, 7997, 103, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[345424, 4917, 8419, 114, 122, 8045, 103, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[353846, 5033, 8468, 115, 122, 8094, 104, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[362317, 5150, 8500, 115, 122, 8118, 104, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[370832, 5268, 214, 6, 43, "Text",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[371083, 5279, 108, 2, 34, "Subsubsection",
      CellTags->{"Sound", "Using MathReader"}],
    Cell[371194, 5283, 465, 12, 38, "Text",
      CellTags->{"Sound", "Using MathReader"}],
    Cell[371662, 5297, 84594, 1172, 182, 33781, 469, "GraphicsData", 
    "PostScript", "Sound",
      Evaluatable->False,
      CellTags->{"Sound", "Using MathReader"}],
    Cell[456293, 6474, 144, 2, 34, "Subsubsection",
      CellTags->{"Display Characteristics", "Using MathReader"}],
    Cell[456440, 6478, 487, 11, 38, "Text",
      CellTags->{"Display Characteristics", "Using MathReader"}],
    Cell[456964, 6494, 105, 2, 34, "Subsubsection",
      CellTags->{"Printing", "Using MathReader"}],
    Cell[457072, 6498, 1144, 32, 61, "Text",
      CellTags->{"Printing", "Using MathReader"}],
    Cell[458253, 6535, 143, 2, 34, "Subsubsection",
      CellTags->{"Special Characters", "Using MathReader"}],
    Cell[458399, 6539, 305, 6, 38, "Text",
      CellTags->{"Special Characters", "Using MathReader"}]},
  "Get Notebook"->{
    Cell[4742, 158, 192, 6, 34, "Subsubsection",
      CellTags->{"Get Notebook", "Using MathReader"}],
    Cell[4937, 166, 267, 9, 23, "Text",
      CellTags->{"Get Notebook", "Using MathReader"}]},
  "Web Browser"->{
    Cell[5241, 180, 210, 7, 34, "Subsubsection",
      CellTags->{"Web Browser", "Using MathReader"}],
    Cell[5454, 189, 1167, 36, 352, "Text",
      CellTags->{"Web Browser", "Using MathReader"}]},
  "Animation"->{
    Cell[6658, 230, 116, 2, 34, "Subsubsection",
      CellTags->{"Animation", "Using MathReader"}],
    Cell[6777, 234, 487, 11, 61, "Text",
      CellTags->{"Animation", "Using MathReader"}],
    Cell[7289, 249, 7824, 104, 114, 7443, 93, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[15116, 355, 7898, 105, 122, 7524, 94, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[23017, 462, 7910, 105, 122, 7536, 94, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[30930, 569, 7946, 105, 122, 7572, 94, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[38879, 676, 7958, 105, 122, 7584, 94, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[46840, 783, 7991, 106, 122, 7617, 95, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[54834, 891, 7998, 109, 122, 7624, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[62835, 1002, 8006, 109, 122, 7632, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[70844, 1113, 7949, 108, 122, 7575, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[78796, 1223, 8018, 109, 122, 7644, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[86817, 1334, 8038, 109, 122, 7664, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[94858, 1445, 8014, 109, 70, 7640, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[102875, 1556, 7978, 109, 70, 7604, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[110856, 1667, 7966, 109, 70, 7592, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[118825, 1778, 7917, 108, 70, 7543, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[126745, 1888, 7925, 108, 70, 7551, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[134673, 1998, 7885, 108, 70, 7511, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[142561, 2108, 7949, 108, 70, 7575, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[150513, 2218, 7966, 109, 70, 7592, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[158482, 2329, 7957, 108, 70, 7583, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[166442, 2439, 7941, 108, 70, 7567, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[174386, 2549, 7990, 109, 70, 7616, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[182379, 2660, 7982, 109, 70, 7608, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[190364, 2771, 7974, 109, 70, 7600, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[198341, 2882, 7941, 108, 70, 7567, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[206285, 2992, 8010, 109, 70, 7636, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[214298, 3103, 8014, 109, 70, 7640, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[222315, 3214, 8059, 110, 70, 7685, 99, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[230377, 3326, 7998, 109, 70, 7624, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[238378, 3437, 8063, 110, 70, 7689, 99, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[246444, 3549, 8055, 110, 70, 7681, 99, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[254502, 3661, 8091, 110, 70, 7717, 99, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[262596, 3773, 8047, 110, 70, 7673, 99, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[270646, 3885, 8204, 111, 70, 7830, 100, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[278853, 3998, 8265, 112, 70, 7891, 101, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[287121, 4112, 8281, 112, 70, 7907, 101, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[295405, 4226, 8306, 113, 70, 7932, 102, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[303714, 4341, 8314, 113, 122, 7940, 102, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[312031, 4456, 8346, 113, 122, 7972, 102, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[320380, 4571, 8358, 113, 122, 7984, 102, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[328741, 4686, 8306, 113, 122, 7932, 102, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[337050, 4801, 8371, 114, 122, 7997, 103, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[345424, 4917, 8419, 114, 122, 8045, 103, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[353846, 5033, 8468, 115, 122, 8094, 104, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[362317, 5150, 8500, 115, 122, 8118, 104, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[370832, 5268, 214, 6, 43, "Text",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}]},
  "Rolling Square"->{
    Cell[7289, 249, 7824, 104, 114, 7443, 93, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[15116, 355, 7898, 105, 122, 7524, 94, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[23017, 462, 7910, 105, 122, 7536, 94, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[30930, 569, 7946, 105, 122, 7572, 94, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[38879, 676, 7958, 105, 122, 7584, 94, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[46840, 783, 7991, 106, 122, 7617, 95, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[54834, 891, 7998, 109, 122, 7624, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[62835, 1002, 8006, 109, 122, 7632, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[70844, 1113, 7949, 108, 122, 7575, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[78796, 1223, 8018, 109, 122, 7644, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[86817, 1334, 8038, 109, 122, 7664, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[94858, 1445, 8014, 109, 70, 7640, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[102875, 1556, 7978, 109, 70, 7604, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[110856, 1667, 7966, 109, 70, 7592, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[118825, 1778, 7917, 108, 70, 7543, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[126745, 1888, 7925, 108, 70, 7551, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[134673, 1998, 7885, 108, 70, 7511, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[142561, 2108, 7949, 108, 70, 7575, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[150513, 2218, 7966, 109, 70, 7592, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[158482, 2329, 7957, 108, 70, 7583, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[166442, 2439, 7941, 108, 70, 7567, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[174386, 2549, 7990, 109, 70, 7616, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[182379, 2660, 7982, 109, 70, 7608, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[190364, 2771, 7974, 109, 70, 7600, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[198341, 2882, 7941, 108, 70, 7567, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[206285, 2992, 8010, 109, 70, 7636, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[214298, 3103, 8014, 109, 70, 7640, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[222315, 3214, 8059, 110, 70, 7685, 99, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[230377, 3326, 7998, 109, 70, 7624, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[238378, 3437, 8063, 110, 70, 7689, 99, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[246444, 3549, 8055, 110, 70, 7681, 99, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[254502, 3661, 8091, 110, 70, 7717, 99, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[262596, 3773, 8047, 110, 70, 7673, 99, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[270646, 3885, 8204, 111, 70, 7830, 100, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[278853, 3998, 8265, 112, 70, 7891, 101, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[287121, 4112, 8281, 112, 70, 7907, 101, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[295405, 4226, 8306, 113, 70, 7932, 102, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[303714, 4341, 8314, 113, 122, 7940, 102, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[312031, 4456, 8346, 113, 122, 7972, 102, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[320380, 4571, 8358, 113, 122, 7984, 102, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[328741, 4686, 8306, 113, 122, 7932, 102, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[337050, 4801, 8371, 114, 122, 7997, 103, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[345424, 4917, 8419, 114, 122, 8045, 103, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[353846, 5033, 8468, 115, 122, 8094, 104, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[362317, 5150, 8500, 115, 122, 8118, 104, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[370832, 5268, 214, 6, 43, "Text",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}]},
  "G.2.38"->{
    Cell[7289, 249, 7824, 104, 114, 7443, 93, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[15116, 355, 7898, 105, 122, 7524, 94, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[23017, 462, 7910, 105, 122, 7536, 94, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[30930, 569, 7946, 105, 122, 7572, 94, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[38879, 676, 7958, 105, 122, 7584, 94, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[46840, 783, 7991, 106, 122, 7617, 95, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[54834, 891, 7998, 109, 122, 7624, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[62835, 1002, 8006, 109, 122, 7632, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[70844, 1113, 7949, 108, 122, 7575, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[78796, 1223, 8018, 109, 122, 7644, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[86817, 1334, 8038, 109, 122, 7664, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[94858, 1445, 8014, 109, 70, 7640, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[102875, 1556, 7978, 109, 70, 7604, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[110856, 1667, 7966, 109, 70, 7592, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[118825, 1778, 7917, 108, 70, 7543, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[126745, 1888, 7925, 108, 70, 7551, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[134673, 1998, 7885, 108, 70, 7511, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[142561, 2108, 7949, 108, 70, 7575, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[150513, 2218, 7966, 109, 70, 7592, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[158482, 2329, 7957, 108, 70, 7583, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[166442, 2439, 7941, 108, 70, 7567, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[174386, 2549, 7990, 109, 70, 7616, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[182379, 2660, 7982, 109, 70, 7608, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[190364, 2771, 7974, 109, 70, 7600, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[198341, 2882, 7941, 108, 70, 7567, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[206285, 2992, 8010, 109, 70, 7636, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[214298, 3103, 8014, 109, 70, 7640, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[222315, 3214, 8059, 110, 70, 7685, 99, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[230377, 3326, 7998, 109, 70, 7624, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[238378, 3437, 8063, 110, 70, 7689, 99, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[246444, 3549, 8055, 110, 70, 7681, 99, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[254502, 3661, 8091, 110, 70, 7717, 99, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[262596, 3773, 8047, 110, 70, 7673, 99, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[270646, 3885, 8204, 111, 70, 7830, 100, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[278853, 3998, 8265, 112, 70, 7891, 101, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[287121, 4112, 8281, 112, 70, 7907, 101, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[295405, 4226, 8306, 113, 70, 7932, 102, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[303714, 4341, 8314, 113, 122, 7940, 102, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[312031, 4456, 8346, 113, 122, 7972, 102, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[320380, 4571, 8358, 113, 122, 7984, 102, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[328741, 4686, 8306, 113, 122, 7932, 102, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[337050, 4801, 8371, 114, 122, 7997, 103, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[345424, 4917, 8419, 114, 122, 8045, 103, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[353846, 5033, 8468, 115, 122, 8094, 104, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[362317, 5150, 8500, 115, 122, 8118, 104, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
    Cell[370832, 5268, 214, 6, 43, "Text",
      CellTags->{
      "Rolling Square", "G.2.38", "Animation", "Using MathReader"}]},
  "Sound"->{
    Cell[371083, 5279, 108, 2, 34, "Subsubsection",
      CellTags->{"Sound", "Using MathReader"}],
    Cell[371194, 5283, 465, 12, 38, "Text",
      CellTags->{"Sound", "Using MathReader"}],
    Cell[371662, 5297, 84594, 1172, 182, 33781, 469, "GraphicsData", 
    "PostScript", "Sound",
      Evaluatable->False,
      CellTags->{"Sound", "Using MathReader"}]},
  "Display Characteristics"->{
    Cell[456293, 6474, 144, 2, 34, "Subsubsection",
      CellTags->{"Display Characteristics", "Using MathReader"}],
    Cell[456440, 6478, 487, 11, 38, "Text",
      CellTags->{"Display Characteristics", "Using MathReader"}]},
  "Printing"->{
    Cell[456964, 6494, 105, 2, 34, "Subsubsection",
      CellTags->{"Printing", "Using MathReader"}],
    Cell[457072, 6498, 1144, 32, 61, "Text",
      CellTags->{"Printing", "Using MathReader"}]},
  "Special Characters"->{
    Cell[458253, 6535, 143, 2, 34, "Subsubsection",
      CellTags->{"Special Characters", "Using MathReader"}],
    Cell[458399, 6539, 305, 6, 38, "Text",
      CellTags->{"Special Characters", "Using MathReader"}]},
  "More Information"->{
    Cell[458753, 6551, 129, 3, 38, "Subsection",
      CellTags->"More Information"],
    Cell[458907, 6558, 121, 2, 34, "Subsubsection",
      CellTags->{"More Information", "Using Help"}],
    Cell[459031, 6562, 577, 20, 39, "Text",
      CellTags->{"More Information", "Using Help"}],
    Cell[459645, 6587, 123, 2, 34, "Subsubsection",
      CellTags->{"More Information", "Notebook Format"}],
    Cell[459771, 6591, 318, 8, 39, "Text",
      CellTags->{"More Information", "Notebook Format"}],
    Cell[460092, 6601, 549, 16, 39, "Text",
      CellTags->{"More Information", "Notebook Format"}],
    Cell[460644, 6619, 224, 5, 23, "Text",
      CellTags->{"More Information", "Notebook Format"}],
    Cell[460905, 6629, 124, 2, 33, "Subsubsection",
      CellTags->{"More Information", "Licensing Info"}],
    Cell[461032, 6633, 438, 13, 37, "Text",
      CellTags->{"More Information", "Licensing Info"}]},
  "Using Help"->{
    Cell[458907, 6558, 121, 2, 34, "Subsubsection",
      CellTags->{"More Information", "Using Help"}],
    Cell[459031, 6562, 577, 20, 39, "Text",
      CellTags->{"More Information", "Using Help"}]},
  "Notebook Format"->{
    Cell[459645, 6587, 123, 2, 34, "Subsubsection",
      CellTags->{"More Information", "Notebook Format"}],
    Cell[459771, 6591, 318, 8, 39, "Text",
      CellTags->{"More Information", "Notebook Format"}],
    Cell[460092, 6601, 549, 16, 39, "Text",
      CellTags->{"More Information", "Notebook Format"}],
    Cell[460644, 6619, 224, 5, 23, "Text",
      CellTags->{"More Information", "Notebook Format"}]},
  "Licensing Info"->{
    Cell[460905, 6629, 124, 2, 33, "Subsubsection",
      CellTags->{"More Information", "Licensing Info"}],
    Cell[461032, 6633, 438, 13, 37, "Text",
      CellTags->{"More Information", "Licensing Info"}]},
  "Web Resources"->{
    Cell[461519, 6652, 130, 3, 38, "Subsection",
      CellTags->"Web Resources"],
    Cell[461674, 6659, 125, 2, 33, "Subsubsection",
      CellTags->{"ContactInformation", "web", "Web Resources"}],
    Cell[461802, 6663, 670, 21, 99, "Text",
      CellTags->{"ContactInformation", "web", "Web Resources"}],
    Cell[462509, 6689, 183, 3, 33, "Subsubsection",
      CellTags->{"ContactInformation", "info", "Web Resources"}],
    Cell[462695, 6694, 402, 14, 41, "Text",
      CellTags->{"info", "Web Resources"}],
    Cell[463134, 6713, 178, 3, 33, "Subsubsection",
      CellTags->{"info", "Web Resources"}],
    Cell[463315, 6718, 239, 6, 22, "Text",
      CellTags->{"info", "Web Resources"}],
    Cell[463591, 6729, 241, 8, 33, "Subsubsection",
      CellTags->{"services", "Web Resources"}],
    Cell[463835, 6739, 432, 14, 41, "Text",
      CellTags->{"services", "Web Resources"}],
    Cell[464304, 6758, 169, 3, 33, "Subsubsection",
      CellTags->{"ContactInformation", "comments", "Web Resources"}],
    Cell[464476, 6763, 444, 14, 41, "Text",
      CellTags->{"comments", "Web Resources"}],
    Cell[464957, 6782, 157, 3, 33, "Subsubsection",
      CellTags->{"comments", "Web Resources"}],
    Cell[465117, 6787, 432, 14, 41, "Text",
      CellTags->{"comments", "Web Resources"}],
    Cell[465586, 6806, 235, 7, 33, "Subsubsection",
      CellTags->{"ContactInformation", "products", "Web Resources"}],
    Cell[465824, 6815, 251, 6, 22, "Text",
      CellTags->{"products", "Web Resources"}],
    Cell[466112, 6826, 269, 10, 33, "Subsubsection",
      CellTags->{"products", "Web Resources"}],
    Cell[466384, 6838, 468, 14, 41, "Text",
      CellTags->{"products", "Web Resources"}],
    Cell[466889, 6857, 230, 8, 33, "Subsubsection",
      CellTags->{"products", "Web Resources"}],
    Cell[467122, 6867, 255, 6, 22, "Text",
      CellTags->{"products", "Web Resources"}],
    Cell[467414, 6878, 238, 8, 33, "Subsubsection",
      CellTags->{"products", "Web Resources"}],
    Cell[467655, 6888, 821, 26, 80, "Text",
      CellTags->{"products", "Web Resources"}],
    Cell[468513, 6919, 228, 8, 33, "Subsubsection",
      CellTags->{"products", "Web Resources"}],
    Cell[468744, 6929, 432, 14, 41, "Text",
      CellTags->{"products", "Web Resources"}]},
  "ContactInformation"->{
    Cell[461674, 6659, 125, 2, 33, "Subsubsection",
      CellTags->{"ContactInformation", "web", "Web Resources"}],
    Cell[461802, 6663, 670, 21, 99, "Text",
      CellTags->{"ContactInformation", "web", "Web Resources"}],
    Cell[462509, 6689, 183, 3, 33, "Subsubsection",
      CellTags->{"ContactInformation", "info", "Web Resources"}],
    Cell[464304, 6758, 169, 3, 33, "Subsubsection",
      CellTags->{"ContactInformation", "comments", "Web Resources"}],
    Cell[465586, 6806, 235, 7, 33, "Subsubsection",
      CellTags->{"ContactInformation", "products", "Web Resources"}]},
  "web"->{
    Cell[461674, 6659, 125, 2, 33, "Subsubsection",
      CellTags->{"ContactInformation", "web", "Web Resources"}],
    Cell[461802, 6663, 670, 21, 99, "Text",
      CellTags->{"ContactInformation", "web", "Web Resources"}]},
  "info"->{
    Cell[462509, 6689, 183, 3, 33, "Subsubsection",
      CellTags->{"ContactInformation", "info", "Web Resources"}],
    Cell[462695, 6694, 402, 14, 41, "Text",
      CellTags->{"info", "Web Resources"}],
    Cell[463134, 6713, 178, 3, 33, "Subsubsection",
      CellTags->{"info", "Web Resources"}],
    Cell[463315, 6718, 239, 6, 22, "Text",
      CellTags->{"info", "Web Resources"}]},
  "services"->{
    Cell[463591, 6729, 241, 8, 33, "Subsubsection",
      CellTags->{"services", "Web Resources"}],
    Cell[463835, 6739, 432, 14, 41, "Text",
      CellTags->{"services", "Web Resources"}]},
  "comments"->{
    Cell[464304, 6758, 169, 3, 33, "Subsubsection",
      CellTags->{"ContactInformation", "comments", "Web Resources"}],
    Cell[464476, 6763, 444, 14, 41, "Text",
      CellTags->{"comments", "Web Resources"}],
    Cell[464957, 6782, 157, 3, 33, "Subsubsection",
      CellTags->{"comments", "Web Resources"}],
    Cell[465117, 6787, 432, 14, 41, "Text",
      CellTags->{"comments", "Web Resources"}]},
  "products"->{
    Cell[465586, 6806, 235, 7, 33, "Subsubsection",
      CellTags->{"ContactInformation", "products", "Web Resources"}],
    Cell[465824, 6815, 251, 6, 22, "Text",
      CellTags->{"products", "Web Resources"}],
    Cell[466112, 6826, 269, 10, 33, "Subsubsection",
      CellTags->{"products", "Web Resources"}],
    Cell[466384, 6838, 468, 14, 41, "Text",
      CellTags->{"products", "Web Resources"}],
    Cell[466889, 6857, 230, 8, 33, "Subsubsection",
      CellTags->{"products", "Web Resources"}],
    Cell[467122, 6867, 255, 6, 22, "Text",
      CellTags->{"products", "Web Resources"}],
    Cell[467414, 6878, 238, 8, 33, "Subsubsection",
      CellTags->{"products", "Web Resources"}],
    Cell[467655, 6888, 821, 26, 80, "Text",
      CellTags->{"products", "Web Resources"}],
    Cell[468513, 6919, 228, 8, 33, "Subsubsection",
      CellTags->{"products", "Web Resources"}],
    Cell[468744, 6929, 432, 14, 41, "Text",
      CellTags->{"products", "Web Resources"}]},
  "Complete Mathematica Contact"->{
    Cell[469225, 6949, 219, 8, 38, "Subsection",
      CellTags->"Complete Mathematica Contact"],
    Cell[469469, 6961, 277, 7, 48, "Subsubsection",
      CellTags->"Complete Mathematica Contact"],
    Cell[469749, 6970, 2378, 90, 490, "Text",
      CellTags->"Complete Mathematica Contact"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"What is MathReader", 473576, 7104},
  {"Licensing Information", 473930, 7113},
  {"Using MathReader", 474129, 7118},
  {"Get Notebook", 487440, 7428},
  {"Web Browser", 487659, 7433},
  {"Animation", 487877, 7438},
  {"Rolling Square", 499620, 7716},
  {"G.2.38", 511161, 7990},
  {"Sound", 522701, 8264},
  {"Display Characteristics", 523096, 8273},
  {"Printing", 523341, 8278},
  {"Special Characters", 523567, 8283},
  {"More Information", 523809, 8288},
  {"Using Help", 524740, 8307},
  {"Notebook Format", 524966, 8312},
  {"Licensing Info", 525403, 8321},
  {"Web Resources", 525635, 8326},
  {"ContactInformation", 527939, 8373},
  {"web", 528539, 8384},
  {"info", 528778, 8389},
  {"services", 529184, 8398},
  {"comments", 529393, 8403},
  {"products", 529816, 8412},
  {"Complete Mathematica Contact", 530834, 8433}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 164, 7, 38, "Subsection",
  CellTags->"What is MathReader"],
Cell[1876, 58, 577, 18, 43, "Subtitle",
  CellTags->"What is MathReader"],
Cell[2456, 78, 289, 7, 70, "Text",
  CellTags->"What is MathReader"],
Cell[2748, 87, 405, 13, 40, "Text",
  CellTags->"What is MathReader"],

Cell[CellGroupData[{
Cell[3178, 104, 180, 4, 34, "Subsubsection",
  CellTags->"Licensing Information"],
Cell[3361, 110, 402, 12, 39, "Text",
  CellTags->"Licensing Information"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3800, 127, 233, 7, 34, "Subsubsection",
  CellTags->"Using MathReader"],
Cell[4036, 136, 681, 18, 56, "Text",
  CellTags->"Using MathReader"],

Cell[CellGroupData[{
Cell[4742, 158, 192, 6, 34, "Subsubsection",
  CellTags->{"Get Notebook", "Using MathReader"}],
Cell[4937, 166, 267, 9, 23, "Text",
  CellTags->{"Get Notebook", "Using MathReader"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[5241, 180, 210, 7, 34, "Subsubsection",
  CellTags->{"Web Browser", "Using MathReader"}],
Cell[5454, 189, 1167, 36, 352, "Text",
  CellTags->{"Web Browser", "Using MathReader"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[6658, 230, 116, 2, 34, "Subsubsection",
  CellTags->{"Animation", "Using MathReader"}],
Cell[6777, 234, 487, 11, 61, "Text",
  CellTags->{"Animation", "Using MathReader"}],

Cell[CellGroupData[{
Cell[7289, 249, 7824, 104, 114, 7443, 93, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[15116, 355, 7898, 105, 122, 7524, 94, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[23017, 462, 7910, 105, 122, 7536, 94, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[30930, 569, 7946, 105, 122, 7572, 94, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[38879, 676, 7958, 105, 122, 7584, 94, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[46840, 783, 7991, 106, 122, 7617, 95, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[54834, 891, 7998, 109, 122, 7624, 98, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[62835, 1002, 8006, 109, 122, 7632, 98, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[70844, 1113, 7949, 108, 122, 7575, 97, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[78796, 1223, 8018, 109, 122, 7644, 98, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[86817, 1334, 8038, 109, 122, 7664, 98, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[94858, 1445, 8014, 109, 70, 7640, 98, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[102875, 1556, 7978, 109, 70, 7604, 98, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[110856, 1667, 7966, 109, 70, 7592, 98, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[118825, 1778, 7917, 108, 70, 7543, 97, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[126745, 1888, 7925, 108, 70, 7551, 97, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[134673, 1998, 7885, 108, 70, 7511, 97, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[142561, 2108, 7949, 108, 70, 7575, 97, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[150513, 2218, 7966, 109, 70, 7592, 98, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[158482, 2329, 7957, 108, 70, 7583, 97, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[166442, 2439, 7941, 108, 70, 7567, 97, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[174386, 2549, 7990, 109, 70, 7616, 98, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[182379, 2660, 7982, 109, 70, 7608, 98, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[190364, 2771, 7974, 109, 70, 7600, 98, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[198341, 2882, 7941, 108, 70, 7567, 97, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[206285, 2992, 8010, 109, 70, 7636, 98, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[214298, 3103, 8014, 109, 70, 7640, 98, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[222315, 3214, 8059, 110, 70, 7685, 99, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[230377, 3326, 7998, 109, 70, 7624, 98, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[238378, 3437, 8063, 110, 70, 7689, 99, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[246444, 3549, 8055, 110, 70, 7681, 99, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[254502, 3661, 8091, 110, 70, 7717, 99, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[262596, 3773, 8047, 110, 70, 7673, 99, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[270646, 3885, 8204, 111, 70, 7830, 100, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[278853, 3998, 8265, 112, 70, 7891, 101, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[287121, 4112, 8281, 112, 70, 7907, 101, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[295405, 4226, 8306, 113, 70, 7932, 102, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[303714, 4341, 8314, 113, 122, 7940, 102, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[312031, 4456, 8346, 113, 122, 7972, 102, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[320380, 4571, 8358, 113, 122, 7984, 102, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[328741, 4686, 8306, 113, 122, 7932, 102, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[337050, 4801, 8371, 114, 122, 7997, 103, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[345424, 4917, 8419, 114, 122, 8045, 103, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[353846, 5033, 8468, 115, 122, 8094, 104, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}],
Cell[362317, 5150, 8500, 115, 122, 8118, 104, "GraphicsData", 
"Bitmap", "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}]
}, Closed]],
Cell[370832, 5268, 214, 6, 43, "Text",
  CellTags->{"Rolling Square", "G.2.38", "Animation", "Using MathReader"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[371083, 5279, 108, 2, 34, "Subsubsection",
  CellTags->{"Sound", "Using MathReader"}],
Cell[371194, 5283, 465, 12, 38, "Text",
  CellTags->{"Sound", "Using MathReader"}],
Cell[371662, 5297, 84594, 1172, 182, 33781, 469, "GraphicsData", 
"PostScript", "Sound",
  Evaluatable->False,
  CellTags->{"Sound", "Using MathReader"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[456293, 6474, 144, 2, 34, "Subsubsection",
  CellTags->{"Display Characteristics", "Using MathReader"}],
Cell[456440, 6478, 487, 11, 38, "Text",
  CellTags->{"Display Characteristics", "Using MathReader"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[456964, 6494, 105, 2, 34, "Subsubsection",
  CellTags->{"Printing", "Using MathReader"}],
Cell[457072, 6498, 1144, 32, 61, "Text",
  CellTags->{"Printing", "Using MathReader"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[458253, 6535, 143, 2, 34, "Subsubsection",
  CellTags->{"Special Characters", "Using MathReader"}],
Cell[458399, 6539, 305, 6, 38, "Text",
  CellTags->{"Special Characters", "Using MathReader"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[458753, 6551, 129, 3, 38, "Subsection",
  CellTags->"More Information"],

Cell[CellGroupData[{
Cell[458907, 6558, 121, 2, 34, "Subsubsection",
  CellTags->{"More Information", "Using Help"}],
Cell[459031, 6562, 577, 20, 39, "Text",
  CellTags->{"More Information", "Using Help"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[459645, 6587, 123, 2, 34, "Subsubsection",
  CellTags->{"More Information", "Notebook Format"}],
Cell[459771, 6591, 318, 8, 39, "Text",
  CellTags->{"More Information", "Notebook Format"}],
Cell[460092, 6601, 549, 16, 39, "Text",
  CellTags->{"More Information", "Notebook Format"}],
Cell[460644, 6619, 224, 5, 23, "Text",
  CellTags->{"More Information", "Notebook Format"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[460905, 6629, 124, 2, 33, "Subsubsection",
  CellTags->{"More Information", "Licensing Info"}],
Cell[461032, 6633, 438, 13, 37, "Text",
  CellTags->{"More Information", "Licensing Info"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[461519, 6652, 130, 3, 38, "Subsection",
  CellTags->"Web Resources"],

Cell[CellGroupData[{
Cell[461674, 6659, 125, 2, 33, "Subsubsection",
  CellTags->{"ContactInformation", "web", "Web Resources"}],
Cell[461802, 6663, 670, 21, 99, "Text",
  CellTags->{"ContactInformation", "web", "Web Resources"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[462509, 6689, 183, 3, 33, "Subsubsection",
  CellTags->{"ContactInformation", "info", "Web Resources"}],
Cell[462695, 6694, 402, 14, 41, "Text",
  CellTags->{"info", "Web Resources"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[463134, 6713, 178, 3, 33, "Subsubsection",
  CellTags->{"info", "Web Resources"}],
Cell[463315, 6718, 239, 6, 22, "Text",
  CellTags->{"info", "Web Resources"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[463591, 6729, 241, 8, 33, "Subsubsection",
  CellTags->{"services", "Web Resources"}],
Cell[463835, 6739, 432, 14, 41, "Text",
  CellTags->{"services", "Web Resources"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[464304, 6758, 169, 3, 33, "Subsubsection",
  CellTags->{"ContactInformation", "comments", "Web Resources"}],
Cell[464476, 6763, 444, 14, 41, "Text",
  CellTags->{"comments", "Web Resources"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[464957, 6782, 157, 3, 33, "Subsubsection",
  CellTags->{"comments", "Web Resources"}],
Cell[465117, 6787, 432, 14, 41, "Text",
  CellTags->{"comments", "Web Resources"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[465586, 6806, 235, 7, 33, "Subsubsection",
  CellTags->{"ContactInformation", "products", "Web Resources"}],
Cell[465824, 6815, 251, 6, 22, "Text",
  CellTags->{"products", "Web Resources"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[466112, 6826, 269, 10, 33, "Subsubsection",
  CellTags->{"products", "Web Resources"}],
Cell[466384, 6838, 468, 14, 41, "Text",
  CellTags->{"products", "Web Resources"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[466889, 6857, 230, 8, 33, "Subsubsection",
  CellTags->{"products", "Web Resources"}],
Cell[467122, 6867, 255, 6, 22, "Text",
  CellTags->{"products", "Web Resources"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[467414, 6878, 238, 8, 33, "Subsubsection",
  CellTags->{"products", "Web Resources"}],
Cell[467655, 6888, 821, 26, 80, "Text",
  CellTags->{"products", "Web Resources"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[468513, 6919, 228, 8, 33, "Subsubsection",
  CellTags->{"products", "Web Resources"}],
Cell[468744, 6929, 432, 14, 41, "Text",
  CellTags->{"products", "Web Resources"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[469225, 6949, 219, 8, 38, "Subsection",
  CellTags->"Complete Mathematica Contact"],

Cell[CellGroupData[{
Cell[469469, 6961, 277, 7, 48, "Subsubsection",
  CellTags->"Complete Mathematica Contact"],
Cell[469749, 6970, 2378, 90, 490, "Text",
  CellTags->"Complete Mathematica Contact"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

